/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.state.RelationshipChangesForNode;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;

public class RelationshipChangesForNodeTest {
    private static final int REL_0 = 0;
    private static final int REL_1 = 1;
    private static final int TYPE_SELF = 0;
    private static final int TYPE_DIR = 1;

    @Test
    public void testOutgoingRelsWithTypeAndLoop() throws Exception {
        RelationshipChangesForNode changes = new RelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.ADD, (RelationshipVisitor.Home)Mockito.mock(RelationshipVisitor.Home.class));
        changes.addRelationship(0L, 0, Direction.BOTH);
        changes.addRelationship(1L, 1, Direction.OUTGOING);
        RelationshipIterator iterator = changes.augmentRelationships(Direction.OUTGOING, new int[]{1}, RelationshipIterator.EMPTY);
        Assert.assertEquals((Object)true, (Object)iterator.hasNext());
        Assert.assertEquals((long)1L, (long)iterator.next());
        Assert.assertEquals((String)"should have no next relationships but has ", (Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void testIncomingRelsWithTypeAndLoop() throws Exception {
        RelationshipChangesForNode changes = new RelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.ADD, (RelationshipVisitor.Home)Mockito.mock(RelationshipVisitor.Home.class));
        changes.addRelationship(0L, 0, Direction.BOTH);
        changes.addRelationship(1L, 1, Direction.INCOMING);
        RelationshipIterator iterator = changes.augmentRelationships(Direction.INCOMING, new int[]{1}, RelationshipIterator.EMPTY);
        Assert.assertEquals((Object)true, (Object)iterator.hasNext());
        Assert.assertEquals((long)1L, (long)iterator.next());
        Assert.assertEquals((String)"should have no next relationships but has ", (Object)false, (Object)iterator.hasNext());
    }
}

