/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.TokenWriteOperations;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.impl.core.Token;

public class LabelIT
extends KernelIntegrationTest {
    @Test
    public void shouldListAllLabels() throws Exception {
        TokenWriteOperations statement = this.tokenWriteOperationsInNewTransaction();
        int label1Id = statement.labelGetOrCreateForName("label1");
        int label2Id = statement.labelGetOrCreateForName("label2");
        Iterator labelIdsBeforeCommit = statement.labelsGetAllTokens();
        Assert.assertThat((Object)IteratorUtil.asCollection((Iterator)labelIdsBeforeCommit), (Matcher)IsCollectionContaining.hasItems((Object[])new Token[]{new Token("label1", label1Id), new Token("label2", label2Id)}));
        this.commit();
        statement = this.dataWriteOperationsInNewTransaction();
        Iterator labelIdsAfterCommit = statement.labelsGetAllTokens();
        Assert.assertThat((Object)IteratorUtil.asCollection((Iterator)labelIdsAfterCommit), (Matcher)IsCollectionContaining.hasItems((Object[])new Token[]{new Token("label1", label1Id), new Token("label2", label2Id)}));
    }

    @Test
    public void addingAndRemovingLabelInSameTxShouldHaveNoEffect() throws Exception {
        DataWriteOperations stmt = this.dataWriteOperationsInNewTransaction();
        int label = stmt.labelGetOrCreateForName("Label 1");
        long node = stmt.nodeCreate();
        stmt.nodeAddLabel(node, label);
        this.commit();
        stmt = this.dataWriteOperationsInNewTransaction();
        stmt.nodeRemoveLabel(node, label);
        stmt.nodeAddLabel(node, label);
        this.commit();
        Assert.assertTrue((boolean)this.readOperationsInNewTransaction().nodeHasLabel(node, label));
    }
}

