/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.inmemory;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.collection.primitive.PrimitiveLongVisitor;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PreexistingIndexEntryConflictException;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.Reservation;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.UniquePropertyIndexUpdater;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndex;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexImplementation;

class UniqueInMemoryIndex
extends InMemoryIndex {
    private final int propertyKeyId;
    private final PrimitiveLongVisitor<RuntimeException> removeFromIndex = new PrimitiveLongVisitor<RuntimeException>(){

        @Override
        public boolean visited(long nodeId) {
            UniqueInMemoryIndex.this.remove(nodeId);
            return false;
        }
    };

    public UniqueInMemoryIndex(int propertyKeyId) {
        this.propertyKeyId = propertyKeyId;
    }

    @Override
    protected IndexUpdater newUpdater(final IndexUpdateMode mode, boolean populating) {
        return new UniquePropertyIndexUpdater(){

            protected void flushUpdates(Iterable<NodePropertyUpdate> updates) throws IOException, IndexEntryConflictException {
                for (NodePropertyUpdate update : updates) {
                    switch (update.getUpdateMode()) {
                        case CHANGED: 
                        case REMOVED: {
                            UniqueInMemoryIndex.this.remove(update.getNodeId(), update.getValueBefore());
                        }
                    }
                }
                for (NodePropertyUpdate update : updates) {
                    switch (update.getUpdateMode()) {
                        case CHANGED: 
                        case ADDED: {
                            UniqueInMemoryIndex.this.add(update.getNodeId(), update.getValueAfter(), IndexUpdateMode.ONLINE == mode);
                        }
                    }
                }
            }

            public Reservation validate(Iterable<NodePropertyUpdate> updates) throws IOException {
                return Reservation.EMPTY;
            }

            public void remove(PrimitiveLongSet nodeIds) {
                nodeIds.visitKeys(UniqueInMemoryIndex.this.removeFromIndex);
            }
        };
    }

    @Override
    public void verifyDeferredConstraints(final PropertyAccessor accessor) throws IndexEntryConflictException, IOException {
        try {
            this.indexData.iterateAll(new InMemoryIndexImplementation.IndexEntryIterator(){

                @Override
                public void visitEntry(Object key, Set<Long> nodeIds) throws Exception {
                    HashMap<Object, Long> entries = new HashMap<Object, Long>();
                    for (long nodeId : nodeIds) {
                        Object value = accessor.getProperty(nodeId, UniqueInMemoryIndex.this.propertyKeyId).value();
                        if (entries.containsKey(value)) {
                            long existingNodeId = (Long)entries.get(value);
                            throw new PreexistingIndexEntryConflictException(value, existingNodeId, nodeId);
                        }
                        entries.put(value, nodeId);
                    }
                }
            });
        }
        catch (PreexistingIndexEntryConflictException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

