/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.inmemory;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.impl.api.PropertyValueComparison;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexImplementation;
import org.neo4j.register.Register;

class HashBasedIndex
extends InMemoryIndexImplementation {
    private Map<Object, Set<Long>> data;

    HashBasedIndex() {
    }

    public Map<Object, Set<Long>> data() {
        if (this.data == null) {
            throw new IllegalStateException("Index has not been created, or has been dropped.");
        }
        return this.data;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.data;
    }

    @Override
    void initialize() {
        this.data = new HashMap<Object, Set<Long>>();
    }

    @Override
    void drop() {
        this.data = null;
    }

    @Override
    PrimitiveLongIterator doIndexSeek(Object propertyValue) {
        Set<Long> nodes = this.data().get(propertyValue);
        return nodes == null ? PrimitiveLongCollections.emptyIterator() : PrimitiveLongCollections.toPrimitiveIterator(nodes.iterator());
    }

    public PrimitiveLongIterator rangeSeekByNumberInclusive(Number lower, Number upper) {
        HashSet nodeIds = new HashSet();
        for (Map.Entry<Object, Set<Long>> entry : this.data.entrySet()) {
            boolean upperFilter;
            Object key = entry.getKey();
            if (!PropertyValueComparison.SuperType.NUMBER.isSuperTypeOf(key)) continue;
            boolean lowerFilter = lower == null || PropertyValueComparison.COMPARE_VALUES.compare(key, (Object)lower) >= 0;
            boolean bl = upperFilter = upper == null || PropertyValueComparison.COMPARE_VALUES.compare(key, (Object)upper) <= 0;
            if (!lowerFilter || !upperFilter) continue;
            nodeIds.addAll(entry.getValue());
        }
        return PrimitiveLongCollections.toPrimitiveIterator(nodeIds.iterator());
    }

    public PrimitiveLongIterator rangeSeekByString(String lower, boolean includeLower, String upper, boolean includeUpper) {
        HashSet nodeIds = new HashSet();
        for (Map.Entry<Object, Set<Long>> entry : this.data.entrySet()) {
            int cmp;
            Object key = entry.getKey();
            if (!PropertyValueComparison.SuperType.STRING.isSuperTypeOf(key)) continue;
            boolean lowerFilter = false;
            boolean upperFilter = false;
            if (lower == null) {
                lowerFilter = true;
            } else {
                cmp = PropertyValueComparison.COMPARE_VALUES.compare(key, (Object)lower);
                boolean bl = lowerFilter = includeLower && cmp >= 0 || cmp > 0;
            }
            if (upper == null) {
                upperFilter = true;
            } else {
                cmp = PropertyValueComparison.COMPARE_VALUES.compare(key, (Object)upper);
                boolean bl = upperFilter = includeUpper && cmp <= 0 || cmp < 0;
            }
            if (!lowerFilter || !upperFilter) continue;
            nodeIds.addAll(entry.getValue());
        }
        return PrimitiveLongCollections.toPrimitiveIterator(nodeIds.iterator());
    }

    public PrimitiveLongIterator rangeSeekByPrefix(String prefix) {
        HashSet nodeIds = new HashSet();
        for (Map.Entry<Object, Set<Long>> entry : this.data.entrySet()) {
            Object key = entry.getKey();
            if (!(key instanceof String) || !key.toString().startsWith(prefix)) continue;
            nodeIds.addAll(entry.getValue());
        }
        return PrimitiveLongCollections.toPrimitiveIterator(nodeIds.iterator());
    }

    public PrimitiveLongIterator scan() {
        Iterable all = Iterables.flattenIterable(this.data.values());
        return PrimitiveLongCollections.toPrimitiveIterator(all.iterator());
    }

    @Override
    boolean doAdd(Object propertyValue, long nodeId, boolean applyIdempotently) {
        Set<Long> nodes = this.data().get(propertyValue);
        if (nodes == null) {
            nodes = new HashSet<Long>();
            this.data().put(propertyValue, nodes);
        }
        return nodes.add(nodeId);
    }

    @Override
    void doRemove(Object propertyValue, long nodeId) {
        Set<Long> nodes = this.data().get(propertyValue);
        if (nodes != null) {
            nodes.remove(nodeId);
        }
    }

    @Override
    void remove(long nodeId) {
        for (Set<Long> nodes : this.data().values()) {
            nodes.remove(nodeId);
        }
    }

    @Override
    void iterateAll(InMemoryIndexImplementation.IndexEntryIterator iterator) throws Exception {
        for (Map.Entry<Object, Set<Long>> entry : this.data().entrySet()) {
            iterator.visitEntry(entry.getKey(), entry.getValue());
        }
    }

    public long maxCount() {
        return this.ids().size();
    }

    public Iterator<Long> iterator() {
        return this.ids().iterator();
    }

    private Collection<Long> ids() {
        HashSet<Long> allIds = new HashSet<Long>();
        for (Set<Long> someIds : this.data().values()) {
            allIds.addAll(someIds);
        }
        return allIds;
    }

    @Override
    InMemoryIndexImplementation snapshot() {
        HashBasedIndex snapshot = new HashBasedIndex();
        snapshot.initialize();
        for (Map.Entry<Object, Set<Long>> entry : this.data().entrySet()) {
            snapshot.data().put(entry.getKey(), new HashSet(entry.getValue()));
        }
        return snapshot;
    }

    public int countIndexedNodes(long nodeId, Object propertyValue) {
        Set<Long> candidates = this.data().get(propertyValue);
        return candidates != null && candidates.contains(nodeId) ? 1 : 0;
    }

    public Set<Class> valueTypesInIndex() {
        if (this.data == null) {
            return Collections.emptySet();
        }
        HashSet<Class> result = new HashSet<Class>();
        for (Object value : this.data.keySet()) {
            if (value instanceof Number) {
                result.add(Number.class);
                continue;
            }
            if (value instanceof String) {
                result.add(String.class);
                continue;
            }
            if (value instanceof Boolean) {
                result.add(Boolean.class);
                continue;
            }
            if (!(value instanceof InMemoryIndexImplementation.ArrayKey)) continue;
            result.add(Array.class);
        }
        return result;
    }

    public long sampleIndex(Register.DoubleLong.Out result) throws IndexNotFoundKernelException {
        if (this.data == null) {
            throw new IndexNotFoundKernelException("Index dropped while sampling.");
        }
        final long[] uniqueAndSize = new long[]{0L, 0L};
        try {
            this.iterateAll(new InMemoryIndexImplementation.IndexEntryIterator(){

                @Override
                public void visitEntry(Object value, Set<Long> nodeIds) {
                    int ids = nodeIds.size();
                    if (ids > 0) {
                        uniqueAndSize[0] = uniqueAndSize[0] + 1L;
                        uniqueAndSize[1] = uniqueAndSize[1] + (long)ids;
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        result.write(uniqueAndSize[0], uniqueAndSize[1]);
        return uniqueAndSize[1];
    }
}

