/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.OnlineIndexUpdatesValidator;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.state.LazyIndexUpdates;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;

public class OnlineIndexUpdatesValidatorTest {
    private final NeoStores neoStores = (NeoStores)Mockito.mock(NeoStores.class);
    private final IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
    private final NodeStore nodeStore = (NodeStore)Mockito.mock(NodeStore.class);
    private final PropertyStore propertyStore = (PropertyStore)Mockito.mock(PropertyStore.class);
    private final PropertyLoader propertyLoader = (PropertyLoader)Mockito.mock(PropertyLoader.class);
    private final PrimitiveLongObjectMap<Command.NodeCommand> emptyNodeCommands = Primitive.longObjectMap();
    private final PrimitiveLongObjectMap<List<Command.PropertyCommand>> emptyPropCommands = Primitive.longObjectMap();

    @Test
    public void shouldValidateIndexesOnNodeCommands() throws IOException {
        IndexUpdatesValidator validator = this.newIndexUpdatesValidatorWithMockedDependencies();
        NodeRecord before = new NodeRecord(11L);
        NodeRecord after = new NodeRecord(12L);
        after.setId(5L);
        Command.NodeCommand command = new Command.NodeCommand().init(before, after);
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(Arrays.asList(command));
        ValidatedIndexUpdates updates = validator.validate((TransactionRepresentation)tx);
        Assert.assertNotSame((Object)updates, (Object)ValidatedIndexUpdates.NONE);
        LazyIndexUpdates expectedUpdates = new LazyIndexUpdates(this.nodeStore, this.propertyStore, this.propertyLoader, this.emptyPropCommands, OnlineIndexUpdatesValidatorTest.groupedById(command));
        ((IndexingService)Mockito.verify((Object)this.indexingService)).validate((Iterable)Matchers.eq((Object)expectedUpdates), (IndexUpdateMode)Matchers.eq((Object)IndexUpdateMode.ONLINE));
    }

    @Test
    public void shouldValidateIndexUpdatesOnPropertyCommandsWhenThePropertyIsOnANode() throws IOException {
        IndexUpdatesValidator validator = this.newIndexUpdatesValidatorWithMockedDependencies();
        PropertyRecord before = new PropertyRecord(11L);
        PropertyRecord after = new PropertyRecord(12L);
        after.setNodeId(42L);
        Command.PropertyCommand command = new Command.PropertyCommand().init(before, after);
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(Arrays.asList(command));
        ValidatedIndexUpdates updates = validator.validate((TransactionRepresentation)tx);
        Assert.assertNotSame((Object)updates, (Object)ValidatedIndexUpdates.NONE);
        LazyIndexUpdates expectedUpdates = new LazyIndexUpdates(this.nodeStore, this.propertyStore, this.propertyLoader, OnlineIndexUpdatesValidatorTest.groupedByNodeId(command), this.emptyNodeCommands);
        ((IndexingService)Mockito.verify((Object)this.indexingService)).validate((Iterable)expectedUpdates, IndexUpdateMode.ONLINE);
    }

    @Test
    public void shouldNotUpdateIndexesOnPropertyCommandsWhenThePropertyIsNotOnANode() throws Exception {
        IndexUpdatesValidator validator = this.newIndexUpdatesValidatorWithMockedDependencies();
        PropertyRecord before = new PropertyRecord(11L);
        PropertyRecord after = new PropertyRecord(12L);
        Command.PropertyCommand command = new Command.PropertyCommand().init(before, after);
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(Arrays.asList(command));
        ValidatedIndexUpdates updates = validator.validate((TransactionRepresentation)tx);
        Assert.assertSame((Object)updates, (Object)ValidatedIndexUpdates.NONE);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.never())).validate((Iterable)Matchers.any(LazyIndexUpdates.class), (IndexUpdateMode)Matchers.any(IndexUpdateMode.class));
    }

    @Test
    public void shouldRethrowExceptionThrownByIndexUpdatersValidationProcedure() throws IOException {
        long node = 1L;
        int label = 2;
        int property = 2;
        NodePropertyCommands commands = OnlineIndexUpdatesValidatorTest.createNodeWithLabelAndPropertyCommands(node, label, property);
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation((Collection)commands);
        LazyIndexUpdates updates = new LazyIndexUpdates(this.nodeStore, this.propertyStore, this.propertyLoader, commands.property(), commands.node());
        IndexCapacityExceededException error = new IndexCapacityExceededException(100L, 100L);
        ((IndexingService)Mockito.doThrow((Throwable)new UnderlyingStorageException((Throwable)error)).when((Object)this.indexingService)).validate((Iterable)updates, IndexUpdateMode.ONLINE);
        IndexUpdatesValidator validator = this.newIndexUpdatesValidatorWithMockedDependencies();
        try {
            validator.validate((TransactionRepresentation)tx);
            Assert.fail((String)("Should have thrown " + UnderlyingStorageException.class.getSimpleName()));
        }
        catch (UnderlyingStorageException e) {
            Assert.assertSame((Object)error, (Object)e.getCause());
        }
    }

    @Test
    public void shouldValidateIndexUpdatesWhenNodeCreated() throws IOException {
        IndexUpdatesValidator validator = this.newIndexUpdatesValidatorWithMockedDependencies();
        Command.NodeCommand createNode1 = OnlineIndexUpdatesValidatorTest.createNodeWithLabel(1L, 1);
        Command.NodeCommand createNode2 = OnlineIndexUpdatesValidatorTest.createNodeWithLabel(2L, 2);
        Command.PropertyCommand addProperty1ToNode1 = OnlineIndexUpdatesValidatorTest.addProperty(1L, 1);
        Command.PropertyCommand addProperty2ToNode1 = OnlineIndexUpdatesValidatorTest.addProperty(1L, 2);
        Command.PropertyCommand addProperty1ToNode2 = OnlineIndexUpdatesValidatorTest.addProperty(2L, 2);
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(Arrays.asList(createNode1, addProperty1ToNode1, addProperty2ToNode1, createNode2, addProperty1ToNode2));
        ValidatedIndexUpdates validatedUpdates = validator.validate((TransactionRepresentation)tx);
        Assert.assertNotSame((Object)ValidatedIndexUpdates.NONE, (Object)validatedUpdates);
        LazyIndexUpdates expectedUpdates = new LazyIndexUpdates(this.nodeStore, this.propertyStore, this.propertyLoader, OnlineIndexUpdatesValidatorTest.groupedByNodeId(addProperty1ToNode1, addProperty2ToNode1, addProperty1ToNode2), OnlineIndexUpdatesValidatorTest.groupedById(createNode1, createNode2));
        ((IndexingService)Mockito.verify((Object)this.indexingService)).validate((Iterable)expectedUpdates, IndexUpdateMode.ONLINE);
    }

    @Test
    public void shouldValidateIndexUpdatesWhenNodeDeleted() throws IOException {
        IndexUpdatesValidator validator = this.newIndexUpdatesValidatorWithMockedDependencies();
        Command.NodeCommand deleteNode1 = OnlineIndexUpdatesValidatorTest.deleteNode(1L);
        Command.NodeCommand deleteNode2 = OnlineIndexUpdatesValidatorTest.deleteNode(1L);
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(Arrays.asList(deleteNode1, deleteNode2));
        ValidatedIndexUpdates validatedUpdates = validator.validate((TransactionRepresentation)tx);
        Assert.assertNotSame((Object)ValidatedIndexUpdates.NONE, (Object)validatedUpdates);
        LazyIndexUpdates expectedUpdates = new LazyIndexUpdates(this.nodeStore, this.propertyStore, this.propertyLoader, this.emptyPropCommands, OnlineIndexUpdatesValidatorTest.groupedById(deleteNode1, deleteNode2));
        ((IndexingService)Mockito.verify((Object)this.indexingService)).validate((Iterable)expectedUpdates, IndexUpdateMode.ONLINE);
    }

    private IndexUpdatesValidator newIndexUpdatesValidatorWithMockedDependencies() {
        Mockito.when((Object)this.neoStores.getNodeStore()).thenReturn((Object)this.nodeStore);
        Mockito.when((Object)this.neoStores.getPropertyStore()).thenReturn((Object)this.propertyStore);
        return new OnlineIndexUpdatesValidator(this.neoStores, null, this.propertyLoader, this.indexingService, IndexUpdateMode.ONLINE);
    }

    private static NodePropertyCommands createNodeWithLabelAndPropertyCommands(long nodeId, int label, int property) {
        Command.NodeCommand nodeCommand = OnlineIndexUpdatesValidatorTest.createNodeWithLabel(nodeId, label);
        Command.PropertyCommand propCommand = OnlineIndexUpdatesValidatorTest.addProperty(nodeId, property);
        return new NodePropertyCommands(nodeCommand, propCommand);
    }

    private static Command.NodeCommand createNodeWithLabel(long nodeId, int label) {
        NodeRecord before = new NodeRecord(nodeId, false, false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue(), (long)Record.NO_LABELS_FIELD.intValue());
        NodeRecord after = new NodeRecord(nodeId, true, false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue(), (long)Record.NO_LABELS_FIELD.intValue());
        new InlineNodeLabels(after.getLabelField(), after).put(new long[]{label}, null, null);
        return new Command.NodeCommand().init(before, after);
    }

    private static Command.NodeCommand deleteNode(long nodeId) {
        NodeRecord before = new NodeRecord(nodeId, true, false, 42L, 42L, (long)Record.NO_LABELS_FIELD.intValue());
        new InlineNodeLabels(before.getLabelField(), before).put(new long[]{42L}, null, null);
        NodeRecord after = new NodeRecord(nodeId, false, false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue(), (long)Record.NO_LABELS_FIELD.intValue());
        return new Command.NodeCommand().init(before, after);
    }

    private static Command.PropertyCommand addProperty(long nodeId, int property) {
        PropertyRecord before = new PropertyRecord(1L);
        before.setInUse(false);
        PropertyRecord after = new PropertyRecord(2L);
        after.setInUse(true);
        after.setCreated();
        after.setNodeId(nodeId);
        PropertyBlock block = new PropertyBlock();
        block.setSingleBlock(42L);
        block.setKeyIndexId(property);
        after.setPropertyBlock(block);
        return new Command.PropertyCommand().init(before, after);
    }

    private static PrimitiveLongObjectMap<Command.NodeCommand> groupedById(Command.NodeCommand ... commands) {
        PrimitiveLongObjectMap<Command.NodeCommand> result = Primitive.longObjectMap(commands.length);
        for (Command.NodeCommand command : commands) {
            result.put(command.getAfter().getId(), command);
        }
        return result;
    }

    private static PrimitiveLongObjectMap<List<Command.PropertyCommand>> groupedByNodeId(Command.PropertyCommand ... commands) {
        PrimitiveLongObjectMap<List<Command.PropertyCommand>> result = Primitive.longObjectMap(commands.length);
        for (Command.PropertyCommand command : commands) {
            List<Command.PropertyCommand> propCommands = result.get(command.getNodeId());
            if (propCommands == null) {
                propCommands = new ArrayList<Command.PropertyCommand>();
                result.put(command.getNodeId(), propCommands);
            }
            propCommands.add(command);
        }
        return result;
    }

    private static class NodePropertyCommands
    extends AbstractCollection<Command> {
        final Command.NodeCommand nodeCommand;
        final Command.PropertyCommand propCommand;

        NodePropertyCommands(Command.NodeCommand nodeCommand, Command.PropertyCommand propCommand) {
            this.nodeCommand = nodeCommand;
            this.propCommand = propCommand;
        }

        @Override
        public Iterator<Command> iterator() {
            return IteratorUtil.iterator((Object[])new Command[]{this.nodeCommand, this.propCommand});
        }

        @Override
        public int size() {
            return IteratorUtil.count(this.iterator());
        }

        PrimitiveLongObjectMap<List<Command.PropertyCommand>> property() {
            return OnlineIndexUpdatesValidatorTest.groupedByNodeId(new Command.PropertyCommand[]{this.propCommand});
        }

        PrimitiveLongObjectMap<Command.NodeCommand> node() {
            return OnlineIndexUpdatesValidatorTest.groupedById(new Command.NodeCommand[]{this.nodeCommand});
        }
    }
}

