/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.counts;

import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.function.Supplier;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.test.Barrier;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.NamedFunction;
import org.neo4j.test.ThreadingRule;

public class NodeCountsTest {
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule();
    @Rule
    public final ThreadingRule threading = new ThreadingRule();
    private Supplier<Statement> statementSupplier;

    @Test
    public void shouldReportNumberOfNodesInAnEmptyGraph() throws Exception {
        long nodeCount = this.numberOfNodes();
        Assert.assertEquals((long)0L, (long)nodeCount);
    }

    @Test
    public void shouldReportNumberOfNodes() throws Exception {
        GraphDatabaseService graphDb = this.db.getGraphDatabaseService();
        try (Transaction tx = graphDb.beginTx();){
            graphDb.createNode();
            graphDb.createNode();
            tx.success();
        }
        long nodeCount = this.numberOfNodes();
        Assert.assertEquals((long)2L, (long)nodeCount);
    }

    @Test
    public void shouldReportAccurateNumberOfNodesAfterDeletion() throws Exception {
        Node one;
        GraphDatabaseService graphDb = this.db.getGraphDatabaseService();
        try (Transaction tx = graphDb.beginTx();){
            one = graphDb.createNode();
            graphDb.createNode();
            tx.success();
        }
        tx = graphDb.beginTx();
        var4_4 = null;
        try {
            one.delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_4.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        long nodeCount = this.numberOfNodes();
        Assert.assertEquals((long)1L, (long)nodeCount);
    }

    @Test
    @Ignore(value="TODO: reenable this test when we can etract proper counts form TxState")
    public void shouldIncludeNumberOfNodesAddedInTransaction() throws Exception {
        GraphDatabaseService graphDb = this.db.getGraphDatabaseService();
        try (Transaction tx = graphDb.beginTx();){
            graphDb.createNode();
            graphDb.createNode();
            tx.success();
        }
        long before = this.numberOfNodes();
        try (Transaction tx = graphDb.beginTx();){
            graphDb.createNode();
            long nodeCount = this.countsForNode();
            Assert.assertEquals((long)(before + 1L), (long)nodeCount);
            tx.success();
        }
    }

    @Test
    @Ignore(value="TODO: reenable this test when we can etract proper counts form TxState")
    public void shouldIncludeNumberOfNodesDeletedInTransaction() throws Exception {
        Node one;
        GraphDatabaseService graphDb = this.db.getGraphDatabaseService();
        try (Transaction tx = graphDb.beginTx();){
            one = graphDb.createNode();
            graphDb.createNode();
            tx.success();
        }
        long before = this.numberOfNodes();
        try (Transaction tx = graphDb.beginTx();){
            one.delete();
            long nodeCount = this.countsForNode();
            Assert.assertEquals((long)(before - 1L), (long)nodeCount);
            tx.success();
        }
    }

    @Test
    public void shouldNotSeeNodeCountsOfOtherTransaction() throws Exception {
        GraphDatabaseService graphDb = this.db.getGraphDatabaseService();
        final Barrier.Control barrier = new Barrier.Control();
        long before = this.numberOfNodes();
        Future<Long> done = this.threading.execute(new NamedFunction<GraphDatabaseService, Long>("create-nodes"){

            @Override
            public Long apply(GraphDatabaseService graphDb) {
                try (Transaction tx = graphDb.beginTx();){
                    graphDb.createNode();
                    graphDb.createNode();
                    barrier.reached();
                    long during = NodeCountsTest.this.countsForNode();
                    tx.success();
                    Long l = during;
                    return l;
                }
            }
        }, graphDb);
        barrier.await();
        long nodes = this.numberOfNodes();
        barrier.release();
        long during = done.get();
        long after = this.numberOfNodes();
        Assert.assertEquals((long)0L, (long)before);
        Assert.assertEquals((long)0L, (long)nodes);
        Assert.assertEquals((long)before, (long)during);
        Assert.assertEquals((long)2L, (long)after);
    }

    private long numberOfNodes() {
        try (Transaction tx = this.db.getGraphDatabaseService().beginTx();){
            long nodeCount = this.countsForNode();
            tx.success();
            long l = nodeCount;
            return l;
        }
    }

    private long countsForNode() {
        return this.statementSupplier.get().readOperations().countsForNode(-1);
    }

    @Before
    public void exposeGuts() {
        this.statementSupplier = (Supplier)this.db.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
    }
}

