/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index.util;

import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.util.FailureStorage;
import org.neo4j.kernel.api.index.util.FolderLayout;
import org.neo4j.test.EphemeralFileSystemRule;

public class FailureStorageTest {
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private FolderLayout folderLayout;
    private final long indexId = 1L;

    @Before
    public void before() {
        File rootDirectory = new File("dir");
        this.fs.get().mkdirs(rootDirectory);
        this.folderLayout = new FolderLayout(rootDirectory);
    }

    @Test
    public void shouldReserveFailureFile() throws Exception {
        FailureStorage storage = new FailureStorage((FileSystemAbstraction)this.fs.get(), this.folderLayout);
        storage.reserveForIndex(1L);
        File failureFile = storage.failureFile(1L);
        Assert.assertTrue((boolean)this.fs.get().fileExists(failureFile));
        Assert.assertTrue((this.fs.get().getFileSize(failureFile) > 100L ? 1 : 0) != 0);
    }

    @Test
    public void shouldStoreFailure() throws Exception {
        FailureStorage storage = new FailureStorage((FileSystemAbstraction)this.fs.get(), this.folderLayout);
        storage.reserveForIndex(1L);
        String failure = String.format("A failure message%nspanning%nmultiple lines.", new Object[0]);
        storage.storeIndexFailure(1L, failure);
        File failureFile = storage.failureFile(1L);
        Assert.assertTrue((boolean)this.fs.get().fileExists(failureFile));
        Assert.assertTrue((this.fs.get().getFileSize(failureFile) > 100L ? 1 : 0) != 0);
        Assert.assertEquals((Object)failure, (Object)storage.loadIndexFailure(1L));
    }

    @Test
    public void shouldClearFailure() throws Exception {
        FailureStorage storage = new FailureStorage((FileSystemAbstraction)this.fs.get(), this.folderLayout);
        storage.reserveForIndex(1L);
        String failure = String.format("A failure message%nspanning%nmultiple lines.", new Object[0]);
        storage.storeIndexFailure(1L, failure);
        File failureFile = storage.failureFile(1L);
        Assert.assertTrue((boolean)this.fs.get().fileExists(failureFile));
        Assert.assertTrue((this.fs.get().getFileSize(failureFile) > 100L ? 1 : 0) != 0);
        storage.clearForIndex(1L);
        Assert.assertFalse((boolean)this.fs.get().fileExists(failureFile));
    }
}

