/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Test;
import org.junit.runner.Runner;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class ParameterizedSuiteRunner
extends Suite {
    public ParameterizedSuiteRunner(Class<?> testClass) throws InitializationError {
        this(testClass, new ParameterBuilder(testClass));
    }

    ParameterizedSuiteRunner(Class<?> testClass, ParameterBuilder builder) throws InitializationError {
        super((RunnerBuilder)builder, testClass, (Class[])builder.suiteClasses());
    }

    private static class Parameterization
    extends BlockJUnit4ClassRunner {
        private final ParameterBuilder builder;
        private final Constructor<?> constructor;

        Parameterization(ParameterBuilder builder, Constructor<?> constructor) throws InitializationError {
            super(constructor.getDeclaringClass());
            this.builder = builder;
            this.constructor = constructor;
        }

        protected void validateConstructor(List<Throwable> errors) {
        }

        protected Object createTest() throws Exception {
            return this.constructor.newInstance(this.builder.newSuiteInstance());
        }
    }

    private static class ParameterBuilder
    extends RunnerBuilder {
        private final Map<Class<?>, Parameterization> parameterizations = new HashMap();
        private final Class<?> suiteClass;

        ParameterBuilder(Class<?> suiteClass) throws InitializationError {
            this.suiteClass = suiteClass;
            boolean ok = false;
            for (Constructor<?> suiteConstructor : suiteClass.getConstructors()) {
                if (suiteConstructor.getParameterTypes().length != 0) continue;
                if (!Modifier.isPublic(suiteConstructor.getModifiers())) break;
                ok = true;
                break;
            }
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            if (!ok) {
                errors.add(new IllegalArgumentException("Suite class (" + suiteClass.getName() + ") does not have a public zero-arg constructor."));
            }
            if (Modifier.isAbstract(suiteClass.getModifiers())) {
                errors.add(new IllegalArgumentException("Suite class (" + suiteClass.getName() + ") is abstract."));
            }
            this.buildParameterizations(this.parameterizations, suiteClass, errors);
            if (!errors.isEmpty()) {
                throw new InitializationError(errors);
            }
        }

        public Runner runnerForClass(Class<?> testClass) throws Throwable {
            if (testClass == this.suiteClass) {
                return new BlockJUnit4ClassRunner(testClass);
            }
            return (Runner)this.parameterizations.get(testClass);
        }

        Class<?>[] suiteClasses() {
            ArrayList classes = new ArrayList(this.parameterizations.keySet());
            for (Method method : this.suiteClass.getMethods()) {
                if (method.getAnnotation(Test.class) == null) continue;
                classes.add(this.suiteClass);
            }
            return classes.toArray(new Class[classes.size()]);
        }

        private void buildParameterizations(Map<Class<?>, Parameterization> result, Class<?> type, List<Throwable> errors) {
            if (type == Object.class) {
                return;
            }
            this.buildParameterizations(result, type.getSuperclass(), errors);
            Suite.SuiteClasses annotation = type.getAnnotation(Suite.SuiteClasses.class);
            if (annotation != null) {
                for (Class test : annotation.value()) {
                    if (result.containsKey(test)) continue;
                    try {
                        result.put(test, new Parameterization(this, test.getConstructor(type)));
                    }
                    catch (InitializationError failure) {
                        errors.addAll(failure.getCauses());
                    }
                    catch (NoSuchMethodException e) {
                        errors.add(e);
                    }
                }
            }
        }

        Object newSuiteInstance() throws Exception {
            return this.suiteClass.newInstance();
        }
    }
}

