/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.function.Consumer;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.RecoveryLabelScanWriterProvider;
import org.neo4j.kernel.impl.api.RecoveryLegacyIndexApplierLookup;
import org.neo4j.kernel.impl.api.index.RecoveryIndexingUpdatesValidator;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.transaction.DeadSimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.DeadSimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.command.CommandHandler;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalWritableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.rotation.StoreFlusher;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.recovery.DefaultRecoverySPI;
import org.neo4j.kernel.recovery.LatestCheckPointFinder;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.test.TargetDirectory;

public class RecoveryTest {
    private final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();
    @Rule
    public final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest(this.getClass());
    private final LogVersionRepository logVersionRepository = new DeadSimpleLogVersionRepository(1L);
    private final TransactionIdStore transactionIdStore = new DeadSimpleTransactionIdStore(5L, 0L, 0L, 0L);
    private final int logVersion = 1;
    private LogEntry lastCommittedTxStartEntry;
    private LogEntry lastCommittedTxCommitEntry;
    private LogEntry expectedStartEntry;
    private LogEntry expectedCommitEntry;
    private LogEntry expectedCheckPointEntry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRecoverExistingData() throws Exception {
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.directory.directory(), "log", this.fs);
        File file = logFiles.getLogFileForVersion(1L);
        this.writeSomeData(file, new Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>(){

            public boolean visit(Pair<LogEntryWriter, Consumer<LogPositionMarker>> pair) throws IOException {
                LogEntryWriter writer = (LogEntryWriter)pair.first();
                Consumer consumer = (Consumer)pair.other();
                LogPositionMarker marker = new LogPositionMarker();
                consumer.accept(marker);
                LogPosition lastCommittedTxPosition = marker.newPosition();
                writer.writeStartEntry(0, 1, 2L, 3L, new byte[0]);
                RecoveryTest.this.lastCommittedTxStartEntry = (LogEntry)new LogEntryStart(0, 1, 2L, 3L, new byte[0], lastCommittedTxPosition);
                writer.writeCommitEntry(4L, 5L);
                RecoveryTest.this.lastCommittedTxCommitEntry = (LogEntry)new OnePhaseCommit(4L, 5L);
                writer.writeCheckPointEntry(lastCommittedTxPosition);
                RecoveryTest.this.expectedCheckPointEntry = (LogEntry)new CheckPoint(lastCommittedTxPosition);
                consumer.accept(marker);
                writer.writeStartEntry(0, 1, 6L, 4L, new byte[0]);
                RecoveryTest.this.expectedStartEntry = (LogEntry)new LogEntryStart(0, 1, 6L, 4L, new byte[0], marker.newPosition());
                writer.writeCommitEntry(5L, 7L);
                RecoveryTest.this.expectedCommitEntry = (LogEntry)new OnePhaseCommit(5L, 7L);
                return true;
            }
        });
        LifeSupport life = new LifeSupport();
        Recovery.Monitor monitor = (Recovery.Monitor)Mockito.mock(Recovery.Monitor.class);
        AtomicBoolean recoveryRequiredCalled = new AtomicBoolean();
        try {
            RecoveryLabelScanWriterProvider provider = (RecoveryLabelScanWriterProvider)Mockito.mock(RecoveryLabelScanWriterProvider.class);
            RecoveryLegacyIndexApplierLookup lookup = (RecoveryLegacyIndexApplierLookup)Mockito.mock(RecoveryLegacyIndexApplierLookup.class);
            RecoveryIndexingUpdatesValidator validator = (RecoveryIndexingUpdatesValidator)Mockito.mock(RecoveryIndexingUpdatesValidator.class);
            StoreFlusher flusher = (StoreFlusher)Mockito.mock(StoreFlusher.class);
            VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader(LogEntryVersion.CURRENT.byteCode());
            LatestCheckPointFinder finder = new LatestCheckPointFinder(logFiles, this.fs, (LogEntryReader)reader);
            life.add((Lifecycle)new Recovery((Recovery.SPI)new DefaultRecoverySPI(provider, lookup, flusher, (NeoStores)Mockito.mock(NeoStores.class), null, logFiles, this.fs, this.logVersionRepository, finder, validator, (LogEntryReader)reader, recoveryRequiredCalled){
                final /* synthetic */ LogEntryReader val$reader;
                final /* synthetic */ AtomicBoolean val$recoveryRequiredCalled;
                {
                    this.val$reader = logEntryReader;
                    this.val$recoveryRequiredCalled = atomicBoolean;
                    super(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9);
                }

                public Visitor<LogVersionedStoreChannel, IOException> getRecoverer() {
                    return new Visitor<LogVersionedStoreChannel, IOException>(){

                        public boolean visit(LogVersionedStoreChannel element) throws IOException {
                            try (ReadAheadLogChannel channel = new ReadAheadLogChannel(element, LogVersionBridge.NO_MORE_CHANNELS, 4096);){
                                Assert.assertEquals((Object)RecoveryTest.this.lastCommittedTxStartEntry, (Object)val$reader.readLogEntry((ReadableLogChannel)channel));
                                Assert.assertEquals((Object)RecoveryTest.this.lastCommittedTxCommitEntry, (Object)val$reader.readLogEntry((ReadableLogChannel)channel));
                                Assert.assertEquals((Object)RecoveryTest.this.expectedCheckPointEntry, (Object)val$reader.readLogEntry((ReadableLogChannel)channel));
                                Assert.assertEquals((Object)RecoveryTest.this.expectedStartEntry, (Object)val$reader.readLogEntry((ReadableLogChannel)channel));
                                Assert.assertEquals((Object)RecoveryTest.this.expectedCommitEntry, (Object)val$reader.readLogEntry((ReadableLogChannel)channel));
                                Assert.assertNull((Object)val$reader.readLogEntry((ReadableLogChannel)channel));
                                boolean bl = true;
                                return bl;
                            }
                        }
                    };
                }

                public void recoveryRequired() {
                    this.val$recoveryRequiredCalled.set(true);
                }
            }, monitor));
            life.add((Lifecycle)new PhysicalLogFile(this.fs, logFiles, 50L, this.transactionIdStore, this.logVersionRepository, (PhysicalLogFile.Monitor)Mockito.mock(PhysicalLogFile.Monitor.class), new TransactionMetadataCache(10, 100)));
            life.start();
            InOrder order = Mockito.inOrder((Object[])new Object[]{monitor});
            ((Recovery.Monitor)order.verify((Object)monitor, Mockito.times((int)1))).recoveryRequired((LogPosition)Matchers.any(LogPosition.class));
            ((Recovery.Monitor)order.verify((Object)monitor, Mockito.times((int)1))).logRecovered((LogPosition)Matchers.any(LogPosition.class));
            ((Recovery.Monitor)order.verify((Object)monitor, Mockito.times((int)1))).recoveryCompleted();
            Assert.assertTrue((boolean)recoveryRequiredCalled.get());
        }
        finally {
            life.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSeeThatACleanDatabaseShouldNotRequireRecovery() throws Exception {
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.directory.directory(), "log", this.fs);
        File file = logFiles.getLogFileForVersion(1L);
        this.writeSomeData(file, new Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>(){

            public boolean visit(Pair<LogEntryWriter, Consumer<LogPositionMarker>> pair) throws IOException {
                LogEntryWriter writer = (LogEntryWriter)pair.first();
                Consumer consumer = (Consumer)pair.other();
                LogPositionMarker marker = new LogPositionMarker();
                consumer.accept(marker);
                writer.writeStartEntry(0, 1, 2L, 3L, new byte[0]);
                writer.writeCommitEntry(4L, 5L);
                consumer.accept(marker);
                writer.writeCheckPointEntry(marker.newPosition());
                return true;
            }
        });
        LifeSupport life = new LifeSupport();
        Recovery.Monitor monitor = (Recovery.Monitor)Mockito.mock(Recovery.Monitor.class);
        try {
            RecoveryLabelScanWriterProvider provider = (RecoveryLabelScanWriterProvider)Mockito.mock(RecoveryLabelScanWriterProvider.class);
            RecoveryLegacyIndexApplierLookup lookup = (RecoveryLegacyIndexApplierLookup)Mockito.mock(RecoveryLegacyIndexApplierLookup.class);
            RecoveryIndexingUpdatesValidator validator = (RecoveryIndexingUpdatesValidator)Mockito.mock(RecoveryIndexingUpdatesValidator.class);
            StoreFlusher flusher = (StoreFlusher)Mockito.mock(StoreFlusher.class);
            VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader(LogEntryVersion.CURRENT.byteCode());
            LatestCheckPointFinder finder = new LatestCheckPointFinder(logFiles, this.fs, (LogEntryReader)reader);
            life.add((Lifecycle)new Recovery((Recovery.SPI)new DefaultRecoverySPI(provider, lookup, flusher, (NeoStores)Mockito.mock(NeoStores.class), null, logFiles, this.fs, this.logVersionRepository, finder, validator){

                public Visitor<LogVersionedStoreChannel, IOException> getRecoverer() {
                    throw new AssertionError((Object)"Recovery should not be required");
                }

                public void recoveryRequired() {
                    Assert.fail((String)"Recovery should not be required");
                }
            }, monitor));
            life.add((Lifecycle)new PhysicalLogFile(this.fs, logFiles, 50L, this.transactionIdStore, this.logVersionRepository, (PhysicalLogFile.Monitor)Mockito.mock(PhysicalLogFile.Monitor.class), new TransactionMetadataCache(10, 100)));
            life.start();
            Mockito.verifyZeroInteractions((Object[])new Object[]{monitor});
        }
        finally {
            life.shutdown();
        }
    }

    private void writeSomeData(File file, Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException> visitor) throws IOException {
        try (PhysicalLogVersionedStoreChannel versionedStoreChannel = new PhysicalLogVersionedStoreChannel(this.fs.open(file, "rw"), 1L, 6);
             final PhysicalWritableLogChannel writableLogChannel = new PhysicalWritableLogChannel((LogVersionedStoreChannel)versionedStoreChannel);){
            LogHeaderWriter.writeLogHeader((WritableLogChannel)writableLogChannel, (long)1L, (long)2L);
            Consumer<LogPositionMarker> consumer = new Consumer<LogPositionMarker>(){

                @Override
                public void accept(LogPositionMarker marker) {
                    try {
                        writableLogChannel.getCurrentPosition(marker);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            LogEntryWriter first = new LogEntryWriter((WritableLogChannel)writableLogChannel, CommandHandler.EMPTY);
            visitor.visit((Object)Pair.of((Object)first, (Object)consumer));
        }
    }
}

