/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.util;

import java.util.Properties;

public class UserAgentBuilder {
    public static final String USER_AGENT = "userAgent";
    private final Properties jdbcDriverProperties;

    public UserAgentBuilder(Properties jdbcDriverProperties) {
        this.jdbcDriverProperties = jdbcDriverProperties;
    }

    public String getAgent() {
        StringBuilder sb = new StringBuilder();
        if (this.jdbcDriverProperties.containsKey(USER_AGENT)) {
            sb.append(this.jdbcDriverProperties.getProperty(USER_AGENT)).append(" via ");
        }
        sb.append(this.getImplementationTitle());
        sb.append("/");
        sb.append(this.getImplementationVersion());
        return sb.toString();
    }

    private String getImplementationVersion() {
        String implementationVersion = this.getClass().getPackage().getImplementationVersion();
        if (implementationVersion == null) {
            implementationVersion = "<unversioned>";
        }
        return implementationVersion;
    }

    private String getImplementationTitle() {
        String implementationTitle = this.getClass().getPackage().getImplementationTitle();
        if (implementationTitle == null) {
            implementationTitle = "Neo4j JDBC Driver";
        }
        return implementationTitle;
    }
}

