/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.util;

import java.io.Closeable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.jdbc.util.ClosableIterator;

public class Closer {
    protected static final Log log = LogFactory.getLog(Closer.class);

    public static void close(Object data) {
        if (data == null) {
            return;
        }
        if (data instanceof AutoCloseable || data instanceof Closeable) {
            try {
                ((AutoCloseable)data).close();
            }
            catch (Exception e) {
                log.warn("Couldn't close object " + data.getClass(), e);
            }
        } else if (data instanceof ClosableIterator) {
            ((ClosableIterator)data).close();
        } else if (data.getClass().getName().equals("org.neo4j.helpers.collection.ClosableIterator")) {
            try {
                data.getClass().getMethod("close", new Class[0]).invoke(data, new Object[0]);
            }
            catch (Exception e) {
                log.warn("Couldn't close object " + data.getClass(), e);
            }
        }
    }
}

