/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.type.TypeReference;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.CharacterSet;
import org.restlet.data.ClientInfo;
import org.restlet.data.MediaType;
import org.restlet.data.Parameter;
import org.restlet.data.Preference;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.ClientResource;
import org.restlet.util.Series;

public class Resources {
    private final Client client;
    private static ObjectMapper mapper = new ObjectMapper();
    private final Reference ref;
    private String user;
    private String password;
    private final String userAgent;

    public Resources(String url, Client client, String userAgent) {
        this.client = client;
        this.userAgent = userAgent;
        this.ref = new Reference(new Reference(url), "/");
    }

    private static void configureClient(Context context, ClientInfo clientInfo) {
        context.getLogger().setLevel(Level.WARNING);
        clientInfo.setAcceptedMediaTypes(Resources.streamingJson());
        clientInfo.setAcceptedCharacterSets(Resources.charsetUtf8());
    }

    static Representation toRepresentation(ObjectNode requestData, ClientResource requestResource) {
        try {
            String jsonString = Resources.toString(requestData);
            Variant variant = new Variant(MediaType.APPLICATION_JSON);
            variant.setCharacterSet(CharacterSet.UTF_8);
            Representation representation = requestResource.toRepresentation(jsonString, variant);
            representation.setCharacterSet(CharacterSet.UTF_8);
            return representation;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Cant convert to representation with UTF-8", ioe);
        }
    }

    private static String toString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private Context createContext() {
        Context context = new Context();
        context.setClientDispatcher(this.client);
        return context;
    }

    public void setAuth(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public DiscoveryClientResource getDiscoveryResource() throws IOException {
        DiscoveryClientResource discovery = this.withAuth(new DiscoveryClientResource(this.createContext(), this.ref, this.userAgent));
        discovery.readInformation();
        return discovery;
    }

    <T extends ClientResource> T withAuth(T resource) {
        if (this.hasAuth()) {
            resource.setChallengeResponse(ChallengeScheme.HTTP_BASIC, this.user, this.password);
        }
        return resource;
    }

    private boolean hasAuth() {
        return this.user != null && this.password != null;
    }

    public ClientResource getCypherResource(String cypherPath) {
        return this.withAuth(new CypherClientResource(new Context(), cypherPath, mapper, this.userAgent));
    }

    public TransactionClientResource getTransactionResource(String transactionPath) {
        return this.withAuth(new TransactionClientResource(new Context(), transactionPath, this.userAgent));
    }

    public TransactionClientResource getTransactionResource(Reference transactionPath) {
        return this.withAuth(new TransactionClientResource(new Context(), transactionPath, this.userAgent));
    }

    public JsonNode readJsonFrom(String uri) {
        try {
            Context context = this.createContext();
            ClientResource resource = this.withAuth(new ClientResource(context, uri));
            Resources.configureClient(context, resource.getClientInfo());
            return mapper.readTree(resource.get().getReader());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error reading data from URI " + uri);
        }
    }

    private String textField(JsonNode node, String field) {
        JsonNode fieldNode = node.get(field);
        if (fieldNode == null) {
            return null;
        }
        return fieldNode.getTextValue();
    }

    public TransactionClientResource subResource(TransactionClientResource res, String segment) {
        return this.withAuth(res.subResource(segment));
    }

    private static List<Preference<CharacterSet>> charsetUtf8() {
        return Arrays.asList(new Preference<CharacterSet>(CharacterSet.UTF_8));
    }

    private static List<Preference<MediaType>> streamingJson() {
        MediaType mediaType = Resources.streamingJsonType();
        return Collections.singletonList(new Preference<MediaType>(mediaType));
    }

    private static MediaType streamingJsonType() {
        Series<Parameter> parameters = new Series<Parameter>(Parameter.class);
        parameters.add("stream", "true");
        return new MediaType(MediaType.APPLICATION_JSON.getName(), parameters);
    }

    public static class TransactionClientResource
    extends Neo4jClientResource {
        private final String userAgent;

        public TransactionClientResource(Context context, String path, String userAgent) {
            super(context, path, userAgent);
            this.userAgent = userAgent;
            Resources.configureClient(context, this.getClientInfo());
        }

        public TransactionClientResource(Context context, Reference path, String userAgent) {
            super(context, path, userAgent);
            this.userAgent = userAgent;
            Resources.configureClient(context, this.getClientInfo());
        }

        public TransactionClientResource subResource(String segment) {
            return new TransactionClientResource(this.getContext(), this.getReference().clone().addSegment(segment), this.userAgent);
        }

        @Override
        public void doError(Status errorStatus) {
            String errors = this.getResponse().getEntityAsText();
            if (errors == null || !errors.isEmpty()) {
                super.doError(new Status(errorStatus.getCode(), "Error executing statement", errors, errorStatus.getUri()));
            }
            super.doError(errorStatus);
        }

        private Collection<Object> findErrors(JsonParser parser) throws IOException {
            parser.nextToken();
            if ("results".equals(parser.getCurrentName())) {
                parser.skipChildren();
                parser.nextToken();
            }
            List errors = Collections.emptyList();
            if ("errors".equals(parser.getCurrentName()) && JsonToken.START_ARRAY == parser.nextToken()) {
                errors = (List)parser.readValueAs(new TypeReference<Object>(){});
            }
            return errors;
        }
    }

    private static class CypherClientResource
    extends Neo4jClientResource {
        private final ObjectMapper mapper;

        public CypherClientResource(Context context, String cypherPath, ObjectMapper mapper, String userAgent) {
            super(context, cypherPath, userAgent);
            this.mapper = mapper;
            Resources.configureClient(context, this.getClientInfo());
        }

        @Override
        public void doError(Status errorStatus) {
            try {
                JsonNode node = this.mapper.readTree(this.getResponse().getEntity().getReader());
                JsonNode message = node.get("message");
                if (message != null) {
                    super.doError(new Status(errorStatus.getCode(), message.toString(), message.toString(), errorStatus.getUri()));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            super.doError(errorStatus);
        }
    }

    public class DiscoveryClientResource
    extends Neo4jClientResource {
        private String version;
        private String transactionPath;
        private String dataUri;
        private String labelPath;
        private String relationshipTypesPath;
        private String propertyKeysPath;

        public DiscoveryClientResource(Context context, Reference ref, String userAgent) {
            super(context, ref, userAgent);
            Resources.configureClient(context, this.getClientInfo());
        }

        public String getVersion() {
            return this.version;
        }

        public void readInformation() throws IOException {
            JsonNode discoveryInfo = mapper.readTree(this.get().getReader());
            this.dataUri = Resources.this.textField(discoveryInfo, "data");
            JsonNode serverData = Resources.this.readJsonFrom(this.dataUri);
            this.version = Resources.this.textField(serverData, "neo4j_version");
            this.labelPath = serverData.get("node_labels").asText();
            this.relationshipTypesPath = serverData.get("relationship_types").asText();
            this.propertyKeysPath = this.dataUri + "propertykeys";
            this.transactionPath = Resources.this.textField(serverData, "transaction");
            if (this.transactionPath == null && this.version.startsWith("2")) {
                this.transactionPath = this.dataUri + "transaction";
            }
        }

        public Collection<String> getLabels() {
            return this.readListFrom(this.labelPath);
        }

        public Collection<String> getRelationshipTypes() {
            return this.readListFrom(this.relationshipTypesPath);
        }

        public Collection<String> getPropertyKeys() {
            return this.readListFrom(this.propertyKeysPath);
        }

        private Collection<String> readListFrom(String uri) {
            Iterator<JsonNode> it = Resources.this.readJsonFrom(uri).getElements();
            ArrayList<String> result = new ArrayList<String>();
            while (it.hasNext()) {
                result.add(it.next().asText());
            }
            return result;
        }

        public String getTransactionPath() {
            return this.transactionPath;
        }
    }

    public static abstract class Neo4jClientResource
    extends ClientResource {
        public Neo4jClientResource(Context context, Reference ref, String userAgent) {
            super(context, ref);
            Resources.configureClient(context, this.getClientInfo());
            this.getClientInfo().setAgent(userAgent);
        }

        public Neo4jClientResource(Context context, String uri, String userAgent) {
            super(context, uri);
            Resources.configureClient(context, this.getClientInfo());
            this.getClientInfo().setAgent(userAgent);
        }

        @Override
        public final Representation toRepresentation(Object source, Variant target) throws IOException {
            target.setCharacterSet(CharacterSet.UTF_8);
            Representation representation = super.toRepresentation(source, target);
            representation.setCharacterSet(CharacterSet.UTF_8);
            return representation;
        }
    }
}

