/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.ext;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.jdbc.Driver;
import org.neo4j.jdbc.Neo4jConnection;
import org.neo4j.jdbc.ResultSetBuilder;

public class LibreOfficeConnection
extends Neo4jConnection
implements Connection {
    public LibreOfficeConnection(Driver driver, String url, Properties properties) throws SQLException {
        super(driver, url, properties);
    }

    @Override
    public ResultSet executeQuery(String query, Map<String, Object> parameters) throws SQLException {
        Pattern pattern = Pattern.compile("SELECT \\* FROM \"(\\w*)\" WHERE \\( 0 = 1 \\)");
        Matcher matcher = pattern.matcher(query);
        if (matcher.matches()) {
            String table = matcher.group(1);
            return this.executeQuery(parameters, table);
        }
        pattern = Pattern.compile("SELECT \\* FROM \"(\\w*)\" WHERE 0 = 1");
        matcher = pattern.matcher(query);
        if (matcher.matches()) {
            String table = matcher.group(1);
            return this.executeQuery(parameters, table);
        }
        pattern = Pattern.compile("SELECT \\* FROM \"(\\w*)\"");
        matcher = pattern.matcher(query);
        if (matcher.matches()) {
            String table = matcher.group(1);
            return this.executeQuery(parameters, table);
        }
        if (query.equals(" WHERE  ( 0 = 1 ) ")) {
            return new ResultSetBuilder().newResultSet(this.debug(this));
        }
        return super.executeQuery(query, parameters);
    }

    protected ResultSet executeQuery(Map<String, Object> parameters, String table) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>(parameters);
        map.put("typeName", table);
        String ewp = this.getDriver().getQueries().getData(table, this.returnProperties(table, "instance"));
        return this.executeQuery(ewp, map);
    }
}

