/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.embedded;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.jdbc.ExecutionResult;
import org.neo4j.jdbc.QueryExecutor;
import org.neo4j.jdbc.Version;

public class EmbeddedQueryExecutor
implements QueryExecutor {
    private final GraphDatabaseService gds;
    ThreadLocal<Transaction> tx = new ThreadLocal();

    public EmbeddedQueryExecutor(GraphDatabaseService gds) {
        this.gds = gds;
    }

    @Override
    public ExecutionResult executeQuery(final String query, Map<String, Object> parameters, final boolean autoCommit) throws Exception {
        Map<Object, Object> params = parameters == null ? Collections.emptyMap() : parameters;
        this.begin();
        final Result result = this.gds.execute(query, params);
        final List columns = result.columns();
        final int cols = columns.size();
        final Object[] resultRow = new Object[cols];
        if (!result.hasNext()) {
            this.commitIfAutoCommit(autoCommit);
        }
        return new ExecutionResult(columns, (Iterator<Object[]>)new IteratorWrapper<Object[], Map<String, Object>>((Iterator)result){
            boolean closed;
            {
                super(x0);
                this.closed = false;
            }

            public Object[] next() {
                try {
                    Object[] objectArray = (Object[])super.next();
                    return objectArray;
                }
                catch (Exception e) {
                    EmbeddedQueryExecutor.this.handleException(e, query);
                    Object[] objectArray = null;
                    return objectArray;
                }
                finally {
                    if (!this.hasNext() && !this.closed) {
                        this.close();
                    }
                }
            }

            protected Object[] underlyingObjectToObject(Map<String, Object> row) {
                for (int i = 0; i < cols; ++i) {
                    resultRow[i] = row.get(columns.get(i));
                }
                return resultRow;
            }

            public void close() {
                result.close();
                this.closed = true;
                EmbeddedQueryExecutor.this.commitIfAutoCommit(autoCommit);
            }
        });
    }

    private void commitIfAutoCommit(boolean autoCommit) {
        if (autoCommit) {
            try {
                this.commit();
            }
            catch (Exception e) {
                throw Exceptions.launderedException((Throwable)e);
            }
        }
    }

    private void begin() {
        if (this.tx.get() == null) {
            this.tx.set(this.gds.beginTx());
        }
    }

    @Override
    public void commit() throws Exception {
        Transaction transaction = this.tx.get();
        if (transaction == null) {
            return;
        }
        this.tx.set(null);
        transaction.success();
        transaction.close();
    }

    @Override
    public void rollback() throws Exception {
        Transaction transaction = this.tx.get();
        if (transaction == null) {
            return;
        }
        this.tx.set(null);
        transaction.failure();
        transaction.close();
    }

    private void handleException(Exception cause, String query) {
        SQLException sqlException = new SQLException("Error executing query: " + query, cause);
        AnyThrow.unchecked(sqlException);
    }

    @Override
    public void stop() throws Exception {
        this.rollback();
    }

    @Override
    public Version getVersion() {
        return new Version(org.neo4j.kernel.Version.getKernel().getRevision());
    }

    public static class AnyThrow {
        public static RuntimeException unchecked(Throwable e) {
            AnyThrow.throwAny(e);
            return null;
        }

        private static <E extends Throwable> void throwAny(Throwable e) throws E {
            throw e;
        }
    }
}

