/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.embedded;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.jdbc.Databases;
import org.neo4j.jdbc.QueryExecutor;
import org.neo4j.jdbc.embedded.EmbeddedQueryExecutor;
import org.neo4j.test.TestGraphDatabaseFactory;

public class EmbeddedDatabases
implements Databases {
    private static final Pattern urlMatcher = Pattern.compile(":([^:]*):(.+)");
    private final WeakHashMap<String, GraphDatabaseService> databases = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphDatabaseService createDatabase(String connectionUrl, Properties properties) {
        Matcher matcher = urlMatcher.matcher(connectionUrl);
        if (!matcher.find()) {
            return EmbeddedDatabases.defaultImpermanentDb();
        }
        try {
            Type type = Type.valueOf(matcher.group(1));
            String name = matcher.group(2);
            GraphDatabaseService gds = this.databases.get(name);
            if (gds != null) {
                return gds;
            }
            Pattern pattern = urlMatcher;
            synchronized (pattern) {
                gds = this.databases.get(name);
                if (gds != null) {
                    return gds;
                }
                gds = type.create(name, properties);
                this.databases.put(name, gds);
            }
            return gds;
        }
        catch (IllegalArgumentException e) {
            return EmbeddedDatabases.defaultImpermanentDb();
        }
    }

    private static GraphDatabaseService defaultImpermanentDb() {
        return new TestGraphDatabaseFactory().newImpermanentDatabase();
    }

    private static GraphDatabaseService withShutdownHook(final GraphDatabaseService db) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                db.shutdown();
            }
        });
        return db;
    }

    @Override
    public QueryExecutor createExecutor(String connectionUrl, Properties properties) {
        GraphDatabaseService gds = this.createDatabase(connectionUrl, properties);
        return new EmbeddedQueryExecutor(gds);
    }

    static enum Type {
        mem{

            @Override
            public GraphDatabaseService create(String name, Properties properties) {
                return EmbeddedDatabases.withShutdownHook(EmbeddedDatabases.defaultImpermanentDb());
            }
        }
        ,
        instance{

            @Override
            public GraphDatabaseService create(String name, Properties properties) {
                return (GraphDatabaseService)properties.remove(name);
            }
        }
        ,
        file{

            @Override
            public GraphDatabaseService create(final String name, Properties properties) {
                GraphDatabaseBuilder builder = new GraphDatabaseBuilder(new GraphDatabaseBuilder.DatabaseCreator(){

                    public GraphDatabaseService newDatabase(Map<String, String> map) {
                        return new GraphDatabaseFactory().newEmbeddedDatabase(new File(name));
                    }
                });
                if (this.isReadOnly(properties)) {
                    builder.setConfig(GraphDatabaseSettings.read_only, "true");
                }
                return EmbeddedDatabases.withShutdownHook(builder.newGraphDatabase());
            }
        };


        public abstract GraphDatabaseService create(String var1, Properties var2);

        protected boolean isReadOnly(Properties properties) {
            return properties != null && properties.getProperty("readonly", "false").equalsIgnoreCase("true");
        }
    }
}

