/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.sql.SQLException;
import java.util.List;
import org.neo4j.jdbc.AbstractResultSet;
import org.neo4j.jdbc.Neo4jColumnMetaData;
import org.neo4j.jdbc.Neo4jConnection;

public class ListResultSet
extends AbstractResultSet {
    private static final int BEFORE_FIRST = -1;
    private int current = -1;
    private List<List<Object>> data;
    private final int rows;

    public ListResultSet(List<Neo4jColumnMetaData> columns, List<List<Object>> data, Neo4jConnection conn) {
        super(columns, conn);
        this.data = data;
        this.rows = this.data.size();
    }

    @Override
    public boolean next() throws SQLException {
        ++this.current;
        return this.rows > this.current;
    }

    @Override
    protected Object[] currentRow() {
        return this.data.get(this.current).toArray();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.current == -1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.current >= this.rows;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.current == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.current == this.rows - 1;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.current = -1;
    }

    @Override
    public void afterLast() throws SQLException {
        this.current = this.rows;
    }

    @Override
    public boolean first() throws SQLException {
        this.current = 0;
        return true;
    }

    @Override
    public boolean last() throws SQLException {
        this.current = this.rows - 1;
        return true;
    }

    @Override
    public int getRow() throws SQLException {
        return this.current + 1;
    }

    @Override
    public boolean absolute(int i) throws SQLException {
        this.current = i > 0 ? i - 1 : this.rows - i;
        return false;
    }

    @Override
    public boolean relative(int i) throws SQLException {
        if (this.current + i >= 0 && this.current + i < this.rows) {
            this.current += i;
            return true;
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        return this.relative(-1);
    }

    @Override
    public String toString() {
        String result = super.toString();
        for (List<Object> row : this.data) {
            result = result + "\n" + row;
        }
        return result;
    }
}

