/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.neo4j.jdbc.Neo4jColumnMetaData;
import org.neo4j.jdbc.Neo4jConnection;
import org.neo4j.jdbc.Neo4jResultSetMetaData;

public abstract class AbstractResultSet
implements ResultSet {
    protected static final Log log = LogFactory.getLog(AbstractResultSet.class);
    private boolean closed = false;
    private List<Neo4jColumnMetaData> columns;
    private Neo4jConnection conn;
    private String[] columnNames;
    private int cols;
    private boolean wasNull = false;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    public String toString() {
        return "Columns: " + Arrays.toString(this.columnNames);
    }

    public AbstractResultSet(List<Neo4jColumnMetaData> columns, Neo4jConnection conn) {
        this.conn = conn;
        this.cols = columns.size();
        this.columns = columns;
        this.columnNames = this.extractColumnNames(columns);
    }

    public AbstractResultSet(Neo4jConnection conn, List<String> columns) {
        this.conn = conn;
        this.cols = columns.size();
        this.columnNames = columns.toArray(new String[this.cols]);
        this.columns = this.createMetadataFor(columns);
    }

    protected List<Neo4jColumnMetaData> createMetadataFor(List<String> columns) {
        ArrayList<Neo4jColumnMetaData> result = new ArrayList<Neo4jColumnMetaData>(columns.size());
        for (String column : columns) {
            result.add(new Neo4jColumnMetaData(column, "String", 12));
        }
        return result;
    }

    private String[] extractColumnNames(List<Neo4jColumnMetaData> columns) {
        String[] result = new String[columns.size()];
        for (int i = 0; i < this.cols; ++i) {
            result[i] = columns.get(i).getName();
        }
        return result;
    }

    @Override
    public String getString(int i) throws SQLException {
        Object value = this.get(i);
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (String.class.equals(type)) {
            return (String)value;
        }
        if (type.isPrimitive() || Number.class.isAssignableFrom(type)) {
            return value.toString();
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(value);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Couldn't convert value " + value + " of type " + type + " to JSON " + e.getMessage());
            }
            return value.toString();
        }
    }

    @Override
    public boolean getBoolean(int i) throws SQLException {
        return (Boolean)this.get(i);
    }

    @Override
    public byte getByte(int i) throws SQLException {
        return this.getNumber(i).byteValue();
    }

    @Override
    public short getShort(int i) throws SQLException {
        return this.getNumber(i).shortValue();
    }

    @Override
    public int getInt(int i) throws SQLException {
        return this.getNumber(i).intValue();
    }

    @Override
    public long getLong(int i) throws SQLException {
        return this.getNumber(i).longValue();
    }

    private Number getNumber(int i) throws SQLException {
        Object value = this.get(i);
        if (value == null) {
            return 0;
        }
        if (!(value instanceof Number)) {
            throw new SQLDataException("Value is not a number" + value);
        }
        return (Number)value;
    }

    private Object get(int column) throws SQLDataException {
        if (column < 1 || column > this.cols) {
            throw new SQLDataException("Column " + column + " is invalid");
        }
        Object value = this.currentRow()[column - 1];
        this.wasNull = value == null;
        return value;
    }

    protected abstract Object[] currentRow();

    @Override
    public float getFloat(int i) throws SQLException {
        return this.getNumber(i).floatValue();
    }

    @Override
    public double getDouble(int i) throws SQLException {
        return this.getNumber(i).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int i, int i1) throws SQLException {
        return (BigDecimal)this.get(i);
    }

    @Override
    public byte[] getBytes(int i) throws SQLException {
        return (byte[])this.get(i);
    }

    @Override
    public Date getDate(int i) throws SQLException {
        return new Date(this.getTimeInMillis(i));
    }

    @Override
    public Time getTime(int i) throws SQLException {
        return new Time(this.getTimeInMillis(i));
    }

    @Override
    public Timestamp getTimestamp(int i) throws SQLException {
        return new Timestamp(this.getTimeInMillis(i));
    }

    private long getTimeInMillis(int i) throws SQLException {
        Number number = this.getNumber(i);
        return number.longValue();
    }

    @Override
    public InputStream getAsciiStream(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("Type AsciiStream");
    }

    @Override
    public InputStream getUnicodeStream(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("Type UnicodeStream");
    }

    @Override
    public InputStream getBinaryStream(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("Type BinaryStream");
    }

    @Override
    public String getString(String s) throws SQLException {
        return this.getString(this.findColumn(s));
    }

    @Override
    public boolean getBoolean(String s) throws SQLException {
        return this.getBoolean(this.findColumn(s));
    }

    @Override
    public byte getByte(String s) throws SQLException {
        return this.getByte(this.findColumn(s));
    }

    @Override
    public short getShort(String s) throws SQLException {
        return this.getShort(this.findColumn(s));
    }

    @Override
    public int getInt(String s) throws SQLException {
        return this.getInt(this.findColumn(s));
    }

    @Override
    public long getLong(String s) throws SQLException {
        return this.getLong(this.findColumn(s));
    }

    @Override
    public float getFloat(String s) throws SQLException {
        return this.getFloat(this.findColumn(s));
    }

    @Override
    public double getDouble(String s) throws SQLException {
        return this.getDouble(this.findColumn(s));
    }

    @Override
    public BigDecimal getBigDecimal(String s, int i) throws SQLException {
        return this.getBigDecimal(this.findColumn(s));
    }

    @Override
    public byte[] getBytes(String s) throws SQLException {
        return this.getBytes(this.findColumn(s));
    }

    @Override
    public Date getDate(String s) throws SQLException {
        return this.getDate(this.findColumn(s));
    }

    @Override
    public Time getTime(String s) throws SQLException {
        return this.getTime(this.findColumn(s));
    }

    @Override
    public Timestamp getTimestamp(String s) throws SQLException {
        return this.getTimestamp(this.findColumn(s));
    }

    @Override
    public InputStream getAsciiStream(String s) throws SQLException {
        return this.getAsciiStream(this.findColumn(s));
    }

    @Override
    public InputStream getUnicodeStream(String s) throws SQLException {
        return this.getUnicodeStream(this.findColumn(s));
    }

    @Override
    public InputStream getBinaryStream(String s) throws SQLException {
        return this.getBinaryStream(this.findColumn(s));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        return null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.conn.debug(new Neo4jResultSetMetaData(this.columns));
    }

    @Override
    public Object getObject(int i) throws SQLException {
        return this.get(i);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return type.cast(this.getObject(columnIndex));
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return type.cast(this.getObject(columnLabel));
    }

    @Override
    public Object getObject(String s) throws SQLException {
        return this.getObject(this.findColumn(s));
    }

    @Override
    public int findColumn(String column) throws SQLException {
        if (column != null) {
            for (int i = 0; i < this.cols; ++i) {
                if (!column.equals(this.columnNames[i])) continue;
                return i + 1;
            }
        }
        throw new SQLException("No such column:" + column);
    }

    @Override
    public Reader getCharacterStream(int i) throws SQLException {
        return new StringReader(this.getString(i));
    }

    @Override
    public Reader getCharacterStream(String s) throws SQLException {
        return new StringReader(this.getString(s));
    }

    @Override
    public BigDecimal getBigDecimal(int i) throws SQLException {
        double d = this.getDouble(i);
        long l = this.getLong(i);
        return (double)l == d ? BigDecimal.valueOf(l) : BigDecimal.valueOf(d);
    }

    @Override
    public BigDecimal getBigDecimal(String s) throws SQLException {
        return this.getBigDecimal(this.findColumn(s));
    }

    @Override
    public void setFetchDirection(int i) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int i) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public void updateNull(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBoolean(int i, boolean b) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateByte(int i, byte b) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateShort(int i, short i1) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateInt(int i, int i1) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateLong(int i, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateFloat(int i, float v) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateDouble(int i, double v) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBigDecimal(int i, BigDecimal bigDecimal) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateString(int i, String s) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBytes(int i, byte[] bytes) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateDate(int i, Date date) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateTime(int i, Time time) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateTimestamp(int i, Timestamp timestamp) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateAsciiStream(int i, InputStream inputStream, int i1) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBinaryStream(int i, InputStream inputStream, int i1) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateCharacterStream(int i, Reader reader, int i1) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateObject(int i, Object o, int i1) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateObject(int i, Object o) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateNull(String s) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBoolean(String s, boolean b) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateByte(String s, byte b) throws SQLException {
    }

    @Override
    public void updateShort(String s, short i) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateInt(String s, int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateLong(String s, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateFloat(String s, float v) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateDouble(String s, double v) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBigDecimal(String s, BigDecimal bigDecimal) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateString(String s, String s1) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBytes(String s, byte[] bytes) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateDate(String s, Date date) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateTime(String s, Time time) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateTimestamp(String s, Timestamp timestamp) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateAsciiStream(String s, InputStream inputStream, int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateBinaryStream(String s, InputStream inputStream, int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateCharacterStream(String s, Reader reader, int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateObject(String s, Object o, int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateObject(String s, Object o) throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("update");
    }

    @Override
    public void refreshRow() throws SQLException {
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("move to insert row");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("move to current row");
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> typeMap) throws SQLException {
        return null;
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("get ref");
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("get blob");
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("get clob");
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("get array");
    }

    @Override
    public Object getObject(String s, Map<String, Class<?>> typeMap) throws SQLException {
        return this.getObject(this.findColumn(s), typeMap);
    }

    @Override
    public Ref getRef(String s) throws SQLException {
        return this.getRef(this.findColumn(s));
    }

    @Override
    public Blob getBlob(String s) throws SQLException {
        return this.getBlob(this.findColumn(s));
    }

    @Override
    public Clob getClob(String s) throws SQLException {
        return this.getClob(this.findColumn(s));
    }

    @Override
    public Array getArray(String s) throws SQLException {
        return this.getArray(this.findColumn(s));
    }

    @Override
    public Date getDate(int i, Calendar calendar) throws SQLException {
        return new Date(this.getCalendarTimeInMillis(i, calendar));
    }

    private long getCalendarTimeInMillis(int i, Calendar calendar) throws SQLException {
        calendar.setTimeInMillis(this.getTimeInMillis(i));
        return calendar.getTimeInMillis();
    }

    @Override
    public Date getDate(String s, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(s), calendar);
    }

    @Override
    public Time getTime(int i, Calendar calendar) throws SQLException {
        return new Time(this.getCalendarTimeInMillis(i, calendar));
    }

    @Override
    public Time getTime(String s, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(s), calendar);
    }

    @Override
    public Timestamp getTimestamp(int i, Calendar calendar) throws SQLException {
        return new Timestamp(this.getCalendarTimeInMillis(i, calendar));
    }

    @Override
    public Timestamp getTimestamp(String s, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(s), calendar);
    }

    @Override
    public URL getURL(int i) throws SQLException {
        String url = this.getString(i);
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new SQLDataException("Malformed url " + url);
        }
    }

    @Override
    public URL getURL(String s) throws SQLException {
        return this.getURL(this.findColumn(s));
    }

    @Override
    public void updateRef(int i, Ref ref) throws SQLException {
        String type = "ref";
        this.notSupportedUpdate(type);
    }

    private void notSupportedUpdate(String type) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("update " + type);
    }

    @Override
    public void updateRef(String s, Ref ref) throws SQLException {
        this.notSupportedUpdate("ref");
    }

    @Override
    public void updateBlob(int i, Blob blob) throws SQLException {
        this.notSupportedUpdate("blob");
    }

    @Override
    public void updateBlob(String s, Blob blob) throws SQLException {
        this.notSupportedUpdate("blob");
    }

    @Override
    public void updateClob(int i, Clob clob) throws SQLException {
        this.notSupportedUpdate("clob");
    }

    @Override
    public void updateClob(String s, Clob clob) throws SQLException {
        this.notSupportedUpdate("clob");
    }

    @Override
    public void updateArray(int i, Array array) throws SQLException {
        this.notSupportedUpdate("array");
    }

    @Override
    public void updateArray(String s, Array array) throws SQLException {
        this.notSupportedUpdate("array");
    }

    @Override
    public RowId getRowId(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("get rowid");
    }

    @Override
    public RowId getRowId(String s) throws SQLException {
        throw new SQLFeatureNotSupportedException("get rowid");
    }

    @Override
    public void updateRowId(int i, RowId rowId) throws SQLException {
        this.notSupportedUpdate("rowid");
    }

    @Override
    public void updateRowId(String s, RowId rowId) throws SQLException {
        this.notSupportedUpdate("rowid");
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public void updateNString(int i, String s) throws SQLException {
        this.notSupportedUpdate("nstring");
    }

    @Override
    public void updateNString(String s, String s1) throws SQLException {
        this.notSupportedUpdate("nstring");
    }

    @Override
    public void updateNClob(int i, NClob nClob) throws SQLException {
        this.notSupportedUpdate("nclob");
    }

    @Override
    public void updateNClob(String s, NClob nClob) throws SQLException {
        this.notSupportedUpdate("nclob");
    }

    @Override
    public NClob getNClob(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("get nclob");
    }

    @Override
    public NClob getNClob(String s) throws SQLException {
        throw new SQLFeatureNotSupportedException("get nclob");
    }

    @Override
    public SQLXML getSQLXML(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("get sqlxml");
    }

    @Override
    public SQLXML getSQLXML(String s) throws SQLException {
        throw new SQLFeatureNotSupportedException("get sqlxml");
    }

    @Override
    public void updateSQLXML(int i, SQLXML sqlxml) throws SQLException {
        this.notSupportedUpdate("sqlxml");
    }

    @Override
    public void updateSQLXML(String s, SQLXML sqlxml) throws SQLException {
        this.notSupportedUpdate("sqlxml");
    }

    @Override
    public String getNString(int i) throws SQLException {
        return this.getString(i);
    }

    @Override
    public String getNString(String s) throws SQLException {
        return this.getString(s);
    }

    @Override
    public Reader getNCharacterStream(int i) throws SQLException {
        return this.getCharacterStream(i);
    }

    @Override
    public Reader getNCharacterStream(String s) throws SQLException {
        return this.getCharacterStream(s);
    }

    @Override
    public void updateNCharacterStream(int i, Reader reader, long l) throws SQLException {
        this.notSupportedUpdate("ncharacterstream");
    }

    @Override
    public void updateNCharacterStream(String s, Reader reader, long l) throws SQLException {
        this.notSupportedUpdate("ncharacterstream");
    }

    @Override
    public void updateAsciiStream(int i, InputStream inputStream, long l) throws SQLException {
        this.notSupportedUpdate("asciistream");
    }

    @Override
    public void updateBinaryStream(int i, InputStream inputStream, long l) throws SQLException {
        this.notSupportedUpdate("binarystream");
    }

    @Override
    public void updateCharacterStream(int i, Reader reader, long l) throws SQLException {
        this.notSupportedUpdate("characterstream");
    }

    @Override
    public void updateAsciiStream(String s, InputStream inputStream, long l) throws SQLException {
        this.notSupportedUpdate("asciistream");
    }

    @Override
    public void updateBinaryStream(String s, InputStream inputStream, long l) throws SQLException {
        this.notSupportedUpdate("binarystream");
    }

    @Override
    public void updateCharacterStream(String s, Reader reader, long l) throws SQLException {
        this.notSupportedUpdate("characterstream");
    }

    @Override
    public void updateBlob(int i, InputStream inputStream, long l) throws SQLException {
        this.notSupportedUpdate("blob");
    }

    @Override
    public void updateBlob(String s, InputStream inputStream, long l) throws SQLException {
        this.notSupportedUpdate("blob");
    }

    @Override
    public void updateClob(int i, Reader reader, long l) throws SQLException {
        this.notSupportedUpdate("clob");
    }

    @Override
    public void updateClob(String s, Reader reader, long l) throws SQLException {
        this.notSupportedUpdate("clob");
    }

    @Override
    public void updateNClob(int i, Reader reader, long l) throws SQLException {
        this.notSupportedUpdate("nclob");
    }

    @Override
    public void updateNClob(String s, Reader reader, long l) throws SQLException {
        this.notSupportedUpdate("nclob");
    }

    @Override
    public void updateNCharacterStream(int i, Reader reader) throws SQLException {
        this.notSupportedUpdate("ncharacterstream");
    }

    @Override
    public void updateNCharacterStream(String s, Reader reader) throws SQLException {
        this.notSupportedUpdate("ncharacterstream");
    }

    @Override
    public void updateAsciiStream(int i, InputStream inputStream) throws SQLException {
        this.notSupportedUpdate("asciistream");
    }

    @Override
    public void updateBinaryStream(int i, InputStream inputStream) throws SQLException {
        this.notSupportedUpdate("binarystream");
    }

    @Override
    public void updateCharacterStream(int i, Reader reader) throws SQLException {
        this.notSupportedUpdate("characterstream");
    }

    @Override
    public void updateAsciiStream(String s, InputStream inputStream) throws SQLException {
        this.notSupportedUpdate("asciistream");
    }

    @Override
    public void updateBinaryStream(String s, InputStream inputStream) throws SQLException {
        this.notSupportedUpdate("binarystream");
    }

    @Override
    public void updateCharacterStream(String s, Reader reader) throws SQLException {
        this.notSupportedUpdate("characterstream");
    }

    @Override
    public void updateBlob(int i, InputStream inputStream) throws SQLException {
        this.notSupportedUpdate("blob");
    }

    @Override
    public void updateBlob(String s, InputStream inputStream) throws SQLException {
        this.notSupportedUpdate("blob");
    }

    @Override
    public void updateClob(int i, Reader reader) throws SQLException {
        this.notSupportedUpdate("clob");
    }

    @Override
    public void updateClob(String s, Reader reader) throws SQLException {
        this.notSupportedUpdate("clob");
    }

    @Override
    public void updateNClob(int i, Reader reader) throws SQLException {
        this.notSupportedUpdate("nclob");
    }

    @Override
    public void updateNClob(String s, Reader reader) throws SQLException {
        this.notSupportedUpdate("nclob");
    }

    @Override
    public <T> T unwrap(Class<T> tClass) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        return false;
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }
}

