/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.stress;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.stress.StressTestRecord;

public class CountUpdater {
    private final int countersPerRecord;

    public CountUpdater(int countersPerRecord) {
        this.countersPerRecord = countersPerRecord;
    }

    public void updateCount(PageCursor cursor, int recordNumber, int counterNumber) {
        this.setOffset(cursor, recordNumber, counterNumber);
        long count = cursor.getLong();
        this.setOffset(cursor, recordNumber, counterNumber);
        cursor.putLong(count + 1L);
        this.setOffset(cursor, recordNumber, this.countersPerRecord);
        long checksum = cursor.getLong();
        this.setOffset(cursor, recordNumber, this.countersPerRecord);
        cursor.putLong(checksum + 1L);
    }

    private void setOffset(PageCursor cursor, int recordNumber, int counterNumber) {
        cursor.setOffset((recordNumber * (this.countersPerRecord + 1) + counterNumber) * StressTestRecord.SizeOfCounter);
    }
}

