/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.File;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.neo4j.io.pagecache.Page;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.impl.ByteBufferPage;

public class StubPageCursor
implements PageCursor {
    private long pageId;
    private int pageSize;
    protected ByteBufferPage page;
    private int currentOffset;

    public StubPageCursor(long initialPageId, int pageSize) {
        this.pageId = initialPageId;
        this.pageSize = pageSize;
        this.page = new ByteBufferPage(ByteBuffer.allocateDirect(pageSize));
    }

    public StubPageCursor(long initialPageId, ByteBuffer buffer) {
        this.pageId = initialPageId;
        this.pageSize = buffer.capacity();
        this.page = new ByteBufferPage(buffer);
    }

    @Override
    public long getCurrentPageId() {
        return this.pageId;
    }

    @Override
    public int getCurrentPageSize() {
        return this.pageSize;
    }

    @Override
    public File getCurrentFile() {
        return new File("");
    }

    @Override
    public void rewind() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean next() throws IOException {
        return false;
    }

    @Override
    public boolean next(long pageId) throws IOException {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean shouldRetry() throws IOException {
        return false;
    }

    @Override
    public byte getByte() {
        byte value = this.getByte(this.currentOffset);
        ++this.currentOffset;
        return value;
    }

    @Override
    public byte getByte(int offset) {
        try {
            return this.page.getByte(offset);
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            throw this.outOfBoundsException(e);
        }
    }

    @Override
    public void putByte(byte value) {
        this.putByte(this.currentOffset, value);
        ++this.currentOffset;
    }

    @Override
    public void putByte(int offset, byte value) {
        try {
            this.page.putByte(value, offset);
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            throw this.outOfBoundsException(e);
        }
    }

    @Override
    public long getLong() {
        long value = this.getLong(this.currentOffset);
        this.currentOffset += 8;
        return value;
    }

    @Override
    public long getLong(int offset) {
        try {
            return this.page.getLong(offset);
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            throw this.outOfBoundsException(e);
        }
    }

    @Override
    public void putLong(long value) {
        this.putLong(this.currentOffset, value);
        this.currentOffset += 8;
    }

    @Override
    public void putLong(int offset, long value) {
        try {
            this.page.putLong(value, offset);
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            throw this.outOfBoundsException(e);
        }
    }

    @Override
    public int getInt() {
        int value = this.getInt(this.currentOffset);
        this.currentOffset += 4;
        return value;
    }

    @Override
    public int getInt(int offset) {
        try {
            return this.page.getInt(offset);
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            throw this.outOfBoundsException(e);
        }
    }

    @Override
    public long getUnsignedInt() {
        return (long)this.getInt() & 0xFFFFFFFFL;
    }

    @Override
    public long getUnsignedInt(int offset) {
        return (long)this.getInt(offset) & 0xFFFFFFFFL;
    }

    @Override
    public void putInt(int value) {
        this.putInt(this.currentOffset, value);
        this.currentOffset += 4;
    }

    @Override
    public void putInt(int offset, int value) {
        try {
            this.page.putInt(value, offset);
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            throw this.outOfBoundsException(e);
        }
    }

    @Override
    public void getBytes(byte[] data) {
        this.getBytes(data, 0, data.length);
    }

    @Override
    public void getBytes(byte[] data, int arrayOffset, int length) {
        try {
            this.page.getBytes(data, this.currentOffset, arrayOffset, length);
            this.currentOffset += length;
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            throw this.outOfBoundsException(e);
        }
    }

    @Override
    public void putBytes(byte[] data) {
        this.putBytes(data, 0, data.length);
    }

    @Override
    public void putBytes(byte[] data, int arrayOffset, int length) {
        try {
            this.page.putBytes(data, this.currentOffset, arrayOffset, length);
            this.currentOffset += length;
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            throw this.outOfBoundsException(e);
        }
    }

    @Override
    public short getShort() {
        short value = this.getShort(this.currentOffset);
        this.currentOffset += 2;
        return value;
    }

    @Override
    public short getShort(int offset) {
        try {
            return this.page.getShort(offset);
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            throw this.outOfBoundsException(e);
        }
    }

    @Override
    public void putShort(short value) {
        this.putShort(this.currentOffset, value);
        this.currentOffset += 2;
    }

    @Override
    public void putShort(int offset, short value) {
        try {
            this.page.putShort(value, offset);
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            throw this.outOfBoundsException(e);
        }
    }

    @Override
    public int getOffset() {
        return this.currentOffset;
    }

    @Override
    public void setOffset(int offset) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.currentOffset = offset;
    }

    public Page getPage() {
        return this.page;
    }

    public String toString() {
        return "PageCursor{currentOffset=" + this.currentOffset + ", page=" + this.page + '}';
    }

    private RuntimeException outOfBoundsException(RuntimeException e) {
        return new RuntimeException("Failed to read or write to page: " + this.toString(), e);
    }
}

