/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.net.URI;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Strings;

public class StringsTest {
    @Test
    public void testDecamelize() {
        Assert.assertEquals((Object)"foo", (Object)Strings.decamelize.apply((Object)"foo"));
        Assert.assertEquals((Object)"foo", (Object)Strings.decamelize.apply((Object)"Foo"));
        Assert.assertEquals((Object)"foo_bar", (Object)Strings.decamelize.apply((Object)"FooBar"));
        Assert.assertEquals((Object)"f_b", (Object)Strings.decamelize.apply((Object)"FB"));
        Assert.assertEquals((Object)"_", (Object)Strings.decamelize.apply((Object)"_"));
    }

    @Test
    public void testPrettyPrint() {
        Object[] recursiveArray;
        Assert.assertEquals((Object)"null", (Object)Strings.prettyPrint(null));
        Assert.assertEquals((Object)"42", (Object)Strings.prettyPrint((Object)42));
        Assert.assertEquals((Object)"42", (Object)Strings.prettyPrint((Object)"42"));
        Assert.assertEquals((Object)"[1, 2, 3, 4]", (Object)Strings.prettyPrint((Object)new int[]{1, 2, 3, 4}));
        Assert.assertEquals((Object)"[false, true, true, false]", (Object)Strings.prettyPrint((Object)new boolean[]{false, true, true, false}));
        Assert.assertEquals((Object)"[a, b, z]", (Object)Strings.prettyPrint((Object)new char[]{'a', 'b', 'z'}));
        Assert.assertEquals((Object)"[ab, cd, zx]", (Object)Strings.prettyPrint((Object)new String[]{"ab", "cd", "zx"}));
        Assert.assertEquals((Object)"[Cat, [http://neo4j.com, http://neo4j.org], Dog, [1, 2, 3], [[[Wolf]]]]", (Object)Strings.prettyPrint((Object)new Object[]{"Cat", new URI[]{URI.create("http://neo4j.com"), URI.create("http://neo4j.org")}, "Dog", new int[]{1, 2, 3}, new Object[]{new Object[]{new Object[]{"Wolf"}}}}));
        recursiveArray[1] = recursiveArray = new Object[]{10.12345, null, "String"};
        Assert.assertEquals((Object)"[10.12345, [...], String]", (Object)Strings.prettyPrint((Object)recursiveArray));
    }

    @Test
    public void testEscape() {
        Assert.assertEquals((Object)"abc", (Object)Strings.escape((String)"abc"));
        Assert.assertEquals((Object)"Abc", (Object)Strings.escape((String)"Abc"));
        Assert.assertEquals((Object)"a\\\"bc", (Object)Strings.escape((String)"a\"bc"));
        Assert.assertEquals((Object)"a\\'bc", (Object)Strings.escape((String)"a'bc"));
        Assert.assertEquals((Object)"a\\\\bc", (Object)Strings.escape((String)"a\\bc"));
        Assert.assertEquals((Object)"a\\nbc", (Object)Strings.escape((String)"a\nbc"));
        Assert.assertEquals((Object)"a\\tbc", (Object)Strings.escape((String)"a\tbc"));
        Assert.assertEquals((Object)"a\\rbc", (Object)Strings.escape((String)"a\rbc"));
        Assert.assertEquals((Object)"a\\bbc", (Object)Strings.escape((String)"a\bbc"));
        Assert.assertEquals((Object)"a\\fbc", (Object)Strings.escape((String)"a\fbc"));
    }

    @Test
    public void testJoiningLines() {
        Assert.assertEquals((Object)("a" + System.lineSeparator() + "b" + System.lineSeparator() + "c" + System.lineSeparator()), (Object)Strings.joinAsLines((String[])new String[]{"a", "b", "c"}));
    }
}

