/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.mockfs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import org.neo4j.graphdb.mockfs.LimitedFilesystemAbstraction;
import org.neo4j.io.fs.StoreChannel;

public class LimitedFileChannel
implements StoreChannel {
    private final StoreChannel inner;
    private final LimitedFilesystemAbstraction fs;

    public LimitedFileChannel(StoreChannel inner, LimitedFilesystemAbstraction limitedFilesystemAbstraction) {
        this.inner = inner;
        this.fs = limitedFilesystemAbstraction;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.inner.read(byteBuffer);
    }

    @Override
    public long read(ByteBuffer[] byteBuffers, int i, int i1) throws IOException {
        return this.inner.read(byteBuffers, i, i1);
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return 0L;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.fs.ensureHasSpace();
        return this.inner.write(byteBuffer);
    }

    @Override
    public long write(ByteBuffer[] byteBuffers, int i, int i1) throws IOException {
        this.fs.ensureHasSpace();
        return this.inner.write(byteBuffers, i, i1);
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return 0L;
    }

    @Override
    public long position() throws IOException {
        return this.inner.position();
    }

    @Override
    public LimitedFileChannel position(long l) throws IOException {
        return new LimitedFileChannel(this.inner.position(l), this.fs);
    }

    @Override
    public long size() throws IOException {
        return this.inner.size();
    }

    @Override
    public LimitedFileChannel truncate(long l) throws IOException {
        return new LimitedFileChannel(this.inner.truncate(l), this.fs);
    }

    @Override
    public void force(boolean b) throws IOException {
        this.fs.ensureHasSpace();
        this.inner.force(b);
    }

    @Override
    public int read(ByteBuffer byteBuffer, long l) throws IOException {
        return this.inner.read(byteBuffer, l);
    }

    @Override
    public FileLock tryLock() throws IOException {
        return this.inner.tryLock();
    }

    @Override
    public int write(ByteBuffer byteBuffer, long l) throws IOException {
        return this.inner.write(byteBuffer, l);
    }

    @Override
    public void writeAll(ByteBuffer src, long position) throws IOException {
        this.fs.ensureHasSpace();
        this.inner.writeAll(src, position);
    }

    @Override
    public void writeAll(ByteBuffer src) throws IOException {
        this.fs.ensureHasSpace();
        this.inner.writeAll(src);
    }

    @Override
    public boolean isOpen() {
        return this.inner.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.inner.close();
    }

    @Override
    public void flush() throws IOException {
        this.inner.flush();
    }
}

