/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cursor.Cursor;
import org.neo4j.function.Consumer;
import org.neo4j.function.Function;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.TopLevelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.cursor.NodeItem;
import org.neo4j.kernel.impl.factory.CommunityEditionModule;
import org.neo4j.kernel.impl.factory.CommunityFacadeFactory;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.TestGraphDatabaseFactoryState;
import org.neo4j.test.impl.EphemeralIdGenerator;
import org.neo4j.tooling.GlobalGraphOperations;

public class LabelsAcceptanceTest {
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();

    @Test
    public void shouldInsertLabelsWithoutDuplicatingThem() throws Exception {
        final Node node = this.dbRule.executeAndCommit(new Function<GraphDatabaseService, Node>(){

            @Override
            public Node apply(GraphDatabaseService db) {
                return db.createNode();
            }
        });
        this.dbRule.executeAndCommit((Consumer<? super GraphDatabaseService>)new Consumer<GraphDatabaseService>(){

            @Override
            public void accept(GraphDatabaseService db) {
                node.addLabel(DynamicLabel.label((String)"FOOBAR"));
            }
        });
        this.dbRule.executeAndCommit((Consumer<? super GraphDatabaseService>)new Consumer<GraphDatabaseService>(){

            @Override
            public void accept(GraphDatabaseService db) {
                node.addLabel(DynamicLabel.label((String)"BAZQUX"));
            }
        });
        this.dbRule.executeAndCommit((Consumer<? super GraphDatabaseService>)new Consumer<GraphDatabaseService>(){

            @Override
            public void accept(GraphDatabaseService db) {
                for (Label label : node.getLabels()) {
                    node.removeLabel(label);
                }
                node.addLabel(DynamicLabel.label((String)"BAZQUX"));
            }
        });
        List<Label> labels = this.dbRule.executeAndCommit(new Function<GraphDatabaseService, List<Label>>(){

            @Override
            public List<Label> apply(GraphDatabaseService db) {
                ArrayList<Label> labels = new ArrayList<Label>();
                for (Label label : node.getLabels()) {
                    labels.add(label);
                }
                return labels;
            }
        });
        Assert.assertEquals((String)labels.toString(), (long)1L, (long)labels.size());
        Assert.assertEquals((Object)"BAZQUX", (Object)labels.get(0).name());
    }

    @Test
    public void addingALabelUsingAValidIdentifierShouldSucceed() throws Exception {
        GraphDatabaseService graphDatabase = this.dbRule.getGraphDatabaseService();
        Node myNode = null;
        try (Transaction tx = graphDatabase.beginTx();){
            myNode = graphDatabase.createNode();
            myNode.addLabel((Label)Labels.MY_LABEL);
            tx.success();
        }
        Assert.assertThat((String)"Label should have been added to node", (Object)myNode, Neo4jMatchers.inTx(graphDatabase, Neo4jMatchers.hasLabel(Labels.MY_LABEL)));
    }

    @Test
    public void addingALabelUsingAnInvalidIdentifierShouldFail() throws Exception {
        Throwable throwable;
        GraphDatabaseService graphDatabase = this.dbRule.getGraphDatabaseService();
        try {
            throwable = null;
            try (Transaction tx = graphDatabase.beginTx();){
                graphDatabase.createNode().addLabel(DynamicLabel.label((String)""));
                Assert.fail((String)"Should have thrown exception");
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
        }
        catch (ConstraintViolationException tx) {
            // empty catch block
        }
        try {
            throwable = null;
            try (Transaction tx2 = graphDatabase.beginTx();){
                graphDatabase.createNode().addLabel(DynamicLabel.label(null));
                Assert.fail((String)"Should have thrown exception");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void addingALabelThatAlreadyExistsBehavesAsNoOp() throws Exception {
        GraphDatabaseService graphDatabase = this.dbRule.getGraphDatabaseService();
        Node myNode = null;
        try (Transaction tx = graphDatabase.beginTx();){
            myNode = graphDatabase.createNode();
            myNode.addLabel((Label)Labels.MY_LABEL);
            myNode.addLabel((Label)Labels.MY_LABEL);
            tx.success();
        }
        Assert.assertThat((String)"Label should have been added to node", (Object)myNode, Neo4jMatchers.inTx(graphDatabase, Neo4jMatchers.hasLabel(Labels.MY_LABEL)));
    }

    @Test
    public void oversteppingMaxNumberOfLabelsShouldFailGracefully() throws Exception {
        GraphDatabaseService graphDatabase = this.beansAPIWithNoMoreLabelIds();
        try (Transaction tx = graphDatabase.beginTx();){
            graphDatabase.createNode().addLabel((Label)Labels.MY_LABEL);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        graphDatabase.shutdown();
    }

    @Test
    public void removingCommittedLabel() throws Exception {
        GraphDatabaseService graphDatabase = this.dbRule.getGraphDatabaseService();
        Labels label = Labels.MY_LABEL;
        Node myNode = this.createNode(graphDatabase, label);
        try (Transaction tx = graphDatabase.beginTx();){
            myNode.removeLabel((Label)label);
            tx.success();
        }
        Assert.assertThat((Object)myNode, (Matcher)Matchers.not(Neo4jMatchers.inTx(graphDatabase, Neo4jMatchers.hasLabel(label))));
    }

    @Test
    public void createNodeWithLabels() throws Exception {
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        Node node = null;
        try (Transaction tx = db.beginTx();){
            node = db.createNode((Label[])Labels.values());
            tx.success();
        }
        Assert.assertThat((Object)node, Neo4jMatchers.inTx(db, Neo4jMatchers.hasLabels(IteratorUtil.asEnumNameSet(Labels.class))));
    }

    @Test
    public void removingNonExistentLabel() throws Exception {
        Node myNode;
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Labels label = Labels.MY_LABEL;
        try (Transaction tx = beansAPI.beginTx();){
            myNode = beansAPI.createNode();
            myNode.removeLabel((Label)label);
            tx.success();
        }
        Assert.assertThat((Object)myNode, (Matcher)Matchers.not(Neo4jMatchers.inTx(beansAPI, Neo4jMatchers.hasLabel(label))));
    }

    @Test
    public void removingExistingLabelFromUnlabeledNode() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Labels label = Labels.MY_LABEL;
        this.createNode(beansAPI, label);
        Node myNode = this.createNode(beansAPI, new Label[0]);
        try (Transaction tx = beansAPI.beginTx();){
            myNode.removeLabel((Label)label);
            tx.success();
        }
        Assert.assertThat((Object)myNode, (Matcher)Matchers.not(Neo4jMatchers.inTx(beansAPI, Neo4jMatchers.hasLabel(label))));
    }

    @Test
    public void removingUncommittedLabel() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Labels label = Labels.MY_LABEL;
        try (Transaction tx = beansAPI.beginTx();){
            Node myNode = beansAPI.createNode();
            myNode.addLabel((Label)label);
            myNode.removeLabel((Label)label);
            Assert.assertFalse((boolean)myNode.hasLabel((Label)label));
            tx.success();
        }
    }

    @Test
    public void shouldBeAbleToListLabelsForANode() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Node node = null;
        Set expected = IteratorUtil.asSet((Object[])new String[]{Labels.MY_LABEL.name(), Labels.MY_OTHER_LABEL.name()});
        try (Transaction tx = beansAPI.beginTx();){
            node = beansAPI.createNode();
            for (String label : expected) {
                node.addLabel(DynamicLabel.label((String)label));
            }
            tx.success();
        }
        Assert.assertThat((Object)node, Neo4jMatchers.inTx(beansAPI, Neo4jMatchers.hasLabels(expected)));
    }

    @Test
    public void shouldReturnEmptyListIfNoLabels() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Node node = this.createNode(beansAPI, new Label[0]);
        Assert.assertThat((Object)node, Neo4jMatchers.inTx(beansAPI, Neo4jMatchers.hasNoLabels()));
    }

    @Test
    public void getNodesWithLabelCommitted() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Node node = null;
        try (Transaction tx = beansAPI.beginTx();){
            node = beansAPI.createNode();
            node.addLabel((Label)Labels.MY_LABEL);
            tx.success();
        }
        Assert.assertThat((Object)beansAPI, Neo4jMatchers.inTx(beansAPI, Neo4jMatchers.hasNodes(Labels.MY_LABEL, node)));
        Assert.assertThat((Object)beansAPI, Neo4jMatchers.inTx(beansAPI, Neo4jMatchers.hasNoNodes(Labels.MY_OTHER_LABEL)));
    }

    @Test
    public void getNodesWithLabelsWithTxAddsAndRemoves() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Node node1 = this.createNode(beansAPI, Labels.MY_LABEL, Labels.MY_OTHER_LABEL);
        Node node2 = this.createNode(beansAPI, Labels.MY_LABEL, Labels.MY_OTHER_LABEL);
        Node node3 = null;
        Set nodesWithMyLabel = null;
        Set nodesWithMyOtherLabel = null;
        try (Transaction tx = beansAPI.beginTx();){
            node3 = beansAPI.createNode(new Label[]{Labels.MY_LABEL});
            node2.removeLabel((Label)Labels.MY_LABEL);
            nodesWithMyLabel = IteratorUtil.asSet((Iterator)beansAPI.findNodes((Label)Labels.MY_LABEL));
            nodesWithMyOtherLabel = IteratorUtil.asSet((Iterator)beansAPI.findNodes((Label)Labels.MY_OTHER_LABEL));
            tx.success();
        }
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Node[]{node1, node3}), (Object)nodesWithMyLabel);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Node[]{node1, node2}), (Object)nodesWithMyOtherLabel);
    }

    @Test
    public void shouldListLabels() throws Exception {
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        GlobalGraphOperations globalOps = GlobalGraphOperations.at((GraphDatabaseService)db);
        this.createNode(db, Labels.MY_LABEL, Labels.MY_OTHER_LABEL);
        List labels = null;
        try (Transaction tx = db.beginTx();){
            labels = Iterables.toList((Iterable)globalOps.getAllLabels());
        }
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertThat((Object)Iterables.map((Function)new Function<Label, String>(){

            @Override
            public String apply(Label label) {
                return label.name();
            }
        }, (Iterable)labels), (Matcher)Matchers.hasItems((Object[])new String[]{Labels.MY_LABEL.name(), Labels.MY_OTHER_LABEL.name()}));
    }

    @Test
    public void deleteAllNodesAndTheirLabels() throws Exception {
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        Label label = DynamicLabel.label((String)"A");
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            node.addLabel(label);
            node.setProperty("name", (Object)"bla");
            tx.success();
        }
        tx = db.beginTx();
        var4_4 = null;
        try {
            for (Node node : GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes()) {
                node.removeLabel(label);
                node.delete();
            }
            tx.success();
        }
        catch (Throwable x2) {
            var4_4 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_4.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var4_4 = null;
        try (Transaction transaction = db.beginTx();){
            Assert.assertEquals((long)0L, (long)IteratorUtil.count((Iterable)GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes()));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void removingLabelDoesNotBreakPreviouslyCreatedLabelsIterator() {
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        Label label1 = DynamicLabel.label((String)"A");
        Label label2 = DynamicLabel.label((String)"B");
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode(new Label[]{label1, label2});
            for (Label next : node.getLabels()) {
                node.removeLabel(next);
            }
            tx.success();
        }
    }

    @Test
    public void removingPropertyDoesNotBreakPreviouslyCreatedNodePropertyKeysIterator() {
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            node.setProperty("name", (Object)"Horst");
            node.setProperty("age", (Object)"72");
            Iterator iterator = node.getPropertyKeys().iterator();
            while (iterator.hasNext()) {
                node.removeProperty((String)iterator.next());
            }
            tx.success();
        }
    }

    @Test
    public void shouldCreateNodeWithLotsOfLabelsAndThenRemoveMostOfThem() throws Exception {
        int i;
        Node node;
        int TOTAL_NUMBER_OF_LABELS = 200;
        int NUMBER_OF_PRESERVED_LABELS = 20;
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        try (Transaction tx = db.beginTx();){
            node = db.createNode();
            for (i = 0; i < 200; ++i) {
                node.addLabel(DynamicLabel.label((String)("label:" + i)));
            }
            tx.success();
        }
        tx = db.beginTx();
        var6_5 = null;
        try {
            for (i = 20; i < 200; ++i) {
                node.removeLabel(DynamicLabel.label((String)("label:" + i)));
            }
            tx.success();
        }
        catch (Throwable x2) {
            var6_5 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var6_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var6_5.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var6_5 = null;
        try (Transaction transaction = db.beginTx();){
            ArrayList<String> labels = new ArrayList<String>();
            for (Label label : node.getLabels()) {
                labels.add(label.name());
            }
            Assert.assertEquals((String)("labels on node: " + labels), (long)20L, (long)labels.size());
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Ignore(value="Fix this properly later")
    @Test
    public void shouldAllowManyLabelsAndPropertyCursor() {
        Node node;
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        try (Transaction tx = db.beginTx();){
            node = db.createNode();
            node.setProperty("foo", (Object)"bar");
            for (int i = 0; i < 20; ++i) {
                node.addLabel(DynamicLabel.label((String)("label:" + i)));
            }
            tx.success();
        }
        tx = db.beginTx();
        var4_3 = null;
        try {
            block73: {
                try (Statement statement = ((TopLevelTransaction)tx).getTransaction().acquireStatement();
                     Cursor nodeCursor = statement.readOperations().nodeCursor(node.getId());){
                    if (!nodeCursor.next()) break block73;
                    try (Cursor properties = ((NodeItem)nodeCursor.get()).properties();){
                        while (properties.next()) {
                            Cursor labels;
                            block74: {
                                labels = ((NodeItem)nodeCursor.get()).labels();
                                Throwable throwable = null;
                                try {
                                    while (labels.next()) {
                                    }
                                    if (labels == null) continue;
                                    if (throwable == null) break block74;
                                }
                                catch (Throwable throwable2) {
                                    try {
                                        throwable = throwable2;
                                        throw throwable2;
                                    }
                                    catch (Throwable throwable3) {
                                        if (labels == null) throw throwable3;
                                        if (throwable == null) {
                                            labels.close();
                                            throw throwable3;
                                        }
                                        try {
                                            labels.close();
                                            throw throwable3;
                                        }
                                        catch (Throwable x2) {
                                            throwable.addSuppressed(x2);
                                            throw throwable3;
                                        }
                                    }
                                }
                                try {
                                    labels.close();
                                    continue;
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                    continue;
                                }
                            }
                            labels.close();
                        }
                    }
                }
            }
            tx.success();
            return;
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private GraphDatabaseService beansAPIWithNoMoreLabelIds() {
        final EphemeralIdGenerator.Factory idFactory = new EphemeralIdGenerator.Factory(){

            @Override
            public IdGenerator open(File fileName, int grabSize, IdType idType, long highId) {
                if (idType == IdType.LABEL_TOKEN) {
                    IdGenerator generator = (IdGenerator)this.generators.get(idType);
                    if (generator == null) {
                        generator = new EphemeralIdGenerator(idType){

                            @Override
                            public long nextId() {
                                throw new UnderlyingStorageException("Id capacity exceeded");
                            }
                        };
                        this.generators.put(idType, generator);
                    }
                    return generator;
                }
                return super.open(fileName, grabSize, idType, Long.MAX_VALUE);
            }
        };
        TestGraphDatabaseFactory dbFactory = new TestGraphDatabaseFactory(){

            @Override
            protected GraphDatabaseBuilder.DatabaseCreator createImpermanentDatabaseCreator(final File storeDir, final TestGraphDatabaseFactoryState state) {
                return new GraphDatabaseBuilder.DatabaseCreator(){

                    public GraphDatabaseService newDatabase(Map<String, String> config) {
                        return new ImpermanentGraphDatabase(storeDir, config, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies((GraphDatabaseFacadeFactory.Dependencies)state.databaseDependencies())){

                            @Override
                            protected void create(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies) {
                                new CommunityFacadeFactory(){

                                    protected EditionModule createEdition(PlatformModule platformModule) {
                                        return new CommunityEditionModule(platformModule){

                                            protected IdGeneratorFactory createIdGeneratorFactory(FileSystemAbstraction fs) {
                                                return idFactory;
                                            }
                                        };
                                    }

                                    protected PlatformModule createPlatform(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade) {
                                        return new ImpermanentGraphDatabase.ImpermanentPlatformModule(storeDir, params, dependencies, graphDatabaseFacade);
                                    }
                                }.newFacade(storeDir, params, dependencies, (GraphDatabaseFacade)this);
                            }
                        };
                    }
                };
            }
        };
        return dbFactory.newImpermanentDatabase();
    }

    private Node createNode(GraphDatabaseService db, Label ... labels) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode(labels);
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    private static enum Labels implements Label
    {
        MY_LABEL,
        MY_OTHER_LABEL;

    }
}

