/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.File;
import java.io.StringWriter;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.function.Predicate;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

public class GraphDatabaseInternalLogIT {
    @Rule
    public TargetDirectory.TestDirectory testDir = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void shouldWriteToInternalDiagnosticsLog() throws Exception {
        new TestGraphDatabaseFactory().newEmbeddedDatabase(this.testDir.graphDbDir()).shutdown();
        File internalLog = new File(this.testDir.graphDbDir(), "messages.log");
        MatcherAssert.assertThat((Object)internalLog.isFile(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)internalLog.length(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        MatcherAssert.assertThat((Object)IteratorUtil.count((Iterable)IteratorUtil.asIterable((File)internalLog, (String)"UTF-8"), (Predicate)new Predicate<String>(){

            @Override
            public boolean test(String line) {
                return line.contains("Database is now ready");
            }
        }), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)IteratorUtil.count((Iterable)IteratorUtil.asIterable((File)internalLog, (String)"UTF-8"), (Predicate)new Predicate<String>(){

            @Override
            public boolean test(String line) {
                return line.contains("Database is now unavailable");
            }
        }), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldNotWriteDebugToInternalDiagnosticsLogByDefault() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabase(this.testDir.graphDbDir());
        LogService logService = (LogService)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(LogService.class);
        logService.getInternalLog(this.getClass()).debug("A debug entry");
        db.shutdown();
        File internalLog = new File(this.testDir.graphDbDir(), "messages.log");
        MatcherAssert.assertThat((Object)internalLog.isFile(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)internalLog.length(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        MatcherAssert.assertThat((Object)IteratorUtil.count((Iterable)IteratorUtil.asIterable((File)internalLog, (String)"UTF-8"), (Predicate)new Predicate<String>(){

            @Override
            public boolean test(String line) {
                return line.contains("A debug entry");
            }
        }), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldWriteDebugToInternalDiagnosticsLogForEnabledContexts() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.testDir.graphDbDir()).setConfig(GraphDatabaseSettings.store_internal_debug_contexts, this.getClass().getName() + ",java.io").newGraphDatabase();
        LogService logService = (LogService)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(LogService.class);
        logService.getInternalLog(this.getClass()).debug("A debug entry");
        logService.getInternalLog(GraphDatabaseService.class).debug("A GDS debug entry");
        logService.getInternalLog(StringWriter.class).debug("A SW debug entry");
        db.shutdown();
        File internalLog = new File(this.testDir.graphDbDir(), "messages.log");
        MatcherAssert.assertThat((Object)internalLog.isFile(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)internalLog.length(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        MatcherAssert.assertThat((Object)IteratorUtil.count((Iterable)IteratorUtil.asIterable((File)internalLog, (String)"UTF-8"), (Predicate)new Predicate<String>(){

            @Override
            public boolean test(String line) {
                return line.contains("A debug entry");
            }
        }), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)IteratorUtil.count((Iterable)IteratorUtil.asIterable((File)internalLog, (String)"UTF-8"), (Predicate)new Predicate<String>(){

            @Override
            public boolean test(String line) {
                return line.contains("A GDS debug entry");
            }
        }), (Matcher)Is.is((Object)0));
        MatcherAssert.assertThat((Object)IteratorUtil.count((Iterable)IteratorUtil.asIterable((File)internalLog, (String)"UTF-8"), (Predicate)new Predicate<String>(){

            @Override
            public boolean test(String line) {
                return line.contains("A SW debug entry");
            }
        }), (Matcher)Is.is((Object)1));
    }
}

