/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import org.neo4j.collection.primitive.PrimitiveLongIntMap;
import org.neo4j.collection.primitive.PrimitiveLongIntVisitor;
import org.neo4j.collection.primitive.hopscotch.AbstractLongHopScotchCollection;
import org.neo4j.collection.primitive.hopscotch.HopScotchHashingAlgorithm;
import org.neo4j.collection.primitive.hopscotch.Table;

public class PrimitiveLongIntHashMap
extends AbstractLongHopScotchCollection<int[]>
implements PrimitiveLongIntMap {
    private final int[] transport = new int[1];
    private final HopScotchHashingAlgorithm.Monitor monitor;

    public PrimitiveLongIntHashMap(Table<int[]> table, HopScotchHashingAlgorithm.Monitor monitor) {
        super(table);
        this.monitor = monitor;
    }

    @Override
    public int put(long key, int value) {
        return this.unpack(HopScotchHashingAlgorithm.put(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key, this.pack(value), this));
    }

    @Override
    public boolean containsKey(long key) {
        return HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key) != null;
    }

    @Override
    public int get(long key) {
        return this.unpack((int[])HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key));
    }

    @Override
    public int remove(long key) {
        return this.unpack((int[])HopScotchHashingAlgorithm.remove(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key));
    }

    @Override
    public int size() {
        return this.table.size();
    }

    @Override
    public String toString() {
        return this.table.toString();
    }

    private int[] pack(int value) {
        this.transport[0] = value;
        return this.transport;
    }

    private int unpack(int[] result) {
        return result != null ? result[0] : -1;
    }

    @Override
    public <E extends Exception> void visitEntries(PrimitiveLongIntVisitor<E> visitor) throws E {
        long nullKey = this.table.nullKey();
        int capacity = this.table.capacity();
        for (int i = 0; i < capacity; ++i) {
            long key;
            int[] value = (int[])this.table.value(i);
            if (value == null || (key = this.table.key(i)) == nullKey || !visitor.visited(key, value[0])) continue;
            return;
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this.typeAndSizeEqual(other)) {
            PrimitiveLongIntHashMap that = (PrimitiveLongIntHashMap)other;
            LongIntEquality equality = new LongIntEquality(that);
            this.visitEntries(equality);
            return equality.isEqual();
        }
        return false;
    }

    @Override
    public int hashCode() {
        HashCodeComputer hash = new HashCodeComputer();
        this.visitEntries(hash);
        return hash.hashCode();
    }

    private static class HashCodeComputer
    implements PrimitiveLongIntVisitor<RuntimeException> {
        private int hash = 1337;

        private HashCodeComputer() {
        }

        @Override
        public boolean visited(long key, int value) throws RuntimeException {
            this.hash += HopScotchHashingAlgorithm.DEFAULT_HASHING.hash(key + (long)HopScotchHashingAlgorithm.DEFAULT_HASHING.hash(value));
            return false;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class LongIntEquality
    implements PrimitiveLongIntVisitor<RuntimeException> {
        private PrimitiveLongIntHashMap other;
        private boolean equal = true;

        public LongIntEquality(PrimitiveLongIntHashMap that) {
            this.other = that;
        }

        @Override
        public boolean visited(long key, int value) {
            this.equal = this.other.get(key) == value;
            return !this.equal;
        }

        public boolean isEqual() {
            return this.equal;
        }
    }
}

