/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.collection.primitive.PrimitiveLongVisitor;
import org.neo4j.collection.primitive.hopscotch.AbstractLongHopScotchCollection;
import org.neo4j.collection.primitive.hopscotch.HopScotchHashingAlgorithm;
import org.neo4j.collection.primitive.hopscotch.Table;

public class PrimitiveLongHashSet
extends AbstractLongHopScotchCollection<Object>
implements PrimitiveLongSet {
    private final Object valueMarker;
    private final HopScotchHashingAlgorithm.Monitor monitor;

    public PrimitiveLongHashSet(Table<Object> table, Object valueMarker, HopScotchHashingAlgorithm.Monitor monitor) {
        super(table);
        this.valueMarker = valueMarker;
        this.monitor = monitor;
    }

    @Override
    public boolean add(long value) {
        return HopScotchHashingAlgorithm.put(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, value, this.valueMarker, this) == null;
    }

    @Override
    public boolean addAll(PrimitiveLongIterator values) {
        boolean changed = false;
        while (values.hasNext()) {
            changed |= HopScotchHashingAlgorithm.put(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, values.next(), this.valueMarker, this) == null;
        }
        return changed;
    }

    @Override
    public boolean contains(long value) {
        return HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, value) == this.valueMarker;
    }

    @Override
    public boolean test(long value) {
        return HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, value) == this.valueMarker;
    }

    @Override
    public boolean accept(long value) {
        return HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, value) == this.valueMarker;
    }

    @Override
    public boolean remove(long value) {
        return HopScotchHashingAlgorithm.remove(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, value) == this.valueMarker;
    }

    @Override
    public boolean equals(Object other) {
        if (this.typeAndSizeEqual(other)) {
            PrimitiveLongHashSet that = (PrimitiveLongHashSet)other;
            LongKeyEquality equality = new LongKeyEquality(that);
            this.visitKeys(equality);
            return equality.isEqual();
        }
        return false;
    }

    @Override
    public int hashCode() {
        HashCodeComputer hash = new HashCodeComputer();
        this.visitKeys(hash);
        return hash.hashCode();
    }

    private static class HashCodeComputer
    implements PrimitiveLongVisitor<RuntimeException> {
        private int hash = 1337;

        private HashCodeComputer() {
        }

        @Override
        public boolean visited(long value) throws RuntimeException {
            this.hash += HopScotchHashingAlgorithm.DEFAULT_HASHING.hash(value);
            return false;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class LongKeyEquality
    implements PrimitiveLongVisitor<RuntimeException> {
        private PrimitiveLongHashSet other;
        private boolean equal = true;

        public LongKeyEquality(PrimitiveLongHashSet that) {
            this.other = that;
        }

        @Override
        public boolean visited(long value) {
            this.equal = this.other.contains(value);
            return !this.equal;
        }

        public boolean isEqual() {
            return this.equal;
        }
    }
}

