/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import org.neo4j.collection.primitive.hopscotch.Table;

public class HopScotchHashingAlgorithm {
    public static final int DEFAULT_H = 32;
    public static final Monitor NO_MONITOR = new Monitor.Adapter(){};
    public static final HashFunction JUL_HASHING = new HashFunction(){

        @Override
        public int hash(long value) {
            int h = (int)(value >>> 32 ^ value);
            h ^= h >>> 20 ^ h >>> 12;
            return h ^ h >>> 7 ^ h >>> 4;
        }
    };
    public static final HashFunction DEFAULT_HASHING = new HashFunction(){

        @Override
        public int hash(long value) {
            value ^= value << 21;
            value ^= value >>> 35;
            value ^= value << 4;
            return (int)(value >>> 32 ^ value);
        }
    };

    public static <VALUE> VALUE get(Table<VALUE> table, Monitor monitor, HashFunction hashFunction, long key) {
        int tableMask = table.mask();
        int index = HopScotchHashingAlgorithm.indexOf(hashFunction, key, tableMask);
        long existingKey = table.key(index);
        if (existingKey == key) {
            return table.value(index);
        }
        for (long hopBits = table.hopBits(index); hopBits > 0L; hopBits &= hopBits - 1L) {
            int hopIndex = HopScotchHashingAlgorithm.nextIndex(index, Long.numberOfTrailingZeros(hopBits) + 1, tableMask);
            if (table.key(hopIndex) != key) continue;
            return table.value(hopIndex);
        }
        return null;
    }

    public static <VALUE> VALUE remove(Table<VALUE> table, Monitor monitor, HashFunction hashFunction, long key) {
        int tableMask = table.mask();
        int index = HopScotchHashingAlgorithm.indexOf(hashFunction, key, tableMask);
        int freedIndex = -1;
        VALUE result = null;
        if (table.key(index) == key) {
            freedIndex = index;
            result = table.remove(index);
        }
        for (long hopBits = table.hopBits(index); hopBits > 0L; hopBits &= hopBits - 1L) {
            int hd = Long.numberOfTrailingZeros(hopBits);
            int hopIndex = HopScotchHashingAlgorithm.nextIndex(index, hd + 1, tableMask);
            if (table.key(hopIndex) != key) continue;
            freedIndex = hopIndex;
            result = table.remove(hopIndex);
            table.removeHopBit(index, hd);
        }
        while (freedIndex != -1) {
            long freedHopBits = table.hopBits(freedIndex);
            if (freedHopBits > 0L) {
                int hd = 63 - Long.numberOfLeadingZeros(freedHopBits);
                int candidateIndex = HopScotchHashingAlgorithm.nextIndex(freedIndex, hd + 1, tableMask);
                long candidateKey = table.move(candidateIndex, freedIndex);
                table.removeHopBit(freedIndex, hd);
                assert (monitor.pulledToFreeIndex(index, table.hopBits(freedIndex), candidateKey, candidateIndex, freedIndex));
                freedIndex = candidateIndex;
                continue;
            }
            freedIndex = -1;
        }
        return result;
    }

    public static <VALUE> VALUE put(Table<VALUE> table, Monitor monitor, HashFunction hashFunction, long key, VALUE value, ResizeMonitor<VALUE> resizeMonitor) {
        long nullKey = table.nullKey();
        assert (key != nullKey);
        int tableMask = table.mask();
        int index = HopScotchHashingAlgorithm.indexOf(hashFunction, key, tableMask);
        long keyAtIndex = table.key(index);
        if (keyAtIndex == nullKey) {
            table.put(index, key, value);
            assert (monitor.placedAtFreeAndIntendedIndex(key, index));
            return null;
        }
        if (keyAtIndex == key) {
            return table.putValue(index, value);
        }
        for (long hopBits = table.hopBits(index); hopBits > 0L; hopBits &= hopBits - 1L) {
            int hopIndex = HopScotchHashingAlgorithm.nextIndex(index, Long.numberOfTrailingZeros(hopBits) + 1, tableMask);
            if (table.key(hopIndex) != key) continue;
            return table.putValue(hopIndex, value);
        }
        if (HopScotchHashingAlgorithm.hopScotchPut(table, monitor, hashFunction, key, value, index, tableMask, nullKey)) {
            return null;
        }
        Table<VALUE> resizedTable = HopScotchHashingAlgorithm.growTable(table, monitor, hashFunction, resizeMonitor);
        return HopScotchHashingAlgorithm.put(resizedTable, monitor, hashFunction, key, value, resizeMonitor);
    }

    private static <VALUE> boolean hopScotchPut(Table<VALUE> table, Monitor monitor, HashFunction hashFunction, long key, VALUE value, int index, int tableMask, long nullKey) {
        int freeIndex = HopScotchHashingAlgorithm.nextIndex(index, 1, tableMask);
        int h = table.h();
        int totalHd = 0;
        boolean foundFreeSpot = false;
        while (freeIndex != index) {
            if (table.key(freeIndex) == nullKey) {
                foundFreeSpot = true;
                break;
            }
            freeIndex = HopScotchHashingAlgorithm.nextIndex(freeIndex, 1, tableMask);
            ++totalHd;
        }
        if (!foundFreeSpot) {
            return false;
        }
        while (totalHd >= h) {
            int neighborIndex = HopScotchHashingAlgorithm.nextIndex(freeIndex, -(h - 1), tableMask);
            boolean swapped = false;
            for (int d = 0; d < h >> 1 && !swapped; ++d) {
                int hd;
                long neighborHopBitsFixed;
                long neighborHopBits = neighborHopBitsFixed = table.hopBits(neighborIndex);
                while (neighborHopBits > 0L && !swapped && (hd = Long.numberOfTrailingZeros(neighborHopBits)) + d < h - 1) {
                    neighborHopBits &= neighborHopBits - 1L;
                    int candidateIndex = HopScotchHashingAlgorithm.nextIndex(neighborIndex, hd + 1, tableMask);
                    int distance = freeIndex - candidateIndex & tableMask;
                    long candidateKey = table.move(candidateIndex, freeIndex);
                    table.moveHopBit(neighborIndex, hd, distance);
                    assert (monitor.pushedToFreeIndex(index, neighborHopBitsFixed, table.hopBits(neighborIndex), neighborIndex, candidateKey, candidateIndex, freeIndex));
                    freeIndex = candidateIndex;
                    swapped = true;
                    totalHd -= distance;
                }
                if (swapped) continue;
                neighborIndex = HopScotchHashingAlgorithm.nextIndex(neighborIndex, 1, tableMask);
            }
            if (swapped) continue;
            return false;
        }
        table.put(freeIndex, key, value);
        table.putHopBit(index, totalHd);
        assert (monitor.placedAtFreedIndex(index, table.hopBits(index), key, freeIndex));
        return true;
    }

    private static int nextIndex(int index, int delta, int mask) {
        return index + delta & mask;
    }

    private static int indexOf(HashFunction hashFunction, long key, int tableMask) {
        return hashFunction.hash(key) & tableMask;
    }

    private static <VALUE> Table<VALUE> growTable(Table<VALUE> oldTable, Monitor monitor, HashFunction hashFunction, ResizeMonitor<VALUE> resizeMonitor) {
        assert (monitor.tableGrowing(oldTable.capacity(), oldTable.size()));
        Table<VALUE> newTable = oldTable.grow();
        long nullKey = oldTable.nullKey();
        int capacity = oldTable.capacity();
        for (int i = 0; i < capacity; ++i) {
            VALUE putResult;
            long key = oldTable.key(i);
            if (key == nullKey || (putResult = HopScotchHashingAlgorithm.put(newTable, monitor, hashFunction, key, oldTable.value(i), resizeMonitor)) == null) continue;
            throw new IllegalStateException("Couldn't add " + key + " when growing table");
        }
        assert (monitor.tableGrew(oldTable.capacity(), newTable.capacity(), newTable.size()));
        resizeMonitor.tableGrew(newTable);
        oldTable.close();
        return newTable;
    }

    public static interface ResizeMonitor<VALUE> {
        public void tableGrew(Table<VALUE> var1);
    }

    public static interface HashFunction {
        public int hash(long var1);
    }

    public static interface Monitor {
        public boolean tableGrowing(int var1, int var2);

        public boolean tableGrew(int var1, int var2, int var3);

        public boolean placedAtFreeAndIntendedIndex(long var1, int var3);

        public boolean pushedToFreeIndex(int var1, long var2, long var4, int var6, long var7, int var9, int var10);

        public boolean placedAtFreedIndex(int var1, long var2, long var4, int var6);

        public boolean pulledToFreeIndex(int var1, long var2, long var4, int var6, int var7);

        public static abstract class Adapter
        implements Monitor {
            @Override
            public boolean placedAtFreedIndex(int intendedIndex, long newHopBits, long key, int actualIndex) {
                return true;
            }

            @Override
            public boolean placedAtFreeAndIntendedIndex(long key, int index) {
                return true;
            }

            @Override
            public boolean pushedToFreeIndex(int intendedIndex, long oldHopBits, long newHopBits, int neighborIndex, long key, int fromIndex, int toIndex) {
                return true;
            }

            @Override
            public boolean pulledToFreeIndex(int intendedIndex, long newHopBits, long key, int fromIndex, int toIndex) {
                return true;
            }

            @Override
            public boolean tableGrowing(int fromCapacity, int currentSize) {
                return true;
            }

            @Override
            public boolean tableGrew(int fromCapacity, int toCapacity, int currentSize) {
                return true;
            }
        }
    }
}

