/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries.fs;

import java.io.IOException;
import java.io.Reader;
import java.nio.BufferOverflowException;
import java.nio.CharBuffer;
import org.neo4j.adversaries.Adversary;

public class AdversarialReader
extends Reader {
    private final Reader reader;
    private final Adversary adversary;

    public AdversarialReader(Reader reader, Adversary adversary) {
        this.reader = reader;
        this.adversary = adversary;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class, BufferOverflowException.class, IndexOutOfBoundsException.class)) {
            CharBuffer dup = target.duplicate();
            dup.limit(Math.max(target.limit() / 2, 1));
            return this.reader.read(dup);
        }
        return this.reader.read(target);
    }

    @Override
    public int read() throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.reader.read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            char[] dup = new char[Math.max(cbuf.length / 2, 1)];
            int read = this.reader.read(dup);
            System.arraycopy(dup, 0, cbuf, 0, read);
            return read;
        }
        return this.reader.read(cbuf);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            return this.reader.read(cbuf, off, Math.max(len / 2, 1));
        }
        return this.reader.read(cbuf, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.adversary.injectFailure(IllegalArgumentException.class, IOException.class);
        return this.reader.skip(n);
    }

    @Override
    public boolean ready() throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.reader.ready();
    }

    @Override
    public boolean markSupported() {
        this.adversary.injectFailure(new Class[0]);
        return this.reader.markSupported();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.reader.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.reader.reset();
    }

    @Override
    public void close() throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.reader.close();
    }
}

