/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries.fs;

import java.io.FileDescriptor;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.adversaries.Adversary;
import sun.nio.ch.DelegateFileDispatcher;

public class AdversarialFileDispatcherFactory {
    public static Object makeFileDispatcherAdversarial(Object delegateFileDispatcher, final Adversary adversary) throws Exception {
        return new DelegateFileDispatcher(delegateFileDispatcher){

            private int mischievousLength(int len) {
                if (adversary.injectFailureOrMischief(IOException.class)) {
                    len = len == 1 ? 1 : ThreadLocalRandom.current().nextInt(1, len);
                }
                return len;
            }

            public long readv(FileDescriptor fd, long address, int len) throws IOException {
                return super.readv(fd, address, this.mischievousLength(len));
            }

            public int read(FileDescriptor fd, long address, int len) throws IOException {
                return super.read(fd, address, this.mischievousLength(len));
            }

            public int pwrite(FileDescriptor fd, long address, int len, long position) throws IOException {
                return super.pwrite(fd, address, this.mischievousLength(len), position);
            }

            public int truncate(FileDescriptor fd, long size) throws IOException {
                adversary.injectFailure(IOException.class);
                return super.truncate(fd, size);
            }

            public int pread(FileDescriptor fd, long address, int len, long position) throws IOException {
                return super.pread(fd, address, this.mischievousLength(len), position);
            }

            public long writev(FileDescriptor fd, long address, int len) throws IOException {
                return super.writev(fd, address, this.mischievousLength(len));
            }

            public int write(FileDescriptor fd, long address, int len) throws IOException {
                return super.write(fd, address, this.mischievousLength(len));
            }
        };
    }
}

