/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.adversaries.RandomAdversary;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public final class AdversarySignals {
    private static final AdversarySignals instance = new AdversarySignals();
    private boolean installed = false;
    private List<Runnable> installedHandlers = new ArrayList<Runnable>();

    private AdversarySignals() {
    }

    public static AdversarySignals getInstance() {
        return instance;
    }

    public synchronized void installAsSIGUSR2() {
        if (!this.installed) {
            Signal.handle(new Signal("USR2"), new SignalHandler(){

                @Override
                public void handle(Signal sig) {
                    AdversarySignals.this.handleSignal();
                }
            });
            this.installed = true;
        }
    }

    private synchronized void handleSignal() {
        for (Runnable handler : this.installedHandlers) {
            handler.run();
        }
    }

    public synchronized void setFactorWhenSignalled(final RandomAdversary adversary, final double factor) {
        this.installedHandlers.add(new Runnable(){

            @Override
            public void run() {
                adversary.setProbabilityFactor(factor);
            }
        });
    }

    public synchronized void setAndResetFactorWhenSignalled(final RandomAdversary adversary, final double factor) {
        this.installedHandlers.add(new Runnable(){

            @Override
            public void run() {
                adversary.setAndResetProbabilityFactor(factor);
            }
        });
    }
}

