/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.test.DefaultFileSystemRule;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;

public class BatchInsertDocTest {
    @Rule
    public DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private DefaultFileSystemAbstraction fileSystem;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void insert() throws Exception {
        File tempStoreDir = new File("target/batchinserter-example").getAbsoluteFile();
        FileUtils.deleteRecursively(tempStoreDir);
        BatchInserter inserter = null;
        try {
            inserter = BatchInserters.inserter((String)new File("target/batchinserter-example").getAbsolutePath());
            Label personLabel = DynamicLabel.label((String)"Person");
            inserter.createDeferredSchemaIndex(personLabel).on("name").create();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("name", "Mattias");
            long mattiasNode = inserter.createNode(properties, new Label[]{personLabel});
            properties.put("name", "Chris");
            long chrisNode = inserter.createNode(properties, new Label[]{personLabel});
            DynamicRelationshipType knows = DynamicRelationshipType.withName((String)"KNOWS");
            inserter.createRelationship(mattiasNode, chrisNode, (RelationshipType)knows, null);
        }
        finally {
            if (inserter != null) {
                inserter.shutdown();
            }
        }
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabase(new File("target/batchinserter-example").getAbsolutePath());
        try (Transaction tx = db.beginTx();){
            db.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
        }
        try {
            tx = db.beginTx();
            var5_6 = null;
            try {
                Label personLabelForTesting = DynamicLabel.label((String)"Person");
                Node mNode = db.findNode(personLabelForTesting, "name", (Object)"Mattias");
                Node cNode = mNode.getSingleRelationship((RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), Direction.OUTGOING).getEndNode();
                Assert.assertThat((Object)((String)cNode.getProperty("name")), (Matcher)Is.is((Object)"Chris"));
                Assert.assertThat((Object)db.schema().getIndexes(personLabelForTesting).iterator().hasNext(), (Matcher)Is.is((Object)true));
            }
            catch (Throwable throwable) {
                var5_6 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var5_6 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable x2) {
                            var5_6.addSuppressed(x2);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        finally {
            db.shutdown();
        }
    }

    @Test
    public void insertWithConfig() throws IOException {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("dbms.pagecache.memory", "512m");
        BatchInserter inserter = BatchInserters.inserter((String)new File("target/batchinserter-example-config").getAbsolutePath(), config);
        inserter.shutdown();
    }

    @Test
    public void insertWithConfigFile() throws IOException {
        try (Writer fw = this.fileSystem.openAsWriter(new File("target/docs/batchinsert-config").getAbsoluteFile(), "utf-8", false);){
            fw.append("dbms.pagecache.memory=8m");
        }
        var2_2 = null;
        try (FileReader input = new FileReader(new File("target/docs/batchinsert-config").getAbsoluteFile());){
            Map config = MapUtil.load((Reader)input);
            BatchInserter inserter = BatchInserters.inserter((String)"target/docs/batchinserter-example-config", (Map)config);
            inserter.shutdown();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Before
    public void before() throws Exception {
        this.fileSystem = this.fileSystemRule.get();
        this.fileSystem.mkdirs(new File("target"));
        this.fileSystem.mkdirs(new File("target/docs"));
    }
}

