;;;; This file is part of gorilla-repl. Copyright (C) 2014-, Jony Hudson.
;;;;
;;;; gorilla-repl is licenced to you under the MIT licence. See the file LICENCE.txt for full details.

(defproject sooheon/gorilla-repl "0.4.1-SNAPSHOT"
  :description "A rich REPL for Clojure in the notebook style."
  :url "https://github.com/sooheon/gorilla-repl"
  :license {:name "MIT"}
  :dependencies ^:replace [[org.clojure/clojure "1.9.0-beta2"]
                           [http-kit "2.2.0" :exclusions [ring/ring-core]]
                           [ring/ring-json "0.5.0-beta1" :exclusions [org.clojure/clojure]]
                           [cheshire "5.7.1"]
                           [compojure "1.6.0" :exclusions [ring/ring-core ring/ring-json]]
                           [org.slf4j/slf4j-api "1.7.25"]
                           [ch.qos.logback/logback-classic "1.2.3"]
                           [gorilla-renderable "2.0.0"]
                           [gorilla-plot "0.1.4" :exclusions [org.clojure/clojure]]
                           [javax.servlet/servlet-api "2.5"]
                           [grimradical/clj-semver "0.2.0" :exclusions [org.clojure/clojure]]
                           [cider/cider-nrepl "0.16.0-SNAPSHOT" :exclusions [org.clojure/clojure]]
                           [refactor-nrepl "2.4.0-SNAPSHOT"]
                           [org.clojure/tools.nrepl "0.2.13"]]
  :main ^:skip-aot gorilla-repl.core
  :target-path "target/%s"
  :deploy-repositories [["snapshots" {:sign-releases false}]])
