// Compiled by ClojureScript 1.9.293 {}
goog.provide('plumbing.fnk.schema');
goog.require('cljs.core');
goog.require('schema.core');
goog.require('schema.utils');
plumbing.fnk.schema.Schema = cljs.core.with_meta.call(null,schema.core.__GT_Protocol.call(null,schema.core.Schema),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734),new cljs.core.Symbol("s","Schema","s/Schema",-1305723789,null),new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716),(function (p1__36042__36043__auto__){
if(!((p1__36042__36043__auto__ == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === p1__36042__36043__auto__.schema$core$Schema$))){
return true;
} else {
if((!p1__36042__36043__auto__.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,schema.core.Schema,p1__36042__36043__auto__);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,schema.core.Schema,p1__36042__36043__auto__);
}
})], null));
plumbing.fnk.schema.InputSchema = cljs.core.PersistentArrayMap.fromArray([schema.core.cond_pre.call(null,schema.core.eq.call(null,schema.core.Keyword),schema.core.OptionalKey,schema.core.Keyword),plumbing.fnk.schema.Schema], true, false);
plumbing.fnk.schema.OutputSchema = plumbing.fnk.schema.Schema;
plumbing.fnk.schema.IOSchemata = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,plumbing.fnk.schema.OutputSchema,new cljs.core.Symbol(null,"output","output",534662484,null))], null);
plumbing.fnk.schema.GraphInputSchema = cljs.core.PersistentArrayMap.fromArray([schema.core.cond_pre.call(null,schema.core.OptionalKey,schema.core.Keyword),plumbing.fnk.schema.Schema], true, false);
plumbing.fnk.schema.MapOutputSchema = cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,plumbing.fnk.schema.Schema], true, false);
plumbing.fnk.schema.GraphIOSchemata = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.GraphInputSchema,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,plumbing.fnk.schema.MapOutputSchema,new cljs.core.Symbol(null,"output","output",534662484,null))], null);
/**
 * Like (assert (distinct? things)) but with a more helpful error message.
 */
plumbing.fnk.schema.assert_distinct = (function plumbing$fnk$schema$assert_distinct(things){
var repeated_things = cljs.core.seq.call(null,cljs.core.filter.call(null,(function (p1__37697_SHARP_){
return (cljs.core.val.call(null,p1__37697_SHARP_) > (1));
}),cljs.core.frequencies.call(null,things)));
if(cljs.core.empty_QMARK_.call(null,repeated_things)){
return null;
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Got repeated items (expected distinct): %s",repeated_things)));
}
});
/**
 * Like (get m k), but throws if k is not present in m.
 */
plumbing.fnk.schema.safe_get = (function plumbing$fnk$schema$safe_get(m,k,key_path){
if(cljs.core.map_QMARK_.call(null,m)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Expected a map at key-path %s, got type %s",key_path,schema.utils.type_of.call(null,m))));
}

var vec__37701 = cljs.core.find.call(null,m,k);
var _ = cljs.core.nth.call(null,vec__37701,(0),null);
var v = cljs.core.nth.call(null,vec__37701,(1),null);
var p = vec__37701;
if(cljs.core.truth_(p)){
} else {
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Key %s not found in %s",k,cljs.core.keys.call(null,m)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"missing-key","missing-key",1259209562),new cljs.core.Keyword(null,"key","key",-1516042587),k,new cljs.core.Keyword(null,"map","map",1371690461),m], null));
}

return v;
});
plumbing.fnk.schema.non_map_union = (function plumbing$fnk$schema$non_map_union(s1,s2){
if(cljs.core._EQ_.call(null,s1,s2)){
return s1;
} else {
if(cljs.core._EQ_.call(null,s1,schema.core.Any)){
return s2;
} else {
if(cljs.core._EQ_.call(null,s2,schema.core.Any)){
return s1;
} else {
return s1;

}
}
}
});
/**
 * Return a difference of schmas s1 and s2, where one is not a map.
 * Punt for now, assuming s2 always satisfies s1.
 */
plumbing.fnk.schema.non_map_diff = (function plumbing$fnk$schema$non_map_diff(s1,s2){
return null;
});
plumbing.fnk.schema.map_schema_QMARK_ = (function plumbing$fnk$schema$map_schema_QMARK_(m){
return ((m instanceof cljs.core.PersistentArrayMap)) || ((m instanceof cljs.core.PersistentHashMap));
});
var ufv___37709 = schema.utils.use_fn_validation;
var output_schema37704_37710 = schema.core.maybe.call(null,schema.core.pair.call(null,schema.core.Keyword,"k",schema.core.Bool,"optional?"));
var input_schema37705_37711 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker37706_37712 = schema.core.checker.call(null,input_schema37705_37711);
var output_checker37707_37713 = schema.core.checker.call(null,output_schema37704_37710);
/**
 * Inputs: [k]
 *   Returns: (s/maybe (s/pair s/Keyword "k" s/Bool "optional?"))
 * 
 *   Given a possibly-unevaluated schema map key form, unpack an explicit keyword
 * and optional? flag, or return nil for a non-explicit key
 */
plumbing.fnk.schema.unwrap_schema_form_key = ((function (ufv___37709,output_schema37704_37710,input_schema37705_37711,input_checker37706_37712,output_checker37707_37713){
return (function plumbing$fnk$schema$unwrap_schema_form_key(G__37708){
var validate__35256__auto__ = ufv___37709.get_cell();
if(cljs.core.truth_(validate__35256__auto__)){
var args__35257__auto___37714 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37708], null);
var temp__6753__auto___37715 = input_checker37706_37712.call(null,args__35257__auto___37714);
if(cljs.core.truth_(temp__6753__auto___37715)){
var error__35258__auto___37716 = temp__6753__auto___37715;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"unwrap-schema-form-key","unwrap-schema-form-key",-300088791,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),cljs.core.list(new cljs.core.Symbol("s","pair","s/pair",1193014306,null),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),"k",new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),"optional?")),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given a possibly-unevaluated schema map key form, unpack an explicit keyword\n   and optional? flag, or return nil for a non-explicit key"], null)),cljs.core.pr_str.call(null,error__35258__auto___37716)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37705_37711,new cljs.core.Keyword(null,"value","value",305978217),args__35257__auto___37714,new cljs.core.Keyword(null,"error","error",-978969032),error__35258__auto___37716], null));
} else {
}
} else {
}

var o__35259__auto__ = (function (){var k = G__37708;
while(true){
if(cljs.core.truth_(schema.core.specific_key_QMARK_.call(null,k))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.explicit_schema_key.call(null,k),schema.core.required_key_QMARK_.call(null,k)], null);
} else {
if((cljs.core.sequential_QMARK_.call(null,k)) && (!(cljs.core.vector_QMARK_.call(null,k))) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,k),(2))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,k),new cljs.core.Symbol("schema.core","optional-key","schema.core/optional-key",-170069547,null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.second.call(null,k),false], null);
} else {
return null;
}
}
break;
}
})();
if(cljs.core.truth_(validate__35256__auto__)){
var temp__6753__auto___37717 = output_checker37707_37713.call(null,o__35259__auto__);
if(cljs.core.truth_(temp__6753__auto___37717)){
var error__35258__auto___37718 = temp__6753__auto___37717;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"unwrap-schema-form-key","unwrap-schema-form-key",-300088791,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),cljs.core.list(new cljs.core.Symbol("s","pair","s/pair",1193014306,null),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),"k",new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),"optional?")),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given a possibly-unevaluated schema map key form, unpack an explicit keyword\n   and optional? flag, or return nil for a non-explicit key"], null)),cljs.core.pr_str.call(null,error__35258__auto___37718)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37704_37710,new cljs.core.Keyword(null,"value","value",305978217),o__35259__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__35258__auto___37718], null));
} else {
}
} else {
}

return o__35259__auto__;
});})(ufv___37709,output_schema37704_37710,input_schema37705_37711,input_checker37706_37712,output_checker37707_37713))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.unwrap_schema_form_key),schema.core.make_fn_schema.call(null,output_schema37704_37710,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37705_37711], null)));
var ufv___37724 = schema.utils.use_fn_validation;
var output_schema37719_37725 = cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Bool], true, false);
var input_schema37720_37726 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker37721_37727 = schema.core.checker.call(null,input_schema37720_37726);
var output_checker37722_37728 = schema.core.checker.call(null,output_schema37719_37725);
/**
 * Inputs: [s]
 *   Returns: #:s{Keyword s/Bool}
 * 
 *   Given a possibly-unevaluated map schema, return a map from bare keyword to true
 * (for required) or false (for optional)
 */
plumbing.fnk.schema.explicit_schema_key_map = ((function (ufv___37724,output_schema37719_37725,input_schema37720_37726,input_checker37721_37727,output_checker37722_37728){
return (function plumbing$fnk$schema$explicit_schema_key_map(G__37723){
var validate__35256__auto__ = ufv___37724.get_cell();
if(cljs.core.truth_(validate__35256__auto__)){
var args__35257__auto___37729 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37723], null);
var temp__6753__auto___37730 = input_checker37721_37727.call(null,args__35257__auto___37729);
if(cljs.core.truth_(temp__6753__auto___37730)){
var error__35258__auto___37731 = temp__6753__auto___37730;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"explicit-schema-key-map","explicit-schema-key-map",1668953963,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given a possibly-unevaluated map schema, return a map from bare keyword to true\n   (for required) or false (for optional)"], null)),cljs.core.pr_str.call(null,error__35258__auto___37731)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37720_37726,new cljs.core.Keyword(null,"value","value",305978217),args__35257__auto___37729,new cljs.core.Keyword(null,"error","error",-978969032),error__35258__auto___37731], null));
} else {
}
} else {
}

var o__35259__auto__ = (function (){var s = G__37723;
while(true){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.keep.call(null,plumbing.fnk.schema.unwrap_schema_form_key,cljs.core.keys.call(null,s)));
break;
}
})();
if(cljs.core.truth_(validate__35256__auto__)){
var temp__6753__auto___37732 = output_checker37722_37728.call(null,o__35259__auto__);
if(cljs.core.truth_(temp__6753__auto___37732)){
var error__35258__auto___37733 = temp__6753__auto___37732;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"explicit-schema-key-map","explicit-schema-key-map",1668953963,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given a possibly-unevaluated map schema, return a map from bare keyword to true\n   (for required) or false (for optional)"], null)),cljs.core.pr_str.call(null,error__35258__auto___37733)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37719_37725,new cljs.core.Keyword(null,"value","value",305978217),o__35259__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__35258__auto___37733], null));
} else {
}
} else {
}

return o__35259__auto__;
});})(ufv___37724,output_schema37719_37725,input_schema37720_37726,input_checker37721_37727,output_checker37722_37728))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.explicit_schema_key_map),schema.core.make_fn_schema.call(null,output_schema37719_37725,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37720_37726], null)));
var ufv___37739 = schema.utils.use_fn_validation;
var output_schema37734_37740 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),new cljs.core.Symbol(null,"required","required",-846788763,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),new cljs.core.Symbol(null,"optional","optional",-600484260,null))], null);
var input_schema37735_37741 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Bool], true, false),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null)], null)], null)))], null);
var input_checker37736_37742 = schema.core.checker.call(null,input_schema37735_37741);
var output_checker37737_37743 = schema.core.checker.call(null,output_schema37734_37740);
/**
 * Inputs: [s :- #:s{Keyword s/Bool}]
 *   Returns: [(s/one [s/Keyword] (quote required)) (s/one [s/Keyword] (quote optional))]
 * 
 *   Given output of explicit-schema-key-map, split into seq [req opt].
 */
plumbing.fnk.schema.split_schema_keys = ((function (ufv___37739,output_schema37734_37740,input_schema37735_37741,input_checker37736_37742,output_checker37737_37743){
return (function plumbing$fnk$schema$split_schema_keys(G__37738){
var validate__35256__auto__ = ufv___37739.get_cell();
if(cljs.core.truth_(validate__35256__auto__)){
var args__35257__auto___37744 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37738], null);
var temp__6753__auto___37745 = input_checker37736_37742.call(null,args__35257__auto___37744);
if(cljs.core.truth_(temp__6753__auto___37745)){
var error__35258__auto___37746 = temp__6753__auto___37745;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"split-schema-keys","split-schema-keys",933671594,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"required","required",-846788763,null))),cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"optional","optional",-600484260,null)))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given output of explicit-schema-key-map, split into seq [req opt]."], null)),cljs.core.pr_str.call(null,error__35258__auto___37746)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37735_37741,new cljs.core.Keyword(null,"value","value",305978217),args__35257__auto___37744,new cljs.core.Keyword(null,"error","error",-978969032),error__35258__auto___37746], null));
} else {
}
} else {
}

var o__35259__auto__ = (function (){var s = G__37738;
while(true){
return cljs.core.mapv.call(null,cljs.core.partial.call(null,cljs.core.mapv,cljs.core.key),cljs.core.juxt.call(null,cljs.core.filter,cljs.core.remove).call(null,cljs.core.val,s));
break;
}
})();
if(cljs.core.truth_(validate__35256__auto__)){
var temp__6753__auto___37747 = output_checker37737_37743.call(null,o__35259__auto__);
if(cljs.core.truth_(temp__6753__auto___37747)){
var error__35258__auto___37748 = temp__6753__auto___37747;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"split-schema-keys","split-schema-keys",933671594,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"required","required",-846788763,null))),cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"optional","optional",-600484260,null)))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given output of explicit-schema-key-map, split into seq [req opt]."], null)),cljs.core.pr_str.call(null,error__35258__auto___37748)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37734_37740,new cljs.core.Keyword(null,"value","value",305978217),o__35259__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__35258__auto___37748], null));
} else {
}
} else {
}

return o__35259__auto__;
});})(ufv___37739,output_schema37734_37740,input_schema37735_37741,input_checker37736_37742,output_checker37737_37743))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.split_schema_keys),schema.core.make_fn_schema.call(null,output_schema37734_37740,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37735_37741], null)));
/**
 * Like merge-with, but also projects keys to a smaller space and merges them similar to the
 * values.
 */
plumbing.fnk.schema.merge_on_with = (function plumbing$fnk$schema$merge_on_with(var_args){
var args__21583__auto__ = [];
var len__21576__auto___37760 = arguments.length;
var i__21577__auto___37761 = (0);
while(true){
if((i__21577__auto___37761 < len__21576__auto___37760)){
args__21583__auto__.push((arguments[i__21577__auto___37761]));

var G__37762 = (i__21577__auto___37761 + (1));
i__21577__auto___37761 = G__37762;
continue;
} else {
}
break;
}

var argseq__21584__auto__ = ((((3) < args__21583__auto__.length))?(new cljs.core.IndexedSeq(args__21583__auto__.slice((3)),(0),null)):null);
return plumbing.fnk.schema.merge_on_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__21584__auto__);
});

plumbing.fnk.schema.merge_on_with.cljs$core$IFn$_invoke$arity$variadic = (function (key_project,key_combine,val_combine,maps){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (m,p__37753){
var vec__37754 = p__37753;
var k = cljs.core.nth.call(null,vec__37754,(0),null);
var v = cljs.core.nth.call(null,vec__37754,(1),null);
var pk = key_project.call(null,k);
var temp__6751__auto__ = cljs.core.get.call(null,m,pk);
if(cljs.core.truth_(temp__6751__auto__)){
var vec__37757 = temp__6751__auto__;
var ok = cljs.core.nth.call(null,vec__37757,(0),null);
var ov = cljs.core.nth.call(null,vec__37757,(1),null);
return cljs.core.assoc.call(null,m,pk,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_combine.call(null,ok,k),val_combine.call(null,ov,v)], null));
} else {
return cljs.core.assoc.call(null,m,pk,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));
}
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.apply.call(null,cljs.core.concat,maps))));
});

plumbing.fnk.schema.merge_on_with.cljs$lang$maxFixedArity = (3);

plumbing.fnk.schema.merge_on_with.cljs$lang$applyTo = (function (seq37749){
var G__37750 = cljs.core.first.call(null,seq37749);
var seq37749__$1 = cljs.core.next.call(null,seq37749);
var G__37751 = cljs.core.first.call(null,seq37749__$1);
var seq37749__$2 = cljs.core.next.call(null,seq37749__$1);
var G__37752 = cljs.core.first.call(null,seq37749__$2);
var seq37749__$3 = cljs.core.next.call(null,seq37749__$2);
return plumbing.fnk.schema.merge_on_with.cljs$core$IFn$_invoke$arity$variadic(G__37750,G__37751,G__37752,seq37749__$3);
});

var ufv___37770 = schema.utils.use_fn_validation;
var output_schema37764_37771 = plumbing.fnk.schema.InputSchema;
var input_schema37765_37772 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"i1","i1",-572470430,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null)], null))),schema.core.one.call(null,plumbing.fnk.schema.InputSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"i2","i2",850408895,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null)], null)))], null);
var input_checker37766_37773 = schema.core.checker.call(null,input_schema37765_37772);
var output_checker37767_37774 = schema.core.checker.call(null,output_schema37764_37771);
/**
 * Inputs: [i1 :- InputSchema i2 :- InputSchema]
 *   Returns: InputSchema
 * 
 *   Returns a minimal input schema schema that entails satisfaction of both s1 and s2
 */
plumbing.fnk.schema.union_input_schemata = ((function (ufv___37770,output_schema37764_37771,input_schema37765_37772,input_checker37766_37773,output_checker37767_37774){
return (function plumbing$fnk$schema$union_input_schemata(G__37768,G__37769){
var validate__35256__auto__ = ufv___37770.get_cell();
if(cljs.core.truth_(validate__35256__auto__)){
var args__35257__auto___37775 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37768,G__37769], null);
var temp__6753__auto___37776 = input_checker37766_37773.call(null,args__35257__auto___37775);
if(cljs.core.truth_(temp__6753__auto___37776)){
var error__35258__auto___37777 = temp__6753__auto___37776;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"union-input-schemata","union-input-schemata",-1338811970,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a minimal input schema schema that entails satisfaction of both s1 and s2"], null)),cljs.core.pr_str.call(null,error__35258__auto___37777)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37765_37772,new cljs.core.Keyword(null,"value","value",305978217),args__35257__auto___37775,new cljs.core.Keyword(null,"error","error",-978969032),error__35258__auto___37777], null));
} else {
}
} else {
}

var o__35259__auto__ = (function (){var i1 = G__37768;
var i2 = G__37769;
while(true){
return plumbing.fnk.schema.merge_on_with.call(null,((function (validate__35256__auto__,ufv___37770,output_schema37764_37771,input_schema37765_37772,input_checker37766_37773,output_checker37767_37774){
return (function (p1__37763_SHARP_){
if(cljs.core.truth_(schema.core.specific_key_QMARK_.call(null,p1__37763_SHARP_))){
return schema.core.explicit_schema_key.call(null,p1__37763_SHARP_);
} else {
return new cljs.core.Keyword(null,"extra","extra",1612569067);
}
});})(validate__35256__auto__,ufv___37770,output_schema37764_37771,input_schema37765_37772,input_checker37766_37773,output_checker37767_37774))
,((function (validate__35256__auto__,ufv___37770,output_schema37764_37771,input_schema37765_37772,input_checker37766_37773,output_checker37767_37774){
return (function (k1,k2){
if(cljs.core.truth_(schema.core.required_key_QMARK_.call(null,k1))){
return k1;
} else {
if(cljs.core.truth_(schema.core.required_key_QMARK_.call(null,k2))){
return k2;
} else {
if(cljs.core.truth_(schema.core.optional_key_QMARK_.call(null,k1))){
if(cljs.core._EQ_.call(null,k1,k2)){
} else {
throw (new Error("Assert failed: (= k1 k2)"));
}

return k1;
} else {
if(cljs.core._EQ_.call(null,k1,k2)){
return k1;
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Only one extra schema allowed")));


}
}
}
}
});})(validate__35256__auto__,ufv___37770,output_schema37764_37771,input_schema37765_37772,input_checker37766_37773,output_checker37767_37774))
,((function (validate__35256__auto__,ufv___37770,output_schema37764_37771,input_schema37765_37772,input_checker37766_37773,output_checker37767_37774){
return (function (s1,s2){
if(cljs.core.truth_((function (){var and__20348__auto__ = plumbing.fnk.schema.map_schema_QMARK_.call(null,s1);
if(cljs.core.truth_(and__20348__auto__)){
return plumbing.fnk.schema.map_schema_QMARK_.call(null,s2);
} else {
return and__20348__auto__;
}
})())){
return plumbing.fnk.schema.union_input_schemata.call(null,s1,s2);
} else {
return plumbing.fnk.schema.non_map_union.call(null,s1,s2);
}
});})(validate__35256__auto__,ufv___37770,output_schema37764_37771,input_schema37765_37772,input_checker37766_37773,output_checker37767_37774))
,i1,i2);
break;
}
})();
if(cljs.core.truth_(validate__35256__auto__)){
var temp__6753__auto___37778 = output_checker37767_37774.call(null,o__35259__auto__);
if(cljs.core.truth_(temp__6753__auto___37778)){
var error__35258__auto___37779 = temp__6753__auto___37778;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"union-input-schemata","union-input-schemata",-1338811970,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a minimal input schema schema that entails satisfaction of both s1 and s2"], null)),cljs.core.pr_str.call(null,error__35258__auto___37779)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37764_37771,new cljs.core.Keyword(null,"value","value",305978217),o__35259__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__35258__auto___37779], null));
} else {
}
} else {
}

return o__35259__auto__;
});})(ufv___37770,output_schema37764_37771,input_schema37765_37772,input_checker37766_37773,output_checker37767_37774))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.union_input_schemata),schema.core.make_fn_schema.call(null,output_schema37764_37771,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37765_37772], null)));
var ufv___37785 = schema.utils.use_fn_validation;
var output_schema37780_37786 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null);
var input_schema37781_37787 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"input-schema","input-schema",1373647181,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null)], null)))], null);
var input_checker37782_37788 = schema.core.checker.call(null,input_schema37781_37787);
var output_checker37783_37789 = schema.core.checker.call(null,output_schema37780_37786);
/**
 * Inputs: [input-schema :- InputSchema]
 *   Returns: [s/Keyword]
 * 
 *   Which top-level keys are required (i.e., non-false) by this input schema.
 */
plumbing.fnk.schema.required_toplevel_keys = ((function (ufv___37785,output_schema37780_37786,input_schema37781_37787,input_checker37782_37788,output_checker37783_37789){
return (function plumbing$fnk$schema$required_toplevel_keys(G__37784){
var validate__35256__auto__ = ufv___37785.get_cell();
if(cljs.core.truth_(validate__35256__auto__)){
var args__35257__auto___37790 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37784], null);
var temp__6753__auto___37791 = input_checker37782_37788.call(null,args__35257__auto___37790);
if(cljs.core.truth_(temp__6753__auto___37791)){
var error__35258__auto___37792 = temp__6753__auto___37791;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"required-toplevel-keys","required-toplevel-keys",1052167617,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Which top-level keys are required (i.e., non-false) by this input schema."], null)),cljs.core.pr_str.call(null,error__35258__auto___37792)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37781_37787,new cljs.core.Keyword(null,"value","value",305978217),args__35257__auto___37790,new cljs.core.Keyword(null,"error","error",-978969032),error__35258__auto___37792], null));
} else {
}
} else {
}

var o__35259__auto__ = (function (){var input_schema = G__37784;
while(true){
return cljs.core.keep.call(null,((function (validate__35256__auto__,ufv___37785,output_schema37780_37786,input_schema37781_37787,input_checker37782_37788,output_checker37783_37789){
return (function (k){
if(cljs.core.truth_(schema.core.required_key_QMARK_.call(null,k))){
return schema.core.explicit_schema_key.call(null,k);
} else {
return null;
}
});})(validate__35256__auto__,ufv___37785,output_schema37780_37786,input_schema37781_37787,input_checker37782_37788,output_checker37783_37789))
,cljs.core.keys.call(null,input_schema));
break;
}
})();
if(cljs.core.truth_(validate__35256__auto__)){
var temp__6753__auto___37793 = output_checker37783_37789.call(null,o__35259__auto__);
if(cljs.core.truth_(temp__6753__auto___37793)){
var error__35258__auto___37794 = temp__6753__auto___37793;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"required-toplevel-keys","required-toplevel-keys",1052167617,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Which top-level keys are required (i.e., non-false) by this input schema."], null)),cljs.core.pr_str.call(null,error__35258__auto___37794)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37780_37786,new cljs.core.Keyword(null,"value","value",305978217),o__35259__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__35258__auto___37794], null));
} else {
}
} else {
}

return o__35259__auto__;
});})(ufv___37785,output_schema37780_37786,input_schema37781_37787,input_checker37782_37788,output_checker37783_37789))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.required_toplevel_keys),schema.core.make_fn_schema.call(null,output_schema37780_37786,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37781_37787], null)));
/**
 * Guess an output schema for an expr.  Currently just looks for literal map structure and
 * all keyword keys.
 */
plumbing.fnk.schema.guess_expr_output_schema = (function plumbing$fnk$schema$guess_expr_output_schema(expr){
if((cljs.core.map_QMARK_.call(null,expr)) && (cljs.core.every_QMARK_.call(null,cljs.core.keyword_QMARK_,cljs.core.keys.call(null,expr)))){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__21217__auto__ = (function plumbing$fnk$schema$guess_expr_output_schema_$_iter__37811(s__37812){
return (new cljs.core.LazySeq(null,(function (){
var s__37812__$1 = s__37812;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__37812__$1);
if(temp__6753__auto__){
var s__37812__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37812__$2)){
var c__21215__auto__ = cljs.core.chunk_first.call(null,s__37812__$2);
var size__21216__auto__ = cljs.core.count.call(null,c__21215__auto__);
var b__37814 = cljs.core.chunk_buffer.call(null,size__21216__auto__);
if((function (){var i__37813 = (0);
while(true){
if((i__37813 < size__21216__auto__)){
var vec__37821 = cljs.core._nth.call(null,c__21215__auto__,i__37813);
var k = cljs.core.nth.call(null,vec__37821,(0),null);
var v = cljs.core.nth.call(null,vec__37821,(1),null);
cljs.core.chunk_append.call(null,b__37814,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,plumbing.fnk.schema.guess_expr_output_schema.call(null,v)], null));

var G__37827 = (i__37813 + (1));
i__37813 = G__37827;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37814),plumbing$fnk$schema$guess_expr_output_schema_$_iter__37811.call(null,cljs.core.chunk_rest.call(null,s__37812__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37814),null);
}
} else {
var vec__37824 = cljs.core.first.call(null,s__37812__$2);
var k = cljs.core.nth.call(null,vec__37824,(0),null);
var v = cljs.core.nth.call(null,vec__37824,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,plumbing.fnk.schema.guess_expr_output_schema.call(null,v)], null),plumbing$fnk$schema$guess_expr_output_schema_$_iter__37811.call(null,cljs.core.rest.call(null,s__37812__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__21217__auto__.call(null,expr);
})());
} else {
return new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null);
}
});
/**
 * Subtract output-schema from input-schema, returning nil if it's possible that an object
 * satisfying the output-schema satisfies the input-schema, or otherwise a description
 * of the part(s) of input-schema not met by output-schema.  Strict about the map structure
 * of output-schema matching input-schema, but loose about everything else (only looks at
 * required keys of output-schema.
 */
plumbing.fnk.schema.schema_diff = (function plumbing$fnk$schema$schema_diff(input_schema,output_schema){
if(cljs.core.not.call(null,plumbing.fnk.schema.map_schema_QMARK_.call(null,input_schema))){
return plumbing.fnk.schema.non_map_diff.call(null,input_schema,output_schema);
} else {
if(cljs.core.not.call(null,plumbing.fnk.schema.map_schema_QMARK_.call(null,output_schema))){
return schema.utils.error.call(null,schema.utils.make_ValidationError.call(null,input_schema,output_schema,(new cljs.core.Delay((function (){
return cljs.core._conj.call(null,(function (){var x__21289__auto__ = schema.core.explain.call(null,output_schema);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__21289__auto__);
})(),new cljs.core.Symbol(null,"map?","map?",-1780568534,null));
}),null)),null));
} else {
return cljs.core.not_empty.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__21217__auto__ = (function plumbing$fnk$schema$schema_diff_$_iter__37844(s__37845){
return (new cljs.core.LazySeq(null,(function (){
var s__37845__$1 = s__37845;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__37845__$1);
if(temp__6753__auto__){
var s__37845__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37845__$2)){
var c__21215__auto__ = cljs.core.chunk_first.call(null,s__37845__$2);
var size__21216__auto__ = cljs.core.count.call(null,c__21215__auto__);
var b__37847 = cljs.core.chunk_buffer.call(null,size__21216__auto__);
if((function (){var i__37846 = (0);
while(true){
if((i__37846 < size__21216__auto__)){
var vec__37854 = cljs.core._nth.call(null,c__21215__auto__,i__37846);
var k = cljs.core.nth.call(null,vec__37854,(0),null);
var v = cljs.core.nth.call(null,vec__37854,(1),null);
if(cljs.core.truth_(schema.core.specific_key_QMARK_.call(null,k))){
var required_QMARK_ = schema.core.required_key_QMARK_.call(null,k);
var raw_k = schema.core.explicit_schema_key.call(null,k);
var present_QMARK_ = cljs.core.contains_QMARK_.call(null,output_schema,raw_k);
if(cljs.core.truth_((function (){var or__20360__auto__ = required_QMARK_;
if(cljs.core.truth_(or__20360__auto__)){
return or__20360__auto__;
} else {
return present_QMARK_;
}
})())){
var fail = ((!(present_QMARK_))?new cljs.core.Symbol(null,"missing-required-key","missing-required-key",709961446,null):plumbing.fnk.schema.schema_diff.call(null,v,cljs.core.get.call(null,output_schema,raw_k)));
if(cljs.core.truth_(fail)){
cljs.core.chunk_append.call(null,b__37847,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fail], null));

var G__37860 = (i__37846 + (1));
i__37846 = G__37860;
continue;
} else {
var G__37861 = (i__37846 + (1));
i__37846 = G__37861;
continue;
}
} else {
var G__37862 = (i__37846 + (1));
i__37846 = G__37862;
continue;
}
} else {
var G__37863 = (i__37846 + (1));
i__37846 = G__37863;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37847),plumbing$fnk$schema$schema_diff_$_iter__37844.call(null,cljs.core.chunk_rest.call(null,s__37845__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37847),null);
}
} else {
var vec__37857 = cljs.core.first.call(null,s__37845__$2);
var k = cljs.core.nth.call(null,vec__37857,(0),null);
var v = cljs.core.nth.call(null,vec__37857,(1),null);
if(cljs.core.truth_(schema.core.specific_key_QMARK_.call(null,k))){
var required_QMARK_ = schema.core.required_key_QMARK_.call(null,k);
var raw_k = schema.core.explicit_schema_key.call(null,k);
var present_QMARK_ = cljs.core.contains_QMARK_.call(null,output_schema,raw_k);
if(cljs.core.truth_((function (){var or__20360__auto__ = required_QMARK_;
if(cljs.core.truth_(or__20360__auto__)){
return or__20360__auto__;
} else {
return present_QMARK_;
}
})())){
var fail = ((!(present_QMARK_))?new cljs.core.Symbol(null,"missing-required-key","missing-required-key",709961446,null):plumbing.fnk.schema.schema_diff.call(null,v,cljs.core.get.call(null,output_schema,raw_k)));
if(cljs.core.truth_(fail)){
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fail], null),plumbing$fnk$schema$schema_diff_$_iter__37844.call(null,cljs.core.rest.call(null,s__37845__$2)));
} else {
var G__37864 = cljs.core.rest.call(null,s__37845__$2);
s__37845__$1 = G__37864;
continue;
}
} else {
var G__37865 = cljs.core.rest.call(null,s__37845__$2);
s__37845__$1 = G__37865;
continue;
}
} else {
var G__37866 = cljs.core.rest.call(null,s__37845__$2);
s__37845__$1 = G__37866;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__21217__auto__.call(null,input_schema);
})()));

}
}
});
plumbing.fnk.schema.assert_satisfies_schema = (function plumbing$fnk$schema$assert_satisfies_schema(input_schema,output_schema){
var fails = plumbing.fnk.schema.schema_diff.call(null,input_schema,output_schema);
if(cljs.core.truth_(fails)){
throw cljs.core.ex_info.call(null,[cljs.core.str(fails)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"does-not-satisfy-schema","does-not-satisfy-schema",-1543152824),new cljs.core.Keyword(null,"failures","failures",-912916356),fails], null));
} else {
return null;
}
});
var ufv___37913 = schema.utils.use_fn_validation;
var output_schema37867_37914 = schema.core.Any;
var input_schema37868_37915 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.IOSchemata,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,plumbing.fnk.schema.MapOutputSchema,new cljs.core.Symbol(null,"output","output",534662484,null))], null),new cljs.core.Symbol(null,"arg1","arg1",-1702536411,null))], null);
var input_checker37869_37916 = schema.core.checker.call(null,input_schema37868_37915);
var output_checker37870_37917 = schema.core.checker.call(null,output_schema37867_37914);
/**
 * Inputs: [[i2 o2] :- IOSchemata [i1 o1] :- [(s/one InputSchema (quote input)) (s/one MapOutputSchema (quote output))]]
 * 
 *   Given pairs of input and output schemata for fnks f1 and f2,
 * return a pair of input and output schemata for #(f2 (merge % (f1 %))).
 * f1's output schema must not contain any optional keys.
 */
plumbing.fnk.schema.compose_schemata = ((function (ufv___37913,output_schema37867_37914,input_schema37868_37915,input_checker37869_37916,output_checker37870_37917){
return (function plumbing$fnk$schema$compose_schemata(G__37871,G__37872){
var validate__35256__auto__ = true;
if(validate__35256__auto__){
var args__35257__auto___37918 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37871,G__37872], null);
var temp__6753__auto___37919 = input_checker37869_37916.call(null,args__35257__auto___37918);
if(cljs.core.truth_(temp__6753__auto___37919)){
var error__35258__auto___37920 = temp__6753__auto___37919;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"compose-schemata","compose-schemata",918607729,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"always-validate","always-validate",1031872127),true,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given pairs of input and output schemata for fnks f1 and f2,\n   return a pair of input and output schemata for #(f2 (merge % (f1 %))).\n   f1's output schema must not contain any optional keys."], null)),cljs.core.pr_str.call(null,error__35258__auto___37920)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37868_37915,new cljs.core.Keyword(null,"value","value",305978217),args__35257__auto___37918,new cljs.core.Keyword(null,"error","error",-978969032),error__35258__auto___37920], null));
} else {
}
} else {
}

var o__35259__auto__ = (function (){var G__37899 = G__37871;
var vec__37901 = G__37899;
var i2 = cljs.core.nth.call(null,vec__37901,(0),null);
var o2 = cljs.core.nth.call(null,vec__37901,(1),null);
var G__37900 = G__37872;
var vec__37904 = G__37900;
var i1 = cljs.core.nth.call(null,vec__37904,(0),null);
var o1 = cljs.core.nth.call(null,vec__37904,(1),null);
var G__37899__$1 = G__37899;
var G__37900__$1 = G__37900;
while(true){
var vec__37907 = G__37899__$1;
var i2__$1 = cljs.core.nth.call(null,vec__37907,(0),null);
var o2__$1 = cljs.core.nth.call(null,vec__37907,(1),null);
var vec__37910 = G__37900__$1;
var i1__$1 = cljs.core.nth.call(null,vec__37910,(0),null);
var o1__$1 = cljs.core.nth.call(null,vec__37910,(1),null);
plumbing.fnk.schema.assert_satisfies_schema.call(null,cljs.core.select_keys.call(null,i2__$1,cljs.core.keys.call(null,o1__$1)),o1__$1);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [plumbing.fnk.schema.union_input_schemata.call(null,cljs.core.apply.call(null,cljs.core.dissoc,i2__$1,cljs.core.concat.call(null,cljs.core.keys.call(null,o1__$1),cljs.core.map.call(null,schema.core.optional_key,cljs.core.keys.call(null,o1__$1)))),i1__$1),o2__$1], null);
break;
}
})();
if(validate__35256__auto__){
var temp__6753__auto___37921 = output_checker37870_37917.call(null,o__35259__auto__);
if(cljs.core.truth_(temp__6753__auto___37921)){
var error__35258__auto___37922 = temp__6753__auto___37921;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"compose-schemata","compose-schemata",918607729,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"always-validate","always-validate",1031872127),true,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given pairs of input and output schemata for fnks f1 and f2,\n   return a pair of input and output schemata for #(f2 (merge % (f1 %))).\n   f1's output schema must not contain any optional keys."], null)),cljs.core.pr_str.call(null,error__35258__auto___37922)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37867_37914,new cljs.core.Keyword(null,"value","value",305978217),o__35259__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__35258__auto___37922], null));
} else {
}
} else {
}

return o__35259__auto__;
});})(ufv___37913,output_schema37867_37914,input_schema37868_37915,input_checker37869_37916,output_checker37870_37917))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.compose_schemata),schema.core.make_fn_schema.call(null,output_schema37867_37914,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37868_37915], null)));
plumbing.fnk.schema.schema_key = (function plumbing$fnk$schema$schema_key(m,k){
if(cljs.core.contains_QMARK_.call(null,m,k)){
return k;
} else {
if(cljs.core.contains_QMARK_.call(null,m,schema.core.optional_key.call(null,k))){
return schema.core.optional_key.call(null,k);
} else {
return null;

}
}
});
plumbing.fnk.schema.possibly_contains_QMARK_ = (function plumbing$fnk$schema$possibly_contains_QMARK_(m,k){
return cljs.core.boolean$.call(null,plumbing.fnk.schema.schema_key.call(null,m,k));
});
var ufv___38065 = schema.utils.use_fn_validation;
var output_schema37923_38066 = schema.core.Any;
var input_schema37924_38067 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null)], null))),schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"ks","ks",-754231827,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_checker37925_38068 = schema.core.checker.call(null,input_schema37924_38067);
var output_checker37926_38069 = schema.core.checker.call(null,output_schema37923_38066);
/**
 * Inputs: [s :- InputSchema ks :- [s/Keyword]]
 * 
 *   Return a pair [ks-part non-ks-part], with any extra schema removed.
 */
plumbing.fnk.schema.split_schema = ((function (ufv___38065,output_schema37923_38066,input_schema37924_38067,input_checker37925_38068,output_checker37926_38069){
return (function plumbing$fnk$schema$split_schema(G__37927,G__37928){
var validate__35256__auto__ = ufv___38065.get_cell();
if(cljs.core.truth_(validate__35256__auto__)){
var args__35257__auto___38070 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37927,G__37928], null);
var temp__6753__auto___38071 = input_checker37925_38068.call(null,args__35257__auto___38070);
if(cljs.core.truth_(temp__6753__auto___38071)){
var error__35258__auto___38072 = temp__6753__auto___38071;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"split-schema","split-schema",1859174771,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a pair [ks-part non-ks-part], with any extra schema removed."], null)),cljs.core.pr_str.call(null,error__35258__auto___38072)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37924_38067,new cljs.core.Keyword(null,"value","value",305978217),args__35257__auto___38070,new cljs.core.Keyword(null,"error","error",-978969032),error__35258__auto___38072], null));
} else {
}
} else {
}

var o__35259__auto__ = (function (){var s = G__37927;
var ks = G__37928;
while(true){
var ks__$1 = cljs.core.set.call(null,ks);
var iter__21217__auto__ = ((function (ks__$1,validate__35256__auto__,ufv___38065,output_schema37923_38066,input_schema37924_38067,input_checker37925_38068,output_checker37926_38069){
return (function plumbing$fnk$schema$split_schema_$_iter__37997(s__37998){
return (new cljs.core.LazySeq(null,((function (ks__$1,validate__35256__auto__,ufv___38065,output_schema37923_38066,input_schema37924_38067,input_checker37925_38068,output_checker37926_38069){
return (function (){
var s__37998__$1 = s__37998;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__37998__$1);
if(temp__6753__auto__){
var s__37998__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37998__$2)){
var c__21215__auto__ = cljs.core.chunk_first.call(null,s__37998__$2);
var size__21216__auto__ = cljs.core.count.call(null,c__21215__auto__);
var b__38000 = cljs.core.chunk_buffer.call(null,size__21216__auto__);
if((function (){var i__37999 = (0);
while(true){
if((i__37999 < size__21216__auto__)){
var in_QMARK_ = cljs.core._nth.call(null,c__21215__auto__,i__37999);
cljs.core.chunk_append.call(null,b__38000,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__21217__auto__ = ((function (i__37999,in_QMARK_,c__21215__auto__,size__21216__auto__,b__38000,s__37998__$2,temp__6753__auto__,ks__$1,validate__35256__auto__,ufv___38065,output_schema37923_38066,input_schema37924_38067,input_checker37925_38068,output_checker37926_38069){
return (function plumbing$fnk$schema$split_schema_$_iter__37997_$_iter__38033(s__38034){
return (new cljs.core.LazySeq(null,((function (i__37999,in_QMARK_,c__21215__auto__,size__21216__auto__,b__38000,s__37998__$2,temp__6753__auto__,ks__$1,validate__35256__auto__,ufv___38065,output_schema37923_38066,input_schema37924_38067,input_checker37925_38068,output_checker37926_38069){
return (function (){
var s__38034__$1 = s__38034;
while(true){
var temp__6753__auto____$1 = cljs.core.seq.call(null,s__38034__$1);
if(temp__6753__auto____$1){
var s__38034__$2 = temp__6753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__38034__$2)){
var c__21215__auto____$1 = cljs.core.chunk_first.call(null,s__38034__$2);
var size__21216__auto____$1 = cljs.core.count.call(null,c__21215__auto____$1);
var b__38036 = cljs.core.chunk_buffer.call(null,size__21216__auto____$1);
if((function (){var i__38035 = (0);
while(true){
if((i__38035 < size__21216__auto____$1)){
var vec__38043 = cljs.core._nth.call(null,c__21215__auto____$1,i__38035);
var k = cljs.core.nth.call(null,vec__38043,(0),null);
var v = cljs.core.nth.call(null,vec__38043,(1),null);
if(cljs.core.truth_((function (){var and__20348__auto__ = schema.core.specific_key_QMARK_.call(null,k);
if(cljs.core.truth_(and__20348__auto__)){
return cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)));
} else {
return and__20348__auto__;
}
})())){
cljs.core.chunk_append.call(null,b__38036,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__38073 = (i__38035 + (1));
i__38035 = G__38073;
continue;
} else {
var G__38074 = (i__38035 + (1));
i__38035 = G__38074;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38036),plumbing$fnk$schema$split_schema_$_iter__37997_$_iter__38033.call(null,cljs.core.chunk_rest.call(null,s__38034__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38036),null);
}
} else {
var vec__38046 = cljs.core.first.call(null,s__38034__$2);
var k = cljs.core.nth.call(null,vec__38046,(0),null);
var v = cljs.core.nth.call(null,vec__38046,(1),null);
if(cljs.core.truth_((function (){var and__20348__auto__ = schema.core.specific_key_QMARK_.call(null,k);
if(cljs.core.truth_(and__20348__auto__)){
return cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)));
} else {
return and__20348__auto__;
}
})())){
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),plumbing$fnk$schema$split_schema_$_iter__37997_$_iter__38033.call(null,cljs.core.rest.call(null,s__38034__$2)));
} else {
var G__38075 = cljs.core.rest.call(null,s__38034__$2);
s__38034__$1 = G__38075;
continue;
}
}
} else {
return null;
}
break;
}
});})(i__37999,in_QMARK_,c__21215__auto__,size__21216__auto__,b__38000,s__37998__$2,temp__6753__auto__,ks__$1,validate__35256__auto__,ufv___38065,output_schema37923_38066,input_schema37924_38067,input_checker37925_38068,output_checker37926_38069))
,null,null));
});})(i__37999,in_QMARK_,c__21215__auto__,size__21216__auto__,b__38000,s__37998__$2,temp__6753__auto__,ks__$1,validate__35256__auto__,ufv___38065,output_schema37923_38066,input_schema37924_38067,input_checker37925_38068,output_checker37926_38069))
;
return iter__21217__auto__.call(null,s);
})()));

var G__38076 = (i__37999 + (1));
i__37999 = G__38076;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38000),plumbing$fnk$schema$split_schema_$_iter__37997.call(null,cljs.core.chunk_rest.call(null,s__37998__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38000),null);
}
} else {
var in_QMARK_ = cljs.core.first.call(null,s__37998__$2);
return cljs.core.cons.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__21217__auto__ = ((function (in_QMARK_,s__37998__$2,temp__6753__auto__,ks__$1,validate__35256__auto__,ufv___38065,output_schema37923_38066,input_schema37924_38067,input_checker37925_38068,output_checker37926_38069){
return (function plumbing$fnk$schema$split_schema_$_iter__37997_$_iter__38049(s__38050){
return (new cljs.core.LazySeq(null,((function (in_QMARK_,s__37998__$2,temp__6753__auto__,ks__$1,validate__35256__auto__,ufv___38065,output_schema37923_38066,input_schema37924_38067,input_checker37925_38068,output_checker37926_38069){
return (function (){
var s__38050__$1 = s__38050;
while(true){
var temp__6753__auto____$1 = cljs.core.seq.call(null,s__38050__$1);
if(temp__6753__auto____$1){
var s__38050__$2 = temp__6753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__38050__$2)){
var c__21215__auto__ = cljs.core.chunk_first.call(null,s__38050__$2);
var size__21216__auto__ = cljs.core.count.call(null,c__21215__auto__);
var b__38052 = cljs.core.chunk_buffer.call(null,size__21216__auto__);
if((function (){var i__38051 = (0);
while(true){
if((i__38051 < size__21216__auto__)){
var vec__38059 = cljs.core._nth.call(null,c__21215__auto__,i__38051);
var k = cljs.core.nth.call(null,vec__38059,(0),null);
var v = cljs.core.nth.call(null,vec__38059,(1),null);
if(cljs.core.truth_((function (){var and__20348__auto__ = schema.core.specific_key_QMARK_.call(null,k);
if(cljs.core.truth_(and__20348__auto__)){
return cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)));
} else {
return and__20348__auto__;
}
})())){
cljs.core.chunk_append.call(null,b__38052,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__38077 = (i__38051 + (1));
i__38051 = G__38077;
continue;
} else {
var G__38078 = (i__38051 + (1));
i__38051 = G__38078;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38052),plumbing$fnk$schema$split_schema_$_iter__37997_$_iter__38049.call(null,cljs.core.chunk_rest.call(null,s__38050__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38052),null);
}
} else {
var vec__38062 = cljs.core.first.call(null,s__38050__$2);
var k = cljs.core.nth.call(null,vec__38062,(0),null);
var v = cljs.core.nth.call(null,vec__38062,(1),null);
if(cljs.core.truth_((function (){var and__20348__auto__ = schema.core.specific_key_QMARK_.call(null,k);
if(cljs.core.truth_(and__20348__auto__)){
return cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)));
} else {
return and__20348__auto__;
}
})())){
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),plumbing$fnk$schema$split_schema_$_iter__37997_$_iter__38049.call(null,cljs.core.rest.call(null,s__38050__$2)));
} else {
var G__38079 = cljs.core.rest.call(null,s__38050__$2);
s__38050__$1 = G__38079;
continue;
}
}
} else {
return null;
}
break;
}
});})(in_QMARK_,s__37998__$2,temp__6753__auto__,ks__$1,validate__35256__auto__,ufv___38065,output_schema37923_38066,input_schema37924_38067,input_checker37925_38068,output_checker37926_38069))
,null,null));
});})(in_QMARK_,s__37998__$2,temp__6753__auto__,ks__$1,validate__35256__auto__,ufv___38065,output_schema37923_38066,input_schema37924_38067,input_checker37925_38068,output_checker37926_38069))
;
return iter__21217__auto__.call(null,s);
})()),plumbing$fnk$schema$split_schema_$_iter__37997.call(null,cljs.core.rest.call(null,s__37998__$2)));
}
} else {
return null;
}
break;
}
});})(ks__$1,validate__35256__auto__,ufv___38065,output_schema37923_38066,input_schema37924_38067,input_checker37925_38068,output_checker37926_38069))
,null,null));
});})(ks__$1,validate__35256__auto__,ufv___38065,output_schema37923_38066,input_schema37924_38067,input_checker37925_38068,output_checker37926_38069))
;
return iter__21217__auto__.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,false], null));
break;
}
})();
if(cljs.core.truth_(validate__35256__auto__)){
var temp__6753__auto___38080 = output_checker37926_38069.call(null,o__35259__auto__);
if(cljs.core.truth_(temp__6753__auto___38080)){
var error__35258__auto___38081 = temp__6753__auto___38080;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"split-schema","split-schema",1859174771,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a pair [ks-part non-ks-part], with any extra schema removed."], null)),cljs.core.pr_str.call(null,error__35258__auto___38081)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37923_38066,new cljs.core.Keyword(null,"value","value",305978217),o__35259__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__35258__auto___38081], null));
} else {
}
} else {
}

return o__35259__auto__;
});})(ufv___38065,output_schema37923_38066,input_schema37924_38067,input_checker37925_38068,output_checker37926_38069))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.split_schema),schema.core.make_fn_schema.call(null,output_schema37923_38066,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37924_38067], null)));
var ufv___38152 = schema.utils.use_fn_validation;
var output_schema38082_38153 = plumbing.fnk.schema.GraphIOSchemata;
var input_schema38083_38154 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.GraphIOSchemata,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Keyword,"key"),schema.core.one.call(null,plumbing.fnk.schema.IOSchemata,"inner-schemas")], null),new cljs.core.Symbol(null,"arg1","arg1",-1702536411,null))], null);
var input_checker38084_38155 = schema.core.checker.call(null,input_schema38083_38154);
var output_checker38085_38156 = schema.core.checker.call(null,output_schema38082_38153);
/**
 * Inputs: [[i1 o1] :- GraphIOSchemata [k [i2 o2]] :- [(s/one s/Keyword "key") (s/one IOSchemata "inner-schemas")]]
 *   Returns: GraphIOSchemata
 * 
 *   Given pairs of input and output schemata for fnks f1 and f2, and a keyword k,
 * return a pair of input and output schemata for #(let [v1 (f1 %)] (assoc v1 k (f2 (merge-disjoint % v1))))
 */
plumbing.fnk.schema.sequence_schemata = ((function (ufv___38152,output_schema38082_38153,input_schema38083_38154,input_checker38084_38155,output_checker38085_38156){
return (function plumbing$fnk$schema$sequence_schemata(G__38086,G__38087){
var validate__35256__auto__ = ufv___38152.get_cell();
if(cljs.core.truth_(validate__35256__auto__)){
var args__35257__auto___38157 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__38086,G__38087], null);
var temp__6753__auto___38158 = input_checker38084_38155.call(null,args__35257__auto___38157);
if(cljs.core.truth_(temp__6753__auto___38158)){
var error__35258__auto___38159 = temp__6753__auto___38158;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"sequence-schemata","sequence-schemata",-2061205313,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"GraphIOSchemata","GraphIOSchemata",-2137701253,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given pairs of input and output schemata for fnks f1 and f2, and a keyword k,\n   return a pair of input and output schemata for #(let [v1 (f1 %)] (assoc v1 k (f2 (merge-disjoint % v1))))"], null)),cljs.core.pr_str.call(null,error__35258__auto___38159)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema38083_38154,new cljs.core.Keyword(null,"value","value",305978217),args__35257__auto___38157,new cljs.core.Keyword(null,"error","error",-978969032),error__35258__auto___38159], null));
} else {
}
} else {
}

var o__35259__auto__ = (function (){var G__38129 = G__38086;
var vec__38131 = G__38129;
var i1 = cljs.core.nth.call(null,vec__38131,(0),null);
var o1 = cljs.core.nth.call(null,vec__38131,(1),null);
var G__38130 = G__38087;
var vec__38134 = G__38130;
var k = cljs.core.nth.call(null,vec__38134,(0),null);
var vec__38137 = cljs.core.nth.call(null,vec__38134,(1),null);
var i2 = cljs.core.nth.call(null,vec__38137,(0),null);
var o2 = cljs.core.nth.call(null,vec__38137,(1),null);
var G__38129__$1 = G__38129;
var G__38130__$1 = G__38130;
while(true){
var vec__38140 = G__38129__$1;
var i1__$1 = cljs.core.nth.call(null,vec__38140,(0),null);
var o1__$1 = cljs.core.nth.call(null,vec__38140,(1),null);
var vec__38143 = G__38130__$1;
var k__$1 = cljs.core.nth.call(null,vec__38143,(0),null);
var vec__38146 = cljs.core.nth.call(null,vec__38143,(1),null);
var i2__$1 = cljs.core.nth.call(null,vec__38146,(0),null);
var o2__$1 = cljs.core.nth.call(null,vec__38146,(1),null);
if(cljs.core.not.call(null,plumbing.fnk.schema.possibly_contains_QMARK_.call(null,i1__$1,k__$1))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Duplicate key output (possibly due to a misordered graph) %s for input %s from input %s",k__$1,schema.core.explain.call(null,i2__$1),schema.core.explain.call(null,i1__$1))));
}

if(cljs.core.not.call(null,plumbing.fnk.schema.possibly_contains_QMARK_.call(null,i2__$1,k__$1))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Node outputs a key %s in its inputs %s",k__$1,schema.core.explain.call(null,i2__$1))));
}

if(cljs.core.not.call(null,plumbing.fnk.schema.possibly_contains_QMARK_.call(null,o1__$1,k__$1))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Node outputs a duplicate key %s given inputs %s",k__$1,schema.core.explain.call(null,i1__$1))));
}

var vec__38149 = plumbing.fnk.schema.split_schema.call(null,i2__$1,cljs.core.keys.call(null,o1__$1));
var used = cljs.core.nth.call(null,vec__38149,(0),null);
var unused = cljs.core.nth.call(null,vec__38149,(1),null);
plumbing.fnk.schema.assert_satisfies_schema.call(null,used,o1__$1);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [plumbing.fnk.schema.union_input_schemata.call(null,unused,i1__$1),cljs.core.assoc.call(null,o1__$1,k__$1,o2__$1)], null);
break;
}
})();
if(cljs.core.truth_(validate__35256__auto__)){
var temp__6753__auto___38160 = output_checker38085_38156.call(null,o__35259__auto__);
if(cljs.core.truth_(temp__6753__auto___38160)){
var error__35258__auto___38161 = temp__6753__auto___38160;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"sequence-schemata","sequence-schemata",-2061205313,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"GraphIOSchemata","GraphIOSchemata",-2137701253,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given pairs of input and output schemata for fnks f1 and f2, and a keyword k,\n   return a pair of input and output schemata for #(let [v1 (f1 %)] (assoc v1 k (f2 (merge-disjoint % v1))))"], null)),cljs.core.pr_str.call(null,error__35258__auto___38161)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema38082_38153,new cljs.core.Keyword(null,"value","value",305978217),o__35259__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__35258__auto___38161], null));
} else {
}
} else {
}

return o__35259__auto__;
});})(ufv___38152,output_schema38082_38153,input_schema38083_38154,input_checker38084_38155,output_checker38085_38156))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.sequence_schemata),schema.core.make_fn_schema.call(null,output_schema38082_38153,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema38083_38154], null)));

//# sourceMappingURL=schema.js.map