// Compiled by ClojureScript 1.9.293 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args24749 = [];
var len__21576__auto___24755 = arguments.length;
var i__21577__auto___24756 = (0);
while(true){
if((i__21577__auto___24756 < len__21576__auto___24755)){
args24749.push((arguments[i__21577__auto___24756]));

var G__24757 = (i__21577__auto___24756 + (1));
i__21577__auto___24756 = G__24757;
continue;
} else {
}
break;
}

var G__24751 = args24749.length;
switch (G__24751) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24749.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async24752 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24752 = (function (f,blockable,meta24753){
this.f = f;
this.blockable = blockable;
this.meta24753 = meta24753;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async24752.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24754,meta24753__$1){
var self__ = this;
var _24754__$1 = this;
return (new cljs.core.async.t_cljs$core$async24752(self__.f,self__.blockable,meta24753__$1));
});

cljs.core.async.t_cljs$core$async24752.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24754){
var self__ = this;
var _24754__$1 = this;
return self__.meta24753;
});

cljs.core.async.t_cljs$core$async24752.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24752.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async24752.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async24752.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async24752.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta24753","meta24753",2052065819,null)], null);
});

cljs.core.async.t_cljs$core$async24752.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24752.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24752";

cljs.core.async.t_cljs$core$async24752.cljs$lang$ctorPrWriter = (function (this__21012__auto__,writer__21013__auto__,opt__21014__auto__){
return cljs.core._write.call(null,writer__21013__auto__,"cljs.core.async/t_cljs$core$async24752");
});

cljs.core.async.__GT_t_cljs$core$async24752 = (function cljs$core$async$__GT_t_cljs$core$async24752(f__$1,blockable__$1,meta24753){
return (new cljs.core.async.t_cljs$core$async24752(f__$1,blockable__$1,meta24753));
});

}

return (new cljs.core.async.t_cljs$core$async24752(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args24761 = [];
var len__21576__auto___24764 = arguments.length;
var i__21577__auto___24765 = (0);
while(true){
if((i__21577__auto___24765 < len__21576__auto___24764)){
args24761.push((arguments[i__21577__auto___24765]));

var G__24766 = (i__21577__auto___24765 + (1));
i__21577__auto___24765 = G__24766;
continue;
} else {
}
break;
}

var G__24763 = args24761.length;
switch (G__24763) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24761.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args24768 = [];
var len__21576__auto___24771 = arguments.length;
var i__21577__auto___24772 = (0);
while(true){
if((i__21577__auto___24772 < len__21576__auto___24771)){
args24768.push((arguments[i__21577__auto___24772]));

var G__24773 = (i__21577__auto___24772 + (1));
i__21577__auto___24772 = G__24773;
continue;
} else {
}
break;
}

var G__24770 = args24768.length;
switch (G__24770) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24768.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args24775 = [];
var len__21576__auto___24778 = arguments.length;
var i__21577__auto___24779 = (0);
while(true){
if((i__21577__auto___24779 < len__21576__auto___24778)){
args24775.push((arguments[i__21577__auto___24779]));

var G__24780 = (i__21577__auto___24779 + (1));
i__21577__auto___24779 = G__24780;
continue;
} else {
}
break;
}

var G__24777 = args24775.length;
switch (G__24777) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24775.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_24782 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_24782);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_24782,ret){
return (function (){
return fn1.call(null,val_24782);
});})(val_24782,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args24783 = [];
var len__21576__auto___24786 = arguments.length;
var i__21577__auto___24787 = (0);
while(true){
if((i__21577__auto___24787 < len__21576__auto___24786)){
args24783.push((arguments[i__21577__auto___24787]));

var G__24788 = (i__21577__auto___24787 + (1));
i__21577__auto___24787 = G__24788;
continue;
} else {
}
break;
}

var G__24785 = args24783.length;
switch (G__24785) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24783.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6751__auto__)){
var ret = temp__6751__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6751__auto__)){
var retb = temp__6751__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6751__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6751__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__21376__auto___24790 = n;
var x_24791 = (0);
while(true){
if((x_24791 < n__21376__auto___24790)){
(a[x_24791] = (0));

var G__24792 = (x_24791 + (1));
x_24791 = G__24792;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__24793 = (i + (1));
i = G__24793;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async24797 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24797 = (function (flag,meta24798){
this.flag = flag;
this.meta24798 = meta24798;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async24797.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_24799,meta24798__$1){
var self__ = this;
var _24799__$1 = this;
return (new cljs.core.async.t_cljs$core$async24797(self__.flag,meta24798__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async24797.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_24799){
var self__ = this;
var _24799__$1 = this;
return self__.meta24798;
});})(flag))
;

cljs.core.async.t_cljs$core$async24797.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24797.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async24797.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async24797.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async24797.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta24798","meta24798",126791429,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async24797.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24797.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24797";

cljs.core.async.t_cljs$core$async24797.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__21012__auto__,writer__21013__auto__,opt__21014__auto__){
return cljs.core._write.call(null,writer__21013__auto__,"cljs.core.async/t_cljs$core$async24797");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async24797 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async24797(flag__$1,meta24798){
return (new cljs.core.async.t_cljs$core$async24797(flag__$1,meta24798));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async24797(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async24803 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24803 = (function (flag,cb,meta24804){
this.flag = flag;
this.cb = cb;
this.meta24804 = meta24804;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async24803.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24805,meta24804__$1){
var self__ = this;
var _24805__$1 = this;
return (new cljs.core.async.t_cljs$core$async24803(self__.flag,self__.cb,meta24804__$1));
});

cljs.core.async.t_cljs$core$async24803.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24805){
var self__ = this;
var _24805__$1 = this;
return self__.meta24804;
});

cljs.core.async.t_cljs$core$async24803.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24803.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async24803.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async24803.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async24803.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta24804","meta24804",693857390,null)], null);
});

cljs.core.async.t_cljs$core$async24803.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24803.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24803";

cljs.core.async.t_cljs$core$async24803.cljs$lang$ctorPrWriter = (function (this__21012__auto__,writer__21013__auto__,opt__21014__auto__){
return cljs.core._write.call(null,writer__21013__auto__,"cljs.core.async/t_cljs$core$async24803");
});

cljs.core.async.__GT_t_cljs$core$async24803 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async24803(flag__$1,cb__$1,meta24804){
return (new cljs.core.async.t_cljs$core$async24803(flag__$1,cb__$1,meta24804));
});

}

return (new cljs.core.async.t_cljs$core$async24803(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__24806_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24806_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__24807_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24807_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__20360__auto__ = wport;
if(cljs.core.truth_(or__20360__auto__)){
return or__20360__auto__;
} else {
return port;
}
})()], null));
} else {
var G__24808 = (i + (1));
i = G__24808;
continue;
}
} else {
return null;
}
break;
}
})();
var or__20360__auto__ = ret;
if(cljs.core.truth_(or__20360__auto__)){
return or__20360__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6753__auto__ = (function (){var and__20348__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__20348__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__20348__auto__;
}
})();
if(cljs.core.truth_(temp__6753__auto__)){
var got = temp__6753__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__21583__auto__ = [];
var len__21576__auto___24814 = arguments.length;
var i__21577__auto___24815 = (0);
while(true){
if((i__21577__auto___24815 < len__21576__auto___24814)){
args__21583__auto__.push((arguments[i__21577__auto___24815]));

var G__24816 = (i__21577__auto___24815 + (1));
i__21577__auto___24815 = G__24816;
continue;
} else {
}
break;
}

var argseq__21584__auto__ = ((((1) < args__21583__auto__.length))?(new cljs.core.IndexedSeq(args__21583__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21584__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__24811){
var map__24812 = p__24811;
var map__24812__$1 = ((((!((map__24812 == null)))?((((map__24812.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24812.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24812):map__24812);
var opts = map__24812__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq24809){
var G__24810 = cljs.core.first.call(null,seq24809);
var seq24809__$1 = cljs.core.next.call(null,seq24809);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__24810,seq24809__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args24817 = [];
var len__21576__auto___24867 = arguments.length;
var i__21577__auto___24868 = (0);
while(true){
if((i__21577__auto___24868 < len__21576__auto___24867)){
args24817.push((arguments[i__21577__auto___24868]));

var G__24869 = (i__21577__auto___24868 + (1));
i__21577__auto___24868 = G__24869;
continue;
} else {
}
break;
}

var G__24819 = args24817.length;
switch (G__24819) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24817.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__24690__auto___24871 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto___24871){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto___24871){
return (function (state_24843){
var state_val_24844 = (state_24843[(1)]);
if((state_val_24844 === (7))){
var inst_24839 = (state_24843[(2)]);
var state_24843__$1 = state_24843;
var statearr_24845_24872 = state_24843__$1;
(statearr_24845_24872[(2)] = inst_24839);

(statearr_24845_24872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24844 === (1))){
var state_24843__$1 = state_24843;
var statearr_24846_24873 = state_24843__$1;
(statearr_24846_24873[(2)] = null);

(statearr_24846_24873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24844 === (4))){
var inst_24822 = (state_24843[(7)]);
var inst_24822__$1 = (state_24843[(2)]);
var inst_24823 = (inst_24822__$1 == null);
var state_24843__$1 = (function (){var statearr_24847 = state_24843;
(statearr_24847[(7)] = inst_24822__$1);

return statearr_24847;
})();
if(cljs.core.truth_(inst_24823)){
var statearr_24848_24874 = state_24843__$1;
(statearr_24848_24874[(1)] = (5));

} else {
var statearr_24849_24875 = state_24843__$1;
(statearr_24849_24875[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24844 === (13))){
var state_24843__$1 = state_24843;
var statearr_24850_24876 = state_24843__$1;
(statearr_24850_24876[(2)] = null);

(statearr_24850_24876[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24844 === (6))){
var inst_24822 = (state_24843[(7)]);
var state_24843__$1 = state_24843;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24843__$1,(11),to,inst_24822);
} else {
if((state_val_24844 === (3))){
var inst_24841 = (state_24843[(2)]);
var state_24843__$1 = state_24843;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24843__$1,inst_24841);
} else {
if((state_val_24844 === (12))){
var state_24843__$1 = state_24843;
var statearr_24851_24877 = state_24843__$1;
(statearr_24851_24877[(2)] = null);

(statearr_24851_24877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24844 === (2))){
var state_24843__$1 = state_24843;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24843__$1,(4),from);
} else {
if((state_val_24844 === (11))){
var inst_24832 = (state_24843[(2)]);
var state_24843__$1 = state_24843;
if(cljs.core.truth_(inst_24832)){
var statearr_24852_24878 = state_24843__$1;
(statearr_24852_24878[(1)] = (12));

} else {
var statearr_24853_24879 = state_24843__$1;
(statearr_24853_24879[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24844 === (9))){
var state_24843__$1 = state_24843;
var statearr_24854_24880 = state_24843__$1;
(statearr_24854_24880[(2)] = null);

(statearr_24854_24880[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24844 === (5))){
var state_24843__$1 = state_24843;
if(cljs.core.truth_(close_QMARK_)){
var statearr_24855_24881 = state_24843__$1;
(statearr_24855_24881[(1)] = (8));

} else {
var statearr_24856_24882 = state_24843__$1;
(statearr_24856_24882[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24844 === (14))){
var inst_24837 = (state_24843[(2)]);
var state_24843__$1 = state_24843;
var statearr_24857_24883 = state_24843__$1;
(statearr_24857_24883[(2)] = inst_24837);

(statearr_24857_24883[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24844 === (10))){
var inst_24829 = (state_24843[(2)]);
var state_24843__$1 = state_24843;
var statearr_24858_24884 = state_24843__$1;
(statearr_24858_24884[(2)] = inst_24829);

(statearr_24858_24884[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24844 === (8))){
var inst_24826 = cljs.core.async.close_BANG_.call(null,to);
var state_24843__$1 = state_24843;
var statearr_24859_24885 = state_24843__$1;
(statearr_24859_24885[(2)] = inst_24826);

(statearr_24859_24885[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24690__auto___24871))
;
return ((function (switch__24576__auto__,c__24690__auto___24871){
return (function() {
var cljs$core$async$state_machine__24577__auto__ = null;
var cljs$core$async$state_machine__24577__auto____0 = (function (){
var statearr_24863 = [null,null,null,null,null,null,null,null];
(statearr_24863[(0)] = cljs$core$async$state_machine__24577__auto__);

(statearr_24863[(1)] = (1));

return statearr_24863;
});
var cljs$core$async$state_machine__24577__auto____1 = (function (state_24843){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_24843);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e24864){if((e24864 instanceof Object)){
var ex__24580__auto__ = e24864;
var statearr_24865_24886 = state_24843;
(statearr_24865_24886[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24843);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24864;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24887 = state_24843;
state_24843 = G__24887;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
cljs$core$async$state_machine__24577__auto__ = function(state_24843){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24577__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24577__auto____1.call(this,state_24843);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24577__auto____0;
cljs$core$async$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24577__auto____1;
return cljs$core$async$state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto___24871))
})();
var state__24692__auto__ = (function (){var statearr_24866 = f__24691__auto__.call(null);
(statearr_24866[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto___24871);

return statearr_24866;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto___24871))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__25075){
var vec__25076 = p__25075;
var v = cljs.core.nth.call(null,vec__25076,(0),null);
var p = cljs.core.nth.call(null,vec__25076,(1),null);
var job = vec__25076;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__24690__auto___25262 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto___25262,res,vec__25076,v,p,job,jobs,results){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto___25262,res,vec__25076,v,p,job,jobs,results){
return (function (state_25083){
var state_val_25084 = (state_25083[(1)]);
if((state_val_25084 === (1))){
var state_25083__$1 = state_25083;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25083__$1,(2),res,v);
} else {
if((state_val_25084 === (2))){
var inst_25080 = (state_25083[(2)]);
var inst_25081 = cljs.core.async.close_BANG_.call(null,res);
var state_25083__$1 = (function (){var statearr_25085 = state_25083;
(statearr_25085[(7)] = inst_25080);

return statearr_25085;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25083__$1,inst_25081);
} else {
return null;
}
}
});})(c__24690__auto___25262,res,vec__25076,v,p,job,jobs,results))
;
return ((function (switch__24576__auto__,c__24690__auto___25262,res,vec__25076,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____0 = (function (){
var statearr_25089 = [null,null,null,null,null,null,null,null];
(statearr_25089[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__);

(statearr_25089[(1)] = (1));

return statearr_25089;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____1 = (function (state_25083){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_25083);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e25090){if((e25090 instanceof Object)){
var ex__24580__auto__ = e25090;
var statearr_25091_25263 = state_25083;
(statearr_25091_25263[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25083);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25090;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25264 = state_25083;
state_25083 = G__25264;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__ = function(state_25083){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____1.call(this,state_25083);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto___25262,res,vec__25076,v,p,job,jobs,results))
})();
var state__24692__auto__ = (function (){var statearr_25092 = f__24691__auto__.call(null);
(statearr_25092[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto___25262);

return statearr_25092;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto___25262,res,vec__25076,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__25093){
var vec__25094 = p__25093;
var v = cljs.core.nth.call(null,vec__25094,(0),null);
var p = cljs.core.nth.call(null,vec__25094,(1),null);
var job = vec__25094;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__21376__auto___25265 = n;
var __25266 = (0);
while(true){
if((__25266 < n__21376__auto___25265)){
var G__25097_25267 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__25097_25267) {
case "compute":
var c__24690__auto___25269 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__25266,c__24690__auto___25269,G__25097_25267,n__21376__auto___25265,jobs,results,process,async){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (__25266,c__24690__auto___25269,G__25097_25267,n__21376__auto___25265,jobs,results,process,async){
return (function (state_25110){
var state_val_25111 = (state_25110[(1)]);
if((state_val_25111 === (1))){
var state_25110__$1 = state_25110;
var statearr_25112_25270 = state_25110__$1;
(statearr_25112_25270[(2)] = null);

(statearr_25112_25270[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25111 === (2))){
var state_25110__$1 = state_25110;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25110__$1,(4),jobs);
} else {
if((state_val_25111 === (3))){
var inst_25108 = (state_25110[(2)]);
var state_25110__$1 = state_25110;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25110__$1,inst_25108);
} else {
if((state_val_25111 === (4))){
var inst_25100 = (state_25110[(2)]);
var inst_25101 = process.call(null,inst_25100);
var state_25110__$1 = state_25110;
if(cljs.core.truth_(inst_25101)){
var statearr_25113_25271 = state_25110__$1;
(statearr_25113_25271[(1)] = (5));

} else {
var statearr_25114_25272 = state_25110__$1;
(statearr_25114_25272[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25111 === (5))){
var state_25110__$1 = state_25110;
var statearr_25115_25273 = state_25110__$1;
(statearr_25115_25273[(2)] = null);

(statearr_25115_25273[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25111 === (6))){
var state_25110__$1 = state_25110;
var statearr_25116_25274 = state_25110__$1;
(statearr_25116_25274[(2)] = null);

(statearr_25116_25274[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25111 === (7))){
var inst_25106 = (state_25110[(2)]);
var state_25110__$1 = state_25110;
var statearr_25117_25275 = state_25110__$1;
(statearr_25117_25275[(2)] = inst_25106);

(statearr_25117_25275[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__25266,c__24690__auto___25269,G__25097_25267,n__21376__auto___25265,jobs,results,process,async))
;
return ((function (__25266,switch__24576__auto__,c__24690__auto___25269,G__25097_25267,n__21376__auto___25265,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____0 = (function (){
var statearr_25121 = [null,null,null,null,null,null,null];
(statearr_25121[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__);

(statearr_25121[(1)] = (1));

return statearr_25121;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____1 = (function (state_25110){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_25110);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e25122){if((e25122 instanceof Object)){
var ex__24580__auto__ = e25122;
var statearr_25123_25276 = state_25110;
(statearr_25123_25276[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25110);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25122;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25277 = state_25110;
state_25110 = G__25277;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__ = function(state_25110){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____1.call(this,state_25110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__;
})()
;})(__25266,switch__24576__auto__,c__24690__auto___25269,G__25097_25267,n__21376__auto___25265,jobs,results,process,async))
})();
var state__24692__auto__ = (function (){var statearr_25124 = f__24691__auto__.call(null);
(statearr_25124[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto___25269);

return statearr_25124;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(__25266,c__24690__auto___25269,G__25097_25267,n__21376__auto___25265,jobs,results,process,async))
);


break;
case "async":
var c__24690__auto___25278 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__25266,c__24690__auto___25278,G__25097_25267,n__21376__auto___25265,jobs,results,process,async){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (__25266,c__24690__auto___25278,G__25097_25267,n__21376__auto___25265,jobs,results,process,async){
return (function (state_25137){
var state_val_25138 = (state_25137[(1)]);
if((state_val_25138 === (1))){
var state_25137__$1 = state_25137;
var statearr_25139_25279 = state_25137__$1;
(statearr_25139_25279[(2)] = null);

(statearr_25139_25279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25138 === (2))){
var state_25137__$1 = state_25137;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25137__$1,(4),jobs);
} else {
if((state_val_25138 === (3))){
var inst_25135 = (state_25137[(2)]);
var state_25137__$1 = state_25137;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25137__$1,inst_25135);
} else {
if((state_val_25138 === (4))){
var inst_25127 = (state_25137[(2)]);
var inst_25128 = async.call(null,inst_25127);
var state_25137__$1 = state_25137;
if(cljs.core.truth_(inst_25128)){
var statearr_25140_25280 = state_25137__$1;
(statearr_25140_25280[(1)] = (5));

} else {
var statearr_25141_25281 = state_25137__$1;
(statearr_25141_25281[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25138 === (5))){
var state_25137__$1 = state_25137;
var statearr_25142_25282 = state_25137__$1;
(statearr_25142_25282[(2)] = null);

(statearr_25142_25282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25138 === (6))){
var state_25137__$1 = state_25137;
var statearr_25143_25283 = state_25137__$1;
(statearr_25143_25283[(2)] = null);

(statearr_25143_25283[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25138 === (7))){
var inst_25133 = (state_25137[(2)]);
var state_25137__$1 = state_25137;
var statearr_25144_25284 = state_25137__$1;
(statearr_25144_25284[(2)] = inst_25133);

(statearr_25144_25284[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__25266,c__24690__auto___25278,G__25097_25267,n__21376__auto___25265,jobs,results,process,async))
;
return ((function (__25266,switch__24576__auto__,c__24690__auto___25278,G__25097_25267,n__21376__auto___25265,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____0 = (function (){
var statearr_25148 = [null,null,null,null,null,null,null];
(statearr_25148[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__);

(statearr_25148[(1)] = (1));

return statearr_25148;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____1 = (function (state_25137){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_25137);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e25149){if((e25149 instanceof Object)){
var ex__24580__auto__ = e25149;
var statearr_25150_25285 = state_25137;
(statearr_25150_25285[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25137);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25149;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25286 = state_25137;
state_25137 = G__25286;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__ = function(state_25137){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____1.call(this,state_25137);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__;
})()
;})(__25266,switch__24576__auto__,c__24690__auto___25278,G__25097_25267,n__21376__auto___25265,jobs,results,process,async))
})();
var state__24692__auto__ = (function (){var statearr_25151 = f__24691__auto__.call(null);
(statearr_25151[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto___25278);

return statearr_25151;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(__25266,c__24690__auto___25278,G__25097_25267,n__21376__auto___25265,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__25287 = (__25266 + (1));
__25266 = G__25287;
continue;
} else {
}
break;
}

var c__24690__auto___25288 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto___25288,jobs,results,process,async){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto___25288,jobs,results,process,async){
return (function (state_25173){
var state_val_25174 = (state_25173[(1)]);
if((state_val_25174 === (1))){
var state_25173__$1 = state_25173;
var statearr_25175_25289 = state_25173__$1;
(statearr_25175_25289[(2)] = null);

(statearr_25175_25289[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25174 === (2))){
var state_25173__$1 = state_25173;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25173__$1,(4),from);
} else {
if((state_val_25174 === (3))){
var inst_25171 = (state_25173[(2)]);
var state_25173__$1 = state_25173;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25173__$1,inst_25171);
} else {
if((state_val_25174 === (4))){
var inst_25154 = (state_25173[(7)]);
var inst_25154__$1 = (state_25173[(2)]);
var inst_25155 = (inst_25154__$1 == null);
var state_25173__$1 = (function (){var statearr_25176 = state_25173;
(statearr_25176[(7)] = inst_25154__$1);

return statearr_25176;
})();
if(cljs.core.truth_(inst_25155)){
var statearr_25177_25290 = state_25173__$1;
(statearr_25177_25290[(1)] = (5));

} else {
var statearr_25178_25291 = state_25173__$1;
(statearr_25178_25291[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25174 === (5))){
var inst_25157 = cljs.core.async.close_BANG_.call(null,jobs);
var state_25173__$1 = state_25173;
var statearr_25179_25292 = state_25173__$1;
(statearr_25179_25292[(2)] = inst_25157);

(statearr_25179_25292[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25174 === (6))){
var inst_25159 = (state_25173[(8)]);
var inst_25154 = (state_25173[(7)]);
var inst_25159__$1 = cljs.core.async.chan.call(null,(1));
var inst_25160 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25161 = [inst_25154,inst_25159__$1];
var inst_25162 = (new cljs.core.PersistentVector(null,2,(5),inst_25160,inst_25161,null));
var state_25173__$1 = (function (){var statearr_25180 = state_25173;
(statearr_25180[(8)] = inst_25159__$1);

return statearr_25180;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25173__$1,(8),jobs,inst_25162);
} else {
if((state_val_25174 === (7))){
var inst_25169 = (state_25173[(2)]);
var state_25173__$1 = state_25173;
var statearr_25181_25293 = state_25173__$1;
(statearr_25181_25293[(2)] = inst_25169);

(statearr_25181_25293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25174 === (8))){
var inst_25159 = (state_25173[(8)]);
var inst_25164 = (state_25173[(2)]);
var state_25173__$1 = (function (){var statearr_25182 = state_25173;
(statearr_25182[(9)] = inst_25164);

return statearr_25182;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25173__$1,(9),results,inst_25159);
} else {
if((state_val_25174 === (9))){
var inst_25166 = (state_25173[(2)]);
var state_25173__$1 = (function (){var statearr_25183 = state_25173;
(statearr_25183[(10)] = inst_25166);

return statearr_25183;
})();
var statearr_25184_25294 = state_25173__$1;
(statearr_25184_25294[(2)] = null);

(statearr_25184_25294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__24690__auto___25288,jobs,results,process,async))
;
return ((function (switch__24576__auto__,c__24690__auto___25288,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____0 = (function (){
var statearr_25188 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25188[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__);

(statearr_25188[(1)] = (1));

return statearr_25188;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____1 = (function (state_25173){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_25173);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e25189){if((e25189 instanceof Object)){
var ex__24580__auto__ = e25189;
var statearr_25190_25295 = state_25173;
(statearr_25190_25295[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25173);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25189;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25296 = state_25173;
state_25173 = G__25296;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__ = function(state_25173){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____1.call(this,state_25173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto___25288,jobs,results,process,async))
})();
var state__24692__auto__ = (function (){var statearr_25191 = f__24691__auto__.call(null);
(statearr_25191[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto___25288);

return statearr_25191;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto___25288,jobs,results,process,async))
);


var c__24690__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto__,jobs,results,process,async){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto__,jobs,results,process,async){
return (function (state_25229){
var state_val_25230 = (state_25229[(1)]);
if((state_val_25230 === (7))){
var inst_25225 = (state_25229[(2)]);
var state_25229__$1 = state_25229;
var statearr_25231_25297 = state_25229__$1;
(statearr_25231_25297[(2)] = inst_25225);

(statearr_25231_25297[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25230 === (20))){
var state_25229__$1 = state_25229;
var statearr_25232_25298 = state_25229__$1;
(statearr_25232_25298[(2)] = null);

(statearr_25232_25298[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25230 === (1))){
var state_25229__$1 = state_25229;
var statearr_25233_25299 = state_25229__$1;
(statearr_25233_25299[(2)] = null);

(statearr_25233_25299[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25230 === (4))){
var inst_25194 = (state_25229[(7)]);
var inst_25194__$1 = (state_25229[(2)]);
var inst_25195 = (inst_25194__$1 == null);
var state_25229__$1 = (function (){var statearr_25234 = state_25229;
(statearr_25234[(7)] = inst_25194__$1);

return statearr_25234;
})();
if(cljs.core.truth_(inst_25195)){
var statearr_25235_25300 = state_25229__$1;
(statearr_25235_25300[(1)] = (5));

} else {
var statearr_25236_25301 = state_25229__$1;
(statearr_25236_25301[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25230 === (15))){
var inst_25207 = (state_25229[(8)]);
var state_25229__$1 = state_25229;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25229__$1,(18),to,inst_25207);
} else {
if((state_val_25230 === (21))){
var inst_25220 = (state_25229[(2)]);
var state_25229__$1 = state_25229;
var statearr_25237_25302 = state_25229__$1;
(statearr_25237_25302[(2)] = inst_25220);

(statearr_25237_25302[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25230 === (13))){
var inst_25222 = (state_25229[(2)]);
var state_25229__$1 = (function (){var statearr_25238 = state_25229;
(statearr_25238[(9)] = inst_25222);

return statearr_25238;
})();
var statearr_25239_25303 = state_25229__$1;
(statearr_25239_25303[(2)] = null);

(statearr_25239_25303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25230 === (6))){
var inst_25194 = (state_25229[(7)]);
var state_25229__$1 = state_25229;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25229__$1,(11),inst_25194);
} else {
if((state_val_25230 === (17))){
var inst_25215 = (state_25229[(2)]);
var state_25229__$1 = state_25229;
if(cljs.core.truth_(inst_25215)){
var statearr_25240_25304 = state_25229__$1;
(statearr_25240_25304[(1)] = (19));

} else {
var statearr_25241_25305 = state_25229__$1;
(statearr_25241_25305[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25230 === (3))){
var inst_25227 = (state_25229[(2)]);
var state_25229__$1 = state_25229;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25229__$1,inst_25227);
} else {
if((state_val_25230 === (12))){
var inst_25204 = (state_25229[(10)]);
var state_25229__$1 = state_25229;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25229__$1,(14),inst_25204);
} else {
if((state_val_25230 === (2))){
var state_25229__$1 = state_25229;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25229__$1,(4),results);
} else {
if((state_val_25230 === (19))){
var state_25229__$1 = state_25229;
var statearr_25242_25306 = state_25229__$1;
(statearr_25242_25306[(2)] = null);

(statearr_25242_25306[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25230 === (11))){
var inst_25204 = (state_25229[(2)]);
var state_25229__$1 = (function (){var statearr_25243 = state_25229;
(statearr_25243[(10)] = inst_25204);

return statearr_25243;
})();
var statearr_25244_25307 = state_25229__$1;
(statearr_25244_25307[(2)] = null);

(statearr_25244_25307[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25230 === (9))){
var state_25229__$1 = state_25229;
var statearr_25245_25308 = state_25229__$1;
(statearr_25245_25308[(2)] = null);

(statearr_25245_25308[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25230 === (5))){
var state_25229__$1 = state_25229;
if(cljs.core.truth_(close_QMARK_)){
var statearr_25246_25309 = state_25229__$1;
(statearr_25246_25309[(1)] = (8));

} else {
var statearr_25247_25310 = state_25229__$1;
(statearr_25247_25310[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25230 === (14))){
var inst_25207 = (state_25229[(8)]);
var inst_25209 = (state_25229[(11)]);
var inst_25207__$1 = (state_25229[(2)]);
var inst_25208 = (inst_25207__$1 == null);
var inst_25209__$1 = cljs.core.not.call(null,inst_25208);
var state_25229__$1 = (function (){var statearr_25248 = state_25229;
(statearr_25248[(8)] = inst_25207__$1);

(statearr_25248[(11)] = inst_25209__$1);

return statearr_25248;
})();
if(inst_25209__$1){
var statearr_25249_25311 = state_25229__$1;
(statearr_25249_25311[(1)] = (15));

} else {
var statearr_25250_25312 = state_25229__$1;
(statearr_25250_25312[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25230 === (16))){
var inst_25209 = (state_25229[(11)]);
var state_25229__$1 = state_25229;
var statearr_25251_25313 = state_25229__$1;
(statearr_25251_25313[(2)] = inst_25209);

(statearr_25251_25313[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25230 === (10))){
var inst_25201 = (state_25229[(2)]);
var state_25229__$1 = state_25229;
var statearr_25252_25314 = state_25229__$1;
(statearr_25252_25314[(2)] = inst_25201);

(statearr_25252_25314[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25230 === (18))){
var inst_25212 = (state_25229[(2)]);
var state_25229__$1 = state_25229;
var statearr_25253_25315 = state_25229__$1;
(statearr_25253_25315[(2)] = inst_25212);

(statearr_25253_25315[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25230 === (8))){
var inst_25198 = cljs.core.async.close_BANG_.call(null,to);
var state_25229__$1 = state_25229;
var statearr_25254_25316 = state_25229__$1;
(statearr_25254_25316[(2)] = inst_25198);

(statearr_25254_25316[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24690__auto__,jobs,results,process,async))
;
return ((function (switch__24576__auto__,c__24690__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____0 = (function (){
var statearr_25258 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25258[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__);

(statearr_25258[(1)] = (1));

return statearr_25258;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____1 = (function (state_25229){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_25229);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e25259){if((e25259 instanceof Object)){
var ex__24580__auto__ = e25259;
var statearr_25260_25317 = state_25229;
(statearr_25260_25317[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25229);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25259;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25318 = state_25229;
state_25229 = G__25318;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__ = function(state_25229){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____1.call(this,state_25229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24577__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto__,jobs,results,process,async))
})();
var state__24692__auto__ = (function (){var statearr_25261 = f__24691__auto__.call(null);
(statearr_25261[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto__);

return statearr_25261;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto__,jobs,results,process,async))
);

return c__24690__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args25319 = [];
var len__21576__auto___25322 = arguments.length;
var i__21577__auto___25323 = (0);
while(true){
if((i__21577__auto___25323 < len__21576__auto___25322)){
args25319.push((arguments[i__21577__auto___25323]));

var G__25324 = (i__21577__auto___25323 + (1));
i__21577__auto___25323 = G__25324;
continue;
} else {
}
break;
}

var G__25321 = args25319.length;
switch (G__25321) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25319.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args25326 = [];
var len__21576__auto___25329 = arguments.length;
var i__21577__auto___25330 = (0);
while(true){
if((i__21577__auto___25330 < len__21576__auto___25329)){
args25326.push((arguments[i__21577__auto___25330]));

var G__25331 = (i__21577__auto___25330 + (1));
i__21577__auto___25330 = G__25331;
continue;
} else {
}
break;
}

var G__25328 = args25326.length;
switch (G__25328) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25326.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args25333 = [];
var len__21576__auto___25386 = arguments.length;
var i__21577__auto___25387 = (0);
while(true){
if((i__21577__auto___25387 < len__21576__auto___25386)){
args25333.push((arguments[i__21577__auto___25387]));

var G__25388 = (i__21577__auto___25387 + (1));
i__21577__auto___25387 = G__25388;
continue;
} else {
}
break;
}

var G__25335 = args25333.length;
switch (G__25335) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25333.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__24690__auto___25390 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto___25390,tc,fc){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto___25390,tc,fc){
return (function (state_25361){
var state_val_25362 = (state_25361[(1)]);
if((state_val_25362 === (7))){
var inst_25357 = (state_25361[(2)]);
var state_25361__$1 = state_25361;
var statearr_25363_25391 = state_25361__$1;
(statearr_25363_25391[(2)] = inst_25357);

(statearr_25363_25391[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25362 === (1))){
var state_25361__$1 = state_25361;
var statearr_25364_25392 = state_25361__$1;
(statearr_25364_25392[(2)] = null);

(statearr_25364_25392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25362 === (4))){
var inst_25338 = (state_25361[(7)]);
var inst_25338__$1 = (state_25361[(2)]);
var inst_25339 = (inst_25338__$1 == null);
var state_25361__$1 = (function (){var statearr_25365 = state_25361;
(statearr_25365[(7)] = inst_25338__$1);

return statearr_25365;
})();
if(cljs.core.truth_(inst_25339)){
var statearr_25366_25393 = state_25361__$1;
(statearr_25366_25393[(1)] = (5));

} else {
var statearr_25367_25394 = state_25361__$1;
(statearr_25367_25394[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25362 === (13))){
var state_25361__$1 = state_25361;
var statearr_25368_25395 = state_25361__$1;
(statearr_25368_25395[(2)] = null);

(statearr_25368_25395[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25362 === (6))){
var inst_25338 = (state_25361[(7)]);
var inst_25344 = p.call(null,inst_25338);
var state_25361__$1 = state_25361;
if(cljs.core.truth_(inst_25344)){
var statearr_25369_25396 = state_25361__$1;
(statearr_25369_25396[(1)] = (9));

} else {
var statearr_25370_25397 = state_25361__$1;
(statearr_25370_25397[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25362 === (3))){
var inst_25359 = (state_25361[(2)]);
var state_25361__$1 = state_25361;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25361__$1,inst_25359);
} else {
if((state_val_25362 === (12))){
var state_25361__$1 = state_25361;
var statearr_25371_25398 = state_25361__$1;
(statearr_25371_25398[(2)] = null);

(statearr_25371_25398[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25362 === (2))){
var state_25361__$1 = state_25361;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25361__$1,(4),ch);
} else {
if((state_val_25362 === (11))){
var inst_25338 = (state_25361[(7)]);
var inst_25348 = (state_25361[(2)]);
var state_25361__$1 = state_25361;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25361__$1,(8),inst_25348,inst_25338);
} else {
if((state_val_25362 === (9))){
var state_25361__$1 = state_25361;
var statearr_25372_25399 = state_25361__$1;
(statearr_25372_25399[(2)] = tc);

(statearr_25372_25399[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25362 === (5))){
var inst_25341 = cljs.core.async.close_BANG_.call(null,tc);
var inst_25342 = cljs.core.async.close_BANG_.call(null,fc);
var state_25361__$1 = (function (){var statearr_25373 = state_25361;
(statearr_25373[(8)] = inst_25341);

return statearr_25373;
})();
var statearr_25374_25400 = state_25361__$1;
(statearr_25374_25400[(2)] = inst_25342);

(statearr_25374_25400[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25362 === (14))){
var inst_25355 = (state_25361[(2)]);
var state_25361__$1 = state_25361;
var statearr_25375_25401 = state_25361__$1;
(statearr_25375_25401[(2)] = inst_25355);

(statearr_25375_25401[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25362 === (10))){
var state_25361__$1 = state_25361;
var statearr_25376_25402 = state_25361__$1;
(statearr_25376_25402[(2)] = fc);

(statearr_25376_25402[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25362 === (8))){
var inst_25350 = (state_25361[(2)]);
var state_25361__$1 = state_25361;
if(cljs.core.truth_(inst_25350)){
var statearr_25377_25403 = state_25361__$1;
(statearr_25377_25403[(1)] = (12));

} else {
var statearr_25378_25404 = state_25361__$1;
(statearr_25378_25404[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24690__auto___25390,tc,fc))
;
return ((function (switch__24576__auto__,c__24690__auto___25390,tc,fc){
return (function() {
var cljs$core$async$state_machine__24577__auto__ = null;
var cljs$core$async$state_machine__24577__auto____0 = (function (){
var statearr_25382 = [null,null,null,null,null,null,null,null,null];
(statearr_25382[(0)] = cljs$core$async$state_machine__24577__auto__);

(statearr_25382[(1)] = (1));

return statearr_25382;
});
var cljs$core$async$state_machine__24577__auto____1 = (function (state_25361){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_25361);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e25383){if((e25383 instanceof Object)){
var ex__24580__auto__ = e25383;
var statearr_25384_25405 = state_25361;
(statearr_25384_25405[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25361);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25383;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25406 = state_25361;
state_25361 = G__25406;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
cljs$core$async$state_machine__24577__auto__ = function(state_25361){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24577__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24577__auto____1.call(this,state_25361);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24577__auto____0;
cljs$core$async$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24577__auto____1;
return cljs$core$async$state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto___25390,tc,fc))
})();
var state__24692__auto__ = (function (){var statearr_25385 = f__24691__auto__.call(null);
(statearr_25385[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto___25390);

return statearr_25385;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto___25390,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__24690__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto__){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto__){
return (function (state_25470){
var state_val_25471 = (state_25470[(1)]);
if((state_val_25471 === (7))){
var inst_25466 = (state_25470[(2)]);
var state_25470__$1 = state_25470;
var statearr_25472_25493 = state_25470__$1;
(statearr_25472_25493[(2)] = inst_25466);

(statearr_25472_25493[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (1))){
var inst_25450 = init;
var state_25470__$1 = (function (){var statearr_25473 = state_25470;
(statearr_25473[(7)] = inst_25450);

return statearr_25473;
})();
var statearr_25474_25494 = state_25470__$1;
(statearr_25474_25494[(2)] = null);

(statearr_25474_25494[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (4))){
var inst_25453 = (state_25470[(8)]);
var inst_25453__$1 = (state_25470[(2)]);
var inst_25454 = (inst_25453__$1 == null);
var state_25470__$1 = (function (){var statearr_25475 = state_25470;
(statearr_25475[(8)] = inst_25453__$1);

return statearr_25475;
})();
if(cljs.core.truth_(inst_25454)){
var statearr_25476_25495 = state_25470__$1;
(statearr_25476_25495[(1)] = (5));

} else {
var statearr_25477_25496 = state_25470__$1;
(statearr_25477_25496[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (6))){
var inst_25450 = (state_25470[(7)]);
var inst_25453 = (state_25470[(8)]);
var inst_25457 = (state_25470[(9)]);
var inst_25457__$1 = f.call(null,inst_25450,inst_25453);
var inst_25458 = cljs.core.reduced_QMARK_.call(null,inst_25457__$1);
var state_25470__$1 = (function (){var statearr_25478 = state_25470;
(statearr_25478[(9)] = inst_25457__$1);

return statearr_25478;
})();
if(inst_25458){
var statearr_25479_25497 = state_25470__$1;
(statearr_25479_25497[(1)] = (8));

} else {
var statearr_25480_25498 = state_25470__$1;
(statearr_25480_25498[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (3))){
var inst_25468 = (state_25470[(2)]);
var state_25470__$1 = state_25470;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25470__$1,inst_25468);
} else {
if((state_val_25471 === (2))){
var state_25470__$1 = state_25470;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25470__$1,(4),ch);
} else {
if((state_val_25471 === (9))){
var inst_25457 = (state_25470[(9)]);
var inst_25450 = inst_25457;
var state_25470__$1 = (function (){var statearr_25481 = state_25470;
(statearr_25481[(7)] = inst_25450);

return statearr_25481;
})();
var statearr_25482_25499 = state_25470__$1;
(statearr_25482_25499[(2)] = null);

(statearr_25482_25499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (5))){
var inst_25450 = (state_25470[(7)]);
var state_25470__$1 = state_25470;
var statearr_25483_25500 = state_25470__$1;
(statearr_25483_25500[(2)] = inst_25450);

(statearr_25483_25500[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (10))){
var inst_25464 = (state_25470[(2)]);
var state_25470__$1 = state_25470;
var statearr_25484_25501 = state_25470__$1;
(statearr_25484_25501[(2)] = inst_25464);

(statearr_25484_25501[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25471 === (8))){
var inst_25457 = (state_25470[(9)]);
var inst_25460 = cljs.core.deref.call(null,inst_25457);
var state_25470__$1 = state_25470;
var statearr_25485_25502 = state_25470__$1;
(statearr_25485_25502[(2)] = inst_25460);

(statearr_25485_25502[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__24690__auto__))
;
return ((function (switch__24576__auto__,c__24690__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__24577__auto__ = null;
var cljs$core$async$reduce_$_state_machine__24577__auto____0 = (function (){
var statearr_25489 = [null,null,null,null,null,null,null,null,null,null];
(statearr_25489[(0)] = cljs$core$async$reduce_$_state_machine__24577__auto__);

(statearr_25489[(1)] = (1));

return statearr_25489;
});
var cljs$core$async$reduce_$_state_machine__24577__auto____1 = (function (state_25470){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_25470);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e25490){if((e25490 instanceof Object)){
var ex__24580__auto__ = e25490;
var statearr_25491_25503 = state_25470;
(statearr_25491_25503[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25470);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25490;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25504 = state_25470;
state_25470 = G__25504;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__24577__auto__ = function(state_25470){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__24577__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__24577__auto____1.call(this,state_25470);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__24577__auto____0;
cljs$core$async$reduce_$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__24577__auto____1;
return cljs$core$async$reduce_$_state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto__))
})();
var state__24692__auto__ = (function (){var statearr_25492 = f__24691__auto__.call(null);
(statearr_25492[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto__);

return statearr_25492;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto__))
);

return c__24690__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args25505 = [];
var len__21576__auto___25557 = arguments.length;
var i__21577__auto___25558 = (0);
while(true){
if((i__21577__auto___25558 < len__21576__auto___25557)){
args25505.push((arguments[i__21577__auto___25558]));

var G__25559 = (i__21577__auto___25558 + (1));
i__21577__auto___25558 = G__25559;
continue;
} else {
}
break;
}

var G__25507 = args25505.length;
switch (G__25507) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25505.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__24690__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto__){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto__){
return (function (state_25532){
var state_val_25533 = (state_25532[(1)]);
if((state_val_25533 === (7))){
var inst_25514 = (state_25532[(2)]);
var state_25532__$1 = state_25532;
var statearr_25534_25561 = state_25532__$1;
(statearr_25534_25561[(2)] = inst_25514);

(statearr_25534_25561[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25533 === (1))){
var inst_25508 = cljs.core.seq.call(null,coll);
var inst_25509 = inst_25508;
var state_25532__$1 = (function (){var statearr_25535 = state_25532;
(statearr_25535[(7)] = inst_25509);

return statearr_25535;
})();
var statearr_25536_25562 = state_25532__$1;
(statearr_25536_25562[(2)] = null);

(statearr_25536_25562[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25533 === (4))){
var inst_25509 = (state_25532[(7)]);
var inst_25512 = cljs.core.first.call(null,inst_25509);
var state_25532__$1 = state_25532;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25532__$1,(7),ch,inst_25512);
} else {
if((state_val_25533 === (13))){
var inst_25526 = (state_25532[(2)]);
var state_25532__$1 = state_25532;
var statearr_25537_25563 = state_25532__$1;
(statearr_25537_25563[(2)] = inst_25526);

(statearr_25537_25563[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25533 === (6))){
var inst_25517 = (state_25532[(2)]);
var state_25532__$1 = state_25532;
if(cljs.core.truth_(inst_25517)){
var statearr_25538_25564 = state_25532__$1;
(statearr_25538_25564[(1)] = (8));

} else {
var statearr_25539_25565 = state_25532__$1;
(statearr_25539_25565[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25533 === (3))){
var inst_25530 = (state_25532[(2)]);
var state_25532__$1 = state_25532;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25532__$1,inst_25530);
} else {
if((state_val_25533 === (12))){
var state_25532__$1 = state_25532;
var statearr_25540_25566 = state_25532__$1;
(statearr_25540_25566[(2)] = null);

(statearr_25540_25566[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25533 === (2))){
var inst_25509 = (state_25532[(7)]);
var state_25532__$1 = state_25532;
if(cljs.core.truth_(inst_25509)){
var statearr_25541_25567 = state_25532__$1;
(statearr_25541_25567[(1)] = (4));

} else {
var statearr_25542_25568 = state_25532__$1;
(statearr_25542_25568[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25533 === (11))){
var inst_25523 = cljs.core.async.close_BANG_.call(null,ch);
var state_25532__$1 = state_25532;
var statearr_25543_25569 = state_25532__$1;
(statearr_25543_25569[(2)] = inst_25523);

(statearr_25543_25569[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25533 === (9))){
var state_25532__$1 = state_25532;
if(cljs.core.truth_(close_QMARK_)){
var statearr_25544_25570 = state_25532__$1;
(statearr_25544_25570[(1)] = (11));

} else {
var statearr_25545_25571 = state_25532__$1;
(statearr_25545_25571[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25533 === (5))){
var inst_25509 = (state_25532[(7)]);
var state_25532__$1 = state_25532;
var statearr_25546_25572 = state_25532__$1;
(statearr_25546_25572[(2)] = inst_25509);

(statearr_25546_25572[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25533 === (10))){
var inst_25528 = (state_25532[(2)]);
var state_25532__$1 = state_25532;
var statearr_25547_25573 = state_25532__$1;
(statearr_25547_25573[(2)] = inst_25528);

(statearr_25547_25573[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25533 === (8))){
var inst_25509 = (state_25532[(7)]);
var inst_25519 = cljs.core.next.call(null,inst_25509);
var inst_25509__$1 = inst_25519;
var state_25532__$1 = (function (){var statearr_25548 = state_25532;
(statearr_25548[(7)] = inst_25509__$1);

return statearr_25548;
})();
var statearr_25549_25574 = state_25532__$1;
(statearr_25549_25574[(2)] = null);

(statearr_25549_25574[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24690__auto__))
;
return ((function (switch__24576__auto__,c__24690__auto__){
return (function() {
var cljs$core$async$state_machine__24577__auto__ = null;
var cljs$core$async$state_machine__24577__auto____0 = (function (){
var statearr_25553 = [null,null,null,null,null,null,null,null];
(statearr_25553[(0)] = cljs$core$async$state_machine__24577__auto__);

(statearr_25553[(1)] = (1));

return statearr_25553;
});
var cljs$core$async$state_machine__24577__auto____1 = (function (state_25532){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_25532);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e25554){if((e25554 instanceof Object)){
var ex__24580__auto__ = e25554;
var statearr_25555_25575 = state_25532;
(statearr_25555_25575[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25532);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25554;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25576 = state_25532;
state_25532 = G__25576;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
cljs$core$async$state_machine__24577__auto__ = function(state_25532){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24577__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24577__auto____1.call(this,state_25532);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24577__auto____0;
cljs$core$async$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24577__auto____1;
return cljs$core$async$state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto__))
})();
var state__24692__auto__ = (function (){var statearr_25556 = f__24691__auto__.call(null);
(statearr_25556[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto__);

return statearr_25556;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto__))
);

return c__24690__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__21073__auto__ = (((_ == null))?null:_);
var m__21074__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__21073__auto__)]);
if(!((m__21074__auto__ == null))){
return m__21074__auto__.call(null,_);
} else {
var m__21074__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__21074__auto____$1 == null))){
return m__21074__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__21073__auto__ = (((m == null))?null:m);
var m__21074__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__21073__auto__)]);
if(!((m__21074__auto__ == null))){
return m__21074__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__21074__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__21074__auto____$1 == null))){
return m__21074__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__21073__auto__ = (((m == null))?null:m);
var m__21074__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__21073__auto__)]);
if(!((m__21074__auto__ == null))){
return m__21074__auto__.call(null,m,ch);
} else {
var m__21074__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__21074__auto____$1 == null))){
return m__21074__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__21073__auto__ = (((m == null))?null:m);
var m__21074__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__21073__auto__)]);
if(!((m__21074__auto__ == null))){
return m__21074__auto__.call(null,m);
} else {
var m__21074__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__21074__auto____$1 == null))){
return m__21074__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async25802 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25802 = (function (ch,cs,meta25803){
this.ch = ch;
this.cs = cs;
this.meta25803 = meta25803;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async25802.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_25804,meta25803__$1){
var self__ = this;
var _25804__$1 = this;
return (new cljs.core.async.t_cljs$core$async25802(self__.ch,self__.cs,meta25803__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async25802.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_25804){
var self__ = this;
var _25804__$1 = this;
return self__.meta25803;
});})(cs))
;

cljs.core.async.t_cljs$core$async25802.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25802.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async25802.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25802.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async25802.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async25802.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async25802.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta25803","meta25803",14194874,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async25802.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25802.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25802";

cljs.core.async.t_cljs$core$async25802.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__21012__auto__,writer__21013__auto__,opt__21014__auto__){
return cljs.core._write.call(null,writer__21013__auto__,"cljs.core.async/t_cljs$core$async25802");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async25802 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async25802(ch__$1,cs__$1,meta25803){
return (new cljs.core.async.t_cljs$core$async25802(ch__$1,cs__$1,meta25803));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async25802(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__24690__auto___26027 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto___26027,cs,m,dchan,dctr,done){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto___26027,cs,m,dchan,dctr,done){
return (function (state_25939){
var state_val_25940 = (state_25939[(1)]);
if((state_val_25940 === (7))){
var inst_25935 = (state_25939[(2)]);
var state_25939__$1 = state_25939;
var statearr_25941_26028 = state_25939__$1;
(statearr_25941_26028[(2)] = inst_25935);

(statearr_25941_26028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (20))){
var inst_25838 = (state_25939[(7)]);
var inst_25850 = cljs.core.first.call(null,inst_25838);
var inst_25851 = cljs.core.nth.call(null,inst_25850,(0),null);
var inst_25852 = cljs.core.nth.call(null,inst_25850,(1),null);
var state_25939__$1 = (function (){var statearr_25942 = state_25939;
(statearr_25942[(8)] = inst_25851);

return statearr_25942;
})();
if(cljs.core.truth_(inst_25852)){
var statearr_25943_26029 = state_25939__$1;
(statearr_25943_26029[(1)] = (22));

} else {
var statearr_25944_26030 = state_25939__$1;
(statearr_25944_26030[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (27))){
var inst_25887 = (state_25939[(9)]);
var inst_25880 = (state_25939[(10)]);
var inst_25807 = (state_25939[(11)]);
var inst_25882 = (state_25939[(12)]);
var inst_25887__$1 = cljs.core._nth.call(null,inst_25880,inst_25882);
var inst_25888 = cljs.core.async.put_BANG_.call(null,inst_25887__$1,inst_25807,done);
var state_25939__$1 = (function (){var statearr_25945 = state_25939;
(statearr_25945[(9)] = inst_25887__$1);

return statearr_25945;
})();
if(cljs.core.truth_(inst_25888)){
var statearr_25946_26031 = state_25939__$1;
(statearr_25946_26031[(1)] = (30));

} else {
var statearr_25947_26032 = state_25939__$1;
(statearr_25947_26032[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (1))){
var state_25939__$1 = state_25939;
var statearr_25948_26033 = state_25939__$1;
(statearr_25948_26033[(2)] = null);

(statearr_25948_26033[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (24))){
var inst_25838 = (state_25939[(7)]);
var inst_25857 = (state_25939[(2)]);
var inst_25858 = cljs.core.next.call(null,inst_25838);
var inst_25816 = inst_25858;
var inst_25817 = null;
var inst_25818 = (0);
var inst_25819 = (0);
var state_25939__$1 = (function (){var statearr_25949 = state_25939;
(statearr_25949[(13)] = inst_25819);

(statearr_25949[(14)] = inst_25857);

(statearr_25949[(15)] = inst_25818);

(statearr_25949[(16)] = inst_25817);

(statearr_25949[(17)] = inst_25816);

return statearr_25949;
})();
var statearr_25950_26034 = state_25939__$1;
(statearr_25950_26034[(2)] = null);

(statearr_25950_26034[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (39))){
var state_25939__$1 = state_25939;
var statearr_25954_26035 = state_25939__$1;
(statearr_25954_26035[(2)] = null);

(statearr_25954_26035[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (4))){
var inst_25807 = (state_25939[(11)]);
var inst_25807__$1 = (state_25939[(2)]);
var inst_25808 = (inst_25807__$1 == null);
var state_25939__$1 = (function (){var statearr_25955 = state_25939;
(statearr_25955[(11)] = inst_25807__$1);

return statearr_25955;
})();
if(cljs.core.truth_(inst_25808)){
var statearr_25956_26036 = state_25939__$1;
(statearr_25956_26036[(1)] = (5));

} else {
var statearr_25957_26037 = state_25939__$1;
(statearr_25957_26037[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (15))){
var inst_25819 = (state_25939[(13)]);
var inst_25818 = (state_25939[(15)]);
var inst_25817 = (state_25939[(16)]);
var inst_25816 = (state_25939[(17)]);
var inst_25834 = (state_25939[(2)]);
var inst_25835 = (inst_25819 + (1));
var tmp25951 = inst_25818;
var tmp25952 = inst_25817;
var tmp25953 = inst_25816;
var inst_25816__$1 = tmp25953;
var inst_25817__$1 = tmp25952;
var inst_25818__$1 = tmp25951;
var inst_25819__$1 = inst_25835;
var state_25939__$1 = (function (){var statearr_25958 = state_25939;
(statearr_25958[(13)] = inst_25819__$1);

(statearr_25958[(15)] = inst_25818__$1);

(statearr_25958[(18)] = inst_25834);

(statearr_25958[(16)] = inst_25817__$1);

(statearr_25958[(17)] = inst_25816__$1);

return statearr_25958;
})();
var statearr_25959_26038 = state_25939__$1;
(statearr_25959_26038[(2)] = null);

(statearr_25959_26038[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (21))){
var inst_25861 = (state_25939[(2)]);
var state_25939__$1 = state_25939;
var statearr_25963_26039 = state_25939__$1;
(statearr_25963_26039[(2)] = inst_25861);

(statearr_25963_26039[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (31))){
var inst_25887 = (state_25939[(9)]);
var inst_25891 = done.call(null,null);
var inst_25892 = cljs.core.async.untap_STAR_.call(null,m,inst_25887);
var state_25939__$1 = (function (){var statearr_25964 = state_25939;
(statearr_25964[(19)] = inst_25891);

return statearr_25964;
})();
var statearr_25965_26040 = state_25939__$1;
(statearr_25965_26040[(2)] = inst_25892);

(statearr_25965_26040[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (32))){
var inst_25880 = (state_25939[(10)]);
var inst_25881 = (state_25939[(20)]);
var inst_25882 = (state_25939[(12)]);
var inst_25879 = (state_25939[(21)]);
var inst_25894 = (state_25939[(2)]);
var inst_25895 = (inst_25882 + (1));
var tmp25960 = inst_25880;
var tmp25961 = inst_25881;
var tmp25962 = inst_25879;
var inst_25879__$1 = tmp25962;
var inst_25880__$1 = tmp25960;
var inst_25881__$1 = tmp25961;
var inst_25882__$1 = inst_25895;
var state_25939__$1 = (function (){var statearr_25966 = state_25939;
(statearr_25966[(10)] = inst_25880__$1);

(statearr_25966[(20)] = inst_25881__$1);

(statearr_25966[(22)] = inst_25894);

(statearr_25966[(12)] = inst_25882__$1);

(statearr_25966[(21)] = inst_25879__$1);

return statearr_25966;
})();
var statearr_25967_26041 = state_25939__$1;
(statearr_25967_26041[(2)] = null);

(statearr_25967_26041[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (40))){
var inst_25907 = (state_25939[(23)]);
var inst_25911 = done.call(null,null);
var inst_25912 = cljs.core.async.untap_STAR_.call(null,m,inst_25907);
var state_25939__$1 = (function (){var statearr_25968 = state_25939;
(statearr_25968[(24)] = inst_25911);

return statearr_25968;
})();
var statearr_25969_26042 = state_25939__$1;
(statearr_25969_26042[(2)] = inst_25912);

(statearr_25969_26042[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (33))){
var inst_25898 = (state_25939[(25)]);
var inst_25900 = cljs.core.chunked_seq_QMARK_.call(null,inst_25898);
var state_25939__$1 = state_25939;
if(inst_25900){
var statearr_25970_26043 = state_25939__$1;
(statearr_25970_26043[(1)] = (36));

} else {
var statearr_25971_26044 = state_25939__$1;
(statearr_25971_26044[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (13))){
var inst_25828 = (state_25939[(26)]);
var inst_25831 = cljs.core.async.close_BANG_.call(null,inst_25828);
var state_25939__$1 = state_25939;
var statearr_25972_26045 = state_25939__$1;
(statearr_25972_26045[(2)] = inst_25831);

(statearr_25972_26045[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (22))){
var inst_25851 = (state_25939[(8)]);
var inst_25854 = cljs.core.async.close_BANG_.call(null,inst_25851);
var state_25939__$1 = state_25939;
var statearr_25973_26046 = state_25939__$1;
(statearr_25973_26046[(2)] = inst_25854);

(statearr_25973_26046[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (36))){
var inst_25898 = (state_25939[(25)]);
var inst_25902 = cljs.core.chunk_first.call(null,inst_25898);
var inst_25903 = cljs.core.chunk_rest.call(null,inst_25898);
var inst_25904 = cljs.core.count.call(null,inst_25902);
var inst_25879 = inst_25903;
var inst_25880 = inst_25902;
var inst_25881 = inst_25904;
var inst_25882 = (0);
var state_25939__$1 = (function (){var statearr_25974 = state_25939;
(statearr_25974[(10)] = inst_25880);

(statearr_25974[(20)] = inst_25881);

(statearr_25974[(12)] = inst_25882);

(statearr_25974[(21)] = inst_25879);

return statearr_25974;
})();
var statearr_25975_26047 = state_25939__$1;
(statearr_25975_26047[(2)] = null);

(statearr_25975_26047[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (41))){
var inst_25898 = (state_25939[(25)]);
var inst_25914 = (state_25939[(2)]);
var inst_25915 = cljs.core.next.call(null,inst_25898);
var inst_25879 = inst_25915;
var inst_25880 = null;
var inst_25881 = (0);
var inst_25882 = (0);
var state_25939__$1 = (function (){var statearr_25976 = state_25939;
(statearr_25976[(10)] = inst_25880);

(statearr_25976[(20)] = inst_25881);

(statearr_25976[(27)] = inst_25914);

(statearr_25976[(12)] = inst_25882);

(statearr_25976[(21)] = inst_25879);

return statearr_25976;
})();
var statearr_25977_26048 = state_25939__$1;
(statearr_25977_26048[(2)] = null);

(statearr_25977_26048[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (43))){
var state_25939__$1 = state_25939;
var statearr_25978_26049 = state_25939__$1;
(statearr_25978_26049[(2)] = null);

(statearr_25978_26049[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (29))){
var inst_25923 = (state_25939[(2)]);
var state_25939__$1 = state_25939;
var statearr_25979_26050 = state_25939__$1;
(statearr_25979_26050[(2)] = inst_25923);

(statearr_25979_26050[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (44))){
var inst_25932 = (state_25939[(2)]);
var state_25939__$1 = (function (){var statearr_25980 = state_25939;
(statearr_25980[(28)] = inst_25932);

return statearr_25980;
})();
var statearr_25981_26051 = state_25939__$1;
(statearr_25981_26051[(2)] = null);

(statearr_25981_26051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (6))){
var inst_25871 = (state_25939[(29)]);
var inst_25870 = cljs.core.deref.call(null,cs);
var inst_25871__$1 = cljs.core.keys.call(null,inst_25870);
var inst_25872 = cljs.core.count.call(null,inst_25871__$1);
var inst_25873 = cljs.core.reset_BANG_.call(null,dctr,inst_25872);
var inst_25878 = cljs.core.seq.call(null,inst_25871__$1);
var inst_25879 = inst_25878;
var inst_25880 = null;
var inst_25881 = (0);
var inst_25882 = (0);
var state_25939__$1 = (function (){var statearr_25982 = state_25939;
(statearr_25982[(29)] = inst_25871__$1);

(statearr_25982[(10)] = inst_25880);

(statearr_25982[(20)] = inst_25881);

(statearr_25982[(30)] = inst_25873);

(statearr_25982[(12)] = inst_25882);

(statearr_25982[(21)] = inst_25879);

return statearr_25982;
})();
var statearr_25983_26052 = state_25939__$1;
(statearr_25983_26052[(2)] = null);

(statearr_25983_26052[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (28))){
var inst_25898 = (state_25939[(25)]);
var inst_25879 = (state_25939[(21)]);
var inst_25898__$1 = cljs.core.seq.call(null,inst_25879);
var state_25939__$1 = (function (){var statearr_25984 = state_25939;
(statearr_25984[(25)] = inst_25898__$1);

return statearr_25984;
})();
if(inst_25898__$1){
var statearr_25985_26053 = state_25939__$1;
(statearr_25985_26053[(1)] = (33));

} else {
var statearr_25986_26054 = state_25939__$1;
(statearr_25986_26054[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (25))){
var inst_25881 = (state_25939[(20)]);
var inst_25882 = (state_25939[(12)]);
var inst_25884 = (inst_25882 < inst_25881);
var inst_25885 = inst_25884;
var state_25939__$1 = state_25939;
if(cljs.core.truth_(inst_25885)){
var statearr_25987_26055 = state_25939__$1;
(statearr_25987_26055[(1)] = (27));

} else {
var statearr_25988_26056 = state_25939__$1;
(statearr_25988_26056[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (34))){
var state_25939__$1 = state_25939;
var statearr_25989_26057 = state_25939__$1;
(statearr_25989_26057[(2)] = null);

(statearr_25989_26057[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (17))){
var state_25939__$1 = state_25939;
var statearr_25990_26058 = state_25939__$1;
(statearr_25990_26058[(2)] = null);

(statearr_25990_26058[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (3))){
var inst_25937 = (state_25939[(2)]);
var state_25939__$1 = state_25939;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25939__$1,inst_25937);
} else {
if((state_val_25940 === (12))){
var inst_25866 = (state_25939[(2)]);
var state_25939__$1 = state_25939;
var statearr_25991_26059 = state_25939__$1;
(statearr_25991_26059[(2)] = inst_25866);

(statearr_25991_26059[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (2))){
var state_25939__$1 = state_25939;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25939__$1,(4),ch);
} else {
if((state_val_25940 === (23))){
var state_25939__$1 = state_25939;
var statearr_25992_26060 = state_25939__$1;
(statearr_25992_26060[(2)] = null);

(statearr_25992_26060[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (35))){
var inst_25921 = (state_25939[(2)]);
var state_25939__$1 = state_25939;
var statearr_25993_26061 = state_25939__$1;
(statearr_25993_26061[(2)] = inst_25921);

(statearr_25993_26061[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (19))){
var inst_25838 = (state_25939[(7)]);
var inst_25842 = cljs.core.chunk_first.call(null,inst_25838);
var inst_25843 = cljs.core.chunk_rest.call(null,inst_25838);
var inst_25844 = cljs.core.count.call(null,inst_25842);
var inst_25816 = inst_25843;
var inst_25817 = inst_25842;
var inst_25818 = inst_25844;
var inst_25819 = (0);
var state_25939__$1 = (function (){var statearr_25994 = state_25939;
(statearr_25994[(13)] = inst_25819);

(statearr_25994[(15)] = inst_25818);

(statearr_25994[(16)] = inst_25817);

(statearr_25994[(17)] = inst_25816);

return statearr_25994;
})();
var statearr_25995_26062 = state_25939__$1;
(statearr_25995_26062[(2)] = null);

(statearr_25995_26062[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (11))){
var inst_25838 = (state_25939[(7)]);
var inst_25816 = (state_25939[(17)]);
var inst_25838__$1 = cljs.core.seq.call(null,inst_25816);
var state_25939__$1 = (function (){var statearr_25996 = state_25939;
(statearr_25996[(7)] = inst_25838__$1);

return statearr_25996;
})();
if(inst_25838__$1){
var statearr_25997_26063 = state_25939__$1;
(statearr_25997_26063[(1)] = (16));

} else {
var statearr_25998_26064 = state_25939__$1;
(statearr_25998_26064[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (9))){
var inst_25868 = (state_25939[(2)]);
var state_25939__$1 = state_25939;
var statearr_25999_26065 = state_25939__$1;
(statearr_25999_26065[(2)] = inst_25868);

(statearr_25999_26065[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (5))){
var inst_25814 = cljs.core.deref.call(null,cs);
var inst_25815 = cljs.core.seq.call(null,inst_25814);
var inst_25816 = inst_25815;
var inst_25817 = null;
var inst_25818 = (0);
var inst_25819 = (0);
var state_25939__$1 = (function (){var statearr_26000 = state_25939;
(statearr_26000[(13)] = inst_25819);

(statearr_26000[(15)] = inst_25818);

(statearr_26000[(16)] = inst_25817);

(statearr_26000[(17)] = inst_25816);

return statearr_26000;
})();
var statearr_26001_26066 = state_25939__$1;
(statearr_26001_26066[(2)] = null);

(statearr_26001_26066[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (14))){
var state_25939__$1 = state_25939;
var statearr_26002_26067 = state_25939__$1;
(statearr_26002_26067[(2)] = null);

(statearr_26002_26067[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (45))){
var inst_25929 = (state_25939[(2)]);
var state_25939__$1 = state_25939;
var statearr_26003_26068 = state_25939__$1;
(statearr_26003_26068[(2)] = inst_25929);

(statearr_26003_26068[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (26))){
var inst_25871 = (state_25939[(29)]);
var inst_25925 = (state_25939[(2)]);
var inst_25926 = cljs.core.seq.call(null,inst_25871);
var state_25939__$1 = (function (){var statearr_26004 = state_25939;
(statearr_26004[(31)] = inst_25925);

return statearr_26004;
})();
if(inst_25926){
var statearr_26005_26069 = state_25939__$1;
(statearr_26005_26069[(1)] = (42));

} else {
var statearr_26006_26070 = state_25939__$1;
(statearr_26006_26070[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (16))){
var inst_25838 = (state_25939[(7)]);
var inst_25840 = cljs.core.chunked_seq_QMARK_.call(null,inst_25838);
var state_25939__$1 = state_25939;
if(inst_25840){
var statearr_26007_26071 = state_25939__$1;
(statearr_26007_26071[(1)] = (19));

} else {
var statearr_26008_26072 = state_25939__$1;
(statearr_26008_26072[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (38))){
var inst_25918 = (state_25939[(2)]);
var state_25939__$1 = state_25939;
var statearr_26009_26073 = state_25939__$1;
(statearr_26009_26073[(2)] = inst_25918);

(statearr_26009_26073[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (30))){
var state_25939__$1 = state_25939;
var statearr_26010_26074 = state_25939__$1;
(statearr_26010_26074[(2)] = null);

(statearr_26010_26074[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (10))){
var inst_25819 = (state_25939[(13)]);
var inst_25817 = (state_25939[(16)]);
var inst_25827 = cljs.core._nth.call(null,inst_25817,inst_25819);
var inst_25828 = cljs.core.nth.call(null,inst_25827,(0),null);
var inst_25829 = cljs.core.nth.call(null,inst_25827,(1),null);
var state_25939__$1 = (function (){var statearr_26011 = state_25939;
(statearr_26011[(26)] = inst_25828);

return statearr_26011;
})();
if(cljs.core.truth_(inst_25829)){
var statearr_26012_26075 = state_25939__$1;
(statearr_26012_26075[(1)] = (13));

} else {
var statearr_26013_26076 = state_25939__$1;
(statearr_26013_26076[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (18))){
var inst_25864 = (state_25939[(2)]);
var state_25939__$1 = state_25939;
var statearr_26014_26077 = state_25939__$1;
(statearr_26014_26077[(2)] = inst_25864);

(statearr_26014_26077[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (42))){
var state_25939__$1 = state_25939;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25939__$1,(45),dchan);
} else {
if((state_val_25940 === (37))){
var inst_25898 = (state_25939[(25)]);
var inst_25807 = (state_25939[(11)]);
var inst_25907 = (state_25939[(23)]);
var inst_25907__$1 = cljs.core.first.call(null,inst_25898);
var inst_25908 = cljs.core.async.put_BANG_.call(null,inst_25907__$1,inst_25807,done);
var state_25939__$1 = (function (){var statearr_26015 = state_25939;
(statearr_26015[(23)] = inst_25907__$1);

return statearr_26015;
})();
if(cljs.core.truth_(inst_25908)){
var statearr_26016_26078 = state_25939__$1;
(statearr_26016_26078[(1)] = (39));

} else {
var statearr_26017_26079 = state_25939__$1;
(statearr_26017_26079[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25940 === (8))){
var inst_25819 = (state_25939[(13)]);
var inst_25818 = (state_25939[(15)]);
var inst_25821 = (inst_25819 < inst_25818);
var inst_25822 = inst_25821;
var state_25939__$1 = state_25939;
if(cljs.core.truth_(inst_25822)){
var statearr_26018_26080 = state_25939__$1;
(statearr_26018_26080[(1)] = (10));

} else {
var statearr_26019_26081 = state_25939__$1;
(statearr_26019_26081[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24690__auto___26027,cs,m,dchan,dctr,done))
;
return ((function (switch__24576__auto__,c__24690__auto___26027,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__24577__auto__ = null;
var cljs$core$async$mult_$_state_machine__24577__auto____0 = (function (){
var statearr_26023 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26023[(0)] = cljs$core$async$mult_$_state_machine__24577__auto__);

(statearr_26023[(1)] = (1));

return statearr_26023;
});
var cljs$core$async$mult_$_state_machine__24577__auto____1 = (function (state_25939){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_25939);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e26024){if((e26024 instanceof Object)){
var ex__24580__auto__ = e26024;
var statearr_26025_26082 = state_25939;
(statearr_26025_26082[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25939);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26024;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26083 = state_25939;
state_25939 = G__26083;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__24577__auto__ = function(state_25939){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__24577__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__24577__auto____1.call(this,state_25939);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__24577__auto____0;
cljs$core$async$mult_$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__24577__auto____1;
return cljs$core$async$mult_$_state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto___26027,cs,m,dchan,dctr,done))
})();
var state__24692__auto__ = (function (){var statearr_26026 = f__24691__auto__.call(null);
(statearr_26026[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto___26027);

return statearr_26026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto___26027,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args26084 = [];
var len__21576__auto___26087 = arguments.length;
var i__21577__auto___26088 = (0);
while(true){
if((i__21577__auto___26088 < len__21576__auto___26087)){
args26084.push((arguments[i__21577__auto___26088]));

var G__26089 = (i__21577__auto___26088 + (1));
i__21577__auto___26088 = G__26089;
continue;
} else {
}
break;
}

var G__26086 = args26084.length;
switch (G__26086) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26084.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__21073__auto__ = (((m == null))?null:m);
var m__21074__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__21073__auto__)]);
if(!((m__21074__auto__ == null))){
return m__21074__auto__.call(null,m,ch);
} else {
var m__21074__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__21074__auto____$1 == null))){
return m__21074__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__21073__auto__ = (((m == null))?null:m);
var m__21074__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__21073__auto__)]);
if(!((m__21074__auto__ == null))){
return m__21074__auto__.call(null,m,ch);
} else {
var m__21074__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__21074__auto____$1 == null))){
return m__21074__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__21073__auto__ = (((m == null))?null:m);
var m__21074__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__21073__auto__)]);
if(!((m__21074__auto__ == null))){
return m__21074__auto__.call(null,m);
} else {
var m__21074__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__21074__auto____$1 == null))){
return m__21074__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__21073__auto__ = (((m == null))?null:m);
var m__21074__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__21073__auto__)]);
if(!((m__21074__auto__ == null))){
return m__21074__auto__.call(null,m,state_map);
} else {
var m__21074__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__21074__auto____$1 == null))){
return m__21074__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__21073__auto__ = (((m == null))?null:m);
var m__21074__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__21073__auto__)]);
if(!((m__21074__auto__ == null))){
return m__21074__auto__.call(null,m,mode);
} else {
var m__21074__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__21074__auto____$1 == null))){
return m__21074__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__21583__auto__ = [];
var len__21576__auto___26101 = arguments.length;
var i__21577__auto___26102 = (0);
while(true){
if((i__21577__auto___26102 < len__21576__auto___26101)){
args__21583__auto__.push((arguments[i__21577__auto___26102]));

var G__26103 = (i__21577__auto___26102 + (1));
i__21577__auto___26102 = G__26103;
continue;
} else {
}
break;
}

var argseq__21584__auto__ = ((((3) < args__21583__auto__.length))?(new cljs.core.IndexedSeq(args__21583__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__21584__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__26095){
var map__26096 = p__26095;
var map__26096__$1 = ((((!((map__26096 == null)))?((((map__26096.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26096.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26096):map__26096);
var opts = map__26096__$1;
var statearr_26098_26104 = state;
(statearr_26098_26104[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6753__auto__ = cljs.core.async.do_alts.call(null,((function (map__26096,map__26096__$1,opts){
return (function (val){
var statearr_26099_26105 = state;
(statearr_26099_26105[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__26096,map__26096__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6753__auto__)){
var cb = temp__6753__auto__;
var statearr_26100_26106 = state;
(statearr_26100_26106[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq26091){
var G__26092 = cljs.core.first.call(null,seq26091);
var seq26091__$1 = cljs.core.next.call(null,seq26091);
var G__26093 = cljs.core.first.call(null,seq26091__$1);
var seq26091__$2 = cljs.core.next.call(null,seq26091__$1);
var G__26094 = cljs.core.first.call(null,seq26091__$2);
var seq26091__$3 = cljs.core.next.call(null,seq26091__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__26092,G__26093,G__26094,seq26091__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async26274 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26274 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta26275){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta26275 = meta26275;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async26274.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_26276,meta26275__$1){
var self__ = this;
var _26276__$1 = this;
return (new cljs.core.async.t_cljs$core$async26274(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta26275__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26274.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_26276){
var self__ = this;
var _26276__$1 = this;
return self__.meta26275;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26274.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26274.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26274.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26274.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26274.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26274.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26274.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26274.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26274.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta26275","meta26275",-792154696,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26274.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26274.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26274";

cljs.core.async.t_cljs$core$async26274.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__21012__auto__,writer__21013__auto__,opt__21014__auto__){
return cljs.core._write.call(null,writer__21013__auto__,"cljs.core.async/t_cljs$core$async26274");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async26274 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async26274(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta26275){
return (new cljs.core.async.t_cljs$core$async26274(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta26275));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async26274(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__24690__auto___26441 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto___26441,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto___26441,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_26378){
var state_val_26379 = (state_26378[(1)]);
if((state_val_26379 === (7))){
var inst_26293 = (state_26378[(2)]);
var state_26378__$1 = state_26378;
var statearr_26380_26442 = state_26378__$1;
(statearr_26380_26442[(2)] = inst_26293);

(statearr_26380_26442[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (20))){
var inst_26305 = (state_26378[(7)]);
var state_26378__$1 = state_26378;
var statearr_26381_26443 = state_26378__$1;
(statearr_26381_26443[(2)] = inst_26305);

(statearr_26381_26443[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (27))){
var state_26378__$1 = state_26378;
var statearr_26382_26444 = state_26378__$1;
(statearr_26382_26444[(2)] = null);

(statearr_26382_26444[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (1))){
var inst_26280 = (state_26378[(8)]);
var inst_26280__$1 = calc_state.call(null);
var inst_26282 = (inst_26280__$1 == null);
var inst_26283 = cljs.core.not.call(null,inst_26282);
var state_26378__$1 = (function (){var statearr_26383 = state_26378;
(statearr_26383[(8)] = inst_26280__$1);

return statearr_26383;
})();
if(inst_26283){
var statearr_26384_26445 = state_26378__$1;
(statearr_26384_26445[(1)] = (2));

} else {
var statearr_26385_26446 = state_26378__$1;
(statearr_26385_26446[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (24))){
var inst_26352 = (state_26378[(9)]);
var inst_26329 = (state_26378[(10)]);
var inst_26338 = (state_26378[(11)]);
var inst_26352__$1 = inst_26329.call(null,inst_26338);
var state_26378__$1 = (function (){var statearr_26386 = state_26378;
(statearr_26386[(9)] = inst_26352__$1);

return statearr_26386;
})();
if(cljs.core.truth_(inst_26352__$1)){
var statearr_26387_26447 = state_26378__$1;
(statearr_26387_26447[(1)] = (29));

} else {
var statearr_26388_26448 = state_26378__$1;
(statearr_26388_26448[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (4))){
var inst_26296 = (state_26378[(2)]);
var state_26378__$1 = state_26378;
if(cljs.core.truth_(inst_26296)){
var statearr_26389_26449 = state_26378__$1;
(statearr_26389_26449[(1)] = (8));

} else {
var statearr_26390_26450 = state_26378__$1;
(statearr_26390_26450[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (15))){
var inst_26323 = (state_26378[(2)]);
var state_26378__$1 = state_26378;
if(cljs.core.truth_(inst_26323)){
var statearr_26391_26451 = state_26378__$1;
(statearr_26391_26451[(1)] = (19));

} else {
var statearr_26392_26452 = state_26378__$1;
(statearr_26392_26452[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (21))){
var inst_26328 = (state_26378[(12)]);
var inst_26328__$1 = (state_26378[(2)]);
var inst_26329 = cljs.core.get.call(null,inst_26328__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_26330 = cljs.core.get.call(null,inst_26328__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_26331 = cljs.core.get.call(null,inst_26328__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_26378__$1 = (function (){var statearr_26393 = state_26378;
(statearr_26393[(12)] = inst_26328__$1);

(statearr_26393[(13)] = inst_26330);

(statearr_26393[(10)] = inst_26329);

return statearr_26393;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_26378__$1,(22),inst_26331);
} else {
if((state_val_26379 === (31))){
var inst_26360 = (state_26378[(2)]);
var state_26378__$1 = state_26378;
if(cljs.core.truth_(inst_26360)){
var statearr_26394_26453 = state_26378__$1;
(statearr_26394_26453[(1)] = (32));

} else {
var statearr_26395_26454 = state_26378__$1;
(statearr_26395_26454[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (32))){
var inst_26337 = (state_26378[(14)]);
var state_26378__$1 = state_26378;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26378__$1,(35),out,inst_26337);
} else {
if((state_val_26379 === (33))){
var inst_26328 = (state_26378[(12)]);
var inst_26305 = inst_26328;
var state_26378__$1 = (function (){var statearr_26396 = state_26378;
(statearr_26396[(7)] = inst_26305);

return statearr_26396;
})();
var statearr_26397_26455 = state_26378__$1;
(statearr_26397_26455[(2)] = null);

(statearr_26397_26455[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (13))){
var inst_26305 = (state_26378[(7)]);
var inst_26312 = inst_26305.cljs$lang$protocol_mask$partition0$;
var inst_26313 = (inst_26312 & (64));
var inst_26314 = inst_26305.cljs$core$ISeq$;
var inst_26315 = (cljs.core.PROTOCOL_SENTINEL === inst_26314);
var inst_26316 = (inst_26313) || (inst_26315);
var state_26378__$1 = state_26378;
if(cljs.core.truth_(inst_26316)){
var statearr_26398_26456 = state_26378__$1;
(statearr_26398_26456[(1)] = (16));

} else {
var statearr_26399_26457 = state_26378__$1;
(statearr_26399_26457[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (22))){
var inst_26337 = (state_26378[(14)]);
var inst_26338 = (state_26378[(11)]);
var inst_26336 = (state_26378[(2)]);
var inst_26337__$1 = cljs.core.nth.call(null,inst_26336,(0),null);
var inst_26338__$1 = cljs.core.nth.call(null,inst_26336,(1),null);
var inst_26339 = (inst_26337__$1 == null);
var inst_26340 = cljs.core._EQ_.call(null,inst_26338__$1,change);
var inst_26341 = (inst_26339) || (inst_26340);
var state_26378__$1 = (function (){var statearr_26400 = state_26378;
(statearr_26400[(14)] = inst_26337__$1);

(statearr_26400[(11)] = inst_26338__$1);

return statearr_26400;
})();
if(cljs.core.truth_(inst_26341)){
var statearr_26401_26458 = state_26378__$1;
(statearr_26401_26458[(1)] = (23));

} else {
var statearr_26402_26459 = state_26378__$1;
(statearr_26402_26459[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (36))){
var inst_26328 = (state_26378[(12)]);
var inst_26305 = inst_26328;
var state_26378__$1 = (function (){var statearr_26403 = state_26378;
(statearr_26403[(7)] = inst_26305);

return statearr_26403;
})();
var statearr_26404_26460 = state_26378__$1;
(statearr_26404_26460[(2)] = null);

(statearr_26404_26460[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (29))){
var inst_26352 = (state_26378[(9)]);
var state_26378__$1 = state_26378;
var statearr_26405_26461 = state_26378__$1;
(statearr_26405_26461[(2)] = inst_26352);

(statearr_26405_26461[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (6))){
var state_26378__$1 = state_26378;
var statearr_26406_26462 = state_26378__$1;
(statearr_26406_26462[(2)] = false);

(statearr_26406_26462[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (28))){
var inst_26348 = (state_26378[(2)]);
var inst_26349 = calc_state.call(null);
var inst_26305 = inst_26349;
var state_26378__$1 = (function (){var statearr_26407 = state_26378;
(statearr_26407[(15)] = inst_26348);

(statearr_26407[(7)] = inst_26305);

return statearr_26407;
})();
var statearr_26408_26463 = state_26378__$1;
(statearr_26408_26463[(2)] = null);

(statearr_26408_26463[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (25))){
var inst_26374 = (state_26378[(2)]);
var state_26378__$1 = state_26378;
var statearr_26409_26464 = state_26378__$1;
(statearr_26409_26464[(2)] = inst_26374);

(statearr_26409_26464[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (34))){
var inst_26372 = (state_26378[(2)]);
var state_26378__$1 = state_26378;
var statearr_26410_26465 = state_26378__$1;
(statearr_26410_26465[(2)] = inst_26372);

(statearr_26410_26465[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (17))){
var state_26378__$1 = state_26378;
var statearr_26411_26466 = state_26378__$1;
(statearr_26411_26466[(2)] = false);

(statearr_26411_26466[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (3))){
var state_26378__$1 = state_26378;
var statearr_26412_26467 = state_26378__$1;
(statearr_26412_26467[(2)] = false);

(statearr_26412_26467[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (12))){
var inst_26376 = (state_26378[(2)]);
var state_26378__$1 = state_26378;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26378__$1,inst_26376);
} else {
if((state_val_26379 === (2))){
var inst_26280 = (state_26378[(8)]);
var inst_26285 = inst_26280.cljs$lang$protocol_mask$partition0$;
var inst_26286 = (inst_26285 & (64));
var inst_26287 = inst_26280.cljs$core$ISeq$;
var inst_26288 = (cljs.core.PROTOCOL_SENTINEL === inst_26287);
var inst_26289 = (inst_26286) || (inst_26288);
var state_26378__$1 = state_26378;
if(cljs.core.truth_(inst_26289)){
var statearr_26413_26468 = state_26378__$1;
(statearr_26413_26468[(1)] = (5));

} else {
var statearr_26414_26469 = state_26378__$1;
(statearr_26414_26469[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (23))){
var inst_26337 = (state_26378[(14)]);
var inst_26343 = (inst_26337 == null);
var state_26378__$1 = state_26378;
if(cljs.core.truth_(inst_26343)){
var statearr_26415_26470 = state_26378__$1;
(statearr_26415_26470[(1)] = (26));

} else {
var statearr_26416_26471 = state_26378__$1;
(statearr_26416_26471[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (35))){
var inst_26363 = (state_26378[(2)]);
var state_26378__$1 = state_26378;
if(cljs.core.truth_(inst_26363)){
var statearr_26417_26472 = state_26378__$1;
(statearr_26417_26472[(1)] = (36));

} else {
var statearr_26418_26473 = state_26378__$1;
(statearr_26418_26473[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (19))){
var inst_26305 = (state_26378[(7)]);
var inst_26325 = cljs.core.apply.call(null,cljs.core.hash_map,inst_26305);
var state_26378__$1 = state_26378;
var statearr_26419_26474 = state_26378__$1;
(statearr_26419_26474[(2)] = inst_26325);

(statearr_26419_26474[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (11))){
var inst_26305 = (state_26378[(7)]);
var inst_26309 = (inst_26305 == null);
var inst_26310 = cljs.core.not.call(null,inst_26309);
var state_26378__$1 = state_26378;
if(inst_26310){
var statearr_26420_26475 = state_26378__$1;
(statearr_26420_26475[(1)] = (13));

} else {
var statearr_26421_26476 = state_26378__$1;
(statearr_26421_26476[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (9))){
var inst_26280 = (state_26378[(8)]);
var state_26378__$1 = state_26378;
var statearr_26422_26477 = state_26378__$1;
(statearr_26422_26477[(2)] = inst_26280);

(statearr_26422_26477[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (5))){
var state_26378__$1 = state_26378;
var statearr_26423_26478 = state_26378__$1;
(statearr_26423_26478[(2)] = true);

(statearr_26423_26478[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (14))){
var state_26378__$1 = state_26378;
var statearr_26424_26479 = state_26378__$1;
(statearr_26424_26479[(2)] = false);

(statearr_26424_26479[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (26))){
var inst_26338 = (state_26378[(11)]);
var inst_26345 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_26338);
var state_26378__$1 = state_26378;
var statearr_26425_26480 = state_26378__$1;
(statearr_26425_26480[(2)] = inst_26345);

(statearr_26425_26480[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (16))){
var state_26378__$1 = state_26378;
var statearr_26426_26481 = state_26378__$1;
(statearr_26426_26481[(2)] = true);

(statearr_26426_26481[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (38))){
var inst_26368 = (state_26378[(2)]);
var state_26378__$1 = state_26378;
var statearr_26427_26482 = state_26378__$1;
(statearr_26427_26482[(2)] = inst_26368);

(statearr_26427_26482[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (30))){
var inst_26330 = (state_26378[(13)]);
var inst_26329 = (state_26378[(10)]);
var inst_26338 = (state_26378[(11)]);
var inst_26355 = cljs.core.empty_QMARK_.call(null,inst_26329);
var inst_26356 = inst_26330.call(null,inst_26338);
var inst_26357 = cljs.core.not.call(null,inst_26356);
var inst_26358 = (inst_26355) && (inst_26357);
var state_26378__$1 = state_26378;
var statearr_26428_26483 = state_26378__$1;
(statearr_26428_26483[(2)] = inst_26358);

(statearr_26428_26483[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (10))){
var inst_26280 = (state_26378[(8)]);
var inst_26301 = (state_26378[(2)]);
var inst_26302 = cljs.core.get.call(null,inst_26301,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_26303 = cljs.core.get.call(null,inst_26301,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_26304 = cljs.core.get.call(null,inst_26301,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_26305 = inst_26280;
var state_26378__$1 = (function (){var statearr_26429 = state_26378;
(statearr_26429[(16)] = inst_26304);

(statearr_26429[(17)] = inst_26303);

(statearr_26429[(18)] = inst_26302);

(statearr_26429[(7)] = inst_26305);

return statearr_26429;
})();
var statearr_26430_26484 = state_26378__$1;
(statearr_26430_26484[(2)] = null);

(statearr_26430_26484[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (18))){
var inst_26320 = (state_26378[(2)]);
var state_26378__$1 = state_26378;
var statearr_26431_26485 = state_26378__$1;
(statearr_26431_26485[(2)] = inst_26320);

(statearr_26431_26485[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (37))){
var state_26378__$1 = state_26378;
var statearr_26432_26486 = state_26378__$1;
(statearr_26432_26486[(2)] = null);

(statearr_26432_26486[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26379 === (8))){
var inst_26280 = (state_26378[(8)]);
var inst_26298 = cljs.core.apply.call(null,cljs.core.hash_map,inst_26280);
var state_26378__$1 = state_26378;
var statearr_26433_26487 = state_26378__$1;
(statearr_26433_26487[(2)] = inst_26298);

(statearr_26433_26487[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24690__auto___26441,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__24576__auto__,c__24690__auto___26441,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__24577__auto__ = null;
var cljs$core$async$mix_$_state_machine__24577__auto____0 = (function (){
var statearr_26437 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26437[(0)] = cljs$core$async$mix_$_state_machine__24577__auto__);

(statearr_26437[(1)] = (1));

return statearr_26437;
});
var cljs$core$async$mix_$_state_machine__24577__auto____1 = (function (state_26378){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_26378);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e26438){if((e26438 instanceof Object)){
var ex__24580__auto__ = e26438;
var statearr_26439_26488 = state_26378;
(statearr_26439_26488[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26378);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26438;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26489 = state_26378;
state_26378 = G__26489;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__24577__auto__ = function(state_26378){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__24577__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__24577__auto____1.call(this,state_26378);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__24577__auto____0;
cljs$core$async$mix_$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__24577__auto____1;
return cljs$core$async$mix_$_state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto___26441,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__24692__auto__ = (function (){var statearr_26440 = f__24691__auto__.call(null);
(statearr_26440[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto___26441);

return statearr_26440;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto___26441,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__21073__auto__ = (((p == null))?null:p);
var m__21074__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__21073__auto__)]);
if(!((m__21074__auto__ == null))){
return m__21074__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__21074__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__21074__auto____$1 == null))){
return m__21074__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__21073__auto__ = (((p == null))?null:p);
var m__21074__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__21073__auto__)]);
if(!((m__21074__auto__ == null))){
return m__21074__auto__.call(null,p,v,ch);
} else {
var m__21074__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__21074__auto____$1 == null))){
return m__21074__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args26490 = [];
var len__21576__auto___26493 = arguments.length;
var i__21577__auto___26494 = (0);
while(true){
if((i__21577__auto___26494 < len__21576__auto___26493)){
args26490.push((arguments[i__21577__auto___26494]));

var G__26495 = (i__21577__auto___26494 + (1));
i__21577__auto___26494 = G__26495;
continue;
} else {
}
break;
}

var G__26492 = args26490.length;
switch (G__26492) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26490.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__21073__auto__ = (((p == null))?null:p);
var m__21074__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__21073__auto__)]);
if(!((m__21074__auto__ == null))){
return m__21074__auto__.call(null,p);
} else {
var m__21074__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__21074__auto____$1 == null))){
return m__21074__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__21073__auto__ = (((p == null))?null:p);
var m__21074__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__21073__auto__)]);
if(!((m__21074__auto__ == null))){
return m__21074__auto__.call(null,p,v);
} else {
var m__21074__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__21074__auto____$1 == null))){
return m__21074__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args26498 = [];
var len__21576__auto___26623 = arguments.length;
var i__21577__auto___26624 = (0);
while(true){
if((i__21577__auto___26624 < len__21576__auto___26623)){
args26498.push((arguments[i__21577__auto___26624]));

var G__26625 = (i__21577__auto___26624 + (1));
i__21577__auto___26624 = G__26625;
continue;
} else {
}
break;
}

var G__26500 = args26498.length;
switch (G__26500) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26498.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__20360__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__20360__auto__)){
return or__20360__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__20360__auto__,mults){
return (function (p1__26497_SHARP_){
if(cljs.core.truth_(p1__26497_SHARP_.call(null,topic))){
return p1__26497_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__26497_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__20360__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async26501 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26501 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta26502){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta26502 = meta26502;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async26501.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_26503,meta26502__$1){
var self__ = this;
var _26503__$1 = this;
return (new cljs.core.async.t_cljs$core$async26501(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta26502__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26501.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_26503){
var self__ = this;
var _26503__$1 = this;
return self__.meta26502;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26501.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26501.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26501.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26501.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26501.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6753__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6753__auto__)){
var m = temp__6753__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26501.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26501.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26501.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta26502","meta26502",-1268923739,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26501.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26501.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26501";

cljs.core.async.t_cljs$core$async26501.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__21012__auto__,writer__21013__auto__,opt__21014__auto__){
return cljs.core._write.call(null,writer__21013__auto__,"cljs.core.async/t_cljs$core$async26501");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async26501 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async26501(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta26502){
return (new cljs.core.async.t_cljs$core$async26501(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta26502));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async26501(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__24690__auto___26627 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto___26627,mults,ensure_mult,p){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto___26627,mults,ensure_mult,p){
return (function (state_26575){
var state_val_26576 = (state_26575[(1)]);
if((state_val_26576 === (7))){
var inst_26571 = (state_26575[(2)]);
var state_26575__$1 = state_26575;
var statearr_26577_26628 = state_26575__$1;
(statearr_26577_26628[(2)] = inst_26571);

(statearr_26577_26628[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26576 === (20))){
var state_26575__$1 = state_26575;
var statearr_26578_26629 = state_26575__$1;
(statearr_26578_26629[(2)] = null);

(statearr_26578_26629[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26576 === (1))){
var state_26575__$1 = state_26575;
var statearr_26579_26630 = state_26575__$1;
(statearr_26579_26630[(2)] = null);

(statearr_26579_26630[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26576 === (24))){
var inst_26554 = (state_26575[(7)]);
var inst_26563 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_26554);
var state_26575__$1 = state_26575;
var statearr_26580_26631 = state_26575__$1;
(statearr_26580_26631[(2)] = inst_26563);

(statearr_26580_26631[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26576 === (4))){
var inst_26506 = (state_26575[(8)]);
var inst_26506__$1 = (state_26575[(2)]);
var inst_26507 = (inst_26506__$1 == null);
var state_26575__$1 = (function (){var statearr_26581 = state_26575;
(statearr_26581[(8)] = inst_26506__$1);

return statearr_26581;
})();
if(cljs.core.truth_(inst_26507)){
var statearr_26582_26632 = state_26575__$1;
(statearr_26582_26632[(1)] = (5));

} else {
var statearr_26583_26633 = state_26575__$1;
(statearr_26583_26633[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26576 === (15))){
var inst_26548 = (state_26575[(2)]);
var state_26575__$1 = state_26575;
var statearr_26584_26634 = state_26575__$1;
(statearr_26584_26634[(2)] = inst_26548);

(statearr_26584_26634[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26576 === (21))){
var inst_26568 = (state_26575[(2)]);
var state_26575__$1 = (function (){var statearr_26585 = state_26575;
(statearr_26585[(9)] = inst_26568);

return statearr_26585;
})();
var statearr_26586_26635 = state_26575__$1;
(statearr_26586_26635[(2)] = null);

(statearr_26586_26635[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26576 === (13))){
var inst_26530 = (state_26575[(10)]);
var inst_26532 = cljs.core.chunked_seq_QMARK_.call(null,inst_26530);
var state_26575__$1 = state_26575;
if(inst_26532){
var statearr_26587_26636 = state_26575__$1;
(statearr_26587_26636[(1)] = (16));

} else {
var statearr_26588_26637 = state_26575__$1;
(statearr_26588_26637[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26576 === (22))){
var inst_26560 = (state_26575[(2)]);
var state_26575__$1 = state_26575;
if(cljs.core.truth_(inst_26560)){
var statearr_26589_26638 = state_26575__$1;
(statearr_26589_26638[(1)] = (23));

} else {
var statearr_26590_26639 = state_26575__$1;
(statearr_26590_26639[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26576 === (6))){
var inst_26556 = (state_26575[(11)]);
var inst_26506 = (state_26575[(8)]);
var inst_26554 = (state_26575[(7)]);
var inst_26554__$1 = topic_fn.call(null,inst_26506);
var inst_26555 = cljs.core.deref.call(null,mults);
var inst_26556__$1 = cljs.core.get.call(null,inst_26555,inst_26554__$1);
var state_26575__$1 = (function (){var statearr_26591 = state_26575;
(statearr_26591[(11)] = inst_26556__$1);

(statearr_26591[(7)] = inst_26554__$1);

return statearr_26591;
})();
if(cljs.core.truth_(inst_26556__$1)){
var statearr_26592_26640 = state_26575__$1;
(statearr_26592_26640[(1)] = (19));

} else {
var statearr_26593_26641 = state_26575__$1;
(statearr_26593_26641[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26576 === (25))){
var inst_26565 = (state_26575[(2)]);
var state_26575__$1 = state_26575;
var statearr_26594_26642 = state_26575__$1;
(statearr_26594_26642[(2)] = inst_26565);

(statearr_26594_26642[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26576 === (17))){
var inst_26530 = (state_26575[(10)]);
var inst_26539 = cljs.core.first.call(null,inst_26530);
var inst_26540 = cljs.core.async.muxch_STAR_.call(null,inst_26539);
var inst_26541 = cljs.core.async.close_BANG_.call(null,inst_26540);
var inst_26542 = cljs.core.next.call(null,inst_26530);
var inst_26516 = inst_26542;
var inst_26517 = null;
var inst_26518 = (0);
var inst_26519 = (0);
var state_26575__$1 = (function (){var statearr_26595 = state_26575;
(statearr_26595[(12)] = inst_26519);

(statearr_26595[(13)] = inst_26517);

(statearr_26595[(14)] = inst_26541);

(statearr_26595[(15)] = inst_26518);

(statearr_26595[(16)] = inst_26516);

return statearr_26595;
})();
var statearr_26596_26643 = state_26575__$1;
(statearr_26596_26643[(2)] = null);

(statearr_26596_26643[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26576 === (3))){
var inst_26573 = (state_26575[(2)]);
var state_26575__$1 = state_26575;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26575__$1,inst_26573);
} else {
if((state_val_26576 === (12))){
var inst_26550 = (state_26575[(2)]);
var state_26575__$1 = state_26575;
var statearr_26597_26644 = state_26575__$1;
(statearr_26597_26644[(2)] = inst_26550);

(statearr_26597_26644[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26576 === (2))){
var state_26575__$1 = state_26575;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26575__$1,(4),ch);
} else {
if((state_val_26576 === (23))){
var state_26575__$1 = state_26575;
var statearr_26598_26645 = state_26575__$1;
(statearr_26598_26645[(2)] = null);

(statearr_26598_26645[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26576 === (19))){
var inst_26556 = (state_26575[(11)]);
var inst_26506 = (state_26575[(8)]);
var inst_26558 = cljs.core.async.muxch_STAR_.call(null,inst_26556);
var state_26575__$1 = state_26575;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26575__$1,(22),inst_26558,inst_26506);
} else {
if((state_val_26576 === (11))){
var inst_26530 = (state_26575[(10)]);
var inst_26516 = (state_26575[(16)]);
var inst_26530__$1 = cljs.core.seq.call(null,inst_26516);
var state_26575__$1 = (function (){var statearr_26599 = state_26575;
(statearr_26599[(10)] = inst_26530__$1);

return statearr_26599;
})();
if(inst_26530__$1){
var statearr_26600_26646 = state_26575__$1;
(statearr_26600_26646[(1)] = (13));

} else {
var statearr_26601_26647 = state_26575__$1;
(statearr_26601_26647[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26576 === (9))){
var inst_26552 = (state_26575[(2)]);
var state_26575__$1 = state_26575;
var statearr_26602_26648 = state_26575__$1;
(statearr_26602_26648[(2)] = inst_26552);

(statearr_26602_26648[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26576 === (5))){
var inst_26513 = cljs.core.deref.call(null,mults);
var inst_26514 = cljs.core.vals.call(null,inst_26513);
var inst_26515 = cljs.core.seq.call(null,inst_26514);
var inst_26516 = inst_26515;
var inst_26517 = null;
var inst_26518 = (0);
var inst_26519 = (0);
var state_26575__$1 = (function (){var statearr_26603 = state_26575;
(statearr_26603[(12)] = inst_26519);

(statearr_26603[(13)] = inst_26517);

(statearr_26603[(15)] = inst_26518);

(statearr_26603[(16)] = inst_26516);

return statearr_26603;
})();
var statearr_26604_26649 = state_26575__$1;
(statearr_26604_26649[(2)] = null);

(statearr_26604_26649[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26576 === (14))){
var state_26575__$1 = state_26575;
var statearr_26608_26650 = state_26575__$1;
(statearr_26608_26650[(2)] = null);

(statearr_26608_26650[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26576 === (16))){
var inst_26530 = (state_26575[(10)]);
var inst_26534 = cljs.core.chunk_first.call(null,inst_26530);
var inst_26535 = cljs.core.chunk_rest.call(null,inst_26530);
var inst_26536 = cljs.core.count.call(null,inst_26534);
var inst_26516 = inst_26535;
var inst_26517 = inst_26534;
var inst_26518 = inst_26536;
var inst_26519 = (0);
var state_26575__$1 = (function (){var statearr_26609 = state_26575;
(statearr_26609[(12)] = inst_26519);

(statearr_26609[(13)] = inst_26517);

(statearr_26609[(15)] = inst_26518);

(statearr_26609[(16)] = inst_26516);

return statearr_26609;
})();
var statearr_26610_26651 = state_26575__$1;
(statearr_26610_26651[(2)] = null);

(statearr_26610_26651[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26576 === (10))){
var inst_26519 = (state_26575[(12)]);
var inst_26517 = (state_26575[(13)]);
var inst_26518 = (state_26575[(15)]);
var inst_26516 = (state_26575[(16)]);
var inst_26524 = cljs.core._nth.call(null,inst_26517,inst_26519);
var inst_26525 = cljs.core.async.muxch_STAR_.call(null,inst_26524);
var inst_26526 = cljs.core.async.close_BANG_.call(null,inst_26525);
var inst_26527 = (inst_26519 + (1));
var tmp26605 = inst_26517;
var tmp26606 = inst_26518;
var tmp26607 = inst_26516;
var inst_26516__$1 = tmp26607;
var inst_26517__$1 = tmp26605;
var inst_26518__$1 = tmp26606;
var inst_26519__$1 = inst_26527;
var state_26575__$1 = (function (){var statearr_26611 = state_26575;
(statearr_26611[(12)] = inst_26519__$1);

(statearr_26611[(13)] = inst_26517__$1);

(statearr_26611[(17)] = inst_26526);

(statearr_26611[(15)] = inst_26518__$1);

(statearr_26611[(16)] = inst_26516__$1);

return statearr_26611;
})();
var statearr_26612_26652 = state_26575__$1;
(statearr_26612_26652[(2)] = null);

(statearr_26612_26652[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26576 === (18))){
var inst_26545 = (state_26575[(2)]);
var state_26575__$1 = state_26575;
var statearr_26613_26653 = state_26575__$1;
(statearr_26613_26653[(2)] = inst_26545);

(statearr_26613_26653[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26576 === (8))){
var inst_26519 = (state_26575[(12)]);
var inst_26518 = (state_26575[(15)]);
var inst_26521 = (inst_26519 < inst_26518);
var inst_26522 = inst_26521;
var state_26575__$1 = state_26575;
if(cljs.core.truth_(inst_26522)){
var statearr_26614_26654 = state_26575__$1;
(statearr_26614_26654[(1)] = (10));

} else {
var statearr_26615_26655 = state_26575__$1;
(statearr_26615_26655[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24690__auto___26627,mults,ensure_mult,p))
;
return ((function (switch__24576__auto__,c__24690__auto___26627,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__24577__auto__ = null;
var cljs$core$async$state_machine__24577__auto____0 = (function (){
var statearr_26619 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26619[(0)] = cljs$core$async$state_machine__24577__auto__);

(statearr_26619[(1)] = (1));

return statearr_26619;
});
var cljs$core$async$state_machine__24577__auto____1 = (function (state_26575){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_26575);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e26620){if((e26620 instanceof Object)){
var ex__24580__auto__ = e26620;
var statearr_26621_26656 = state_26575;
(statearr_26621_26656[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26575);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26620;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26657 = state_26575;
state_26575 = G__26657;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
cljs$core$async$state_machine__24577__auto__ = function(state_26575){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24577__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24577__auto____1.call(this,state_26575);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24577__auto____0;
cljs$core$async$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24577__auto____1;
return cljs$core$async$state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto___26627,mults,ensure_mult,p))
})();
var state__24692__auto__ = (function (){var statearr_26622 = f__24691__auto__.call(null);
(statearr_26622[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto___26627);

return statearr_26622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto___26627,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args26658 = [];
var len__21576__auto___26661 = arguments.length;
var i__21577__auto___26662 = (0);
while(true){
if((i__21577__auto___26662 < len__21576__auto___26661)){
args26658.push((arguments[i__21577__auto___26662]));

var G__26663 = (i__21577__auto___26662 + (1));
i__21577__auto___26662 = G__26663;
continue;
} else {
}
break;
}

var G__26660 = args26658.length;
switch (G__26660) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26658.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args26665 = [];
var len__21576__auto___26668 = arguments.length;
var i__21577__auto___26669 = (0);
while(true){
if((i__21577__auto___26669 < len__21576__auto___26668)){
args26665.push((arguments[i__21577__auto___26669]));

var G__26670 = (i__21577__auto___26669 + (1));
i__21577__auto___26669 = G__26670;
continue;
} else {
}
break;
}

var G__26667 = args26665.length;
switch (G__26667) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26665.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args26672 = [];
var len__21576__auto___26743 = arguments.length;
var i__21577__auto___26744 = (0);
while(true){
if((i__21577__auto___26744 < len__21576__auto___26743)){
args26672.push((arguments[i__21577__auto___26744]));

var G__26745 = (i__21577__auto___26744 + (1));
i__21577__auto___26744 = G__26745;
continue;
} else {
}
break;
}

var G__26674 = args26672.length;
switch (G__26674) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26672.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__24690__auto___26747 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto___26747,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto___26747,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_26713){
var state_val_26714 = (state_26713[(1)]);
if((state_val_26714 === (7))){
var state_26713__$1 = state_26713;
var statearr_26715_26748 = state_26713__$1;
(statearr_26715_26748[(2)] = null);

(statearr_26715_26748[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26714 === (1))){
var state_26713__$1 = state_26713;
var statearr_26716_26749 = state_26713__$1;
(statearr_26716_26749[(2)] = null);

(statearr_26716_26749[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26714 === (4))){
var inst_26677 = (state_26713[(7)]);
var inst_26679 = (inst_26677 < cnt);
var state_26713__$1 = state_26713;
if(cljs.core.truth_(inst_26679)){
var statearr_26717_26750 = state_26713__$1;
(statearr_26717_26750[(1)] = (6));

} else {
var statearr_26718_26751 = state_26713__$1;
(statearr_26718_26751[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26714 === (15))){
var inst_26709 = (state_26713[(2)]);
var state_26713__$1 = state_26713;
var statearr_26719_26752 = state_26713__$1;
(statearr_26719_26752[(2)] = inst_26709);

(statearr_26719_26752[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26714 === (13))){
var inst_26702 = cljs.core.async.close_BANG_.call(null,out);
var state_26713__$1 = state_26713;
var statearr_26720_26753 = state_26713__$1;
(statearr_26720_26753[(2)] = inst_26702);

(statearr_26720_26753[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26714 === (6))){
var state_26713__$1 = state_26713;
var statearr_26721_26754 = state_26713__$1;
(statearr_26721_26754[(2)] = null);

(statearr_26721_26754[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26714 === (3))){
var inst_26711 = (state_26713[(2)]);
var state_26713__$1 = state_26713;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26713__$1,inst_26711);
} else {
if((state_val_26714 === (12))){
var inst_26699 = (state_26713[(8)]);
var inst_26699__$1 = (state_26713[(2)]);
var inst_26700 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_26699__$1);
var state_26713__$1 = (function (){var statearr_26722 = state_26713;
(statearr_26722[(8)] = inst_26699__$1);

return statearr_26722;
})();
if(cljs.core.truth_(inst_26700)){
var statearr_26723_26755 = state_26713__$1;
(statearr_26723_26755[(1)] = (13));

} else {
var statearr_26724_26756 = state_26713__$1;
(statearr_26724_26756[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26714 === (2))){
var inst_26676 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_26677 = (0);
var state_26713__$1 = (function (){var statearr_26725 = state_26713;
(statearr_26725[(7)] = inst_26677);

(statearr_26725[(9)] = inst_26676);

return statearr_26725;
})();
var statearr_26726_26757 = state_26713__$1;
(statearr_26726_26757[(2)] = null);

(statearr_26726_26757[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26714 === (11))){
var inst_26677 = (state_26713[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_26713,(10),Object,null,(9));
var inst_26686 = chs__$1.call(null,inst_26677);
var inst_26687 = done.call(null,inst_26677);
var inst_26688 = cljs.core.async.take_BANG_.call(null,inst_26686,inst_26687);
var state_26713__$1 = state_26713;
var statearr_26727_26758 = state_26713__$1;
(statearr_26727_26758[(2)] = inst_26688);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26713__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26714 === (9))){
var inst_26677 = (state_26713[(7)]);
var inst_26690 = (state_26713[(2)]);
var inst_26691 = (inst_26677 + (1));
var inst_26677__$1 = inst_26691;
var state_26713__$1 = (function (){var statearr_26728 = state_26713;
(statearr_26728[(10)] = inst_26690);

(statearr_26728[(7)] = inst_26677__$1);

return statearr_26728;
})();
var statearr_26729_26759 = state_26713__$1;
(statearr_26729_26759[(2)] = null);

(statearr_26729_26759[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26714 === (5))){
var inst_26697 = (state_26713[(2)]);
var state_26713__$1 = (function (){var statearr_26730 = state_26713;
(statearr_26730[(11)] = inst_26697);

return statearr_26730;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26713__$1,(12),dchan);
} else {
if((state_val_26714 === (14))){
var inst_26699 = (state_26713[(8)]);
var inst_26704 = cljs.core.apply.call(null,f,inst_26699);
var state_26713__$1 = state_26713;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26713__$1,(16),out,inst_26704);
} else {
if((state_val_26714 === (16))){
var inst_26706 = (state_26713[(2)]);
var state_26713__$1 = (function (){var statearr_26731 = state_26713;
(statearr_26731[(12)] = inst_26706);

return statearr_26731;
})();
var statearr_26732_26760 = state_26713__$1;
(statearr_26732_26760[(2)] = null);

(statearr_26732_26760[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26714 === (10))){
var inst_26681 = (state_26713[(2)]);
var inst_26682 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_26713__$1 = (function (){var statearr_26733 = state_26713;
(statearr_26733[(13)] = inst_26681);

return statearr_26733;
})();
var statearr_26734_26761 = state_26713__$1;
(statearr_26734_26761[(2)] = inst_26682);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26713__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26714 === (8))){
var inst_26695 = (state_26713[(2)]);
var state_26713__$1 = state_26713;
var statearr_26735_26762 = state_26713__$1;
(statearr_26735_26762[(2)] = inst_26695);

(statearr_26735_26762[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24690__auto___26747,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__24576__auto__,c__24690__auto___26747,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__24577__auto__ = null;
var cljs$core$async$state_machine__24577__auto____0 = (function (){
var statearr_26739 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26739[(0)] = cljs$core$async$state_machine__24577__auto__);

(statearr_26739[(1)] = (1));

return statearr_26739;
});
var cljs$core$async$state_machine__24577__auto____1 = (function (state_26713){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_26713);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e26740){if((e26740 instanceof Object)){
var ex__24580__auto__ = e26740;
var statearr_26741_26763 = state_26713;
(statearr_26741_26763[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26713);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26740;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26764 = state_26713;
state_26713 = G__26764;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
cljs$core$async$state_machine__24577__auto__ = function(state_26713){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24577__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24577__auto____1.call(this,state_26713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24577__auto____0;
cljs$core$async$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24577__auto____1;
return cljs$core$async$state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto___26747,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__24692__auto__ = (function (){var statearr_26742 = f__24691__auto__.call(null);
(statearr_26742[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto___26747);

return statearr_26742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto___26747,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args26766 = [];
var len__21576__auto___26824 = arguments.length;
var i__21577__auto___26825 = (0);
while(true){
if((i__21577__auto___26825 < len__21576__auto___26824)){
args26766.push((arguments[i__21577__auto___26825]));

var G__26826 = (i__21577__auto___26825 + (1));
i__21577__auto___26825 = G__26826;
continue;
} else {
}
break;
}

var G__26768 = args26766.length;
switch (G__26768) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26766.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__24690__auto___26828 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto___26828,out){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto___26828,out){
return (function (state_26800){
var state_val_26801 = (state_26800[(1)]);
if((state_val_26801 === (7))){
var inst_26780 = (state_26800[(7)]);
var inst_26779 = (state_26800[(8)]);
var inst_26779__$1 = (state_26800[(2)]);
var inst_26780__$1 = cljs.core.nth.call(null,inst_26779__$1,(0),null);
var inst_26781 = cljs.core.nth.call(null,inst_26779__$1,(1),null);
var inst_26782 = (inst_26780__$1 == null);
var state_26800__$1 = (function (){var statearr_26802 = state_26800;
(statearr_26802[(7)] = inst_26780__$1);

(statearr_26802[(9)] = inst_26781);

(statearr_26802[(8)] = inst_26779__$1);

return statearr_26802;
})();
if(cljs.core.truth_(inst_26782)){
var statearr_26803_26829 = state_26800__$1;
(statearr_26803_26829[(1)] = (8));

} else {
var statearr_26804_26830 = state_26800__$1;
(statearr_26804_26830[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26801 === (1))){
var inst_26769 = cljs.core.vec.call(null,chs);
var inst_26770 = inst_26769;
var state_26800__$1 = (function (){var statearr_26805 = state_26800;
(statearr_26805[(10)] = inst_26770);

return statearr_26805;
})();
var statearr_26806_26831 = state_26800__$1;
(statearr_26806_26831[(2)] = null);

(statearr_26806_26831[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26801 === (4))){
var inst_26770 = (state_26800[(10)]);
var state_26800__$1 = state_26800;
return cljs.core.async.ioc_alts_BANG_.call(null,state_26800__$1,(7),inst_26770);
} else {
if((state_val_26801 === (6))){
var inst_26796 = (state_26800[(2)]);
var state_26800__$1 = state_26800;
var statearr_26807_26832 = state_26800__$1;
(statearr_26807_26832[(2)] = inst_26796);

(statearr_26807_26832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26801 === (3))){
var inst_26798 = (state_26800[(2)]);
var state_26800__$1 = state_26800;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26800__$1,inst_26798);
} else {
if((state_val_26801 === (2))){
var inst_26770 = (state_26800[(10)]);
var inst_26772 = cljs.core.count.call(null,inst_26770);
var inst_26773 = (inst_26772 > (0));
var state_26800__$1 = state_26800;
if(cljs.core.truth_(inst_26773)){
var statearr_26809_26833 = state_26800__$1;
(statearr_26809_26833[(1)] = (4));

} else {
var statearr_26810_26834 = state_26800__$1;
(statearr_26810_26834[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26801 === (11))){
var inst_26770 = (state_26800[(10)]);
var inst_26789 = (state_26800[(2)]);
var tmp26808 = inst_26770;
var inst_26770__$1 = tmp26808;
var state_26800__$1 = (function (){var statearr_26811 = state_26800;
(statearr_26811[(11)] = inst_26789);

(statearr_26811[(10)] = inst_26770__$1);

return statearr_26811;
})();
var statearr_26812_26835 = state_26800__$1;
(statearr_26812_26835[(2)] = null);

(statearr_26812_26835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26801 === (9))){
var inst_26780 = (state_26800[(7)]);
var state_26800__$1 = state_26800;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26800__$1,(11),out,inst_26780);
} else {
if((state_val_26801 === (5))){
var inst_26794 = cljs.core.async.close_BANG_.call(null,out);
var state_26800__$1 = state_26800;
var statearr_26813_26836 = state_26800__$1;
(statearr_26813_26836[(2)] = inst_26794);

(statearr_26813_26836[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26801 === (10))){
var inst_26792 = (state_26800[(2)]);
var state_26800__$1 = state_26800;
var statearr_26814_26837 = state_26800__$1;
(statearr_26814_26837[(2)] = inst_26792);

(statearr_26814_26837[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26801 === (8))){
var inst_26780 = (state_26800[(7)]);
var inst_26770 = (state_26800[(10)]);
var inst_26781 = (state_26800[(9)]);
var inst_26779 = (state_26800[(8)]);
var inst_26784 = (function (){var cs = inst_26770;
var vec__26775 = inst_26779;
var v = inst_26780;
var c = inst_26781;
return ((function (cs,vec__26775,v,c,inst_26780,inst_26770,inst_26781,inst_26779,state_val_26801,c__24690__auto___26828,out){
return (function (p1__26765_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__26765_SHARP_);
});
;})(cs,vec__26775,v,c,inst_26780,inst_26770,inst_26781,inst_26779,state_val_26801,c__24690__auto___26828,out))
})();
var inst_26785 = cljs.core.filterv.call(null,inst_26784,inst_26770);
var inst_26770__$1 = inst_26785;
var state_26800__$1 = (function (){var statearr_26815 = state_26800;
(statearr_26815[(10)] = inst_26770__$1);

return statearr_26815;
})();
var statearr_26816_26838 = state_26800__$1;
(statearr_26816_26838[(2)] = null);

(statearr_26816_26838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__24690__auto___26828,out))
;
return ((function (switch__24576__auto__,c__24690__auto___26828,out){
return (function() {
var cljs$core$async$state_machine__24577__auto__ = null;
var cljs$core$async$state_machine__24577__auto____0 = (function (){
var statearr_26820 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26820[(0)] = cljs$core$async$state_machine__24577__auto__);

(statearr_26820[(1)] = (1));

return statearr_26820;
});
var cljs$core$async$state_machine__24577__auto____1 = (function (state_26800){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_26800);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e26821){if((e26821 instanceof Object)){
var ex__24580__auto__ = e26821;
var statearr_26822_26839 = state_26800;
(statearr_26822_26839[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26800);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26821;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26840 = state_26800;
state_26800 = G__26840;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
cljs$core$async$state_machine__24577__auto__ = function(state_26800){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24577__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24577__auto____1.call(this,state_26800);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24577__auto____0;
cljs$core$async$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24577__auto____1;
return cljs$core$async$state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto___26828,out))
})();
var state__24692__auto__ = (function (){var statearr_26823 = f__24691__auto__.call(null);
(statearr_26823[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto___26828);

return statearr_26823;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto___26828,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args26841 = [];
var len__21576__auto___26890 = arguments.length;
var i__21577__auto___26891 = (0);
while(true){
if((i__21577__auto___26891 < len__21576__auto___26890)){
args26841.push((arguments[i__21577__auto___26891]));

var G__26892 = (i__21577__auto___26891 + (1));
i__21577__auto___26891 = G__26892;
continue;
} else {
}
break;
}

var G__26843 = args26841.length;
switch (G__26843) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26841.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__24690__auto___26894 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto___26894,out){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto___26894,out){
return (function (state_26867){
var state_val_26868 = (state_26867[(1)]);
if((state_val_26868 === (7))){
var inst_26849 = (state_26867[(7)]);
var inst_26849__$1 = (state_26867[(2)]);
var inst_26850 = (inst_26849__$1 == null);
var inst_26851 = cljs.core.not.call(null,inst_26850);
var state_26867__$1 = (function (){var statearr_26869 = state_26867;
(statearr_26869[(7)] = inst_26849__$1);

return statearr_26869;
})();
if(inst_26851){
var statearr_26870_26895 = state_26867__$1;
(statearr_26870_26895[(1)] = (8));

} else {
var statearr_26871_26896 = state_26867__$1;
(statearr_26871_26896[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26868 === (1))){
var inst_26844 = (0);
var state_26867__$1 = (function (){var statearr_26872 = state_26867;
(statearr_26872[(8)] = inst_26844);

return statearr_26872;
})();
var statearr_26873_26897 = state_26867__$1;
(statearr_26873_26897[(2)] = null);

(statearr_26873_26897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26868 === (4))){
var state_26867__$1 = state_26867;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26867__$1,(7),ch);
} else {
if((state_val_26868 === (6))){
var inst_26862 = (state_26867[(2)]);
var state_26867__$1 = state_26867;
var statearr_26874_26898 = state_26867__$1;
(statearr_26874_26898[(2)] = inst_26862);

(statearr_26874_26898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26868 === (3))){
var inst_26864 = (state_26867[(2)]);
var inst_26865 = cljs.core.async.close_BANG_.call(null,out);
var state_26867__$1 = (function (){var statearr_26875 = state_26867;
(statearr_26875[(9)] = inst_26864);

return statearr_26875;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26867__$1,inst_26865);
} else {
if((state_val_26868 === (2))){
var inst_26844 = (state_26867[(8)]);
var inst_26846 = (inst_26844 < n);
var state_26867__$1 = state_26867;
if(cljs.core.truth_(inst_26846)){
var statearr_26876_26899 = state_26867__$1;
(statearr_26876_26899[(1)] = (4));

} else {
var statearr_26877_26900 = state_26867__$1;
(statearr_26877_26900[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26868 === (11))){
var inst_26844 = (state_26867[(8)]);
var inst_26854 = (state_26867[(2)]);
var inst_26855 = (inst_26844 + (1));
var inst_26844__$1 = inst_26855;
var state_26867__$1 = (function (){var statearr_26878 = state_26867;
(statearr_26878[(8)] = inst_26844__$1);

(statearr_26878[(10)] = inst_26854);

return statearr_26878;
})();
var statearr_26879_26901 = state_26867__$1;
(statearr_26879_26901[(2)] = null);

(statearr_26879_26901[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26868 === (9))){
var state_26867__$1 = state_26867;
var statearr_26880_26902 = state_26867__$1;
(statearr_26880_26902[(2)] = null);

(statearr_26880_26902[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26868 === (5))){
var state_26867__$1 = state_26867;
var statearr_26881_26903 = state_26867__$1;
(statearr_26881_26903[(2)] = null);

(statearr_26881_26903[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26868 === (10))){
var inst_26859 = (state_26867[(2)]);
var state_26867__$1 = state_26867;
var statearr_26882_26904 = state_26867__$1;
(statearr_26882_26904[(2)] = inst_26859);

(statearr_26882_26904[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26868 === (8))){
var inst_26849 = (state_26867[(7)]);
var state_26867__$1 = state_26867;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26867__$1,(11),out,inst_26849);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__24690__auto___26894,out))
;
return ((function (switch__24576__auto__,c__24690__auto___26894,out){
return (function() {
var cljs$core$async$state_machine__24577__auto__ = null;
var cljs$core$async$state_machine__24577__auto____0 = (function (){
var statearr_26886 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_26886[(0)] = cljs$core$async$state_machine__24577__auto__);

(statearr_26886[(1)] = (1));

return statearr_26886;
});
var cljs$core$async$state_machine__24577__auto____1 = (function (state_26867){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_26867);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e26887){if((e26887 instanceof Object)){
var ex__24580__auto__ = e26887;
var statearr_26888_26905 = state_26867;
(statearr_26888_26905[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26867);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26887;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26906 = state_26867;
state_26867 = G__26906;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
cljs$core$async$state_machine__24577__auto__ = function(state_26867){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24577__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24577__auto____1.call(this,state_26867);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24577__auto____0;
cljs$core$async$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24577__auto____1;
return cljs$core$async$state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto___26894,out))
})();
var state__24692__auto__ = (function (){var statearr_26889 = f__24691__auto__.call(null);
(statearr_26889[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto___26894);

return statearr_26889;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto___26894,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async26914 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26914 = (function (f,ch,meta26915){
this.f = f;
this.ch = ch;
this.meta26915 = meta26915;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async26914.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26916,meta26915__$1){
var self__ = this;
var _26916__$1 = this;
return (new cljs.core.async.t_cljs$core$async26914(self__.f,self__.ch,meta26915__$1));
});

cljs.core.async.t_cljs$core$async26914.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26916){
var self__ = this;
var _26916__$1 = this;
return self__.meta26915;
});

cljs.core.async.t_cljs$core$async26914.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26914.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async26914.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async26914.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26914.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async26917 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26917 = (function (f,ch,meta26915,_,fn1,meta26918){
this.f = f;
this.ch = ch;
this.meta26915 = meta26915;
this._ = _;
this.fn1 = fn1;
this.meta26918 = meta26918;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async26917.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_26919,meta26918__$1){
var self__ = this;
var _26919__$1 = this;
return (new cljs.core.async.t_cljs$core$async26917(self__.f,self__.ch,self__.meta26915,self__._,self__.fn1,meta26918__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async26917.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_26919){
var self__ = this;
var _26919__$1 = this;
return self__.meta26918;
});})(___$1))
;

cljs.core.async.t_cljs$core$async26917.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26917.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async26917.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async26917.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__26907_SHARP_){
return f1.call(null,(((p1__26907_SHARP_ == null))?null:self__.f.call(null,p1__26907_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async26917.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta26915","meta26915",1217540167,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async26914","cljs.core.async/t_cljs$core$async26914",-1175032928,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta26918","meta26918",1085690943,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async26917.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26917.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26917";

cljs.core.async.t_cljs$core$async26917.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__21012__auto__,writer__21013__auto__,opt__21014__auto__){
return cljs.core._write.call(null,writer__21013__auto__,"cljs.core.async/t_cljs$core$async26917");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async26917 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async26917(f__$1,ch__$1,meta26915__$1,___$2,fn1__$1,meta26918){
return (new cljs.core.async.t_cljs$core$async26917(f__$1,ch__$1,meta26915__$1,___$2,fn1__$1,meta26918));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async26917(self__.f,self__.ch,self__.meta26915,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__20348__auto__ = ret;
if(cljs.core.truth_(and__20348__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__20348__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async26914.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26914.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async26914.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta26915","meta26915",1217540167,null)], null);
});

cljs.core.async.t_cljs$core$async26914.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26914.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26914";

cljs.core.async.t_cljs$core$async26914.cljs$lang$ctorPrWriter = (function (this__21012__auto__,writer__21013__auto__,opt__21014__auto__){
return cljs.core._write.call(null,writer__21013__auto__,"cljs.core.async/t_cljs$core$async26914");
});

cljs.core.async.__GT_t_cljs$core$async26914 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async26914(f__$1,ch__$1,meta26915){
return (new cljs.core.async.t_cljs$core$async26914(f__$1,ch__$1,meta26915));
});

}

return (new cljs.core.async.t_cljs$core$async26914(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async26923 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26923 = (function (f,ch,meta26924){
this.f = f;
this.ch = ch;
this.meta26924 = meta26924;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async26923.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26925,meta26924__$1){
var self__ = this;
var _26925__$1 = this;
return (new cljs.core.async.t_cljs$core$async26923(self__.f,self__.ch,meta26924__$1));
});

cljs.core.async.t_cljs$core$async26923.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26925){
var self__ = this;
var _26925__$1 = this;
return self__.meta26924;
});

cljs.core.async.t_cljs$core$async26923.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26923.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async26923.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26923.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async26923.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26923.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async26923.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta26924","meta26924",-1654195339,null)], null);
});

cljs.core.async.t_cljs$core$async26923.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26923.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26923";

cljs.core.async.t_cljs$core$async26923.cljs$lang$ctorPrWriter = (function (this__21012__auto__,writer__21013__auto__,opt__21014__auto__){
return cljs.core._write.call(null,writer__21013__auto__,"cljs.core.async/t_cljs$core$async26923");
});

cljs.core.async.__GT_t_cljs$core$async26923 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async26923(f__$1,ch__$1,meta26924){
return (new cljs.core.async.t_cljs$core$async26923(f__$1,ch__$1,meta26924));
});

}

return (new cljs.core.async.t_cljs$core$async26923(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async26929 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26929 = (function (p,ch,meta26930){
this.p = p;
this.ch = ch;
this.meta26930 = meta26930;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async26929.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26931,meta26930__$1){
var self__ = this;
var _26931__$1 = this;
return (new cljs.core.async.t_cljs$core$async26929(self__.p,self__.ch,meta26930__$1));
});

cljs.core.async.t_cljs$core$async26929.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26931){
var self__ = this;
var _26931__$1 = this;
return self__.meta26930;
});

cljs.core.async.t_cljs$core$async26929.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26929.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async26929.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async26929.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26929.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async26929.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26929.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async26929.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta26930","meta26930",-507720049,null)], null);
});

cljs.core.async.t_cljs$core$async26929.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26929.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26929";

cljs.core.async.t_cljs$core$async26929.cljs$lang$ctorPrWriter = (function (this__21012__auto__,writer__21013__auto__,opt__21014__auto__){
return cljs.core._write.call(null,writer__21013__auto__,"cljs.core.async/t_cljs$core$async26929");
});

cljs.core.async.__GT_t_cljs$core$async26929 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async26929(p__$1,ch__$1,meta26930){
return (new cljs.core.async.t_cljs$core$async26929(p__$1,ch__$1,meta26930));
});

}

return (new cljs.core.async.t_cljs$core$async26929(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args26932 = [];
var len__21576__auto___26976 = arguments.length;
var i__21577__auto___26977 = (0);
while(true){
if((i__21577__auto___26977 < len__21576__auto___26976)){
args26932.push((arguments[i__21577__auto___26977]));

var G__26978 = (i__21577__auto___26977 + (1));
i__21577__auto___26977 = G__26978;
continue;
} else {
}
break;
}

var G__26934 = args26932.length;
switch (G__26934) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26932.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__24690__auto___26980 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto___26980,out){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto___26980,out){
return (function (state_26955){
var state_val_26956 = (state_26955[(1)]);
if((state_val_26956 === (7))){
var inst_26951 = (state_26955[(2)]);
var state_26955__$1 = state_26955;
var statearr_26957_26981 = state_26955__$1;
(statearr_26957_26981[(2)] = inst_26951);

(statearr_26957_26981[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26956 === (1))){
var state_26955__$1 = state_26955;
var statearr_26958_26982 = state_26955__$1;
(statearr_26958_26982[(2)] = null);

(statearr_26958_26982[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26956 === (4))){
var inst_26937 = (state_26955[(7)]);
var inst_26937__$1 = (state_26955[(2)]);
var inst_26938 = (inst_26937__$1 == null);
var state_26955__$1 = (function (){var statearr_26959 = state_26955;
(statearr_26959[(7)] = inst_26937__$1);

return statearr_26959;
})();
if(cljs.core.truth_(inst_26938)){
var statearr_26960_26983 = state_26955__$1;
(statearr_26960_26983[(1)] = (5));

} else {
var statearr_26961_26984 = state_26955__$1;
(statearr_26961_26984[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26956 === (6))){
var inst_26937 = (state_26955[(7)]);
var inst_26942 = p.call(null,inst_26937);
var state_26955__$1 = state_26955;
if(cljs.core.truth_(inst_26942)){
var statearr_26962_26985 = state_26955__$1;
(statearr_26962_26985[(1)] = (8));

} else {
var statearr_26963_26986 = state_26955__$1;
(statearr_26963_26986[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26956 === (3))){
var inst_26953 = (state_26955[(2)]);
var state_26955__$1 = state_26955;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26955__$1,inst_26953);
} else {
if((state_val_26956 === (2))){
var state_26955__$1 = state_26955;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26955__$1,(4),ch);
} else {
if((state_val_26956 === (11))){
var inst_26945 = (state_26955[(2)]);
var state_26955__$1 = state_26955;
var statearr_26964_26987 = state_26955__$1;
(statearr_26964_26987[(2)] = inst_26945);

(statearr_26964_26987[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26956 === (9))){
var state_26955__$1 = state_26955;
var statearr_26965_26988 = state_26955__$1;
(statearr_26965_26988[(2)] = null);

(statearr_26965_26988[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26956 === (5))){
var inst_26940 = cljs.core.async.close_BANG_.call(null,out);
var state_26955__$1 = state_26955;
var statearr_26966_26989 = state_26955__$1;
(statearr_26966_26989[(2)] = inst_26940);

(statearr_26966_26989[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26956 === (10))){
var inst_26948 = (state_26955[(2)]);
var state_26955__$1 = (function (){var statearr_26967 = state_26955;
(statearr_26967[(8)] = inst_26948);

return statearr_26967;
})();
var statearr_26968_26990 = state_26955__$1;
(statearr_26968_26990[(2)] = null);

(statearr_26968_26990[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26956 === (8))){
var inst_26937 = (state_26955[(7)]);
var state_26955__$1 = state_26955;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26955__$1,(11),out,inst_26937);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__24690__auto___26980,out))
;
return ((function (switch__24576__auto__,c__24690__auto___26980,out){
return (function() {
var cljs$core$async$state_machine__24577__auto__ = null;
var cljs$core$async$state_machine__24577__auto____0 = (function (){
var statearr_26972 = [null,null,null,null,null,null,null,null,null];
(statearr_26972[(0)] = cljs$core$async$state_machine__24577__auto__);

(statearr_26972[(1)] = (1));

return statearr_26972;
});
var cljs$core$async$state_machine__24577__auto____1 = (function (state_26955){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_26955);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e26973){if((e26973 instanceof Object)){
var ex__24580__auto__ = e26973;
var statearr_26974_26991 = state_26955;
(statearr_26974_26991[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26955);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26973;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26992 = state_26955;
state_26955 = G__26992;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
cljs$core$async$state_machine__24577__auto__ = function(state_26955){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24577__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24577__auto____1.call(this,state_26955);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24577__auto____0;
cljs$core$async$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24577__auto____1;
return cljs$core$async$state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto___26980,out))
})();
var state__24692__auto__ = (function (){var statearr_26975 = f__24691__auto__.call(null);
(statearr_26975[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto___26980);

return statearr_26975;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto___26980,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args26993 = [];
var len__21576__auto___26996 = arguments.length;
var i__21577__auto___26997 = (0);
while(true){
if((i__21577__auto___26997 < len__21576__auto___26996)){
args26993.push((arguments[i__21577__auto___26997]));

var G__26998 = (i__21577__auto___26997 + (1));
i__21577__auto___26997 = G__26998;
continue;
} else {
}
break;
}

var G__26995 = args26993.length;
switch (G__26995) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26993.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__24690__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto__){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto__){
return (function (state_27165){
var state_val_27166 = (state_27165[(1)]);
if((state_val_27166 === (7))){
var inst_27161 = (state_27165[(2)]);
var state_27165__$1 = state_27165;
var statearr_27167_27208 = state_27165__$1;
(statearr_27167_27208[(2)] = inst_27161);

(statearr_27167_27208[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (20))){
var inst_27131 = (state_27165[(7)]);
var inst_27142 = (state_27165[(2)]);
var inst_27143 = cljs.core.next.call(null,inst_27131);
var inst_27117 = inst_27143;
var inst_27118 = null;
var inst_27119 = (0);
var inst_27120 = (0);
var state_27165__$1 = (function (){var statearr_27168 = state_27165;
(statearr_27168[(8)] = inst_27119);

(statearr_27168[(9)] = inst_27142);

(statearr_27168[(10)] = inst_27120);

(statearr_27168[(11)] = inst_27118);

(statearr_27168[(12)] = inst_27117);

return statearr_27168;
})();
var statearr_27169_27209 = state_27165__$1;
(statearr_27169_27209[(2)] = null);

(statearr_27169_27209[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (1))){
var state_27165__$1 = state_27165;
var statearr_27170_27210 = state_27165__$1;
(statearr_27170_27210[(2)] = null);

(statearr_27170_27210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (4))){
var inst_27106 = (state_27165[(13)]);
var inst_27106__$1 = (state_27165[(2)]);
var inst_27107 = (inst_27106__$1 == null);
var state_27165__$1 = (function (){var statearr_27171 = state_27165;
(statearr_27171[(13)] = inst_27106__$1);

return statearr_27171;
})();
if(cljs.core.truth_(inst_27107)){
var statearr_27172_27211 = state_27165__$1;
(statearr_27172_27211[(1)] = (5));

} else {
var statearr_27173_27212 = state_27165__$1;
(statearr_27173_27212[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (15))){
var state_27165__$1 = state_27165;
var statearr_27177_27213 = state_27165__$1;
(statearr_27177_27213[(2)] = null);

(statearr_27177_27213[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (21))){
var state_27165__$1 = state_27165;
var statearr_27178_27214 = state_27165__$1;
(statearr_27178_27214[(2)] = null);

(statearr_27178_27214[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (13))){
var inst_27119 = (state_27165[(8)]);
var inst_27120 = (state_27165[(10)]);
var inst_27118 = (state_27165[(11)]);
var inst_27117 = (state_27165[(12)]);
var inst_27127 = (state_27165[(2)]);
var inst_27128 = (inst_27120 + (1));
var tmp27174 = inst_27119;
var tmp27175 = inst_27118;
var tmp27176 = inst_27117;
var inst_27117__$1 = tmp27176;
var inst_27118__$1 = tmp27175;
var inst_27119__$1 = tmp27174;
var inst_27120__$1 = inst_27128;
var state_27165__$1 = (function (){var statearr_27179 = state_27165;
(statearr_27179[(8)] = inst_27119__$1);

(statearr_27179[(14)] = inst_27127);

(statearr_27179[(10)] = inst_27120__$1);

(statearr_27179[(11)] = inst_27118__$1);

(statearr_27179[(12)] = inst_27117__$1);

return statearr_27179;
})();
var statearr_27180_27215 = state_27165__$1;
(statearr_27180_27215[(2)] = null);

(statearr_27180_27215[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (22))){
var state_27165__$1 = state_27165;
var statearr_27181_27216 = state_27165__$1;
(statearr_27181_27216[(2)] = null);

(statearr_27181_27216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (6))){
var inst_27106 = (state_27165[(13)]);
var inst_27115 = f.call(null,inst_27106);
var inst_27116 = cljs.core.seq.call(null,inst_27115);
var inst_27117 = inst_27116;
var inst_27118 = null;
var inst_27119 = (0);
var inst_27120 = (0);
var state_27165__$1 = (function (){var statearr_27182 = state_27165;
(statearr_27182[(8)] = inst_27119);

(statearr_27182[(10)] = inst_27120);

(statearr_27182[(11)] = inst_27118);

(statearr_27182[(12)] = inst_27117);

return statearr_27182;
})();
var statearr_27183_27217 = state_27165__$1;
(statearr_27183_27217[(2)] = null);

(statearr_27183_27217[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (17))){
var inst_27131 = (state_27165[(7)]);
var inst_27135 = cljs.core.chunk_first.call(null,inst_27131);
var inst_27136 = cljs.core.chunk_rest.call(null,inst_27131);
var inst_27137 = cljs.core.count.call(null,inst_27135);
var inst_27117 = inst_27136;
var inst_27118 = inst_27135;
var inst_27119 = inst_27137;
var inst_27120 = (0);
var state_27165__$1 = (function (){var statearr_27184 = state_27165;
(statearr_27184[(8)] = inst_27119);

(statearr_27184[(10)] = inst_27120);

(statearr_27184[(11)] = inst_27118);

(statearr_27184[(12)] = inst_27117);

return statearr_27184;
})();
var statearr_27185_27218 = state_27165__$1;
(statearr_27185_27218[(2)] = null);

(statearr_27185_27218[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (3))){
var inst_27163 = (state_27165[(2)]);
var state_27165__$1 = state_27165;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27165__$1,inst_27163);
} else {
if((state_val_27166 === (12))){
var inst_27151 = (state_27165[(2)]);
var state_27165__$1 = state_27165;
var statearr_27186_27219 = state_27165__$1;
(statearr_27186_27219[(2)] = inst_27151);

(statearr_27186_27219[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (2))){
var state_27165__$1 = state_27165;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27165__$1,(4),in$);
} else {
if((state_val_27166 === (23))){
var inst_27159 = (state_27165[(2)]);
var state_27165__$1 = state_27165;
var statearr_27187_27220 = state_27165__$1;
(statearr_27187_27220[(2)] = inst_27159);

(statearr_27187_27220[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (19))){
var inst_27146 = (state_27165[(2)]);
var state_27165__$1 = state_27165;
var statearr_27188_27221 = state_27165__$1;
(statearr_27188_27221[(2)] = inst_27146);

(statearr_27188_27221[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (11))){
var inst_27131 = (state_27165[(7)]);
var inst_27117 = (state_27165[(12)]);
var inst_27131__$1 = cljs.core.seq.call(null,inst_27117);
var state_27165__$1 = (function (){var statearr_27189 = state_27165;
(statearr_27189[(7)] = inst_27131__$1);

return statearr_27189;
})();
if(inst_27131__$1){
var statearr_27190_27222 = state_27165__$1;
(statearr_27190_27222[(1)] = (14));

} else {
var statearr_27191_27223 = state_27165__$1;
(statearr_27191_27223[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (9))){
var inst_27153 = (state_27165[(2)]);
var inst_27154 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_27165__$1 = (function (){var statearr_27192 = state_27165;
(statearr_27192[(15)] = inst_27153);

return statearr_27192;
})();
if(cljs.core.truth_(inst_27154)){
var statearr_27193_27224 = state_27165__$1;
(statearr_27193_27224[(1)] = (21));

} else {
var statearr_27194_27225 = state_27165__$1;
(statearr_27194_27225[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (5))){
var inst_27109 = cljs.core.async.close_BANG_.call(null,out);
var state_27165__$1 = state_27165;
var statearr_27195_27226 = state_27165__$1;
(statearr_27195_27226[(2)] = inst_27109);

(statearr_27195_27226[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (14))){
var inst_27131 = (state_27165[(7)]);
var inst_27133 = cljs.core.chunked_seq_QMARK_.call(null,inst_27131);
var state_27165__$1 = state_27165;
if(inst_27133){
var statearr_27196_27227 = state_27165__$1;
(statearr_27196_27227[(1)] = (17));

} else {
var statearr_27197_27228 = state_27165__$1;
(statearr_27197_27228[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (16))){
var inst_27149 = (state_27165[(2)]);
var state_27165__$1 = state_27165;
var statearr_27198_27229 = state_27165__$1;
(statearr_27198_27229[(2)] = inst_27149);

(statearr_27198_27229[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (10))){
var inst_27120 = (state_27165[(10)]);
var inst_27118 = (state_27165[(11)]);
var inst_27125 = cljs.core._nth.call(null,inst_27118,inst_27120);
var state_27165__$1 = state_27165;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27165__$1,(13),out,inst_27125);
} else {
if((state_val_27166 === (18))){
var inst_27131 = (state_27165[(7)]);
var inst_27140 = cljs.core.first.call(null,inst_27131);
var state_27165__$1 = state_27165;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27165__$1,(20),out,inst_27140);
} else {
if((state_val_27166 === (8))){
var inst_27119 = (state_27165[(8)]);
var inst_27120 = (state_27165[(10)]);
var inst_27122 = (inst_27120 < inst_27119);
var inst_27123 = inst_27122;
var state_27165__$1 = state_27165;
if(cljs.core.truth_(inst_27123)){
var statearr_27199_27230 = state_27165__$1;
(statearr_27199_27230[(1)] = (10));

} else {
var statearr_27200_27231 = state_27165__$1;
(statearr_27200_27231[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24690__auto__))
;
return ((function (switch__24576__auto__,c__24690__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__24577__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__24577__auto____0 = (function (){
var statearr_27204 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27204[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__24577__auto__);

(statearr_27204[(1)] = (1));

return statearr_27204;
});
var cljs$core$async$mapcat_STAR__$_state_machine__24577__auto____1 = (function (state_27165){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_27165);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e27205){if((e27205 instanceof Object)){
var ex__24580__auto__ = e27205;
var statearr_27206_27232 = state_27165;
(statearr_27206_27232[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27165);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27205;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27233 = state_27165;
state_27165 = G__27233;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__24577__auto__ = function(state_27165){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__24577__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__24577__auto____1.call(this,state_27165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__24577__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__24577__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto__))
})();
var state__24692__auto__ = (function (){var statearr_27207 = f__24691__auto__.call(null);
(statearr_27207[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto__);

return statearr_27207;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto__))
);

return c__24690__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args27234 = [];
var len__21576__auto___27237 = arguments.length;
var i__21577__auto___27238 = (0);
while(true){
if((i__21577__auto___27238 < len__21576__auto___27237)){
args27234.push((arguments[i__21577__auto___27238]));

var G__27239 = (i__21577__auto___27238 + (1));
i__21577__auto___27238 = G__27239;
continue;
} else {
}
break;
}

var G__27236 = args27234.length;
switch (G__27236) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27234.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args27241 = [];
var len__21576__auto___27244 = arguments.length;
var i__21577__auto___27245 = (0);
while(true){
if((i__21577__auto___27245 < len__21576__auto___27244)){
args27241.push((arguments[i__21577__auto___27245]));

var G__27246 = (i__21577__auto___27245 + (1));
i__21577__auto___27245 = G__27246;
continue;
} else {
}
break;
}

var G__27243 = args27241.length;
switch (G__27243) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27241.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args27248 = [];
var len__21576__auto___27299 = arguments.length;
var i__21577__auto___27300 = (0);
while(true){
if((i__21577__auto___27300 < len__21576__auto___27299)){
args27248.push((arguments[i__21577__auto___27300]));

var G__27301 = (i__21577__auto___27300 + (1));
i__21577__auto___27300 = G__27301;
continue;
} else {
}
break;
}

var G__27250 = args27248.length;
switch (G__27250) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27248.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__24690__auto___27303 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto___27303,out){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto___27303,out){
return (function (state_27274){
var state_val_27275 = (state_27274[(1)]);
if((state_val_27275 === (7))){
var inst_27269 = (state_27274[(2)]);
var state_27274__$1 = state_27274;
var statearr_27276_27304 = state_27274__$1;
(statearr_27276_27304[(2)] = inst_27269);

(statearr_27276_27304[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27275 === (1))){
var inst_27251 = null;
var state_27274__$1 = (function (){var statearr_27277 = state_27274;
(statearr_27277[(7)] = inst_27251);

return statearr_27277;
})();
var statearr_27278_27305 = state_27274__$1;
(statearr_27278_27305[(2)] = null);

(statearr_27278_27305[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27275 === (4))){
var inst_27254 = (state_27274[(8)]);
var inst_27254__$1 = (state_27274[(2)]);
var inst_27255 = (inst_27254__$1 == null);
var inst_27256 = cljs.core.not.call(null,inst_27255);
var state_27274__$1 = (function (){var statearr_27279 = state_27274;
(statearr_27279[(8)] = inst_27254__$1);

return statearr_27279;
})();
if(inst_27256){
var statearr_27280_27306 = state_27274__$1;
(statearr_27280_27306[(1)] = (5));

} else {
var statearr_27281_27307 = state_27274__$1;
(statearr_27281_27307[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27275 === (6))){
var state_27274__$1 = state_27274;
var statearr_27282_27308 = state_27274__$1;
(statearr_27282_27308[(2)] = null);

(statearr_27282_27308[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27275 === (3))){
var inst_27271 = (state_27274[(2)]);
var inst_27272 = cljs.core.async.close_BANG_.call(null,out);
var state_27274__$1 = (function (){var statearr_27283 = state_27274;
(statearr_27283[(9)] = inst_27271);

return statearr_27283;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27274__$1,inst_27272);
} else {
if((state_val_27275 === (2))){
var state_27274__$1 = state_27274;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27274__$1,(4),ch);
} else {
if((state_val_27275 === (11))){
var inst_27254 = (state_27274[(8)]);
var inst_27263 = (state_27274[(2)]);
var inst_27251 = inst_27254;
var state_27274__$1 = (function (){var statearr_27284 = state_27274;
(statearr_27284[(10)] = inst_27263);

(statearr_27284[(7)] = inst_27251);

return statearr_27284;
})();
var statearr_27285_27309 = state_27274__$1;
(statearr_27285_27309[(2)] = null);

(statearr_27285_27309[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27275 === (9))){
var inst_27254 = (state_27274[(8)]);
var state_27274__$1 = state_27274;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27274__$1,(11),out,inst_27254);
} else {
if((state_val_27275 === (5))){
var inst_27254 = (state_27274[(8)]);
var inst_27251 = (state_27274[(7)]);
var inst_27258 = cljs.core._EQ_.call(null,inst_27254,inst_27251);
var state_27274__$1 = state_27274;
if(inst_27258){
var statearr_27287_27310 = state_27274__$1;
(statearr_27287_27310[(1)] = (8));

} else {
var statearr_27288_27311 = state_27274__$1;
(statearr_27288_27311[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27275 === (10))){
var inst_27266 = (state_27274[(2)]);
var state_27274__$1 = state_27274;
var statearr_27289_27312 = state_27274__$1;
(statearr_27289_27312[(2)] = inst_27266);

(statearr_27289_27312[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27275 === (8))){
var inst_27251 = (state_27274[(7)]);
var tmp27286 = inst_27251;
var inst_27251__$1 = tmp27286;
var state_27274__$1 = (function (){var statearr_27290 = state_27274;
(statearr_27290[(7)] = inst_27251__$1);

return statearr_27290;
})();
var statearr_27291_27313 = state_27274__$1;
(statearr_27291_27313[(2)] = null);

(statearr_27291_27313[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__24690__auto___27303,out))
;
return ((function (switch__24576__auto__,c__24690__auto___27303,out){
return (function() {
var cljs$core$async$state_machine__24577__auto__ = null;
var cljs$core$async$state_machine__24577__auto____0 = (function (){
var statearr_27295 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27295[(0)] = cljs$core$async$state_machine__24577__auto__);

(statearr_27295[(1)] = (1));

return statearr_27295;
});
var cljs$core$async$state_machine__24577__auto____1 = (function (state_27274){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_27274);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e27296){if((e27296 instanceof Object)){
var ex__24580__auto__ = e27296;
var statearr_27297_27314 = state_27274;
(statearr_27297_27314[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27274);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27296;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27315 = state_27274;
state_27274 = G__27315;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
cljs$core$async$state_machine__24577__auto__ = function(state_27274){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24577__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24577__auto____1.call(this,state_27274);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24577__auto____0;
cljs$core$async$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24577__auto____1;
return cljs$core$async$state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto___27303,out))
})();
var state__24692__auto__ = (function (){var statearr_27298 = f__24691__auto__.call(null);
(statearr_27298[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto___27303);

return statearr_27298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto___27303,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args27316 = [];
var len__21576__auto___27386 = arguments.length;
var i__21577__auto___27387 = (0);
while(true){
if((i__21577__auto___27387 < len__21576__auto___27386)){
args27316.push((arguments[i__21577__auto___27387]));

var G__27388 = (i__21577__auto___27387 + (1));
i__21577__auto___27387 = G__27388;
continue;
} else {
}
break;
}

var G__27318 = args27316.length;
switch (G__27318) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27316.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__24690__auto___27390 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto___27390,out){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto___27390,out){
return (function (state_27356){
var state_val_27357 = (state_27356[(1)]);
if((state_val_27357 === (7))){
var inst_27352 = (state_27356[(2)]);
var state_27356__$1 = state_27356;
var statearr_27358_27391 = state_27356__$1;
(statearr_27358_27391[(2)] = inst_27352);

(statearr_27358_27391[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27357 === (1))){
var inst_27319 = (new Array(n));
var inst_27320 = inst_27319;
var inst_27321 = (0);
var state_27356__$1 = (function (){var statearr_27359 = state_27356;
(statearr_27359[(7)] = inst_27320);

(statearr_27359[(8)] = inst_27321);

return statearr_27359;
})();
var statearr_27360_27392 = state_27356__$1;
(statearr_27360_27392[(2)] = null);

(statearr_27360_27392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27357 === (4))){
var inst_27324 = (state_27356[(9)]);
var inst_27324__$1 = (state_27356[(2)]);
var inst_27325 = (inst_27324__$1 == null);
var inst_27326 = cljs.core.not.call(null,inst_27325);
var state_27356__$1 = (function (){var statearr_27361 = state_27356;
(statearr_27361[(9)] = inst_27324__$1);

return statearr_27361;
})();
if(inst_27326){
var statearr_27362_27393 = state_27356__$1;
(statearr_27362_27393[(1)] = (5));

} else {
var statearr_27363_27394 = state_27356__$1;
(statearr_27363_27394[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27357 === (15))){
var inst_27346 = (state_27356[(2)]);
var state_27356__$1 = state_27356;
var statearr_27364_27395 = state_27356__$1;
(statearr_27364_27395[(2)] = inst_27346);

(statearr_27364_27395[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27357 === (13))){
var state_27356__$1 = state_27356;
var statearr_27365_27396 = state_27356__$1;
(statearr_27365_27396[(2)] = null);

(statearr_27365_27396[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27357 === (6))){
var inst_27321 = (state_27356[(8)]);
var inst_27342 = (inst_27321 > (0));
var state_27356__$1 = state_27356;
if(cljs.core.truth_(inst_27342)){
var statearr_27366_27397 = state_27356__$1;
(statearr_27366_27397[(1)] = (12));

} else {
var statearr_27367_27398 = state_27356__$1;
(statearr_27367_27398[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27357 === (3))){
var inst_27354 = (state_27356[(2)]);
var state_27356__$1 = state_27356;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27356__$1,inst_27354);
} else {
if((state_val_27357 === (12))){
var inst_27320 = (state_27356[(7)]);
var inst_27344 = cljs.core.vec.call(null,inst_27320);
var state_27356__$1 = state_27356;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27356__$1,(15),out,inst_27344);
} else {
if((state_val_27357 === (2))){
var state_27356__$1 = state_27356;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27356__$1,(4),ch);
} else {
if((state_val_27357 === (11))){
var inst_27336 = (state_27356[(2)]);
var inst_27337 = (new Array(n));
var inst_27320 = inst_27337;
var inst_27321 = (0);
var state_27356__$1 = (function (){var statearr_27368 = state_27356;
(statearr_27368[(7)] = inst_27320);

(statearr_27368[(10)] = inst_27336);

(statearr_27368[(8)] = inst_27321);

return statearr_27368;
})();
var statearr_27369_27399 = state_27356__$1;
(statearr_27369_27399[(2)] = null);

(statearr_27369_27399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27357 === (9))){
var inst_27320 = (state_27356[(7)]);
var inst_27334 = cljs.core.vec.call(null,inst_27320);
var state_27356__$1 = state_27356;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27356__$1,(11),out,inst_27334);
} else {
if((state_val_27357 === (5))){
var inst_27320 = (state_27356[(7)]);
var inst_27324 = (state_27356[(9)]);
var inst_27329 = (state_27356[(11)]);
var inst_27321 = (state_27356[(8)]);
var inst_27328 = (inst_27320[inst_27321] = inst_27324);
var inst_27329__$1 = (inst_27321 + (1));
var inst_27330 = (inst_27329__$1 < n);
var state_27356__$1 = (function (){var statearr_27370 = state_27356;
(statearr_27370[(12)] = inst_27328);

(statearr_27370[(11)] = inst_27329__$1);

return statearr_27370;
})();
if(cljs.core.truth_(inst_27330)){
var statearr_27371_27400 = state_27356__$1;
(statearr_27371_27400[(1)] = (8));

} else {
var statearr_27372_27401 = state_27356__$1;
(statearr_27372_27401[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27357 === (14))){
var inst_27349 = (state_27356[(2)]);
var inst_27350 = cljs.core.async.close_BANG_.call(null,out);
var state_27356__$1 = (function (){var statearr_27374 = state_27356;
(statearr_27374[(13)] = inst_27349);

return statearr_27374;
})();
var statearr_27375_27402 = state_27356__$1;
(statearr_27375_27402[(2)] = inst_27350);

(statearr_27375_27402[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27357 === (10))){
var inst_27340 = (state_27356[(2)]);
var state_27356__$1 = state_27356;
var statearr_27376_27403 = state_27356__$1;
(statearr_27376_27403[(2)] = inst_27340);

(statearr_27376_27403[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27357 === (8))){
var inst_27320 = (state_27356[(7)]);
var inst_27329 = (state_27356[(11)]);
var tmp27373 = inst_27320;
var inst_27320__$1 = tmp27373;
var inst_27321 = inst_27329;
var state_27356__$1 = (function (){var statearr_27377 = state_27356;
(statearr_27377[(7)] = inst_27320__$1);

(statearr_27377[(8)] = inst_27321);

return statearr_27377;
})();
var statearr_27378_27404 = state_27356__$1;
(statearr_27378_27404[(2)] = null);

(statearr_27378_27404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24690__auto___27390,out))
;
return ((function (switch__24576__auto__,c__24690__auto___27390,out){
return (function() {
var cljs$core$async$state_machine__24577__auto__ = null;
var cljs$core$async$state_machine__24577__auto____0 = (function (){
var statearr_27382 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27382[(0)] = cljs$core$async$state_machine__24577__auto__);

(statearr_27382[(1)] = (1));

return statearr_27382;
});
var cljs$core$async$state_machine__24577__auto____1 = (function (state_27356){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_27356);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e27383){if((e27383 instanceof Object)){
var ex__24580__auto__ = e27383;
var statearr_27384_27405 = state_27356;
(statearr_27384_27405[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27356);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27383;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27406 = state_27356;
state_27356 = G__27406;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
cljs$core$async$state_machine__24577__auto__ = function(state_27356){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24577__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24577__auto____1.call(this,state_27356);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24577__auto____0;
cljs$core$async$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24577__auto____1;
return cljs$core$async$state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto___27390,out))
})();
var state__24692__auto__ = (function (){var statearr_27385 = f__24691__auto__.call(null);
(statearr_27385[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto___27390);

return statearr_27385;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto___27390,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args27407 = [];
var len__21576__auto___27481 = arguments.length;
var i__21577__auto___27482 = (0);
while(true){
if((i__21577__auto___27482 < len__21576__auto___27481)){
args27407.push((arguments[i__21577__auto___27482]));

var G__27483 = (i__21577__auto___27482 + (1));
i__21577__auto___27482 = G__27483;
continue;
} else {
}
break;
}

var G__27409 = args27407.length;
switch (G__27409) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27407.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__24690__auto___27485 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto___27485,out){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto___27485,out){
return (function (state_27451){
var state_val_27452 = (state_27451[(1)]);
if((state_val_27452 === (7))){
var inst_27447 = (state_27451[(2)]);
var state_27451__$1 = state_27451;
var statearr_27453_27486 = state_27451__$1;
(statearr_27453_27486[(2)] = inst_27447);

(statearr_27453_27486[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27452 === (1))){
var inst_27410 = [];
var inst_27411 = inst_27410;
var inst_27412 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_27451__$1 = (function (){var statearr_27454 = state_27451;
(statearr_27454[(7)] = inst_27411);

(statearr_27454[(8)] = inst_27412);

return statearr_27454;
})();
var statearr_27455_27487 = state_27451__$1;
(statearr_27455_27487[(2)] = null);

(statearr_27455_27487[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27452 === (4))){
var inst_27415 = (state_27451[(9)]);
var inst_27415__$1 = (state_27451[(2)]);
var inst_27416 = (inst_27415__$1 == null);
var inst_27417 = cljs.core.not.call(null,inst_27416);
var state_27451__$1 = (function (){var statearr_27456 = state_27451;
(statearr_27456[(9)] = inst_27415__$1);

return statearr_27456;
})();
if(inst_27417){
var statearr_27457_27488 = state_27451__$1;
(statearr_27457_27488[(1)] = (5));

} else {
var statearr_27458_27489 = state_27451__$1;
(statearr_27458_27489[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27452 === (15))){
var inst_27441 = (state_27451[(2)]);
var state_27451__$1 = state_27451;
var statearr_27459_27490 = state_27451__$1;
(statearr_27459_27490[(2)] = inst_27441);

(statearr_27459_27490[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27452 === (13))){
var state_27451__$1 = state_27451;
var statearr_27460_27491 = state_27451__$1;
(statearr_27460_27491[(2)] = null);

(statearr_27460_27491[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27452 === (6))){
var inst_27411 = (state_27451[(7)]);
var inst_27436 = inst_27411.length;
var inst_27437 = (inst_27436 > (0));
var state_27451__$1 = state_27451;
if(cljs.core.truth_(inst_27437)){
var statearr_27461_27492 = state_27451__$1;
(statearr_27461_27492[(1)] = (12));

} else {
var statearr_27462_27493 = state_27451__$1;
(statearr_27462_27493[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27452 === (3))){
var inst_27449 = (state_27451[(2)]);
var state_27451__$1 = state_27451;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27451__$1,inst_27449);
} else {
if((state_val_27452 === (12))){
var inst_27411 = (state_27451[(7)]);
var inst_27439 = cljs.core.vec.call(null,inst_27411);
var state_27451__$1 = state_27451;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27451__$1,(15),out,inst_27439);
} else {
if((state_val_27452 === (2))){
var state_27451__$1 = state_27451;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27451__$1,(4),ch);
} else {
if((state_val_27452 === (11))){
var inst_27415 = (state_27451[(9)]);
var inst_27419 = (state_27451[(10)]);
var inst_27429 = (state_27451[(2)]);
var inst_27430 = [];
var inst_27431 = inst_27430.push(inst_27415);
var inst_27411 = inst_27430;
var inst_27412 = inst_27419;
var state_27451__$1 = (function (){var statearr_27463 = state_27451;
(statearr_27463[(7)] = inst_27411);

(statearr_27463[(11)] = inst_27429);

(statearr_27463[(12)] = inst_27431);

(statearr_27463[(8)] = inst_27412);

return statearr_27463;
})();
var statearr_27464_27494 = state_27451__$1;
(statearr_27464_27494[(2)] = null);

(statearr_27464_27494[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27452 === (9))){
var inst_27411 = (state_27451[(7)]);
var inst_27427 = cljs.core.vec.call(null,inst_27411);
var state_27451__$1 = state_27451;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27451__$1,(11),out,inst_27427);
} else {
if((state_val_27452 === (5))){
var inst_27415 = (state_27451[(9)]);
var inst_27412 = (state_27451[(8)]);
var inst_27419 = (state_27451[(10)]);
var inst_27419__$1 = f.call(null,inst_27415);
var inst_27420 = cljs.core._EQ_.call(null,inst_27419__$1,inst_27412);
var inst_27421 = cljs.core.keyword_identical_QMARK_.call(null,inst_27412,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_27422 = (inst_27420) || (inst_27421);
var state_27451__$1 = (function (){var statearr_27465 = state_27451;
(statearr_27465[(10)] = inst_27419__$1);

return statearr_27465;
})();
if(cljs.core.truth_(inst_27422)){
var statearr_27466_27495 = state_27451__$1;
(statearr_27466_27495[(1)] = (8));

} else {
var statearr_27467_27496 = state_27451__$1;
(statearr_27467_27496[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27452 === (14))){
var inst_27444 = (state_27451[(2)]);
var inst_27445 = cljs.core.async.close_BANG_.call(null,out);
var state_27451__$1 = (function (){var statearr_27469 = state_27451;
(statearr_27469[(13)] = inst_27444);

return statearr_27469;
})();
var statearr_27470_27497 = state_27451__$1;
(statearr_27470_27497[(2)] = inst_27445);

(statearr_27470_27497[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27452 === (10))){
var inst_27434 = (state_27451[(2)]);
var state_27451__$1 = state_27451;
var statearr_27471_27498 = state_27451__$1;
(statearr_27471_27498[(2)] = inst_27434);

(statearr_27471_27498[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27452 === (8))){
var inst_27415 = (state_27451[(9)]);
var inst_27411 = (state_27451[(7)]);
var inst_27419 = (state_27451[(10)]);
var inst_27424 = inst_27411.push(inst_27415);
var tmp27468 = inst_27411;
var inst_27411__$1 = tmp27468;
var inst_27412 = inst_27419;
var state_27451__$1 = (function (){var statearr_27472 = state_27451;
(statearr_27472[(7)] = inst_27411__$1);

(statearr_27472[(8)] = inst_27412);

(statearr_27472[(14)] = inst_27424);

return statearr_27472;
})();
var statearr_27473_27499 = state_27451__$1;
(statearr_27473_27499[(2)] = null);

(statearr_27473_27499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24690__auto___27485,out))
;
return ((function (switch__24576__auto__,c__24690__auto___27485,out){
return (function() {
var cljs$core$async$state_machine__24577__auto__ = null;
var cljs$core$async$state_machine__24577__auto____0 = (function (){
var statearr_27477 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27477[(0)] = cljs$core$async$state_machine__24577__auto__);

(statearr_27477[(1)] = (1));

return statearr_27477;
});
var cljs$core$async$state_machine__24577__auto____1 = (function (state_27451){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_27451);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e27478){if((e27478 instanceof Object)){
var ex__24580__auto__ = e27478;
var statearr_27479_27500 = state_27451;
(statearr_27479_27500[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27451);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27478;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27501 = state_27451;
state_27451 = G__27501;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
cljs$core$async$state_machine__24577__auto__ = function(state_27451){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24577__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24577__auto____1.call(this,state_27451);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24577__auto____0;
cljs$core$async$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24577__auto____1;
return cljs$core$async$state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto___27485,out))
})();
var state__24692__auto__ = (function (){var statearr_27480 = f__24691__auto__.call(null);
(statearr_27480[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto___27485);

return statearr_27480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto___27485,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map