(defproject solar.beam/aws "0.0.1"
  :description "AWS utility library used at Beam Energy Labs"
  :url "http://beamenergy.solar"
  :license {:name "Eclipse Public License"
            :url  "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[environ "1.1.0"]
                 [org.clojure/clojure "1.9.0"]
                 [com.taoensso/timbre "4.10.0"]
                 [fierce/fierce-lambda "0.0.8"]
                 [bidi "2.1.3"]
                 [clj-time "0.14.0"]
                 [clj-http "3.9.0"]
                 [camel-snake-kebab "0.4.0"]
                 [amazonica "0.3.111" :exclusions [com.amazonaws/aws-java-sdk
                                                   com.amazonaws/amazon-kinesis-client]]
                 [com.amazonaws/aws-java-sdk-core "1.11.179"]
                 [com.amazonaws/aws-java-sdk-cognitoidp "1.11.179"]
                 [com.amazonaws/aws-java-sdk-dynamodb "1.11.224"]
                 [org.sharetribe/aws-sig4 "0.1.3"]]
  :omit-source true
  :source-paths ["src/main/clj"]
  :test-paths ["src/test/clj" "src/itest/clj"]
  :profiles {:dev     {:resource-paths ["src/test/resources" "src/itest/resources"]}
             :uberjar {:aot :all}}
  :uberjar-name "aws.jar")
