package iny;

import io.netty.handler.codec.http2.CompressorHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Settings;

public final class CompressedHttp2CodecBuilder extends Http2FrameCodecBuilder {
  @Override
  protected Http2FrameCodec build(
    Http2ConnectionDecoder decoder,
    Http2ConnectionEncoder encoder,
    Http2Settings initialSettings
  ) {
    Http2ConnectionEncoder wrappedEncoder =
      new CompressorHttp2ConnectionEncoder(encoder);

    Http2FrameListener wrappedListener =
      new DelegatingDecompressorFrameListener(decoder.connection(), decoder.frameListener());

    frameListener(wrappedListener);

    return super.build(decoder, wrappedEncoder, initialSettings);
  }
}
