/*
 * Decompiled with CFR 0.152.
 */
package de.androidpit.colorthief.test;

import de.androidpit.colorthief.ColorThief;
import de.androidpit.colorthief.MMCQ;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ColorThiefTest {
    public static void main(String[] args) throws IOException {
        ColorThiefTest.printStyleHeader();
        ColorThiefTest.test("examples/img/photo1.jpg");
        ColorThiefTest.test("examples/img/photo2.jpg");
        ColorThiefTest.test("examples/img/photo3.jpg");
    }

    private static void printStyleHeader() {
        System.out.println("<style>div.color{width:4em;height:4em;float:left;margin:0 1em 1em 0;}th{text-align:left}td{vertical-align:top;padding-right:1em}</style>");
    }

    private static void test(String pathname) throws IOException {
        System.out.println("<h1>Image: &quot;" + pathname + "&quot</h1>");
        BufferedImage img = ImageIO.read(new File(pathname));
        System.out.println("<h2>Dominant Color</h2>");
        MMCQ.CMap result = ColorThief.getColorMap(img, 5);
        MMCQ.VBox dominantColor = result.vboxes.get(0);
        ColorThiefTest.printVBox(dominantColor);
        System.out.println("<h2>Palette</h2>");
        result = ColorThief.getColorMap(img, 10);
        for (MMCQ.VBox vbox : result.vboxes) {
            ColorThiefTest.printVBox(vbox);
        }
    }

    private static void printVBox(MMCQ.VBox vbox) {
        int[] rgb = vbox.avg(false);
        String rgbString = ColorThiefTest.createRGBString(rgb);
        String rgbHexString = ColorThiefTest.createRGBHexString(rgb);
        StringBuilder line = new StringBuilder();
        line.append("<div>");
        line.append("<div class=\"color\" style=\"background:").append(rgbString).append(";\"></div>");
        line.append("<table><tr><th>Color code:</th><th>Volume &times pixel count:</th><th>VBox:</th></tr>");
        line.append("<tr><td>").append(rgbString).append(" / ").append(rgbHexString).append("</td>");
        int volume = vbox.volume(false);
        int count = vbox.count(false);
        line.append("<td>").append(String.format("%,d", volume)).append(" &times; ").append(String.format("%,d", count)).append(" = ").append(String.format("%,d", volume * count)).append("</td>");
        line.append("<td>").append(vbox.toString()).append("</td></tr></table>");
        line.append("<div style=\"clear:both\"></div>");
        line.append("</div>");
        System.out.println(line);
    }

    private static String createRGBString(int[] rgb) {
        return "rgb(" + rgb[0] + "," + rgb[1] + "," + rgb[2] + ")";
    }

    private static String createRGBHexString(int[] rgb) {
        String rgbHex = Integer.toHexString(rgb[0] << 16 | rgb[1] << 8 | rgb[2]);
        int length = rgbHex.length();
        if (length < 6) {
            rgbHex = "00000".substring(0, 6 - length) + rgbHex;
        }
        return "#" + rgbHex;
    }
}

