/*
 * Decompiled with CFR 0.152.
 */
package de.androidpit.colorthief.test;

import de.androidpit.colorthief.ColorThief;
import de.androidpit.colorthief.MMCQ;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ColorThiefPerformanceTest {
    private static final int NUM_TESTS_WARMUP = 500;
    private static final int NUM_TESTS = 500;

    public static void main(String[] args) throws Exception {
        BufferedImage img1 = ImageIO.read(new File("examples/img/photo1.jpg"));
        BufferedImage img2 = ImageIO.read(new File("examples/img/photo2.jpg"));
        BufferedImage img3 = ImageIO.read(new File("examples/img/photo3.jpg"));
        System.out.println("Warming up...");
        ColorThiefPerformanceTest.test(img1, img2, img3, 500);
        System.out.println("Testing...");
        long start = System.currentTimeMillis();
        ColorThiefPerformanceTest.test(img1, img2, img3, 500);
        long end = System.currentTimeMillis();
        long total = end - start;
        System.out.println("Total time = " + total + " ms / per image = " + (double)total / 500.0 / 3.0 + " ms");
    }

    private static void test(BufferedImage img1, BufferedImage img2, BufferedImage img3, int max) throws IOException {
        long sum = 0L;
        for (int i = 0; i < max; ++i) {
            if (i % 100 == 0) {
                System.out.println("Round " + (i + 1) + " of " + max + "...");
            }
            MMCQ.CMap result = ColorThief.getColorMap(img1, 10);
            sum += (long)result.vboxes.size();
            result = ColorThief.getColorMap(img2, 10);
            sum += (long)result.vboxes.size();
            result = ColorThief.getColorMap(img3, 10);
            sum += (long)result.vboxes.size();
        }
        System.out.println("Finished (sum = " + sum + ")");
    }
}

