;;;; user apis
(ns wexin.users
  (:require [clj-http.client :as http]
            [cheshire.core :as json]
            [clojure.xml :as xml]
            [wexin.core :as wexin :refer [api]])
  (:gen-class))
(defmethod api {:type :qi-ye-we-xin :api :user-info}
  [{:keys [userid access_token]}]
  (let [req (http/get "https://qyapi.weixin.qq.com/cgi-bin/user/get"
                {:query-params
                  {"access_token" access_token
                   "userid" userid}}
                :as :json
                :accept :json)
        x (json/parse-string (:body req) true)]
      (conj x {:userid userid})))


(defmethod api {:type :qi-ye-we-xin :api :users-list}
    [{:keys [access_token agentid] :as params}]
    (let [req (http/get "https://qyapi.weixin.qq.com/cgi-bin/agent/get"
                  {:query-params
                    {"access_token" access_token
                     "agentid" agentid}}
                  :as :json
                  :accept :json)
           c (json/parse-string (:body req) true)
           uids  (get-in c [:allow_userinfos :user]) 
           userinfo-fn (fn [uidmap] (api (conj params {:api :user-info} uidmap)))]
        (doall (map userinfo-fn uids))))
