;;;; department apis
(ns wexin.deps
  (:require [clj-http.client :as http]
            [cheshire.core :as json]
            [clojure.xml :as xml]
            [wexin.core :as wexin :refer [api]])
  (:gen-class))

(defmethod api {:type :ding-yue-hao :api :tag-list}
  [{:keys [access_token]}]
  (http/get "https://api.weixin.qq.com/cgi-bin/tags/get"
            {:query-params
             {"access_token" access_token}}
            :as :json
            :accept :json))

(defmethod api {:type :qi-ye-we-xin :api :tag-list}
  [{:keys [access_token]}]
  (let [req (http/get "https://qyapi.weixin.qq.com/cgi-bin/tag/list"
              {:query-params
                {"access_token" access_token}}
              :as :json
              :accept :json)
         c (json/parse-string (:body req) true)]
    (get-in c [:taglist])))

(defmethod api {:type :ding-yue-hao :api :users-with-tag}
  [{:keys [access_token tagid next_openid]}]
  (http/post (str "https://api.weixin.qq.com/cgi-bin/user/tag/get?access_token=" access_token)
             {:body (json/generate-string
                     {"tagid" tagid "next_openid" next_openid})}
             :as :json
             :content-type :json :accept :json))

(defmethod api {:type :qi-ye-we-xin :api :users-with-tag}
  [{:keys [access_token tagid]}]
  (http/get "https://qyapi.weixin.qq.com/cgi-bin/tag/get"
            {:query-params
             {"access_token" access_token
              "tagid" tagid}}
            :as :json
            :accept :json))


(defmethod api {:type :qi-ye-we-xin :api :department-list}
    [{:keys [access_token]}]
    (let [req (http/get "https://qyapi.weixin.qq.com/cgi-bin/department/list"
                  {:query-params
                    {"access_token" access_token}}
                  :as :json
                  :accept :json)
           c (json/parse-string (:body req) true)
           depinfo  (get-in c [:department])]
      (if (empty? depinfo) [{:name "未授权部门或参数未配置对"}] depinfo)))
    
