(ns boot-docker.docker
  (require [boot.util :as util]))

(defn image-name [org r]
  (when-not (empty? r)
    (str  (if (empty? org) "" (str org "/")) r))) 


(defn taglist [org r tags]
  (if (empty? tags)
    [(image-name org r)]
    (map #(str (image-name org r) ":" %1) tags)))

(defn- build-opts [org r tags]
  (interleave (repeat "-t")
              (taglist org r tags)))

(defn build-image [ctx-dir org repo tags]
  (binding [util/*sh-dir* (.getAbsolutePath ctx-dir)]
    ((apply util/sh "docker" "build"
            (concat
              (build-opts org repo tags)
              ["."])))))

