# signal-logging

Logging is hard - https://signal-ai.getoutline.com/doc/logging-oiwQo3JNFl

This library attempts to pave a road so you have less to do. It implements zero code so dependency hell is the only risk.

## Usage

Include this libary in your project.clj
```
[signal.logging "0.1.0-SNAPSHOT"]
```

Then when you need to log something, call out to (tools.logging)[https://github.com/clojure/tools.logging] as you normally would:
```clj
(require '[clojure.tools.logging :as log])

(log/info "hello world")
```

### Configure the log level
With this library you don't need to worry about writing your own `logback.xml` files. You can simply configure the log level using an environment variable:
```
LOG_LEVEL=DEBUG lein repl
```

## When to not use this library
If this configuration is too simple, this library is potentially not for you. You can write your own `logback.xml` and configure this at runtime with `java -Dlogback.configurationFile=/path/to/config.xml -jar app.jar` but it will probably make your build even more complicated.

## Future enhancements

### Timbre?
Does (Timbre)[https://github.com/ptaoussanis/timbre] provide a better alternative to logging?

### Structured logging?
AWS Cloudwatch logs will parse JSON formatted logs to make it even easier to search over - https://aws.amazon.com/about-aws/whats-new/2015/01/20/amazon-cloudwatch-logs-json-log-format-support/
Logback supports logging JSON - https://medium.com/@krishankantsinghal/structured-logging-why-and-how-to-achieve-in-java-33974d22accb

Still to be tested if these two marry up in practice like they do in theory

## License

Copyright © 2020 FIXME

This program and the accompanying materials are made available under the
terms of the Eclipse Public License 2.0 which is available at
http://www.eclipse.org/legal/epl-2.0.

This Source Code may also be made available under the following Secondary
Licenses when the conditions for such availability set forth in the Eclipse
Public License, v. 2.0 are satisfied: GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or (at your
option) any later version, with the GNU Classpath Exception which is available
at https://www.gnu.org/software/classpath/license.html.
