(ns signal-logging.core
  (:import [org.slf4j LoggerFactory]
           [org.slf4j.bridge SLF4JBridgeHandler]
           [ch.qos.logback.classic Logger Level]))

(defn init! []
  (SLF4JBridgeHandler/removeHandlersForRootLogger)
  (SLF4JBridgeHandler/install))


(defn set-root-log-level [^Level newLevel]
  (let [^Logger root (LoggerFactory/getLogger Logger/ROOT_LOGGER_NAME)]
    (.setLevel root newLevel)))
