(ns lein-git-version.plugin
  (:require
   [clojure.pprint]
   [leiningen.git-version :refer [get-git-ref get-git-last-message] :as gv]
   [clojure.string :as string])
  (:import (java.io File)
           (java.util.regex Pattern)))

(defn middleware
  [project]
  (let [fs       File/separator
        fsp      (Pattern/quote fs)
        ns (str "(ns " (cond
                         (:git-version-root-ns project)
                         (:git-version-root-ns project)
                         (:git-version-path project)
                         (if-let [path (:git-version-path project)]
                           (-> path
                               (string/replace (:root project) "")
                               (string/replace (re-pattern (str "^" fsp "src" fsp)) "")
                               (string/replace fs "."))
                           (:name project))
                         :else "x")
                ".version)\n")
        code     (str
                  ";; Do not edit.  Generated by lein-git-version plugin.\n"
                  ns
                  "(def timestamp " (gv/get-git-ts) ")\n"
                  "(def version \"" (:version project) "\")\n"
                  "(def gitref \"" (get-git-ref) "\")\n"
                  "(def gitmsg \"" (get-git-last-message) "\")\n")
        proj-dir (.toLowerCase (.replace (:name project) \- \_))
        filename (if (:git-version-path project)
                   (str (:git-version-path project) "/version.cljc")
                   (str (or (first (:source-paths project)) "src") "/"
                        proj-dir "/version.cljc"))]
    (spit filename code)
    project))
