# lein-git-version

```clojure
:plugins [[shmish111/lein-git-version "1.0.13"]]
```

This auto-generates a `version.clj` file with git information for inclusion in
your artifacts.

> If your project is not using the scheme above, you can change the folder for
> the `version.clj` file by setting `:git-version-path` in your `project.clj`
> file. Example:
>
> ```
> :git-version-path "src/prefix/my-project"
> ```

## Usage

Put `[shmish111/lein-git-version "1.0.13"]` into the `:plugins` vector
of your `project.clj`.

Example:

```
$ lein new nifty
Generating a project called nifty based on the 'default' template.
The default template is intended for library projects, not applications.
To see other templates (app, plugin, etc), try `lein help new`.
$ cd nifty
$ vim project.clj
$ cat project.clj
(defproject nifty "0.1.0-SNAPSHOT"
  :description "FIXME: write description"
  :url "http://example.com/FIXME"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[org.clojure/clojure "1.8.0"]]
  :plugins [[shmish111/lein-git-version "1.0.12"]])
$ git init
Initialized empty Git repository in /private/var/folders/wv/9lkw754x31l1m4b228b663400000gn/T/tmp.OUbfsZ5JN6/nifty/.git/
$ git add . && git commit -m "initial"
[master (root-commit) 305ca69] initial
 8 files changed, 286 insertions(+)
 create mode 100644 .gitignore
 create mode 100644 CHANGELOG.md
 create mode 100644 LICENSE
 create mode 100644 README.md
 create mode 100644 doc/intro.md
 create mode 100644 project.clj
 create mode 100644 src/nifty/core.clj
 create mode 100644 test/nifty/core_test.clj
$ lein git-version
Version: 0.1.0-SNAPSHOT
 commit 305ca69142b643e701e118589265c3100f8fa128
Author: Gary Verhaegen <gary.verhaegen@style.com>
Date:   Tue Jul 19 14:18:48 2016 +0100

    initial
$ cat src/nifty/version.clj
;; Do not edit.  Generated by lein-git-version plugin.
(ns nifty.version)
(def version "0.1.0-SNAPSHOT")
(def gitref "305ca69142b643e701e118589265c3100f8fa128")
(def gitmsg "commit 305ca69142b643e701e118589265c3100f8fa128
Author: Gary Verhaegen <gary.verhaegen@style.com>
Date:   Tue Jul 19 14:18:48 2016 +0100

    initial")
$
```

## License

Copyright © 2012 Colin Steele

Distributed under the Eclipse Public License, the same as Clojure.
