(ns bhatkhande.db
  (:require [clojure.spec.alpha :as s]
            [bhatkhande.spec :as us]))

(defn percentage-95
  [i]
  (let [ iw (js/parseInt i)]
    (- iw (* 0.05 iw))))

(def dispinfo
  {:x 20 :y 30 :under 30
   :x-start 20
   :y-inc 80
   :x-end (percentage-95 (.-innerWidth js/window))
   :y-end (percentage-95 (.-innerHeight js/window))
   :over 30
   :kan-raise 10
   :octave 15
   :part-header-font-size 30
   :comp-label-font-size 35
   :header-y-spacing 50
   :sam-khaali 35 
   :font-size 20 :spacing 10 :text-align :left})

(def iseq1 [[{::us/note [:madhyam :s]}]
            [{::us/note [:taar :r]}]
            [{::us/note [:mandra :-n]}]
            [{::us/note [:madhyam :r]
              ::us/kan [:madhyam :-g]}]
            [{::us/note [:taar :r]}
             {::us/note [:mandra :n]
              ::us/kan [:madhyam :-g]}
             {::us/note [:madhyam :s]}]
            [{::us/note [:madhyam :-g]}
             {::us/note [:madhyam :m]}]
            [{::us/note [:taar :m+]}]
            [{::us/note [:taar :r]
              ::us/kan [:taar :-g]}]
            [{::us/note [:mandra :r]
              ::us/kan [:mandra :-g]}]
            [{::us/note [:madhyam :s]}]
            [{::us/note [:taar :r]}]
            [{::us/note [:mandra :-n]}]
            [{::us/note [:madhyam :r]
              ::us/kan [:madhyam :-g]}]
            [{::us/note [:taar :r]}
             {::us/note [:mandra :n]
              ::us/kan [:madhyam :-g]}
             {::us/note [:madhyam :s]}]
            [{::us/note [:madhyam :-g]}
             {::us/note [:madhyam :m]}]
            [{::us/note [:madhyam :s]}]
            [{::us/note [:taar :r]}]
            [{::us/note [:madhyam :g]}]
            [{::us/note [:madhyam :g]}]
            [{::us/note [:madhyam :g]}]
            [{::us/note [:madhyam :r] ::us/meend-start true}]
            [{::us/note [:madhyam :r] ::us/meend-end true}]
            ])

(def antara1 [[{::us/note [:madhyam :s]}]
            [{::us/note [:madhyam :r]}]
            [{::us/note [:mandra :-n]}]
            [{::us/note [:madhyam :r]
              ::us/kan [:madhyam :s] }]
            [{::us/note [:madhyam :s]}]
            [{::us/note [:madhyam :r]}]
            [{::us/note [:mandra :-n]}]
            [{::us/note [:madhyam :s]}]
            [{::us/note [:madhyam :r]}]
            [{::us/note [:mandra :-n]}]
            ])

(def test1 
  {::us/m-noteseq iseq1
   ::us/taal {::us/num-beats 10 ::us/taal-name :jhaptaal
    ::us/taal-label "झपताल"
    ::us/sam-khaali {1 "x" 3 "2" 8 "4" 6 "o"}
              ::us/bhaags [2 3 2 3]}
   ::us/part-label "partname"
   })

(def comp1 {::us/parts [{::us/m-noteseq iseq1
                         ::us/part-label "Sthayi"
                         }
                        {::us/m-noteseq antara1
                         ::us/part-label "Antara"
                         }
                        ]
            ::us/taal {::us/num-beats 10 ::us/taal-name :jhaptaal
                       ::us/taal-label "झपताल"
                       ::us/sam-khaali {1 "x" 3 "2" 8 "4" 6 "o"}
                       ::us/bhaags [2 3 2 3]}
            ::us/comp-id "fadaccaa"
            ::us/comp-label "Bandish name"})
(def default-db
  {:name "re-frame" })
