// Compiled by ClojureScript 1.7.228 {:static-fns true, :optimize-constants true}
goog.provide('shale.webapp');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('ajax.core');
goog.require('secretary.core');
goog.require('reagent.session');
goog.require('cemerick.url');
goog.require('accountant.core');
shale.webapp.delete_session = (function shale$webapp$delete_session(session_id){
return ajax.core.DELETE([cljs.core.str("/sessions/"),cljs.core.str(session_id)].join(''));
});
shale.webapp.get_node = (function shale$webapp$get_node(id,success_fn){
return ajax.core.GET.cljs$core$IFn$_invoke$arity$variadic([cljs.core.str("/nodes/"),cljs.core.str(id)].join(''),cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$handler,success_fn], null)], 0));
});
shale.webapp.get_nodes = (function shale$webapp$get_nodes(success_fn){
return ajax.core.GET.cljs$core$IFn$_invoke$arity$variadic("/nodes",cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$handler,success_fn], null)], 0));
});
shale.webapp.get_session = (function shale$webapp$get_session(id,success_fn){
return ajax.core.GET.cljs$core$IFn$_invoke$arity$variadic([cljs.core.str("/sessions/"),cljs.core.str(id)].join(''),cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$handler,success_fn], null)], 0));
});
shale.webapp.get_sessions = (function shale$webapp$get_sessions(success_fn){
return ajax.core.GET.cljs$core$IFn$_invoke$arity$variadic("/sessions",cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$handler,success_fn], null)], 0));
});
shale.webapp.set_session_reservation = (function shale$webapp$set_session_reservation(session_id,reserved,finally_fn){
return ajax.core.PUT.cljs$core$IFn$_invoke$arity$variadic([cljs.core.str("/sessions/"),cljs.core.str(session_id)].join(''),cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$format,cljs.core.cst$kw$json,cljs.core.cst$kw$params,new cljs.core.PersistentArrayMap(null, 1, ["reserved",reserved], null),cljs.core.cst$kw$finally,finally_fn], null)], 0));
});
shale.webapp.a_href_text = (function shale$webapp$a_href_text(text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,text], null),text], null);
});
shale.webapp.host_port = (function shale$webapp$host_port(s){
var G__13339 = ":";
var G__13340 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$host,cljs.core.cst$kw$port).call(null,cemerick.url.url.cljs$core$IFn$_invoke$arity$1(s));
return (clojure.string.join.cljs$core$IFn$_invoke$arity$2 ? clojure.string.join.cljs$core$IFn$_invoke$arity$2(G__13339,G__13340) : clojure.string.join.call(null,G__13339,G__13340));
});
shale.webapp.node_component = (function shale$webapp$node_component(node){
var url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(node,"url");
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(node,"id");
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$btn_DASH_group,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$node$btn$btn_DASH_default,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,[cljs.core.str("/manage/node/"),cljs.core.str(id)].join('')], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_share_DASH_alt], null),shale.webapp.host_port(url)], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,id], null));
});
shale.webapp.node_detail_component = (function shale$webapp$node_detail_component(node){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table$table,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,"URL"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,shale.webapp.a_href_text(cljs.core.get.cljs$core$IFn$_invoke$arity$2(node,"url"))], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,"Tags"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",cljs.core.get.cljs$core$IFn$_invoke$arity$2(node,"tags"))], null)], null)], null)], null);
});
shale.webapp.node_list_component = (function shale$webapp$node_list_component(){
var nodes = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
var load_nodes = ((function (nodes){
return (function (){
return shale.webapp.get_nodes(((function (nodes){
return (function (p1__13341_SHARP_){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(nodes,p1__13341_SHARP_) : cljs.core.reset_BANG_.call(null,nodes,p1__13341_SHARP_));
});})(nodes))
);
});})(nodes))
;
load_nodes();

setInterval(load_nodes,(5000));

return ((function (nodes,load_nodes){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul$node_DASH_list,(function (){var iter__6808__auto__ = ((function (nodes,load_nodes){
return (function shale$webapp$node_list_component_$_iter__13348(s__13349){
return (new cljs.core.LazySeq(null,((function (nodes,load_nodes){
return (function (){
var s__13349__$1 = s__13349;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__13349__$1);
if(temp__4425__auto__){
var s__13349__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__13349__$2)){
var c__6806__auto__ = cljs.core.chunk_first(s__13349__$2);
var size__6807__auto__ = cljs.core.count(c__6806__auto__);
var b__13351 = cljs.core.chunk_buffer(size__6807__auto__);
if((function (){var i__13350 = (0);
while(true){
if((i__13350 < size__6807__auto__)){
var node = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6806__auto__,i__13350);
cljs.core.chunk_append(b__13351,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [shale.webapp.node_component,node], null)], null));

var G__13354 = (i__13350 + (1));
i__13350 = G__13354;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__13351),shale$webapp$node_list_component_$_iter__13348(cljs.core.chunk_rest(s__13349__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__13351),null);
}
} else {
var node = cljs.core.first(s__13349__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [shale.webapp.node_component,node], null)], null),shale$webapp$node_list_component_$_iter__13348(cljs.core.rest(s__13349__$2)));
}
} else {
return null;
}
break;
}
});})(nodes,load_nodes))
,null,null));
});})(nodes,load_nodes))
;
return iter__6808__auto__((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(nodes) : cljs.core.deref.call(null,nodes)));
})()], null);
});
;})(nodes,load_nodes))
});
shale.webapp.browser_icon_component = (function shale$webapp$browser_icon_component(browser){
var G__13356 = browser;
switch (G__13356) {
case "chrome":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_chrome,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,browser], null)], null);

break;
case "firefox":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_firefox,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,browser], null)], null);

break;
default:
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_laptop,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,browser], null)], null);

}
});
shale.webapp.reserve_button_component = (function shale$webapp$reserve_button_component(session,reserving,reserve_fn){
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(session,"id");
var reserved = cljs.core.get.cljs$core$IFn$_invoke$arity$2(session,"reserved");
var title = (cljs.core.truth_(reserved)?"Unreserve session":"Reserve session");
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_default,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$title,title,cljs.core.cst$kw$on_DASH_click,((function (id,reserved,title){
return (function (){
var G__13359 = !(cljs.core.boolean$(reserved));
return (reserve_fn.cljs$core$IFn$_invoke$arity$1 ? reserve_fn.cljs$core$IFn$_invoke$arity$1(G__13359) : reserve_fn.call(null,G__13359));
});})(id,reserved,title))
], null),(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.fromArray([id], true),reserving))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_spinner$fa_DASH_spin], null):(cljs.core.truth_(reserved)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_lock], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_unlock], null)))], null);
});
shale.webapp.destroy_button_component = (function shale$webapp$destroy_button_component(session,deleting,delete_fn){
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(session,"id");
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_default,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$title,"Destroy session",cljs.core.cst$kw$on_DASH_click,delete_fn], null),(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.fromArray([id], true),deleting))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_spinner$fa_DASH_spin], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_remove], null))], null);
});
shale.webapp.session_component = (function shale$webapp$session_component(session){
var deleting = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
var reserving = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
return ((function (deleting,reserving){
return (function (session__$1){
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(session__$1,"id");
var browser = cljs.core.get.cljs$core$IFn$_invoke$arity$2(session__$1,"browser_name");
var delete_fn = ((function (id,browser,deleting,reserving){
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(deleting,((function (id,browser,deleting,reserving){
return (function (p1__13360_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__13360_SHARP_,id);
});})(id,browser,deleting,reserving))
);

return shale.webapp.delete_session(id);
});})(id,browser,deleting,reserving))
;
var remove_from_reserving_BANG_ = ((function (id,browser,delete_fn,deleting,reserving){
return (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(reserving,((function (id,browser,delete_fn,deleting,reserving){
return (function (p1__13361_SHARP_){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(cljs.core.PersistentHashSet.fromArray([id], true)),p1__13361_SHARP_);
});})(id,browser,delete_fn,deleting,reserving))
);
});})(id,browser,delete_fn,deleting,reserving))
;
var reserve_fn = ((function (id,browser,delete_fn,remove_from_reserving_BANG_,deleting,reserving){
return (function (reserve){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(reserving,((function (id,browser,delete_fn,remove_from_reserving_BANG_,deleting,reserving){
return (function (p1__13362_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__13362_SHARP_,id);
});})(id,browser,delete_fn,remove_from_reserving_BANG_,deleting,reserving))
);

return shale.webapp.set_session_reservation(id,reserve,remove_from_reserving_BANG_);
});})(id,browser,delete_fn,remove_from_reserving_BANG_,deleting,reserving))
;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$btn_DASH_group,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$session$btn$btn_DASH_default,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,[cljs.core.str("/manage/session/"),cljs.core.str(id)].join('')], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [shale.webapp.browser_icon_component,browser], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,id], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [shale.webapp.reserve_button_component,session__$1,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(reserving) : cljs.core.deref.call(null,reserving)),reserve_fn], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [shale.webapp.destroy_button_component,session__$1,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(deleting) : cljs.core.deref.call(null,deleting)),delete_fn], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,id], null));
});
;})(deleting,reserving))
});
shale.webapp.session_detail_component = (function shale$webapp$session_detail_component(session){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table$table,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,"Webdriver ID"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,cljs.core.get.cljs$core$IFn$_invoke$arity$2(session,"webdriver_id")], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,"Browser"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,cljs.core.get.cljs$core$IFn$_invoke$arity$2(session,"browser_name")], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,"Reserved"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(session,"reserved"))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_check], null):null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,"Tags"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",cljs.core.get.cljs$core$IFn$_invoke$arity$2(session,"tags"))], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,"Node"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(session,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["node","id"], null))], null),shale.webapp.host_port(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(session,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["node","url"], null)))], null)], null)], null)], null)], null);
});
shale.webapp.session_list_component = (function shale$webapp$session_list_component(){
var sessions = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
var load_sessions = ((function (sessions){
return (function (){
return shale.webapp.get_sessions(((function (sessions){
return (function (p1__13363_SHARP_){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(sessions,p1__13363_SHARP_) : cljs.core.reset_BANG_.call(null,sessions,p1__13363_SHARP_));
});})(sessions))
);
});})(sessions))
;
load_sessions();

setInterval(load_sessions,(5000));

return ((function (sessions,load_sessions){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul$session_DASH_list,(function (){var iter__6808__auto__ = ((function (sessions,load_sessions){
return (function shale$webapp$session_list_component_$_iter__13370(s__13371){
return (new cljs.core.LazySeq(null,((function (sessions,load_sessions){
return (function (){
var s__13371__$1 = s__13371;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__13371__$1);
if(temp__4425__auto__){
var s__13371__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__13371__$2)){
var c__6806__auto__ = cljs.core.chunk_first(s__13371__$2);
var size__6807__auto__ = cljs.core.count(c__6806__auto__);
var b__13373 = cljs.core.chunk_buffer(size__6807__auto__);
if((function (){var i__13372 = (0);
while(true){
if((i__13372 < size__6807__auto__)){
var session = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6806__auto__,i__13372);
cljs.core.chunk_append(b__13373,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [shale.webapp.session_component,session], null)], null));

var G__13376 = (i__13372 + (1));
i__13372 = G__13376;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__13373),shale$webapp$session_list_component_$_iter__13370(cljs.core.chunk_rest(s__13371__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__13373),null);
}
} else {
var session = cljs.core.first(s__13371__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [shale.webapp.session_component,session], null)], null),shale$webapp$session_list_component_$_iter__13370(cljs.core.rest(s__13371__$2)));
}
} else {
return null;
}
break;
}
});})(sessions,load_sessions))
,null,null));
});})(sessions,load_sessions))
;
return iter__6808__auto__((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(sessions) : cljs.core.deref.call(null,sessions)));
})()], null);
});
;})(sessions,load_sessions))
});
shale.webapp.management_page_header = (function shale$webapp$management_page_header(var_args){
var args__7101__auto__ = [];
var len__7094__auto___13378 = arguments.length;
var i__7095__auto___13379 = (0);
while(true){
if((i__7095__auto___13379 < len__7094__auto___13378)){
args__7101__auto__.push((arguments[i__7095__auto___13379]));

var G__13380 = (i__7095__auto___13379 + (1));
i__7095__auto___13379 = G__13380;
continue;
} else {
}
break;
}

var argseq__7102__auto__ = ((((0) < args__7101__auto__.length))?(new cljs.core.IndexedSeq(args__7101__auto__.slice((0)),(0))):null);
return shale.webapp.management_page_header.cljs$core$IFn$_invoke$arity$variadic(argseq__7102__auto__);
});

shale.webapp.management_page_header.cljs$core$IFn$_invoke$arity$variadic = (function (body){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h2$text_DASH_center,"Shale Management Console"], null),body], null);
});

shale.webapp.management_page_header.cljs$lang$maxFixedArity = (0);

shale.webapp.management_page_header.cljs$lang$applyTo = (function (seq13377){
return shale.webapp.management_page_header.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq13377));
});
shale.webapp.home_page = (function shale$webapp$home_page(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h2,"Shale"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$nav,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,"/manage"], null),"Management Console"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,"/docs"], null),"API Docs"], null)], null)], null)], null)], null);
});
shale.webapp.docs_page = (function shale$webapp$docs_page(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h2,"Shale"], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,shale.webapp.a_href_text("/sessions"),"Active Selenium sessions."], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,shale.webapp.a_href_text("/sessions/:id"),[cljs.core.str("A session identified by id."),cljs.core.str("Accepts GET, PUT, & DELETE.")].join('')], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,shale.webapp.a_href_text("/sessions/refresh"),[cljs.core.str("POST to refresh all sessions. This shuldn't be necessary in "),cljs.core.str("production since refreshes are scheduled regularly.")].join('')], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,shale.webapp.a_href_text("/nodes"),"Active Selenium nodes"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,shale.webapp.a_href_text("/nodes/:id"),[cljs.core.str("A node identified by id."),cljs.core.str("Accepts GET, PUT, & DELETE.")].join('')], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,shale.webapp.a_href_text("/nodes/refresh"),"POST to refresh all nodes."], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,shale.webapp.a_href_text("/proxies"),"Proxies available for use with new sessions."], null)], null)], null);
});
shale.webapp.management_page = (function shale$webapp$management_page(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [shale.webapp.management_page_header,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_md_DASH_3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h3,"Nodes"], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [shale.webapp.node_list_component], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_md_DASH_5,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h3,"Sessions"], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [shale.webapp.session_list_component], null)], null)], null);
});
shale.webapp.node_page = (function shale$webapp$node_page(id){
var node = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
shale.webapp.get_node(id,((function (node){
return (function (p1__13381_SHARP_){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(node,p1__13381_SHARP_) : cljs.core.reset_BANG_.call(null,node,p1__13381_SHARP_));
});})(node))
);

return ((function (node){
return (function (id__$1){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [shale.webapp.management_page_header,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_md_DASH_6$col_DASH_md_DASH_offset_DASH_3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h3$text_DASH_center,[cljs.core.str("Node "),cljs.core.str(id__$1)].join('')], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [shale.webapp.node_detail_component,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(node) : cljs.core.deref.call(null,node))], null)], null)], null);
});
;})(node))
});
shale.webapp.session_page = (function shale$webapp$session_page(id){
var session = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
shale.webapp.get_session(id,((function (session){
return (function (p1__13382_SHARP_){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(session,p1__13382_SHARP_) : cljs.core.reset_BANG_.call(null,session,p1__13382_SHARP_));
});})(session))
);

return ((function (session){
return (function (id__$1){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [shale.webapp.management_page_header,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_md_DASH_6$col_DASH_md_DASH_offset_DASH_3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h3$text_DASH_center,[cljs.core.str("Session "),cljs.core.str(id__$1)].join('')], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [shale.webapp.session_detail_component,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(session) : cljs.core.deref.call(null,session))], null)], null)], null);
});
;})(session))
});
shale.webapp.current_page = (function shale$webapp$current_page(){
return reagent.session.get(cljs.core.cst$kw$current_DASH_page);
});
var action__13236__auto___13386 = (function (params__13237__auto__){
if(cljs.core.map_QMARK_(params__13237__auto__)){
var map__13383 = params__13237__auto__;
var map__13383__$1 = ((((!((map__13383 == null)))?((((map__13383.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13383.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13383):map__13383);
return reagent.session.put_BANG_(cljs.core.cst$kw$current_DASH_page,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Var(function(){return shale.webapp.home_page;},cljs.core.cst$sym$shale$webapp_SLASH_home_DASH_page,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$shale$webapp,cljs.core.cst$sym$home_DASH_page,"/home/matt/shale/src/cljs/shale/webapp.cljs",16,1,158,158,cljs.core.list(cljs.core.PersistentVector.EMPTY),null,(cljs.core.truth_(shale.webapp.home_page)?shale.webapp.home_page.cljs$lang$test:null)]))], null));
} else {
if(cljs.core.vector_QMARK_(params__13237__auto__)){
var vec__13385 = params__13237__auto__;
return reagent.session.put_BANG_(cljs.core.cst$kw$current_DASH_page,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Var(function(){return shale.webapp.home_page;},cljs.core.cst$sym$shale$webapp_SLASH_home_DASH_page,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$shale$webapp,cljs.core.cst$sym$home_DASH_page,"/home/matt/shale/src/cljs/shale/webapp.cljs",16,1,158,158,cljs.core.list(cljs.core.PersistentVector.EMPTY),null,(cljs.core.truth_(shale.webapp.home_page)?shale.webapp.home_page.cljs$lang$test:null)]))], null));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/",action__13236__auto___13386);

var action__13236__auto___13390 = (function (params__13237__auto__){
if(cljs.core.map_QMARK_(params__13237__auto__)){
var map__13387 = params__13237__auto__;
var map__13387__$1 = ((((!((map__13387 == null)))?((((map__13387.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13387.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13387):map__13387);
return reagent.session.put_BANG_(cljs.core.cst$kw$current_DASH_page,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Var(function(){return shale.webapp.management_page;},cljs.core.cst$sym$shale$webapp_SLASH_management_DASH_page,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$shale$webapp,cljs.core.cst$sym$management_DASH_page,"/home/matt/shale/src/cljs/shale/webapp.cljs",22,1,186,186,cljs.core.list(cljs.core.PersistentVector.EMPTY),null,(cljs.core.truth_(shale.webapp.management_page)?shale.webapp.management_page.cljs$lang$test:null)]))], null));
} else {
if(cljs.core.vector_QMARK_(params__13237__auto__)){
var vec__13389 = params__13237__auto__;
return reagent.session.put_BANG_(cljs.core.cst$kw$current_DASH_page,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Var(function(){return shale.webapp.management_page;},cljs.core.cst$sym$shale$webapp_SLASH_management_DASH_page,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$shale$webapp,cljs.core.cst$sym$management_DASH_page,"/home/matt/shale/src/cljs/shale/webapp.cljs",22,1,186,186,cljs.core.list(cljs.core.PersistentVector.EMPTY),null,(cljs.core.truth_(shale.webapp.management_page)?shale.webapp.management_page.cljs$lang$test:null)]))], null));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/manage",action__13236__auto___13390);

var action__13236__auto___13394 = (function (params__13237__auto__){
if(cljs.core.map_QMARK_(params__13237__auto__)){
var map__13391 = params__13237__auto__;
var map__13391__$1 = ((((!((map__13391 == null)))?((((map__13391.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13391.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13391):map__13391);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13391__$1,cljs.core.cst$kw$id);
return reagent.session.put_BANG_(cljs.core.cst$kw$current_DASH_page,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Var(function(){return shale.webapp.node_page;},cljs.core.cst$sym$shale$webapp_SLASH_node_DASH_page,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$shale$webapp,cljs.core.cst$sym$node_DASH_page,"/home/matt/shale/src/cljs/shale/webapp.cljs",16,1,195,195,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$id], null)),null,(cljs.core.truth_(shale.webapp.node_page)?shale.webapp.node_page.cljs$lang$test:null)])),id], null));
} else {
if(cljs.core.vector_QMARK_(params__13237__auto__)){
var vec__13393 = params__13237__auto__;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13393,(0),null);
return reagent.session.put_BANG_(cljs.core.cst$kw$current_DASH_page,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Var(function(){return shale.webapp.node_page;},cljs.core.cst$sym$shale$webapp_SLASH_node_DASH_page,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$shale$webapp,cljs.core.cst$sym$node_DASH_page,"/home/matt/shale/src/cljs/shale/webapp.cljs",16,1,195,195,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$id], null)),null,(cljs.core.truth_(shale.webapp.node_page)?shale.webapp.node_page.cljs$lang$test:null)])),id], null));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/manage/node/:id",action__13236__auto___13394);

var action__13236__auto___13399 = (function (params__13237__auto__){
if(cljs.core.map_QMARK_(params__13237__auto__)){
var map__13395 = params__13237__auto__;
var map__13395__$1 = ((((!((map__13395 == null)))?((((map__13395.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13395.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13395):map__13395);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13395__$1,cljs.core.cst$kw$id);
return reagent.session.put_BANG_(cljs.core.cst$kw$current_DASH_page,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Var(function(){return shale.webapp.session_page;},cljs.core.cst$sym$shale$webapp_SLASH_session_DASH_page,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$shale$webapp,cljs.core.cst$sym$session_DASH_page,"/home/matt/shale/src/cljs/shale/webapp.cljs",19,1,204,204,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$id], null)),null,(cljs.core.truth_(shale.webapp.session_page)?shale.webapp.session_page.cljs$lang$test:null)])),id], null));
} else {
if(cljs.core.vector_QMARK_(params__13237__auto__)){
var map__13397 = params__13237__auto__;
var map__13397__$1 = ((((!((map__13397 == null)))?((((map__13397.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13397.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13397):map__13397);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13397__$1,cljs.core.cst$kw$id);
return reagent.session.put_BANG_(cljs.core.cst$kw$current_DASH_page,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Var(function(){return shale.webapp.session_page;},cljs.core.cst$sym$shale$webapp_SLASH_session_DASH_page,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$shale$webapp,cljs.core.cst$sym$session_DASH_page,"/home/matt/shale/src/cljs/shale/webapp.cljs",19,1,204,204,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$id], null)),null,(cljs.core.truth_(shale.webapp.session_page)?shale.webapp.session_page.cljs$lang$test:null)])),id], null));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/manage/session/:id",action__13236__auto___13399);

var action__13236__auto___13403 = (function (params__13237__auto__){
if(cljs.core.map_QMARK_(params__13237__auto__)){
var map__13400 = params__13237__auto__;
var map__13400__$1 = ((((!((map__13400 == null)))?((((map__13400.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13400.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13400):map__13400);
return reagent.session.put_BANG_(cljs.core.cst$kw$current_DASH_page,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Var(function(){return shale.webapp.docs_page;},cljs.core.cst$sym$shale$webapp_SLASH_docs_DASH_page,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$shale$webapp,cljs.core.cst$sym$docs_DASH_page,"/home/matt/shale/src/cljs/shale/webapp.cljs",16,1,165,165,cljs.core.list(cljs.core.PersistentVector.EMPTY),null,(cljs.core.truth_(shale.webapp.docs_page)?shale.webapp.docs_page.cljs$lang$test:null)]))], null));
} else {
if(cljs.core.vector_QMARK_(params__13237__auto__)){
var vec__13402 = params__13237__auto__;
return reagent.session.put_BANG_(cljs.core.cst$kw$current_DASH_page,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Var(function(){return shale.webapp.docs_page;},cljs.core.cst$sym$shale$webapp_SLASH_docs_DASH_page,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$shale$webapp,cljs.core.cst$sym$docs_DASH_page,"/home/matt/shale/src/cljs/shale/webapp.cljs",16,1,165,165,cljs.core.list(cljs.core.PersistentVector.EMPTY),null,(cljs.core.truth_(shale.webapp.docs_page)?shale.webapp.docs_page.cljs$lang$test:null)]))], null));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/docs",action__13236__auto___13403);

shale.webapp.mount_root = (function shale$webapp$mount_root(){
return reagent.core.render.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [shale.webapp.current_page], null),document.getElementById("app"));
});
shale.webapp.init_BANG_ = (function shale$webapp$init_BANG_(){
accountant.core.configure_navigation_BANG_(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$nav_DASH_handler,(function (path){
return secretary.core.dispatch_BANG_(path);
}),cljs.core.cst$kw$path_DASH_exists_QMARK_,(function (path){
return secretary.core.locate_route(path);
})], null));

accountant.core.dispatch_current_BANG_();

return shale.webapp.mount_root();
});
