// Compiled by ClojureScript 1.7.228 {:static-fns true, :optimize-constants true}
goog.provide('reagent.session');
goog.require('cljs.core');
goog.require('reagent.core');
reagent.session.state = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
/**
 * Get the key's value from the session, returns nil if it doesn't exist.
 */
reagent.session.get = (function reagent$session$get(var_args){
var args__7101__auto__ = [];
var len__7094__auto___12870 = arguments.length;
var i__7095__auto___12871 = (0);
while(true){
if((i__7095__auto___12871 < len__7094__auto___12870)){
args__7101__auto__.push((arguments[i__7095__auto___12871]));

var G__12872 = (i__7095__auto___12871 + (1));
i__7095__auto___12871 = G__12872;
continue;
} else {
}
break;
}

var argseq__7102__auto__ = ((((1) < args__7101__auto__.length))?(new cljs.core.IndexedSeq(args__7101__auto__.slice((1)),(0))):null);
return reagent.session.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7102__auto__);
});

reagent.session.get.cljs$core$IFn$_invoke$arity$variadic = (function (k,p__12868){
var vec__12869 = p__12868;
var default$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12869,(0),null);
return cljs.core.get.cljs$core$IFn$_invoke$arity$3((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(reagent.session.state) : cljs.core.deref.call(null,reagent.session.state)),k,default$);
});

reagent.session.get.cljs$lang$maxFixedArity = (1);

reagent.session.get.cljs$lang$applyTo = (function (seq12866){
var G__12867 = cljs.core.first(seq12866);
var seq12866__$1 = cljs.core.next(seq12866);
return reagent.session.get.cljs$core$IFn$_invoke$arity$variadic(G__12867,seq12866__$1);
});
reagent.session.put_BANG_ = (function reagent$session$put_BANG_(k,v){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(reagent.session.state,cljs.core.assoc,k,v);
});
/**
 * Gets the value at the path specified by the vector ks from the session,
 *   returns nil if it doesn't exist.
 */
reagent.session.get_in = (function reagent$session$get_in(var_args){
var args__7101__auto__ = [];
var len__7094__auto___12877 = arguments.length;
var i__7095__auto___12878 = (0);
while(true){
if((i__7095__auto___12878 < len__7094__auto___12877)){
args__7101__auto__.push((arguments[i__7095__auto___12878]));

var G__12879 = (i__7095__auto___12878 + (1));
i__7095__auto___12878 = G__12879;
continue;
} else {
}
break;
}

var argseq__7102__auto__ = ((((1) < args__7101__auto__.length))?(new cljs.core.IndexedSeq(args__7101__auto__.slice((1)),(0))):null);
return reagent.session.get_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7102__auto__);
});

reagent.session.get_in.cljs$core$IFn$_invoke$arity$variadic = (function (ks,p__12875){
var vec__12876 = p__12875;
var default$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12876,(0),null);
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(reagent.session.state) : cljs.core.deref.call(null,reagent.session.state)),ks,default$);
});

reagent.session.get_in.cljs$lang$maxFixedArity = (1);

reagent.session.get_in.cljs$lang$applyTo = (function (seq12873){
var G__12874 = cljs.core.first(seq12873);
var seq12873__$1 = cljs.core.next(seq12873);
return reagent.session.get_in.cljs$core$IFn$_invoke$arity$variadic(G__12874,seq12873__$1);
});
/**
 * Replace the current session's value with the result of executing f with
 *   the current value and args.
 */
reagent.session.swap_BANG_ = (function reagent$session$swap_BANG_(var_args){
var args__7101__auto__ = [];
var len__7094__auto___12882 = arguments.length;
var i__7095__auto___12883 = (0);
while(true){
if((i__7095__auto___12883 < len__7094__auto___12882)){
args__7101__auto__.push((arguments[i__7095__auto___12883]));

var G__12884 = (i__7095__auto___12883 + (1));
i__7095__auto___12883 = G__12884;
continue;
} else {
}
break;
}

var argseq__7102__auto__ = ((((1) < args__7101__auto__.length))?(new cljs.core.IndexedSeq(args__7101__auto__.slice((1)),(0))):null);
return reagent.session.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7102__auto__);
});

reagent.session.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (f,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.swap_BANG_,reagent.session.state,f,args);
});

reagent.session.swap_BANG_.cljs$lang$maxFixedArity = (1);

reagent.session.swap_BANG_.cljs$lang$applyTo = (function (seq12880){
var G__12881 = cljs.core.first(seq12880);
var seq12880__$1 = cljs.core.next(seq12880);
return reagent.session.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12881,seq12880__$1);
});
/**
 * Remove all data from the session and start over cleanly.
 */
reagent.session.clear_BANG_ = (function reagent$session$clear_BANG_(){
var G__12887 = reagent.session.state;
var G__12888 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__12887,G__12888) : cljs.core.reset_BANG_.call(null,G__12887,G__12888));
});
reagent.session.reset_BANG_ = (function reagent$session$reset_BANG_(m){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(reagent.session.state,m) : cljs.core.reset_BANG_.call(null,reagent.session.state,m));
});
/**
 * Remove a key from the session
 */
reagent.session.remove_BANG_ = (function reagent$session$remove_BANG_(k){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(reagent.session.state,cljs.core.dissoc,k);
});
/**
 * Associates a value in the session, where ks is a
 * sequence of keys and v is the new value and returns
 * a new nested structure. If any levels do not exist,
 * hash-maps will be created.
 */
reagent.session.assoc_in_BANG_ = (function reagent$session$assoc_in_BANG_(ks,v){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(reagent.session.state,(function (p1__12889_SHARP_){
return cljs.core.assoc_in(p1__12889_SHARP_,ks,v);
}));
});
/**
 * Destructive get from the session. This returns the current value of the key
 *   and then removes it from the session.
 */
reagent.session.get_BANG_ = (function reagent$session$get_BANG_(var_args){
var args__7101__auto__ = [];
var len__7094__auto___12894 = arguments.length;
var i__7095__auto___12895 = (0);
while(true){
if((i__7095__auto___12895 < len__7094__auto___12894)){
args__7101__auto__.push((arguments[i__7095__auto___12895]));

var G__12896 = (i__7095__auto___12895 + (1));
i__7095__auto___12895 = G__12896;
continue;
} else {
}
break;
}

var argseq__7102__auto__ = ((((1) < args__7101__auto__.length))?(new cljs.core.IndexedSeq(args__7101__auto__.slice((1)),(0))):null);
return reagent.session.get_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7102__auto__);
});

reagent.session.get_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (k,p__12892){
var vec__12893 = p__12892;
var default$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12893,(0),null);
var cur = reagent.session.get.cljs$core$IFn$_invoke$arity$variadic(k,cljs.core.array_seq([default$], 0));
reagent.session.remove_BANG_(k);

return cur;
});

reagent.session.get_BANG_.cljs$lang$maxFixedArity = (1);

reagent.session.get_BANG_.cljs$lang$applyTo = (function (seq12890){
var G__12891 = cljs.core.first(seq12890);
var seq12890__$1 = cljs.core.next(seq12890);
return reagent.session.get_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12891,seq12890__$1);
});
/**
 * Destructive get from the session. This returns the current value of the path
 *   specified by the vector ks and then removes it from the session.
 */
reagent.session.get_in_BANG_ = (function reagent$session$get_in_BANG_(var_args){
var args__7101__auto__ = [];
var len__7094__auto___12901 = arguments.length;
var i__7095__auto___12902 = (0);
while(true){
if((i__7095__auto___12902 < len__7094__auto___12901)){
args__7101__auto__.push((arguments[i__7095__auto___12902]));

var G__12903 = (i__7095__auto___12902 + (1));
i__7095__auto___12902 = G__12903;
continue;
} else {
}
break;
}

var argseq__7102__auto__ = ((((1) < args__7101__auto__.length))?(new cljs.core.IndexedSeq(args__7101__auto__.slice((1)),(0))):null);
return reagent.session.get_in_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7102__auto__);
});

reagent.session.get_in_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ks,p__12899){
var vec__12900 = p__12899;
var default$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12900,(0),null);
var cur = cljs.core.get_in.cljs$core$IFn$_invoke$arity$3((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(reagent.session.state) : cljs.core.deref.call(null,reagent.session.state)),ks,default$);
reagent.session.assoc_in_BANG_(ks,null);

return cur;
});

reagent.session.get_in_BANG_.cljs$lang$maxFixedArity = (1);

reagent.session.get_in_BANG_.cljs$lang$applyTo = (function (seq12897){
var G__12898 = cljs.core.first(seq12897);
var seq12897__$1 = cljs.core.next(seq12897);
return reagent.session.get_in_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12898,seq12897__$1);
});
/**
 * Updates a value in session where k is a key and f
 * is the function that takes the old value along with any
 * supplied args and return the new value. If key is not
 * present it will be added.
 */
reagent.session.update_BANG_ = (function reagent$session$update_BANG_(var_args){
var args__7101__auto__ = [];
var len__7094__auto___12908 = arguments.length;
var i__7095__auto___12909 = (0);
while(true){
if((i__7095__auto___12909 < len__7094__auto___12908)){
args__7101__auto__.push((arguments[i__7095__auto___12909]));

var G__12910 = (i__7095__auto___12909 + (1));
i__7095__auto___12909 = G__12910;
continue;
} else {
}
break;
}

var argseq__7102__auto__ = ((((2) < args__7101__auto__.length))?(new cljs.core.IndexedSeq(args__7101__auto__.slice((2)),(0))):null);
return reagent.session.update_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7102__auto__);
});

reagent.session.update_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (k,f,args){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(reagent.session.state,(function (p1__12904_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$4(cljs.core.update,p1__12904_SHARP_,k,f),args);
}));
});

reagent.session.update_BANG_.cljs$lang$maxFixedArity = (2);

reagent.session.update_BANG_.cljs$lang$applyTo = (function (seq12905){
var G__12906 = cljs.core.first(seq12905);
var seq12905__$1 = cljs.core.next(seq12905);
var G__12907 = cljs.core.first(seq12905__$1);
var seq12905__$2 = cljs.core.next(seq12905__$1);
return reagent.session.update_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12906,G__12907,seq12905__$2);
});
/**
 * 'Updates a value in the session, where ks is a
 * sequence of keys and f is a function that will
 * take the old value along with any supplied args and return
 * the new value. If any levels do not exist, hash-maps
 * will be created.
 */
reagent.session.update_in_BANG_ = (function reagent$session$update_in_BANG_(var_args){
var args__7101__auto__ = [];
var len__7094__auto___12915 = arguments.length;
var i__7095__auto___12916 = (0);
while(true){
if((i__7095__auto___12916 < len__7094__auto___12915)){
args__7101__auto__.push((arguments[i__7095__auto___12916]));

var G__12917 = (i__7095__auto___12916 + (1));
i__7095__auto___12916 = G__12917;
continue;
} else {
}
break;
}

var argseq__7102__auto__ = ((((2) < args__7101__auto__.length))?(new cljs.core.IndexedSeq(args__7101__auto__.slice((2)),(0))):null);
return reagent.session.update_in_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7102__auto__);
});

reagent.session.update_in_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ks,f,args){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(reagent.session.state,(function (p1__12911_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$4(cljs.core.update_in,p1__12911_SHARP_,ks,f),args);
}));
});

reagent.session.update_in_BANG_.cljs$lang$maxFixedArity = (2);

reagent.session.update_in_BANG_.cljs$lang$applyTo = (function (seq12912){
var G__12913 = cljs.core.first(seq12912);
var seq12912__$1 = cljs.core.next(seq12912);
var G__12914 = cljs.core.first(seq12912__$1);
var seq12912__$2 = cljs.core.next(seq12912__$1);
return reagent.session.update_in_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12913,G__12914,seq12912__$2);
});
