(ns sgr-utils.utils
  (:require [sgr-sound.converter :as      cv]
            [sgr-db.utils        :as      db]

            [sgr-utils.config    :as     cfg]
            [sgr-utils.file      :refer :all]))

(defn import-<record&mfcc>
  [sourceFile targetName targetPath gender
   & {:keys [utils-config] :or {utils-config cfg/utils-config}}]
  (let [targetFile  (newFile (str targetPath targetName))
        cvr         (cv/sound->convert->mfcc->average sourceFile targetFile)
        convertFile (:convertFile cvr)
        mfcc        (:mfcc        cvr)]
     (if (and convertFile mfcc)
       (let [user {:name      "unknown"
                   :gender     gender
                   :genderSVM "unknown"
                   :SVM?       true}
             records (list {:path (getPath sourceFile)
                            :converted? false
                            :mfcc       false}
                           {:path (getPath convertFile)
                            :converted? true
                            :mfcc       mfcc})]
         (db/create-user<-add-records user records)))))

(defn import-<gender>-<record&mfcc>
  [sourceFiles targetPath gender
   & {:keys [utils-config] :or {utils-config cfg/utils-config}}]
  (let [cnt (countFilesFromDirectory targetPath)]
    (reduce #'and
            (map-indexed (fn [index sourceFile]
                           (import-<record&mfcc> sourceFile
                                                 (str gender "-converted-" (+ cnt index) ".wav")
                                                 targetPath
                                                 gender
                                                 :utils-config utils-config)) sourceFiles))))


(defn import-<records&mfcc>
  [& {:keys [utils-config] :or {utils-config cfg/utils-config}}]
  (let [maleSourceFiles   (getFilesFromDirectory (:source (:male   (:audio utils-config))))
        femaleSourceFiles (getFilesFromDirectory (:source (:female (:audio utils-config))))
        maleTargetPath    (:target (:male   (:audio utils-config)))
        femaleTargetPath  (:target (:female (:audio utils-config)))]
    (and (import-<gender>-<record&mfcc> femaleSourceFiles femaleTargetPath "female" :utils-config utils-config)
         (import-<gender>-<record&mfcc>   maleSourceFiles   maleTargetPath   "male" :utils-config utils-config))))


(import-<records&mfcc>)
;;(count (db/get-all-<gender&mfcc> "sgr" "users" "records" '("male" "female")))
