(ns sgr-utils.file
  (:require [clojure.java.io :as io])
  (:import [java.nio.file StandardCopyOption StandardCopyOption]))

(defn newFile [path]
  (io/file path))

(defn lengthFile [file]
  (.length file))

(defn getPath
  [file]
  (.getPath file))

(defn getFileNameFromPath
  "Get the name of the file from the full path"
  [path]
  (last (clojure.string/split path #"/")))

(defn getFileName
  [file]
  (.getName file))

(defn getFileextension
  [file]
  (let [fileName (getFileName file)]
    (.getExtentions file)))

(defn saveFile
  "Save file and return path."
  ([path tempfile]
   (do
     (io/copy tempfile (newFile path))
     path))
  ([filename path tempfile]
   (saveFile (str path filename) tempfile)))

(defn copyFile
  {:doc ".copy(source, target, REPLACE_EXISTING)"}
  [sourcePath targetPath]
  (.copy sourcePath targetPath StandardCopyOption/REPLACE_EXISTING))

(defn deleteFile
  [file]
  (.delete file))


(defn isFile? [file]
  (.isFile file))

(defn getFilesFromDirectory
  [pathToDirectory]
  (let [directory (newFile pathToDirectory)]
    (keep #(if (isFile? %) %) (file-seq directory))))

(defn countFilesFromDirectory
  [pathToDirectory]
  (count (getFilesFromDirectory pathToDirectory)))
