(ns sgr-svm.dataset
  (:require [svm.core     :as svm]
            [sgr-db.utils :as  db]))

(defn mfcc->svm-mfcc [mfcc]
  (svm/sparse-map (into (sorted-map) mfcc)))

(defn data->svm-data [data]
  (map #(case (:gender %)
          "male"   (list -1 (mfcc->svm-mfcc (:mfcc %)))
          "female" (list  1 (mfcc->svm-mfcc (:mfcc %)))) data))

(defn get-dataset-from-db []
  {:doc "genders : '('male', 'female', ...)"}
  (let [data-from-db (db/get-all-<gender&mfcc> '("male" "female"))
        dataset (data->svm-data data-from-db)]
    dataset))

(defn write-dataset
  ([filename]
   (let [dataset (get-dataset-from-db)]
     (write-dataset dataset filename)))
  ([dataset filename]
   (svm/write-dataset dataset filename)))

(defn read-dataset [filename]
  (svm/read-dataset filename))




